/*
 * Decompiled with CFR 0.152.
 */
package abbot.util;

import abbot.Log;
import abbot.util.PathClassLoader;

public class NonDelegatingClassLoader
extends PathClassLoader {
    public NonDelegatingClassLoader(String path, ClassLoader parent) {
        super(path, parent);
    }

    protected boolean shouldDelegate(String name) {
        return false;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Log.debug("Looking up " + name + " with " + this);
        return super.findClass(name);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.shouldDelegate(name)) {
            Log.debug("Delegating lookup for " + name);
            return super.loadClass(name, resolve);
        }
        Log.debug("Non-delegating lookup for " + name);
        Class c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (SecurityException se) {
                Log.debug(se);
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException cnf) {
                return super.loadClass(name, resolve);
            }
            if (resolve) {
                this.resolveClass(c);
            }
        } else {
            Log.debug("Class already loaded " + name);
        }
        return c;
    }
}

