/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.abbot;

import abbot.Log;
import abbot.finder.ComponentNotFoundException;
import abbot.finder.ComponentSearchException;
import abbot.finder.MultipleComponentsFoundException;
import abbot.finder.matchers.ClassMatcher;
import abbot.finder.matchers.WindowMatcher;
import abbot.tester.ComponentTester;
import abbot.tester.Robot;
import abbot.tester.WindowTracker;
import abbot.util.AWT;
import abbot.util.AWTFixtureHelper;
import abbot.util.Bugs;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import junit.extensions.abbot.ResolverFixture;
import junit.extensions.abbot.Timer;

public abstract class ComponentTestFixture
extends ResolverFixture {
    public static final int EVENT_GENERATION_DELAY = 5000;
    public static final int WINDOW_DELAY = 20000;
    public static final int POPUP_DELAY = 10000;
    protected static final Class[] DISPOSE_CLASSES = new Class[]{Component.class, ComponentTester.class};
    private Robot robot;
    private WindowTracker tracker;
    private AWTFixtureHelper savedState;
    private Throwable edtException;
    private long edtExceptionTime;
    private int modifiers;

    protected Robot getRobot() {
        return this.robot;
    }

    protected WindowTracker getWindowTracker() {
        return this.tracker;
    }

    protected Frame showFrame(Component comp) {
        return this.showFrame(comp, null);
    }

    protected Frame showFrame(Component comp, Dimension size) {
        JFrame frame = new JFrame(this.getName());
        frame.setDefaultCloseOperation(3);
        JPanel pane = (JPanel)frame.getContentPane();
        pane.setBorder(new EmptyBorder(10, 10, 10, 10));
        pane.add(comp);
        this.showWindow(frame, size, true);
        return frame;
    }

    protected void showWindow(Window w) {
        this.showWindow(w, null, true);
    }

    protected void showWindow(Window w, Dimension size) {
        this.showWindow(w, size, true);
    }

    protected void showWindow(final Window w, final Dimension size, final boolean pack) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (pack) {
                    w.pack();
                    w.setLocation(100, 100);
                }
                if (size != null) {
                    w.setSize(size.width, size.height);
                }
                w.setVisible(true);
            }
        });
        this.waitForWindow(w, true);
    }

    protected void waitForWindow(Window w, boolean visible) {
        Timer timer = new Timer();
        while (Robot.getEventMode() == Robot.EM_ROBOT && this.tracker.isWindowReady(w) != visible || w.isShowing() != visible) {
            if (timer.elapsed() > 20000L) {
                throw new RuntimeException("Timed out waiting for Window to " + (visible ? "open" : "close") + " (" + timer.elapsed() + "ms)");
            }
            this.robot.sleep();
        }
    }

    protected void hideWindow(final Window w) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                w.setVisible(false);
            }
        });
        this.waitForWindow(w, false);
        this.robot.waitForIdle();
    }

    protected void disposeWindow(Window w) {
        w.dispose();
        this.waitForWindow(w, false);
        this.robot.waitForIdle();
    }

    protected void setModifiers(int modifiers, boolean pressed) {
        this.modifiers = pressed ? (this.modifiers |= modifiers) : (this.modifiers &= ~modifiers);
        this.robot.setModifiers(modifiers, pressed);
        this.robot.waitForIdle();
    }

    protected void installPopup(Component invoker, final JPopupMenu popup) {
        invoker.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.mouseReleased(e);
            }

            public void mouseClicked(MouseEvent e) {
                this.mouseReleased(e);
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    System.out.println("trigger on " + e);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    protected void showPopup(JPopupMenu popup, Component invoker) {
        this.showPopup(popup, invoker, invoker.getWidth() / 2, invoker.getHeight() / 2);
    }

    protected void showPopup(final JPopupMenu popup, final Component invoker, final int x, final int y) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                popup.show(invoker, x, y);
            }
        });
        Timer timer = new Timer();
        while (!popup.isShowing()) {
            if (timer.elapsed() > 10000L) {
                throw new RuntimeException("Timed out waiting for popup to show");
            }
            this.robot.sleep();
        }
        this.waitForWindow(SwingUtilities.getWindowAncestor(popup), true);
    }

    protected Dialog showModalDialog(Runnable showAction) throws Exception {
        EventQueue.invokeLater(showAction);
        ClassMatcher matcher = new ClassMatcher(Dialog.class, true){

            public boolean matches(Component c) {
                return super.matches(c) && ((Dialog)c).isModal() && AWT.containsFocus(c);
            }
        };
        Timer timer = new Timer();
        while (true) {
            try {
                return (Dialog)this.getFinder().find(matcher);
            }
            catch (ComponentSearchException e) {
                if (timer.elapsed() > 10000L) {
                    throw new RuntimeException("Timed out waiting for dialog to be ready");
                }
                this.robot.sleep();
                continue;
            }
            break;
        }
    }

    protected Dialog showModalDialog(Runnable showAction, Component contents) throws Exception {
        return this.showModalDialog(showAction);
    }

    protected boolean isShowing(String id) {
        try {
            this.getFinder().find(new WindowMatcher(id, true));
        }
        catch (ComponentNotFoundException e) {
            return false;
        }
        catch (MultipleComponentsFoundException multipleComponentsFoundException) {
            // empty catch block
        }
        return true;
    }

    public ComponentTestFixture(String name) {
        super(name);
    }

    public ComponentTestFixture() {
    }

    protected void fixtureSetUp() throws Throwable {
        super.fixtureSetUp();
        this.savedState = new AWTFixtureHelper();
        this.robot = new Robot();
        this.tracker = WindowTracker.getTracker();
        this.robot.reset();
        if (Bugs.hasMultiClickFrameBug()) {
            this.robot.delay(500);
        }
    }

    protected void fixtureTearDown() throws Throwable {
        if (this.robot != null) {
            int buttons;
            if (this.modifiers != 0) {
                this.robot.setModifiers(this.modifiers, false);
                this.modifiers = 0;
            }
            if ((buttons = Robot.getState().getButtons()) != 0) {
                this.robot.mouseRelease(buttons);
            }
            this.robot = null;
        }
        super.fixtureTearDown();
        this.tracker = null;
        this.edtExceptionTime = this.savedState.getEventDispatchErrorTime();
        this.edtException = this.savedState.getEventDispatchError();
        this.savedState.restore();
        this.savedState = null;
        this.clearTestFields();
    }

    private void clearTestFields() {
        try {
            Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if ((fields[i].getModifiers() & 8) != 0) continue;
                fields[i].setAccessible(true);
                for (int c = 0; c < DISPOSE_CLASSES.length; ++c) {
                    Class cls = DISPOSE_CLASSES[c];
                    if (!cls.isAssignableFrom(fields[i].getType())) continue;
                    fields[i].set((Object)this, null);
                }
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        if (Boolean.getBoolean("abbot.suppress_ui_tests")) {
            return;
        }
        Throwable exception = null;
        long exceptionTime = -1L;
        try {
            super.runBare();
        }
        catch (Throwable e) {
            exceptionTime = System.currentTimeMillis();
            exception = e;
        }
        finally {
            if (this.edtException != null && (exception == null || this.edtExceptionTime < exceptionTime)) {
                exception = new EventDispatchException(this.edtException);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public class EventDispatchException
    extends InvocationTargetException {
        private EventDispatchException(Throwable t) {
            super(t, "An exception was thrown on the event dispatch thread: " + t.toString());
        }

        public void printStackTrace() {
            this.getTargetException().printStackTrace();
        }

        public void printStackTrace(PrintStream p) {
            this.getTargetException().printStackTrace(p);
        }

        public void printStackTrace(PrintWriter p) {
            this.getTargetException().printStackTrace(p);
        }
    }
}

