/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.FloatBufferWrapper;
import java.util.ArrayList;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.IndexedGeometryStripArrayRetained;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArrayRetained;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;

abstract class GeometryStripArrayRetained
extends GeometryArrayRetained {
    int[] stripVertexCounts;
    int[] stripStartVertexIndices;
    int[] stripStartOffsetIndices;
    int[] compileNumStrips;
    int[] compileStripCountOffset;

    GeometryStripArrayRetained() {
    }

    void setStripVertexCounts(int[] nArray) {
        int n;
        boolean bl = false;
        int n2 = nArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += nArray[n];
            if (this instanceof LineStripArrayRetained) {
                if (nArray[n] >= 2) continue;
                throw new IllegalArgumentException(J3dI18N.getString("LineStripArrayRetained1"));
            }
            if (this instanceof TriangleStripArrayRetained) {
                if (nArray[n] >= 3) continue;
                throw new IllegalArgumentException(J3dI18N.getString("TriangleStripArrayRetained1"));
            }
            if (!(this instanceof TriangleFanArrayRetained) || nArray[n] >= 3) continue;
            throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArrayRetained1"));
        }
        if (this.initialVertexIndex + n3 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray3"));
        }
        if (this.initialCoordIndex + n3 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray7"));
        }
        if (this.initialColorIndex + n3 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray4"));
        }
        if (this.initialNormalIndex + n3 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray5"));
        }
        if ((this.vertexFormat & 0x460) != 0 && (this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            for (n = 0; n < this.texCoordSetCount; ++n) {
                if (this.initialTexCoordIndex[n] + n3 <= this.vertexCount) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray6"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x40;
        this.validVertexCount = n3;
        this.stripVertexCounts = new int[n2];
        this.stripStartVertexIndices = new int[n2];
        this.stripStartOffsetIndices = new int[n2];
        this.stripStartOffsetIndices[0] = 0;
        if ((this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            this.stripStartVertexIndices[0] = this.initialCoordIndex;
            bl = (this.vertexType & 0xF) == 0;
        } else {
            this.stripStartVertexIndices[0] = this.initialVertexIndex;
            if ((this.vertexFormat & 0x100) != 0) {
                bl = (this.vertexFormat & 0x800) != 0 ? this.interLeavedVertexData == null : this.interleavedFloatBufferImpl == null;
            }
        }
        for (n = 0; n < n2 - 1; ++n) {
            this.stripVertexCounts[n] = nArray[n];
            this.stripStartVertexIndices[n + 1] = this.stripStartVertexIndices[n] + nArray[n];
            this.stripStartOffsetIndices[n + 1] = this.stripStartOffsetIndices[n] + nArray[n];
        }
        this.stripVertexCounts[n2 - 1] = nArray[n2 - 1];
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged(bl);
            this.sendDataChangedMessage(true);
        }
    }

    void unIndexify(IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained) {
        if ((indexedGeometryStripArrayRetained.vertexFormat & 0x800) == 0) {
            this.unIndexifyJavaArray(indexedGeometryStripArrayRetained);
        } else {
            this.unIndexifyNIOBuffer(indexedGeometryStripArrayRetained);
        }
    }

    void unIndexifyJavaArray(IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained) {
        int n = 0;
        int n2 = 0;
        int n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
        int n4 = 0;
        float[] fArray = null;
        if ((indexedGeometryStripArrayRetained.vertexFormat & 0x80) == 0 || (indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryStripArrayRetained.vertexFormat & 0x80) == 0) {
                fArray = indexedGeometryStripArrayRetained.vertexData;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                    n4 = 4;
                }
            } else if ((indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
                fArray = indexedGeometryStripArrayRetained.interLeavedVertexData;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n4 = 4;
                } else if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                    n4 = 3;
                }
            }
            for (int i = 0; i < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++i) {
                for (int j = 0; j < indexedGeometryStripArrayRetained.stripIndexCounts[i]; ++j) {
                    int n5 = j + n3;
                    if ((this.vertexFormat & 2) != 0) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexNormal[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.normalOffset, this.vertexData, n + this.normalOffset, 3);
                    }
                    if (n4 == 4) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexColor[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n4);
                    } else if (n4 == 3) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexColor[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n4);
                        this.vertexData[n + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x460) != 0) {
                        for (int k = 0; k < this.texCoordSetCount; ++k) {
                            System.arraycopy(fArray, ((int[])indexedGeometryStripArrayRetained.indexTexCoord[k])[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.textureOffset + indexedGeometryStripArrayRetained.texCoordSetMapOffset[k], this.vertexData, n + this.textureOffset + this.texCoordSetMapOffset[k], this.texCoordStride);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexCoord[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.coordinateOffset, this.vertexData, n + this.coordinateOffset, 3);
                    }
                    n += this.stride;
                }
                n3 += indexedGeometryStripArrayRetained.stripIndexCounts[i];
            }
        } else {
            int n6;
            int n7;
            int n8;
            if ((this.vertexFormat & 2) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.normalOffset;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xC00) {
                    case 1024: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = n7 + n3;
                                System.arraycopy(indexedGeometryStripArrayRetained.floatRefNormals, indexedGeometryStripArrayRetained.indexNormal[n6] * 3, this.vertexData, n, 3);
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 2048: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexNormal[n7 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.v3fRefNormals[n6].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.v3fRefNormals[n6].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.v3fRefNormals[n6].z;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.colorOffset;
                int n9 = 3;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n9 = 4;
                }
                switch (indexedGeometryStripArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = n7 + n3;
                                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                                    System.arraycopy(indexedGeometryStripArrayRetained.floatRefColors, indexedGeometryStripArrayRetained.indexColor[n6] * n9, this.vertexData, n, 4);
                                } else {
                                    System.arraycopy(indexedGeometryStripArrayRetained.floatRefColors, indexedGeometryStripArrayRetained.indexColor[n6] * n9, this.vertexData, n, 3);
                                    this.vertexData[n + 3] = 1.0f;
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 32: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexColor[n7 + n3] * n9;
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n6] & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n6 + 1] & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n6 + 2] & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = (indexedGeometryStripArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryStripArrayRetained.byteRefColors[n6 + 3] & 0xFF) * 0.003921569f : 1.0f;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 64: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexColor[n7 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.c3fRefColors[n6].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.c3fRefColors[n6].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.c3fRefColors[n6].z;
                                this.vertexData[n + 3] = 1.0f;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 128: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexColor[n7 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.c4fRefColors[n6].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.c4fRefColors[n6].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.c4fRefColors[n6].z;
                                this.vertexData[n + 3] = indexedGeometryStripArrayRetained.c4fRefColors[n6].w;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 256: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexColor[n7 + n3];
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n6].x & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n6].y & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n6].z & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = 1.0f;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 512: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexColor[n7 + n3];
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n6].x & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n6].y & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n6].z & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n6].w & 0xFF) * 0.003921569f;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.textureOffset;
                switch (indexedGeometryStripArrayRetained.vertexType & 0x7000) {
                    case 4096: {
                        int n10;
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = n7 + n3;
                                n2 = n;
                                for (n10 = 0; n10 < this.texCoordSetCount; ++n10) {
                                    System.arraycopy(indexedGeometryStripArrayRetained.refTexCoords[n10], ((int[])indexedGeometryStripArrayRetained.indexTexCoord[n10])[n6] * this.texCoordStride, this.vertexData, n2, this.texCoordStride);
                                    n2 += this.texCoordStride;
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 8192: {
                        int n11;
                        int n10;
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = n7 + n3;
                                n2 = n;
                                for (n10 = 0; n10 < this.texCoordSetCount; ++n10) {
                                    n11 = ((int[])indexedGeometryStripArrayRetained.indexTexCoord[n10])[n6];
                                    this.vertexData[n2] = ((TexCoord2f[])indexedGeometryStripArrayRetained.refTexCoords[n10])[n11].x;
                                    this.vertexData[n2 + 1] = ((TexCoord2f[])indexedGeometryStripArrayRetained.refTexCoords[n10])[n11].y;
                                    n2 += this.texCoordStride;
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 16384: {
                        int n11;
                        int n10;
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = n7 + n3;
                                n2 = n;
                                for (n10 = 0; n10 < this.texCoordSetCount; ++n10) {
                                    n11 = ((int[])indexedGeometryStripArrayRetained.indexTexCoord[n10])[n6];
                                    this.vertexData[n2] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n10])[n11].x;
                                    this.vertexData[n2 + 1] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n10])[n11].y;
                                    this.vertexData[n2 + 2] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n10])[n11].z;
                                    n2 += this.texCoordStride;
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n = this.coordinateOffset;
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xF) {
                    case 1: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = n7 + n3;
                                System.arraycopy(indexedGeometryStripArrayRetained.floatRefCoords, indexedGeometryStripArrayRetained.indexCoord[n6] * 3, this.vertexData, n, 3);
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 2: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexCoord[n7 + n3] * 3;
                                this.vertexData[n] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n6];
                                this.vertexData[n + 1] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n6 + 1];
                                this.vertexData[n + 2] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n6 + 2];
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 4: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexCoord[n7 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.p3fRefCoords[n6].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.p3fRefCoords[n6].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.p3fRefCoords[n6].z;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 8: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexCoord[n7 + n3];
                                this.vertexData[n] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n6].x;
                                this.vertexData[n + 1] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n6].y;
                                this.vertexData[n + 2] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n6].z;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                }
            }
        }
    }

    void unIndexifyNIOBuffer(IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained) {
        int n = 0;
        int n2 = 0;
        int n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
        int n4 = 0;
        if ((indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                n4 = 4;
            } else if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                n4 = 3;
            }
            for (int i = 0; i < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++i) {
                for (int j = 0; j < indexedGeometryStripArrayRetained.stripIndexCounts[i]; ++j) {
                    int n5 = j + n3;
                    if ((this.vertexFormat & 2) != 0) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexNormal[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.normalOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.normalOffset, 3);
                    }
                    if (n4 == 4) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexColor[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.colorOffset, n4);
                    } else if (n4 == 3) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexColor[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.colorOffset, n4);
                        this.vertexData[n + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x460) != 0) {
                        for (int k = 0; k < this.texCoordSetCount; ++k) {
                            indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(((int[])indexedGeometryStripArrayRetained.indexTexCoord[k])[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.textureOffset + indexedGeometryStripArrayRetained.texCoordSetMapOffset[k]);
                            indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.textureOffset + this.texCoordSetMapOffset[k], this.texCoordStride);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexCoord[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.coordinateOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.coordinateOffset, 3);
                    }
                    n += this.stride;
                }
                n3 += indexedGeometryStripArrayRetained.stripIndexCounts[i];
            }
        } else {
            int n6;
            int n7;
            int n8;
            if ((this.vertexFormat & 2) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.normalOffset;
                if ((indexedGeometryStripArrayRetained.vertexType & 0xC00) != 0) {
                    for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                        for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                            n6 = n7 + n3;
                            indexedGeometryStripArrayRetained.floatBufferRefNormals.position(indexedGeometryStripArrayRetained.indexNormal[n6] * 3);
                            indexedGeometryStripArrayRetained.floatBufferRefNormals.get(this.vertexData, n, 3);
                            n += this.stride;
                        }
                        n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.colorOffset;
                int n9 = 3;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n9 = 4;
                }
                switch (indexedGeometryStripArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = n7 + n3;
                                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.position(indexedGeometryStripArrayRetained.indexColor[n6] * n9);
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.get(this.vertexData, n, 4);
                                } else {
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.position(indexedGeometryStripArrayRetained.indexColor[n6] * n9);
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.get(this.vertexData, n, 3);
                                    this.vertexData[n + 3] = 1.0f;
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 32: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexColor[n7 + n3] * n9;
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n6) & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n6 + 1) & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n6 + 2) & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = (indexedGeometryStripArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n6 + 3) & 0xFF) * 0.003921569f : 1.0f;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.textureOffset;
                if ((indexedGeometryStripArrayRetained.vertexType & 0x7000) != 0) {
                    for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                        for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                            n6 = n7 + n3;
                            n2 = n;
                            for (int i = 0; i < this.texCoordSetCount; ++i) {
                                FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)indexedGeometryStripArrayRetained.refTexCoordsBuffer[i]).getBufferImpl();
                                floatBufferWrapper.position(((int[])indexedGeometryStripArrayRetained.indexTexCoord[i])[n6] * this.texCoordStride);
                                floatBufferWrapper.get(this.vertexData, n2, this.texCoordStride);
                                n2 += this.texCoordStride;
                            }
                            n += this.stride;
                        }
                        n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n = this.coordinateOffset;
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xF) {
                    case 1: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = n7 + n3;
                                indexedGeometryStripArrayRetained.floatBufferRefCoords.position(indexedGeometryStripArrayRetained.indexCoord[n6] * 3);
                                indexedGeometryStripArrayRetained.floatBufferRefCoords.get(this.vertexData, n, 3);
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                    case 2: {
                        for (n8 = 0; n8 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n8) {
                            for (n7 = 0; n7 < indexedGeometryStripArrayRetained.stripIndexCounts[n8]; ++n7) {
                                n6 = indexedGeometryStripArrayRetained.indexCoord[n7 + n3] * 3;
                                this.vertexData[n] = (float)indexedGeometryStripArrayRetained.doubleBufferRefCoords.get(n6);
                                this.vertexData[n + 1] = (float)indexedGeometryStripArrayRetained.doubleBufferRefCoords.get(n6 + 1);
                                this.vertexData[n + 2] = (float)indexedGeometryStripArrayRetained.doubleBufferRefCoords.get(n6 + 2);
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n8];
                        }
                        break;
                    }
                }
            }
        }
    }

    int getNumStrips() {
        return this.stripVertexCounts.length;
    }

    void getStripVertexCounts(int[] nArray) {
        int n = this.stripVertexCounts.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.stripVertexCounts[i];
        }
    }

    void getStripVertexCounts(int n, int[] nArray) {
        int n2 = this.compileStripCountOffset[n];
        int n3 = this.compileNumStrips[n];
        System.arraycopy(this.stripVertexCounts, n2, nArray, 0, n3);
    }

    int getNumStrips(int n) {
        return this.compileNumStrips[n];
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n;
        int n2 = arrayList.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += ((GeometryStripArrayRetained)arrayList.get((int)n)).stripVertexCounts.length;
        }
        this.stripVertexCounts = new int[n3];
        this.stripStartVertexIndices = new int[n3];
        this.stripStartOffsetIndices = new int[n3];
        n = 0;
        int n4 = 0;
        this.compileNumStrips = new int[n2];
        this.compileStripCountOffset = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n5;
            GeometryStripArrayRetained geometryStripArrayRetained = (GeometryStripArrayRetained)arrayList.get(i);
            int[] nArray = geometryStripArrayRetained.stripVertexCounts;
            int[] nArray2 = geometryStripArrayRetained.stripStartVertexIndices;
            int[] nArray3 = geometryStripArrayRetained.stripStartOffsetIndices;
            this.compileNumStrips[i] = n5 = nArray.length;
            this.compileStripCountOffset[i] = n;
            System.arraycopy(nArray, 0, this.stripVertexCounts, n, n5);
            for (int j = 0; j < n5; ++j) {
                this.stripStartVertexIndices[j + n] = nArray2[j] + n4;
                this.stripStartOffsetIndices[j + n] = nArray3[j] + n4;
            }
            n += n5;
            n4 += geometryStripArrayRetained.validVertexCount;
        }
        this.validVertexCount = n4;
        super.mergeGeometryArrays(arrayList);
    }
}

