/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class PointAttributesRetained
extends NodeComponentRetained {
    static final int POINT_SIZE_CHANGED = 1;
    static final int POINT_AA_CHANGED = 2;
    float pointSize = 1.0f;
    boolean pointAntialiasing = false;

    PointAttributesRetained() {
    }

    final void initPointSize(float f) {
        this.pointSize = f;
    }

    final void setPointSize(float f) {
        this.initPointSize(f);
        this.sendMessage(1, new Float(f));
    }

    final float getPointSize() {
        return this.pointSize;
    }

    final void initPointAntialiasingEnable(boolean bl) {
        this.pointAntialiasing = bl;
    }

    final void setPointAntialiasingEnable(boolean bl) {
        this.initPointAntialiasingEnable(this.pointAntialiasing);
        this.sendMessage(2, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getPointAntialiasingEnable() {
        return this.pointAntialiasing;
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                PointAttributesRetained pointAttributesRetained = new PointAttributesRetained();
                pointAttributesRetained.set(this);
                pointAttributesRetained.source = this.source;
                this.mirror = pointAttributesRetained;
            }
        } else {
            ((PointAttributesRetained)this.mirror).set(this);
        }
    }

    native void updateNative(long var1, float var3, boolean var4);

    void updateNative(long l) {
        this.updateNative(l, this.pointSize, this.pointAntialiasing);
    }

    synchronized void initMirrorObject() {
        ((PointAttributesRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int n, Object object) {
        PointAttributesRetained pointAttributesRetained = (PointAttributesRetained)this.mirror;
        if ((n & 1) != 0) {
            pointAttributesRetained.pointSize = ((Float)object).floatValue();
        } else if ((n & 2) != 0) {
            pointAttributesRetained.pointAntialiasing = (Boolean)object;
        }
    }

    boolean equivalent(PointAttributesRetained pointAttributesRetained) {
        return pointAttributesRetained != null && pointAttributesRetained.pointSize == this.pointSize && pointAttributesRetained.pointAntialiasing == this.pointAntialiasing;
    }

    protected void set(PointAttributesRetained pointAttributesRetained) {
        super.set(pointAttributesRetained);
        this.pointSize = pointAttributesRetained.pointSize;
        this.pointAntialiasing = pointAttributesRetained.pointAntialiasing;
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 8;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 8;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void handleFrequencyChange(int n) {
        if (n == 1 || n == 3) {
            this.setFrequencyChangeMask(n, 1);
        }
    }
}

