/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.Log;
import abbot.editor.editors.StepEditor;
import abbot.script.Event;
import abbot.script.Resolver;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class EventEditor
extends StepEditor {
    private Event event;
    JComboBox type;
    JComboBox kind;
    JComboBox cref;
    private boolean ignoreCombo = false;
    JTextField xValue;
    JTextField yValue;
    JTextField keyCode;

    public EventEditor(Event event) {
        super(event);
        this.event = event;
        String idtype = event.getType();
        String idkind = event.getKind();
        Object[] typeValues = new String[]{"Mouse Event", "Key Event"};
        this.ignoreCombo = true;
        this.type = this.addComboBox("Type", typeValues[0], typeValues);
        this.type.setEnabled(false);
        this.type.setEditable(false);
        Resolver resolver = event.getResolver();
        String refid = event.getComponentID();
        if ("MouseEvent".equals(idtype)) {
            Object[] kindValues = new String[]{"MOUSE_PRESSED", "MOUSE_RELEASED", "MOUSE_MOVED", "MOUSE_DRAGGED"};
            this.kind = this.addComboBox("Kind", idkind, kindValues);
            this.kind.setEditable(false);
            this.kind.setEnabled(false);
            this.cref = this.addComponentSelector("On Component", refid, resolver, false);
            this.xValue = this.addTextField("X", event.getAttribute("x"));
            this.yValue = this.addTextField("Y", event.getAttribute("y"));
        } else if ("KeyEvent".equals(idtype)) {
            this.type.setSelectedItem(typeValues[1]);
            Object[] kindValues = new String[]{"KEY_PRESSED", "KEY_RELEASED"};
            this.kind = this.addComboBox("Kind", idkind, kindValues);
            this.kind.setEditable(false);
            this.cref = this.addComponentSelector("On Component", refid, resolver, false);
            this.keyCode = this.addTextField("Key Code", event.getAttribute("keyCode"));
        } else {
            Log.warn("Unhandled ID type: " + idtype);
        }
        this.ignoreCombo = false;
    }

    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.cref) {
            this.event.setComponentID((String)this.cref.getSelectedItem());
            this.fireStepChanged();
        } else if (src == this.kind) {
            if (!this.ignoreCombo) {
                this.event.setAttribute("kind", (String)this.kind.getSelectedItem());
                this.fireStepChanged();
            }
        } else if (src == this.xValue) {
            try {
                int value = Integer.parseInt(this.xValue.getText());
                this.event.setAttribute("x", String.valueOf(value));
                this.xValue.setForeground(DEFAULT_FOREGROUND);
                this.fireStepChanged();
            }
            catch (NumberFormatException nfe) {
                this.xValue.setForeground(ERROR_FOREGROUND);
            }
        } else if (src == this.yValue) {
            try {
                int value = Integer.parseInt(this.yValue.getText());
                this.event.setAttribute("y", String.valueOf(value));
                this.yValue.setForeground(DEFAULT_FOREGROUND);
                this.fireStepChanged();
            }
            catch (NumberFormatException nfe) {
                this.yValue.setForeground(ERROR_FOREGROUND);
            }
        } else if (src == this.keyCode) {
            try {
                String codestr = this.keyCode.getText().trim();
                this.event.setAttribute("keyCode", codestr);
                this.keyCode.setForeground(DEFAULT_FOREGROUND);
                this.fireStepChanged();
            }
            catch (IllegalArgumentException iae) {
                this.keyCode.setForeground(ERROR_FOREGROUND);
            }
        } else {
            super.actionPerformed(ev);
        }
    }
}

