/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.editor.editors.CallEditor;
import abbot.i18n.Strings;
import abbot.script.ComponentReference;
import abbot.script.PropertyCall;
import abbot.tester.ComponentTester;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;

public abstract class PropertyCallEditor
extends CallEditor {
    private JComboBox component;
    private PropertyCall call;

    public PropertyCallEditor(PropertyCall call) {
        super(call);
        this.call = call;
        this.component = this.addComponentSelector(Strings.get("ComponentID"), call.getComponentID(), call.getResolver(), true);
        this.component.setName("component");
    }

    protected Class getComponentTargetClass(Class cls) {
        String[] args = this.getCall().getArguments();
        if (args.length == 1) {
            String id = args[0];
            ComponentReference ref = this.getCall().getResolver().getComponentReference(id);
            if (ref != null) {
                try {
                    return this.getCall().resolveClass(ref.getRefClassName());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected Map getMethods(Class cls, int mask) {
        Class<?> testerClass;
        Class<Object> componentClass;
        boolean isTester = ComponentTester.class.isAssignableFrom(cls);
        boolean isComponent = Component.class.isAssignableFrom(cls);
        Class<Object> clazz = isTester ? this.getComponentTargetClass(cls) : (componentClass = isComponent ? cls : null);
        Class<Object> clazz2 = isTester ? cls : (testerClass = isComponent ? ComponentTester.getTester(componentClass).getClass() : null);
        if (!isTester && !isComponent) {
            return super.getMethods(cls, mask);
        }
        HashMap<String, Method> map = new HashMap<String, Method>();
        if (componentClass != null) {
            for (Method m : super.getMethods(componentClass, mask).values()) {
                if (!PropertyCall.isPropertyMethod(m)) continue;
                map.put(m.getName(), m);
            }
        }
        try {
            ComponentTester tester = componentClass != null ? ComponentTester.getTester(componentClass) : (ComponentTester)testerClass.newInstance();
            for (Method m : this.getComponentTesterMethods(tester)) {
                map.put(m.getName(), m);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return map;
    }

    protected boolean includeMethod(Class cls, Method m) {
        return true;
    }

    protected Collection getComponentTesterMethods(ComponentTester tester) {
        return Arrays.asList(tester.getPropertyMethods());
    }

    protected void componentChanged() {
        this.component.setSelectedItem(this.call.getComponentID());
    }

    public void actionPerformed(ActionEvent ev) {
        block12: {
            Object src = ev.getSource();
            if (src == this.component) {
                ComponentReference ref;
                String id = (String)this.component.getSelectedItem();
                if (id != null) {
                    id = id.trim();
                }
                if ("".equals(id)) {
                    id = null;
                }
                String tcn = (ref = this.call.getResolver().getComponentReference(id)) != null ? ref.getRefClassName() : Component.class.getClass().getName();
                this.call.setComponentID(id);
                this.call.setTargetClassName(tcn);
                this.call.setArguments(new String[0]);
                this.targetClassChanged();
                this.argumentsChanged();
                this.fireStepChanged();
            } else if (src == this.method) {
                super.actionPerformed(ev);
                try {
                    Class cls = this.call.getTargetClass();
                    String methodName = (String)this.method.getSelectedItem();
                    Map methods = this.getMethods(cls, 1);
                    Method m = (Method)methods.get(methodName);
                    if (m == null) break block12;
                    Class newClass = m.getDeclaringClass();
                    if (ComponentTester.class.isAssignableFrom(newClass) && Component.class.isAssignableFrom(cls)) {
                        String id = this.call.getComponentID();
                        if (id != null) {
                            this.call.setArguments(new String[]{id});
                            this.argumentsChanged();
                        }
                        this.call.setComponentID(null);
                        this.call.setTargetClassName(newClass.getName());
                        this.componentChanged();
                        this.targetClassChanged();
                        this.fireStepChanged();
                    } else if (Component.class.isAssignableFrom(newClass) && ComponentTester.class.isAssignableFrom(cls) && this.call.getArguments().length == 1) {
                        newClass = this.getComponentTargetClass(cls);
                        String id = this.call.getArguments()[0];
                        this.call.setArguments(new String[0]);
                        this.call.setComponentID(id);
                        this.call.setTargetClassName(newClass.getName());
                        this.argumentsChanged();
                        this.componentChanged();
                        this.targetClassChanged();
                        this.fireStepChanged();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                super.actionPerformed(ev);
            }
        }
    }
}

