/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.Log;
import abbot.editor.editors.StepChangeListener;
import abbot.editor.widgets.ArrayEditor;
import abbot.editor.widgets.TextArea;
import abbot.editor.widgets.TextField;
import abbot.i18n.Strings;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Step;
import abbot.script.XMLConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public abstract class StepEditor
extends JPanel
implements ActionListener,
Scrollable,
XMLConstants {
    private Step step;
    private JLabel label;
    JTextField description;
    private LayoutManager layout;
    private ArrayList listeners = new ArrayList();
    protected static final int MARGIN = 4;
    private boolean fieldChanging = false;
    protected static Color DEFAULT_FOREGROUND = null;
    protected static Color ERROR_FOREGROUND = Color.red;
    private static final String NONE = "<None>";

    public StepEditor(Step step) {
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setLayout(new BoxLayout(this, 1));
        this.layout = this.getLayout();
        this.step = step;
        this.label = new JLabel(step.getXMLTag());
        this.label.setFont(this.label.getFont().deriveFont(1));
        this.label.setToolTipText(step.getUsage());
        this.add(this.label);
        this.description = this.addTextField(null, step.getDescription());
        this.description.setName("desc");
        this.description.setToolTipText(Strings.get("editor.step.description.tip"));
        if (DEFAULT_FOREGROUND == null) {
            DEFAULT_FOREGROUND = this.description.getForeground();
        }
    }

    public Dimension getMinimumSize() {
        Dimension min = super.getMinimumSize();
        min.width = 200;
        return min;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = 200;
        return size;
    }

    public Dimension getMaximumSize() {
        Dimension max = super.getMaximumSize();
        max.width = 400;
        return max;
    }

    protected JCheckBox addCheckBox(String title, boolean value) {
        JCheckBox cb = new JCheckBox(title);
        cb.setSelected(value);
        cb.addActionListener(this);
        this.add(cb);
        return cb;
    }

    protected JComboBox addComponentSelector(String title, String refid, Resolver resolver, boolean allowNone) {
        ComboBox cb = new ComboBox(new RefModel(resolver, allowNone));
        cb.setSelectedItem(refid);
        cb.addActionListener(this);
        this.add(title, cb);
        return cb;
    }

    protected JComboBox addComboBox(String title, Object value, Object[] values) {
        ComboBox cb = new ComboBox(values);
        cb.setEditable(true);
        cb.setSelectedItem(value);
        cb.addActionListener(this);
        this.add(title, cb);
        return cb;
    }

    protected JTextField addTextField(String title, String value) {
        return this.addTextField(title, value, null);
    }

    protected JTextField addTextField(String title, String value, String defaultValue) {
        TextField field = new TextField(value, defaultValue);
        field.addActionListener(this);
        this.add(title, field);
        return field;
    }

    protected ArrayEditor addArrayEditor(String title, Object[] values) {
        ArrayEditor ed = new ArrayEditor(values);
        ed.addActionListener(this);
        ed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() != "item.changed") {
                    StepEditor.this.revalidate();
                    StepEditor.this.repaint();
                }
            }
        });
        this.add(title, ed);
        return ed;
    }

    protected JButton addButton(String title) {
        JButton button = new JButton(title);
        button.addActionListener(this);
        this.add(button);
        return button;
    }

    protected JTextArea addTextArea(String title, String value) {
        TextArea text = new TextArea(value != null ? value : "");
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setBorder(UIManager.getBorder("TextField.border"));
        text.addActionListener(this);
        this.add(title, text);
        return text;
    }

    public void remove(Component comp) {
        if (this.getLayout() == this.layout) {
            Component[] children = super.getComponents();
            for (int i = 1; i < children.length; ++i) {
                if (children[i] != comp) continue;
                super.remove(children[i - 1]);
                break;
            }
        }
        super.remove(comp);
    }

    public Component add(String name, Component comp) {
        if (name != null) {
            JLabel label = new JLabel(name);
            label.setLabelFor(comp);
            this.add(label);
        }
        return this.add(comp);
    }

    public Component add(Component comp) {
        if (this.getLayout() == this.layout) {
            super.add(Box.createVerticalStrut(4));
            if (comp instanceof JComponent) {
                ((JComponent)comp).setAlignmentX(0.0f);
            }
        }
        return super.add(comp);
    }

    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.description) {
            String text = this.description.getText();
            String cmd = ev.getActionCommand();
            if ("".equals(text)) {
                if (!TextField.isDocumentAction(ev.getActionCommand())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StepEditor.this.description.setText(StepEditor.this.step.getDefaultDescription());
                            StepEditor.this.description.selectAll();
                        }
                    });
                    this.step.setDescription(null);
                    this.fireStepChanged();
                }
            } else if (cmd == "text-reverted" || !text.equals(this.step.getDefaultDescription())) {
                this.step.setDescription(text);
                this.fireStepChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStepChangeListener(StepChangeListener scl) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(scl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStepChangeListener(StepChangeListener scl) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(scl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStepChanged() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (StepChangeListener scl : this.listeners) {
                scl.stepChanged(this.step);
            }
        }
        if (!this.description.getText().equals(this.step.getDescription())) {
            this.description.setText(this.step.getDescription());
        }
    }

    public static StepEditor getEditor(Step step) {
        Class<?> stepClass = step.getClass();
        Log.debug("Looking up editor for " + step + " using " + stepClass);
        String className = stepClass.getName();
        className = "abbot.editor.editors." + className.substring(className.lastIndexOf(".") + 1) + "Editor";
        try {
            Log.debug("Trying " + className);
            Class<?> cls = Class.forName(className);
            Class[] types = new Class[]{stepClass};
            Constructor<?> ctor = cls.getConstructor(types);
            return (StepEditor)ctor.newInstance(step);
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            Log.warn(e);
        }
        return null;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visible, int orient, int direction) {
        return orient == 0 ? visible.width : visible.height;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle visible, int orient, int direction) {
        return orient == 0 ? 10 : this.description.getSize().height;
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.label.getText();
    }

    private class RefModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Resolver resolver;
        private boolean includeNone;
        private Object selected;
        private Collection set;

        public RefModel(Resolver r, boolean includeNone) {
            this.resolver = r;
            this.includeNone = includeNone;
            this.set = this.resolver.getComponentReferences();
        }

        public Object getElementAt(int i) {
            this.checkContents();
            if (this.includeNone) {
                if (i == 0) {
                    return StepEditor.NONE;
                }
                --i;
            }
            return ((ComponentReference)this.set.toArray()[i]).getID();
        }

        public int getSize() {
            this.checkContents();
            int size = this.set.size();
            return this.includeNone ? size + 1 : size;
        }

        public void setSelectedItem(Object o) {
            if (o instanceof ComponentReference) {
                o = ((ComponentReference)o).getID();
            } else if (o == null) {
                o = StepEditor.NONE;
            }
            this.selected = o;
            this.checkContents();
        }

        public Object getSelectedItem() {
            this.checkContents();
            return this.selected == StepEditor.NONE ? null : this.selected;
        }

        private void checkContents() {
            Collection current = this.resolver.getComponentReferences();
            if (this.set.size() != current.size()) {
                this.set = current;
                if (!StepEditor.this.fieldChanging) {
                    StepEditor.this.fieldChanging = true;
                    this.fireContentsChanged(this, 0, this.set.size() - 1);
                    StepEditor.this.fieldChanging = false;
                }
            }
        }
    }

    private class ComboBox
    extends JComboBox {
        private JTextField editor;
        private boolean configuringEditor;

        public ComboBox() {
        }

        public ComboBox(ComboBoxModel model) {
            super(model);
        }

        public ComboBox(Object[] values) {
            super(values);
        }

        public void addImpl(Component c, Object constraints, int index) {
            if (c instanceof JTextField) {
                this.editor = (JTextField)c;
                TextField.decorate(this.editor);
            }
            super.addImpl(c, constraints, index);
        }

        public void configureEditor(ComboBoxEditor editor, Object item) {
            if (!this.configuringEditor) {
                this.configuringEditor = true;
                super.configureEditor(editor, item);
                this.configuringEditor = false;
            }
        }

        public void setForeground(Color c) {
            if (this.editor != null) {
                this.editor.setForeground(c);
            }
        }

        public void fireActionEvent() {
            if (!StepEditor.this.fieldChanging) {
                StepEditor.this.fieldChanging = true;
                super.fireActionEvent();
                StepEditor.this.fieldChanging = false;
            }
        }

        public void fireItemStateChanged(ItemEvent e) {
            if (!StepEditor.this.fieldChanging) {
                StepEditor.this.fieldChanging = true;
                super.fireItemStateChanged(e);
                StepEditor.this.fieldChanging = false;
            }
        }
    }
}

