/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.Log;
import abbot.finder.Hierarchy;
import abbot.i18n.Strings;
import abbot.script.Resolver;
import abbot.script.Script;
import abbot.script.StepRunner;
import abbot.script.UIContext;
import java.util.Map;

public class Fixture
extends Script
implements UIContext {
    private static Fixture currentFixture = null;

    public Fixture(String filename, Hierarchy h) {
        super(filename, h);
    }

    public Fixture(Resolver parent, Map attributes) {
        super(parent, attributes);
        this.setHierarchy(parent.getHierarchy());
    }

    public void launch(StepRunner runner) throws Throwable {
        runner.run(this);
    }

    public boolean isLaunched() {
        return this.equivalent(currentFixture);
    }

    protected void runStep(StepRunner runner) throws Throwable {
        if (!this.isLaunched()) {
            if (currentFixture != null) {
                currentFixture.terminate();
            }
            currentFixture = this;
            super.runStep(runner);
        }
    }

    public void terminate() {
        Log.debug("fixture terminate");
        if (this.equivalent(currentFixture)) {
            if (currentFixture != this) {
                currentFixture.terminate();
            } else {
                UIContext context = this.getUIContext();
                if (context != null) {
                    context.terminate();
                }
                currentFixture = null;
            }
        }
    }

    public String getXMLTag() {
        return "fixture";
    }

    public String getDefaultDescription() {
        String ext = this.isForked() ? " &" : "";
        String desc = Strings.get("fixture.desc", new Object[]{this.getFilename(), ext});
        return desc.indexOf(UNTITLED_FILE) != -1 ? UNTITLED : desc;
    }

    public boolean equivalent(UIContext f) {
        return f instanceof Fixture && (this.equals(f) || this.getFullXMLString().equals(((Fixture)f).getFullXMLString()));
    }
}

