/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.i18n.Strings;
import abbot.tester.ComponentLocation;
import abbot.tester.JListTester;
import abbot.tester.LocationUnavailableException;
import abbot.util.ExtendedComparator;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;

public class JListLocation
extends ComponentLocation {
    private String value = null;
    private int row = -1;

    public JListLocation() {
    }

    public JListLocation(String value) {
        this.value = value;
    }

    public JListLocation(int row) {
        if (row < 0) {
            String msg = Strings.get("tester.JList.invalid_index", new Object[]{new Integer(row)});
            throw new LocationUnavailableException(msg);
        }
        this.row = row;
    }

    public JListLocation(Point where) {
        super(where);
    }

    protected String badFormat(String encoded) {
        return Strings.get("location.list.bad_format", new Object[]{encoded});
    }

    protected Point indexToPoint(JList list, int index) {
        if (index < 0 || index >= list.getModel().getSize()) {
            String msg = Strings.get("tester.JList.invalid_index", new Object[]{new Integer(index)});
            throw new LocationUnavailableException(msg);
        }
        Rectangle rect = list.getCellBounds(index, index);
        return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    private int valueToIndex(JList list, String value) {
        int size = list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            String str = JListTester.valueToString(list, i);
            if (!ExtendedComparator.stringsMatch(value, str)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(JList list) {
        if (this.value != null) {
            return this.valueToIndex(list, this.value);
        }
        if (this.row != -1) {
            return this.row;
        }
        return list.locationToIndex(super.getPoint(list));
    }

    public Point getPoint(Component c) {
        JList list = (JList)c;
        if (this.value != null || this.row != -1) {
            return this.indexToPoint(list, this.getIndex(list));
        }
        return super.getPoint(list);
    }

    public Rectangle getBounds(Component c) {
        JList list = (JList)c;
        int index = this.getIndex(list);
        if (index == -1) {
            String msg = Strings.get("tester.JList.invalid_index", new Object[]{new Integer(index)});
            throw new LocationUnavailableException(msg);
        }
        return list.getCellBounds(index, index);
    }

    public boolean equals(Object o) {
        if (o instanceof JListLocation) {
            JListLocation loc = (JListLocation)o;
            if (this.value != null) {
                return this.value.equals(loc.value);
            }
            if (this.row != -1) {
                return this.row == loc.row;
            }
        }
        return super.equals(o);
    }

    public String toString() {
        if (this.value != null) {
            return this.encodeValue(this.value);
        }
        if (this.row != -1) {
            return this.encodeIndex(this.row);
        }
        return super.toString();
    }

    public ComponentLocation parse(String encoded) {
        if (this.isValue(encoded = encoded.trim())) {
            this.value = this.parseValue(encoded);
            return this;
        }
        if (this.isIndex(encoded)) {
            this.row = this.parseIndex(encoded);
            return this;
        }
        return super.parse(encoded);
    }
}

