/*
 * Decompiled with CFR 0.152.
 */
package com.mentorgen.tools.profile.instrument;

import com.mentorgen.tools.profile.Controller;
import com.mentorgen.tools.profile.instrument.PerfClassAdapter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.objectweb.asm.jip.ClassReader;
import org.objectweb.asm.jip.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer
implements ClassFileTransformer {
    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        byte[] byArray2;
        if (string.startsWith("com/mentorgen/tools/profile")) {
            return byArray;
        }
        if (!Controller._filter.accept(classLoader)) {
            if (Controller._debug) {
                this.debug(classLoader, string, false);
            }
            return byArray;
        }
        for (String string2 : Controller._excludeList) {
            if (!string.startsWith(string2)) continue;
            if (Controller._debug) {
                this.debug(classLoader, string, false);
            }
            return byArray;
        }
        byte[] byArray3 = byArray;
        try {
            if (Controller._debug) {
                this.debug(classLoader, string, true);
            }
            ++Controller._instrumentCount;
            ClassReader classReader = new ClassReader(byArray);
            ClassWriter classWriter = new ClassWriter(true);
            PerfClassAdapter perfClassAdapter = new PerfClassAdapter(classWriter, string);
            classReader.accept(perfClassAdapter, true);
            byArray2 = classWriter.toByteArray();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
        return byArray2;
    }

    private void debug(ClassLoader classLoader, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("INST");
        } else {
            stringBuffer.append("skip");
        }
        stringBuffer.append("\t");
        stringBuffer.append(string);
        stringBuffer.append("\t");
        stringBuffer.append("[");
        stringBuffer.append(classLoader.getClass().getName());
        stringBuffer.append("]");
        System.out.println(stringBuffer.toString());
    }
}

