/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.MasterControl;
import javax.media.j3d.NativeConfigTemplate3D;
import javax.media.j3d.VirtualUniverse;

public class GraphicsConfigTemplate3D
extends GraphicsConfigTemplate {
    int depthSize = 16;
    int doubleBuffer = 1;
    int blueSize = 2;
    int greenSize = 2;
    int redSize = 2;
    int sceneAntialiasing = 3;
    int stereo = 3;
    Object testCfg;
    static Object globalLock = new Object();
    static Object monitorLock = new Object();
    static boolean threadWaiting = false;
    static NativeConfigTemplate3D nativeTemplate = new NativeConfigTemplate3D();

    public void setDoubleBuffer(int n) {
        if (n < 1 && n > 3) {
            return;
        }
        this.doubleBuffer = n;
    }

    public int getDoubleBuffer() {
        return this.doubleBuffer;
    }

    public void setStereo(int n) {
        if (n < 1 && n > 3) {
            return;
        }
        this.stereo = n;
    }

    public int getStereo() {
        return this.stereo;
    }

    public void setSceneAntialiasing(int n) {
        if (n < 1 && n > 3) {
            return;
        }
        this.sceneAntialiasing = n;
    }

    public int getSceneAntialiasing() {
        return this.sceneAntialiasing;
    }

    public void setDepthSize(int n) {
        if (n < 0) {
            return;
        }
        this.depthSize = n;
    }

    public int getDepthSize() {
        return this.depthSize;
    }

    public void setRedSize(int n) {
        if (n < 0) {
            return;
        }
        this.redSize = n;
    }

    public int getRedSize() {
        return this.redSize;
    }

    public void setGreenSize(int n) {
        if (n < 0) {
            return;
        }
        this.greenSize = n;
    }

    public int getGreenSize() {
        return this.greenSize;
    }

    public void setBlueSize(int n) {
        if (n < 0) {
            return;
        }
        this.blueSize = n;
    }

    public int getBlueSize() {
        return this.blueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicsConfiguration getBestConfiguration(GraphicsConfiguration[] graphicsConfigurationArray) {
        if (graphicsConfigurationArray == null || graphicsConfigurationArray.length == 0 || graphicsConfigurationArray[0] == null) {
            return null;
        }
        Object object = globalLock;
        synchronized (object) {
            this.testCfg = graphicsConfigurationArray;
            threadWaiting = true;
            if (Thread.currentThread() instanceof BehaviorScheduler) {
                VirtualUniverse.mc.sendRenderMessage(graphicsConfigurationArray[0], this, MasterControl.GETBESTCONFIG);
            } else {
                VirtualUniverse.mc.postRequest(MasterControl.GETBESTCONFIG, this);
            }
            GraphicsConfigTemplate3D.runMonitor(0);
            return (GraphicsConfiguration)this.testCfg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGraphicsConfigSupported(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            return false;
        }
        Object object = globalLock;
        synchronized (object) {
            this.testCfg = graphicsConfiguration;
            threadWaiting = true;
            if (Thread.currentThread() instanceof BehaviorScheduler) {
                VirtualUniverse.mc.sendRenderMessage(graphicsConfiguration, this, MasterControl.ISCONFIGSUPPORT);
            } else {
                VirtualUniverse.mc.postRequest(MasterControl.ISCONFIGSUPPORT, this);
            }
            GraphicsConfigTemplate3D.runMonitor(0);
            return (Boolean)this.testCfg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getGraphicsConfigFeatures(Canvas3D canvas3D) {
        Object object = globalLock;
        synchronized (object) {
            threadWaiting = true;
            if (Thread.currentThread() instanceof BehaviorScheduler) {
                VirtualUniverse.mc.sendRenderMessage(canvas3D.graphicsConfiguration, canvas3D, MasterControl.SET_GRAPHICSCONFIG_FEATURES);
            } else {
                VirtualUniverse.mc.postRequest(MasterControl.SET_GRAPHICSCONFIG_FEATURES, canvas3D);
            }
            GraphicsConfigTemplate3D.runMonitor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setQueryProps(Canvas3D canvas3D) {
        Object object = globalLock;
        synchronized (object) {
            threadWaiting = true;
            if (Thread.currentThread() instanceof BehaviorScheduler) {
                VirtualUniverse.mc.sendRenderMessage(canvas3D.graphicsConfiguration, canvas3D, MasterControl.SET_QUERYPROPERTIES);
            } else {
                VirtualUniverse.mc.postRequest(MasterControl.SET_QUERYPROPERTIES, canvas3D);
            }
            GraphicsConfigTemplate3D.runMonitor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runMonitor(int n) {
        Object object = monitorLock;
        synchronized (object) {
            switch (n) {
                case 0: {
                    if (!threadWaiting) break;
                    try {
                        monitorLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println(interruptedException);
                    }
                    break;
                }
                case 2: {
                    monitorLock.notify();
                    threadWaiting = false;
                }
            }
        }
    }

    private static final String enumStr(int n) {
        switch (n) {
            case 1: {
                return "REQUIRED";
            }
            case 2: {
                return "PREFERRED";
            }
            case 3: {
                return "UNNECESSARY";
            }
        }
        return "UNDEFINED";
    }

    public String toString() {
        return "redSize : " + this.redSize + ", " + "greenSize : " + this.greenSize + ", " + "blueSize : " + this.blueSize + ", " + "depthSize : " + this.depthSize + ", " + "doubleBuffer : " + GraphicsConfigTemplate3D.enumStr(this.doubleBuffer) + ", " + "sceneAntialiasing : " + GraphicsConfigTemplate3D.enumStr(this.sceneAntialiasing) + ", " + "stereo : " + GraphicsConfigTemplate3D.enumStr(this.stereo);
    }
}

