/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.FloatBufferWrapper;
import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineArrayRetained;
import javax.media.j3d.PointArrayRetained;
import javax.media.j3d.QuadArrayRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArrayRetained;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;

abstract class IndexedGeometryArrayRetained
extends GeometryArrayRetained {
    int[] indexCoord;
    int[] indexColor;
    int[] indexNormal;
    Object[] indexTexCoord;
    int indexCount;
    int initialIndexIndex = 0;
    int validIndexCount = 0;
    int[] compileIndexCount;
    int[] compileIndexOffset;
    int maxCoordIndex = 0;
    int maxColorIndex = 0;
    int maxNormalIndex = 0;
    int[] maxTexCoordIndices = null;

    IndexedGeometryArrayRetained() {
    }

    void createIndexedGeometryArrayData(int n) {
        boolean bl;
        this.indexCount = n;
        this.validIndexCount = n;
        boolean bl2 = bl = (this.vertexFormat & 0x200) == 0;
        if ((this.vertexFormat & 1) != 0) {
            this.indexCoord = new int[n];
        }
        if ((this.vertexFormat & 2) != 0 && bl) {
            this.indexNormal = new int[n];
        }
        if ((this.vertexFormat & 4) != 0 && bl) {
            this.indexColor = new int[n];
        }
        if ((this.vertexFormat & 0x460) != 0) {
            this.indexTexCoord = new Object[this.texCoordSetCount];
            if (bl) {
                for (int i = 0; i < this.texCoordSetCount; ++i) {
                    this.indexTexCoord[i] = new int[n];
                }
            }
            this.maxTexCoordIndices = new int[this.texCoordSetCount];
        }
    }

    Object cloneNonIndexedGeometry() {
        GeometryArrayRetained geometryArrayRetained = null;
        switch (this.geoType) {
            case 11: {
                geometryArrayRetained = new LineArrayRetained();
                break;
            }
            case 10: {
                geometryArrayRetained = new PointArrayRetained();
                break;
            }
            case 8: {
                geometryArrayRetained = new QuadArrayRetained();
                break;
            }
            case 9: {
                geometryArrayRetained = new TriangleArrayRetained();
            }
        }
        geometryArrayRetained.createGeometryArrayData(this.validIndexCount, this.vertexFormat & 0xFFFFF67F, this.texCoordSetCount, this.texCoordSetMap);
        geometryArrayRetained.cloneSourceArray = this;
        geometryArrayRetained.unIndexify(this);
        return geometryArrayRetained;
    }

    void execute(long l, RenderAtom renderAtom, boolean bl, boolean bl2, float f) {
        throw new RuntimeException(J3dI18N.getString("IndexedGeometryArrayRetained0"));
    }

    int getIndexCount() {
        return this.indexCount;
    }

    void doErrorCheck(int n) {
        this.doCoordCheck(n);
        if ((this.vertexFormat & 0x200) != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.doColorCheck(n);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (int i = 0; i < this.texCoordSetCount; ++i) {
                    this.doTexCoordCheck(n, i);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.doNormalCheck(n);
            }
        }
    }

    void doCoordCheck(int n) {
        block20: {
            block22: {
                block21: {
                    block19: {
                        if ((this.vertexFormat & 0x80) != 0) break block19;
                        if (n >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    if ((this.vertexFormat & 0x800) == 0) break block21;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0xF) {
                            case 1: {
                                if (this.floatBufferRefCoords == null || 3 * n < this.floatBufferRefCoords.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                            }
                            case 2: {
                                if (this.doubleBufferRefCoords == null || 3 * n < this.doubleBufferRefCoords.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                    }
                    break block20;
                }
                if ((this.vertexFormat & 0x100) != 0) break block22;
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatRefCoords != null && 3 * n >= this.floatRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 2: {
                        if (this.doubleRefCoords != null && 3 * n >= this.doubleRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 4: {
                        if (this.p3fRefCoords != null && n >= this.p3fRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 8: {
                        if (this.p3dRefCoords != null && n >= this.p3dRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                }
                break block20;
            }
            if (this.interLeavedVertexData != null && this.stride * n >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
            }
        }
    }

    void doColorCheck(int n) {
        block25: {
            block27: {
                int n2;
                block26: {
                    block24: {
                        if ((this.vertexFormat & 4) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block24;
                        if (n >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    n2 = this.getColorStride();
                    if ((this.vertexFormat & 0x800) == 0) break block26;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0x3F0) {
                            case 16: {
                                if (this.floatBufferRefColors == null || n2 * n < this.floatBufferRefColors.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                            }
                            case 32: {
                                if (this.byteBufferRefColors == null || n2 * n < this.byteBufferRefColors.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                    }
                    break block25;
                }
                if ((this.vertexFormat & 0x100) != 0) break block27;
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (this.floatRefColors != null && n2 * n >= this.floatRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 32: {
                        if (this.byteRefColors != null && n2 * n >= this.byteRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 64: {
                        if (this.c3fRefColors != null && n >= this.c3fRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 128: {
                        if (this.c4fRefColors != null && n >= this.c4fRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 256: {
                        if (this.c3bRefColors != null && n >= this.c3bRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 512: {
                        if (this.c4bRefColors != null && n >= this.c4bRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                }
                break block25;
            }
            if (this.interLeavedVertexData != null && this.stride * n >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
            }
        }
    }

    void doNormalCheck(int n) {
        block16: {
            block18: {
                block17: {
                    block15: {
                        if ((this.vertexFormat & 2) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block15;
                        if (n >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                    if ((this.vertexFormat & 0x800) == 0) break block17;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0xC00) {
                            case 1024: {
                                if (this.floatBufferRefNormals == null || 3 * n < this.floatBufferRefNormals.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                    }
                    break block16;
                }
                if ((this.vertexFormat & 0x100) != 0) break block18;
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatRefNormals != null && 3 * n >= this.floatRefNormals.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                    case 2048: {
                        if (this.v3fRefNormals != null && n >= this.v3fRefNormals.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                }
                break block16;
            }
            if (this.interLeavedVertexData != null && this.stride * n >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
            }
        }
    }

    void doTexCoordCheck(int n, int n2) {
        block18: {
            block20: {
                int n3;
                block19: {
                    block17: {
                        if ((this.vertexFormat & 0x460) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block17;
                        if (n >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    n3 = this.getTexStride();
                    if ((this.vertexFormat & 0x800) == 0) break block19;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0x7000) {
                            case 4096: {
                                FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n2]).getBufferImpl();
                                if (this.refTexCoords[n2] == null || n3 * n < floatBufferWrapper.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                    }
                    break block18;
                }
                if ((this.vertexFormat & 0x100) != 0) break block20;
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        if (this.refTexCoords[n2] != null && n3 * n >= ((float[])this.refTexCoords[n2]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    case 8192: {
                        if (this.refTexCoords[n2] != null && n >= ((TexCoord2f[])this.refTexCoords[n2]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    case 16384: {
                        if (this.refTexCoords[n2] != null && n >= ((TexCoord3f[])this.refTexCoords[n2]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                }
                break block18;
            }
            if (this.interLeavedVertexData != null && this.stride * n >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
            }
        }
    }

    final void setCoordinateIndex(int n, int n2) {
        int n3 = this.doIndexCheck(n, this.maxCoordIndex, this.indexCoord, n2);
        if (n3 > this.maxCoordIndex) {
            this.doErrorCheck(n3);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = n3;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (int i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = n3;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = n3;
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x20;
        this.indexCoord[n] = n2;
        this.maxCoordIndex = n3;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    int doIndexCheck(int n, int n2, int[] nArray, int n3) {
        int n4 = n2;
        if (n < this.initialIndexIndex) {
            return n4;
        }
        if (n >= this.initialIndexIndex + this.validIndexCount) {
            return n4;
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
        }
        if (n4 == nArray[n]) {
            if (n3 >= n4) {
                n4 = n3;
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] <= n4) continue;
                    n4 = nArray[i];
                }
            }
        } else if (n3 > n4) {
            n4 = n3;
        }
        return n4;
    }

    int doIndicesCheck(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = n2;
        boolean bl = false;
        int n4 = nArray2.length;
        boolean bl2 = false;
        for (int i = 0; i < n4; ++i) {
            if (n + i < this.initialIndexIndex || n + i >= this.initialIndexIndex + this.validIndexCount) continue;
            if (nArray2[i] < 0) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
            }
            if (nArray[n + i] == n2) {
                if (nArray2[i] >= n3) {
                    n3 = nArray2[i];
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (bl2) continue;
                bl = true;
                continue;
            }
            if (nArray2[i] < n3) continue;
            n3 = nArray2[i];
            bl = false;
            bl2 = true;
        }
        if (bl) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= n3) continue;
                n3 = nArray[i];
            }
        }
        return n3;
    }

    final void setCoordinateIndices(int n, int[] nArray) {
        int n2;
        int n3 = nArray.length;
        int n4 = this.doIndicesCheck(n, this.maxCoordIndex, this.indexCoord, nArray);
        if (n4 > this.maxCoordIndex) {
            this.doErrorCheck(n4);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = n4;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.maxTexCoordIndices[n2] = n4;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = n4;
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x20;
        this.maxCoordIndex = n4;
        n2 = 0;
        int n5 = n;
        while (n2 < n3) {
            this.indexCoord[n5] = nArray[n2];
            ++n2;
            ++n5;
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    final void setColorIndex(int n, int n2) {
        int n3 = this.maxColorIndex;
        if ((this.vertexFormat & 0x200) == 0) {
            n3 = this.doIndexCheck(n, this.maxColorIndex, this.indexColor, n2);
            if (n3 > this.maxColorIndex) {
                this.doColorCheck(n3);
            }
            this.geomLock.getLock();
            this.indexColor[n] = n2;
            this.maxColorIndex = n3;
            this.geomLock.unLock();
            if (!this.inUpdater && this.source != null && this.source.isLive()) {
                this.sendDataChangedMessage(false);
            }
        } else {
            if ((this.vertexFormat & 4) != 0 && this.indexColor == null) {
                this.indexColor = new int[this.indexCount];
                System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained1"));
            }
            this.indexColor[n] = n2;
        }
    }

    final void setColorIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        if ((this.vertexFormat & 0x200) == 0) {
            int n3 = this.doIndicesCheck(n, this.maxColorIndex, this.indexColor, nArray);
            if (n3 > this.maxColorIndex) {
                this.doColorCheck(n3);
            }
            this.geomLock.getLock();
            this.maxColorIndex = n3;
            int n4 = 0;
            int n5 = n;
            while (n4 < n2) {
                this.indexColor[n5] = nArray[n4];
                ++n4;
                ++n5;
            }
            this.geomLock.unLock();
            if (!this.inUpdater && this.source != null && this.source.isLive()) {
                this.sendDataChangedMessage(false);
            }
        } else {
            if ((this.vertexFormat & 4) != 0 && this.indexColor == null) {
                this.indexColor = new int[this.indexCount];
                System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained1"));
            }
            int n6 = 0;
            int n7 = n;
            while (n6 < n2) {
                this.indexColor[n7] = nArray[n6];
                ++n6;
                ++n7;
            }
        }
    }

    final void setNormalIndex(int n, int n2) {
        if ((this.vertexFormat & 0x200) == 0) {
            int n3 = this.doIndexCheck(n, this.maxNormalIndex, this.indexNormal, n2);
            if (n3 > this.maxNormalIndex) {
                this.doNormalCheck(n3);
            }
            this.geomLock.getLock();
            this.maxNormalIndex = n3;
            this.indexNormal[n] = n2;
            this.geomLock.unLock();
            if (!this.inUpdater && this.source != null && this.source.isLive()) {
                this.sendDataChangedMessage(false);
            }
        } else {
            if ((this.vertexFormat & 2) != 0 && this.indexNormal == null) {
                this.indexNormal = new int[this.indexCount];
                System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained2"));
            }
            this.indexNormal[n] = n2;
        }
    }

    final void setNormalIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        if ((this.vertexFormat & 0x200) == 0) {
            int n3 = this.doIndicesCheck(n, this.maxNormalIndex, this.indexNormal, nArray);
            if (n3 > this.maxNormalIndex) {
                this.doNormalCheck(n3);
            }
            this.geomLock.getLock();
            int n4 = 0;
            int n5 = n;
            while (n4 < n2) {
                this.indexNormal[n5] = nArray[n4];
                ++n4;
                ++n5;
            }
            this.maxNormalIndex = n3;
            this.geomLock.unLock();
            if (!this.inUpdater && this.source != null && this.source.isLive()) {
                this.sendDataChangedMessage(false);
            }
        } else {
            if ((this.vertexFormat & 2) != 0 && this.indexNormal == null) {
                this.indexNormal = new int[this.indexCount];
                System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained2"));
            }
            int n6 = 0;
            int n7 = n;
            while (n6 < n2) {
                this.indexNormal[n7] = nArray[n6];
                ++n6;
                ++n7;
            }
        }
    }

    final void setTextureCoordinateIndex(int n, int n2, int n3) {
        int[] nArray = (int[])this.indexTexCoord[n];
        if ((this.vertexFormat & 0x200) == 0) {
            int n4 = this.doIndexCheck(n2, this.maxTexCoordIndices[n], nArray, n3);
            if (n4 > this.maxTexCoordIndices[n]) {
                this.doTexCoordCheck(n4, n);
            }
            this.geomLock.getLock();
            this.maxTexCoordIndices[n] = n4;
            nArray[n2] = n3;
            this.geomLock.unLock();
            if (!this.inUpdater && this.source != null && this.source.isLive()) {
                this.sendDataChangedMessage(false);
            }
        } else {
            if ((this.vertexFormat & 0x460) != 0 && nArray == null) {
                nArray = new int[this.indexCount];
                this.indexTexCoord[n] = nArray;
                System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained3"));
            }
            nArray[n2] = n3;
        }
    }

    final void setTextureCoordinateIndices(int n, int n2, int[] nArray) {
        int n3 = nArray.length;
        int[] nArray2 = (int[])this.indexTexCoord[n];
        if ((this.vertexFormat & 0x200) == 0) {
            int n4 = this.doIndicesCheck(n2, this.maxTexCoordIndices[n], nArray2, nArray);
            if (n4 > this.maxTexCoordIndices[n]) {
                this.doTexCoordCheck(n4, n);
            }
            this.geomLock.getLock();
            this.maxTexCoordIndices[n] = n4;
            int n5 = 0;
            int n6 = n2;
            while (n5 < n3) {
                nArray2[n6] = nArray[n5];
                ++n5;
                ++n6;
            }
            this.geomLock.unLock();
            if (!this.inUpdater && this.source != null && this.source.isLive()) {
                this.sendDataChangedMessage(false);
            }
        } else {
            if ((this.vertexFormat & 0x460) != 0 && nArray2 == null) {
                nArray2 = new int[this.indexCount];
                this.indexTexCoord[n] = nArray2;
                System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained3"));
            }
            int n7 = 0;
            int n8 = n2;
            while (n7 < n3) {
                nArray2[n8] = nArray[n7];
                ++n7;
                ++n8;
            }
        }
    }

    final int getCoordinateIndex(int n) {
        return this.indexCoord[n];
    }

    final void getCoordinateIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.indexCoord[n4];
            ++n3;
            ++n4;
        }
    }

    final int getColorIndex(int n) {
        if ((this.vertexFormat & 0x200) != 0 && (this.vertexFormat & 4) != 0 && this.indexColor == null) {
            this.indexColor = new int[this.indexCount];
            System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained1"));
        }
        return this.indexColor[n];
    }

    final void getColorIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        if ((this.vertexFormat & 0x200) != 0 && (this.vertexFormat & 4) != 0 && this.indexColor == null) {
            this.indexColor = new int[this.indexCount];
            System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained1"));
        }
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.indexColor[n4];
            ++n3;
            ++n4;
        }
    }

    final int getNormalIndex(int n) {
        if ((this.vertexFormat & 0x200) != 0 && (this.vertexFormat & 2) != 0 && this.indexNormal == null) {
            this.indexNormal = new int[this.indexCount];
            System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained2"));
        }
        return this.indexNormal[n];
    }

    final void getNormalIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        if ((this.vertexFormat & 0x200) != 0 && (this.vertexFormat & 2) != 0 && this.indexNormal == null) {
            this.indexNormal = new int[this.indexCount];
            System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained2"));
        }
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.indexNormal[n4];
            ++n3;
            ++n4;
        }
    }

    final int getTextureCoordinateIndex(int n, int n2) {
        int[] nArray = (int[])this.indexTexCoord[n];
        if ((this.vertexFormat & 0x200) != 0 && (this.vertexFormat & 0x460) != 0 && nArray == null) {
            nArray = new int[this.indexCount];
            this.indexTexCoord[n] = nArray;
            System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained3"));
        }
        return nArray[n2];
    }

    final void getTextureCoordinateIndices(int n, int n2, int[] nArray) {
        int n3 = nArray.length;
        int[] nArray2 = (int[])this.indexTexCoord[n];
        if ((this.vertexFormat & 0x200) != 0 && (this.vertexFormat & 0x460) != 0 && nArray2 == null) {
            nArray2 = new int[this.indexCount];
            this.indexTexCoord[n] = nArray2;
            System.err.println(J3dI18N.getString("IndexedGeometryArrayRetained3"));
        }
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            nArray[n4] = nArray2[n5];
            ++n4;
            ++n5;
        }
    }

    native void executeIndexedGeometry(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8, int var9, int var10, int var11, int var12, int var13, int[] var14, int var15, int[] var16, int var17, int[] var18, float[] var19, float[] var20, int var21, int var22, int[] var23);

    native void executeIndexedGeometryBuffer(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8, int var9, int var10, int var11, int var12, int var13, int[] var14, int var15, int[] var16, int var17, int[] var18, Object var19, float[] var20, int var21, int var22, int[] var23);

    native void executeIndexedGeometryVA(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11, int var12, float[] var13, double[] var14, float[] var15, byte[] var16, float[] var17, int var18, int var19, int[] var20, int var21, int[] var22, int var23, Object[] var24, int var25, int[] var26);

    native void executeIndexedGeometryVABuffer(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11, int var12, Object var13, Object var14, float[] var15, byte[] var16, Object var17, int var18, int var19, int[] var20, int var21, int[] var22, int var23, Object[] var24, int var25, int[] var26);

    native void buildIndexedGeometry(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, float var7, boolean var8, int var9, int var10, int var11, int var12, int var13, int[] var14, int var15, int[] var16, double[] var17, double[] var18, float[] var19, int[] var20);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, int n, boolean bl4, int n2) {
        boolean bl5 = false;
        if (this.mirrorGeometry != null) {
            this.mirrorGeometry.execute(canvas3D, renderAtom, bl, bl2, f, bl3, n, bl4, n2);
            return;
        }
        if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                float[] fArray;
                int n3;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
                synchronized (indexedGeometryArrayRetained) {
                    n3 = this.dirtyFlag;
                    if (bl2 && !bl4) {
                        Object[] objectArray = this.updateAlphaInVertexData(canvas3D, n, f);
                        bl5 = objectArray[0] == Boolean.TRUE;
                        fArray = (float[])objectArray[1];
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n3 |= 4;
                        }
                    } else {
                        fArray = this.vertexData;
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n3 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
                this.executeIndexedGeometry(canvas3D.ctx, this, this.geoType, bl, bl5, bl3, bl4, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, (this.vertexFormat & 4) != 0 ? this.vertexFormat | 0xC : this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, canvas3D.texUnitStateMap, fArray, null, n2, n3, this.indexCoord);
            } else if ((this.vertexFormat & 0x100) != 0) {
                int n4;
                if (this.interLeavedVertexData == null) {
                    return;
                }
                float[] fArray = null;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
                synchronized (indexedGeometryArrayRetained) {
                    n4 = this.dirtyFlag;
                    if (bl2 && !bl4) {
                        Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n, f);
                        bl5 = objectArray[0] == Boolean.TRUE;
                        fArray = (float[])objectArray[1];
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n4 |= 4;
                        }
                    } else if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n4 |= 4;
                    }
                    this.dirtyFlag = 0;
                }
                this.executeIndexedGeometry(canvas3D.ctx, this, this.geoType, bl, bl5, bl3, bl4, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, canvas3D.texUnitStateMap, this.interLeavedVertexData, fArray, n2, n4, this.indexCoord);
            } else {
                int n5;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained;
                if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                    return;
                }
                byte[] byArray = null;
                float[] fArray = null;
                if ((this.vertexType & 0xD0) != 0) {
                    indexedGeometryArrayRetained = this;
                    synchronized (indexedGeometryArrayRetained) {
                        n5 = this.dirtyFlag;
                        if (bl2 && !bl4) {
                            fArray = this.updateAlphaInFloatRefColors(canvas3D, n, f);
                            if (f != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f;
                                n5 |= 4;
                            }
                        } else {
                            fArray = this.mirrorFloatRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n5 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else if ((this.vertexType & 0x320) != 0) {
                    indexedGeometryArrayRetained = this;
                    synchronized (indexedGeometryArrayRetained) {
                        n5 = this.dirtyFlag;
                        if (bl2 && !bl4) {
                            byArray = this.updateAlphaInByteRefColors(canvas3D, n, f);
                            if (f != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f;
                                n5 |= 4;
                            }
                        } else {
                            byArray = this.mirrorUnsignedByteRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n5 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else {
                    n5 = this.dirtyFlag;
                }
                int n6 = 0;
                if ((this.vertexType & 5) != 0) {
                    n6 |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    n6 |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    n6 |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    n6 |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    n6 |= 0x10;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    n6 |= 0x20;
                }
                this.executeIndexedGeometryVA(canvas3D.ctx, this, this.geoType, bl, bl3, bl4, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat | this.c4fAllocated, n6, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, fArray, byArray, this.mirrorFloatRefNormals, n2, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, canvas3D.texUnitStateMap, this.texCoordStride, this.mirrorRefTexCoords, n5, this.indexCoord);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n7;
            if (this.interleavedFloatBufferImpl == null) {
                return;
            }
            float[] fArray = null;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
            synchronized (indexedGeometryArrayRetained) {
                n7 = this.dirtyFlag;
                if (bl2 && !bl4) {
                    Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n, f);
                    bl5 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f;
                        n7 |= 4;
                    }
                } else if (this.lastScreenAlpha != -1.0f) {
                    this.lastScreenAlpha = -1.0f;
                    n7 |= 4;
                }
                this.dirtyFlag = 0;
            }
            this.executeIndexedGeometryBuffer(canvas3D.ctx, this, this.geoType, bl, bl5, bl3, bl4, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, canvas3D.texUnitStateMap, this.interleavedFloatBufferImpl.getBufferAsObject(), fArray, n2, n7, this.indexCoord);
        } else {
            int n8;
            Object object;
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            byte[] byArray = null;
            float[] fArray = null;
            if ((this.vertexType & 0x10) != 0) {
                object = this;
                synchronized (object) {
                    n8 = this.dirtyFlag;
                    if (bl2 && !bl4) {
                        fArray = this.updateAlphaInFloatRefColors(canvas3D, n, f);
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n8 |= 4;
                        }
                    } else {
                        fArray = this.mirrorFloatRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n8 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else if ((this.vertexType & 0x20) != 0) {
                object = this;
                synchronized (object) {
                    n8 = this.dirtyFlag;
                    if (bl2 && !bl4) {
                        byArray = this.updateAlphaInByteRefColors(canvas3D, n, f);
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n8 |= 4;
                        }
                    } else {
                        byArray = this.mirrorUnsignedByteRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n8 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else {
                n8 = this.dirtyFlag;
            }
            object = null;
            Object object2 = null;
            Object object3 = null;
            int n9 = 0;
            if ((this.vertexType & 1) != 0) {
                n9 |= 1;
                object = this.floatBufferRefCoords.getBufferAsObject();
            } else if ((this.vertexType & 2) != 0) {
                n9 |= 2;
                object = this.doubleBufferRefCoords.getBufferAsObject();
            }
            if ((this.vertexType & 0x10) != 0) {
                n9 |= 4;
                object2 = this.floatBufferRefColors.getBufferAsObject();
            } else if ((this.vertexType & 0x20) != 0) {
                n9 |= 8;
                object2 = this.byteBufferRefColors.getBufferAsObject();
            }
            if ((this.vertexType & 0xC00) != 0) {
                n9 |= 0x10;
                object3 = this.floatBufferRefNormals.getBufferAsObject();
            }
            if ((this.vertexType & 0x7000) != 0) {
                n9 |= 0x20;
            }
            this.executeIndexedGeometryVABuffer(canvas3D.ctx, this, this.geoType, bl, bl3, bl4, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat | this.c4fAllocated, n9, object, object2, fArray, byArray, object3, n2, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, canvas3D.texUnitStateMap, this.texCoordStride, this.refTexCoords, n8, this.indexCoord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildGA(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, Transform3D transform3D, Transform3D transform3D2) {
        boolean bl4 = false;
        if (this.mirrorGeometry != null) {
            ((GeometryArrayRetained)this.mirrorGeometry).buildGA(canvas3D, renderAtom, bl, bl2, f, bl3, transform3D, transform3D2);
        } else if ((this.vertexFormat & 0x80) == 0) {
            float[] fArray;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
            synchronized (indexedGeometryArrayRetained) {
                int n = this.dirtyFlag;
                if (bl2 && !bl3) {
                    Object[] objectArray = this.updateAlphaInVertexData(canvas3D, canvas3D.screen.screen, f);
                    bl4 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f;
                        n |= 4;
                    }
                } else {
                    fArray = this.vertexData;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            this.buildIndexedGeometry(canvas3D.ctx, this, this.geoType, bl, bl2, f, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat, fArray, this.indexCoord);
        }
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n;
        int n2 = arrayList.size();
        int[] nArray = null;
        this.indexCount = 0;
        for (n = 0; n < n2; ++n) {
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)arrayList.get(n);
            this.indexCount += indexedGeometryArrayRetained.validIndexCount;
        }
        this.validIndexCount = this.indexCount;
        this.initialIndexIndex = 0;
        this.compileIndexCount = new int[n2];
        this.compileIndexOffset = new int[n2];
        this.indexCoord = new int[this.indexCount];
        int n3 = n = (this.vertexFormat & 0x200) == 0 ? 1 : 0;
        if (n != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.indexColor = new int[this.indexCount];
            }
            if ((this.vertexFormat & 2) != 0) {
                this.indexNormal = new int[this.indexCount];
            }
            if ((this.vertexFormat & 0x460) != 0) {
                this.indexTexCoord = new Object[1];
                this.indexTexCoord[0] = new int[this.indexCount];
                nArray = (int[])this.indexTexCoord[0];
            }
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)arrayList.get(i);
            this.compileIndexCount[i] = n6 = indexedGeometryArrayRetained.validIndexCount;
            for (int j = 0; j < n6; ++j) {
                this.indexCoord[j + n5] = indexedGeometryArrayRetained.indexCoord[j + indexedGeometryArrayRetained.initialIndexIndex] + n4;
                if (n == 0) continue;
                if ((this.vertexFormat & 4) != 0) {
                    this.indexColor[j + n5] = indexedGeometryArrayRetained.indexColor[j + indexedGeometryArrayRetained.initialIndexIndex] + n4;
                }
                if ((this.vertexFormat & 2) != 0) {
                    this.indexNormal[j + n5] = indexedGeometryArrayRetained.indexNormal[j + indexedGeometryArrayRetained.initialIndexIndex] + n4;
                }
                if ((this.vertexFormat & 0x460) == 0) continue;
                nArray[j + n5] = ((int[])indexedGeometryArrayRetained.indexTexCoord[0])[j + indexedGeometryArrayRetained.initialIndexIndex] + n4;
            }
            this.maxCoordIndex = indexedGeometryArrayRetained.maxCoordIndex + n4;
            this.compileIndexOffset[i] = n5;
            n4 += indexedGeometryArrayRetained.vertexCount;
            n5 += n6;
        }
        super.mergeGeometryArrays(arrayList);
    }

    boolean isWriteStatic() {
        return super.isWriteStatic() && !this.source.getCapability(10) && !this.source.getCapability(12) && !this.source.getCapability(14) && !this.source.getCapability(16);
    }

    int getIndexCount(int n) {
        return this.compileIndexCount[n];
    }

    int computeMaxIndex(int n, int n2, int[] nArray) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            if (nArray[i] <= n3) continue;
            n3 = nArray[i];
        }
        return n3;
    }

    void setValidIndexCount(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray21"));
        }
        if (this.initialIndexIndex + n > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray22"));
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = null;
        n3 = this.computeMaxIndex(this.initialIndexIndex, n, this.indexCoord);
        this.doErrorCheck(n3);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                n4 = this.computeMaxIndex(this.initialIndexIndex, n, this.indexColor);
                this.doColorCheck(n4);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                nArray = new int[this.texCoordSetCount];
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    nArray[n2] = this.computeMaxIndex(this.initialIndexIndex, n, (int[])this.indexTexCoord[n2]);
                    this.doTexCoordCheck(nArray[n2], n2);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                n5 = this.computeMaxIndex(this.initialIndexIndex, n, this.indexNormal);
                this.doNormalCheck(n5);
            }
        }
        this.geomLock.getLock();
        this.validIndexCount = n;
        this.maxCoordIndex = n3;
        if ((this.vertexFormat & 0x200) == 0) {
            this.maxColorIndex = n4;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.maxTexCoordIndices[n2] = nArray[n2];
                }
            }
            this.maxNormalIndex = n5;
        } else {
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.maxTexCoordIndices[n2] = this.maxCoordIndex;
                }
            }
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    void setInitialIndexIndex(int n) {
        int n2;
        if (n + this.validIndexCount > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray22"));
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = null;
        n3 = this.computeMaxIndex(n, this.validIndexCount, this.indexCoord);
        this.doErrorCheck(n3);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                n4 = this.computeMaxIndex(n, this.validIndexCount, this.indexColor);
                this.doColorCheck(n4);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                nArray = new int[this.texCoordSetCount];
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    nArray[n2] = this.computeMaxIndex(n, this.validIndexCount, (int[])this.indexTexCoord[n2]);
                    this.doTexCoordCheck(nArray[n2], n2);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                n5 = this.computeMaxIndex(n, this.validIndexCount, this.indexNormal);
                this.doNormalCheck(n5);
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x20;
        this.initialIndexIndex = n;
        this.maxCoordIndex = n3;
        if ((this.vertexFormat & 0x200) == 0) {
            this.maxColorIndex = n4;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.maxTexCoordIndices[n2] = nArray[n2];
                }
            }
            this.maxNormalIndex = n5;
        } else {
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.maxTexCoordIndices[n2] = this.maxCoordIndex;
                }
            }
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialIndexIndex() {
        return this.initialIndexIndex;
    }

    int getValidIndexCount() {
        return this.validIndexCount;
    }

    void handleFrequencyChange(int n) {
        if (n == 10 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 4) != 0 && n == 12 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 2) != 0 && n == 14 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 0x460) != 0 && n == 16) {
            this.setFrequencyChangeMask(n, 1);
        } else {
            super.handleFrequencyChange(n);
        }
    }
}

