/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.script.XMLifiable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class XMLEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private JTextField textField = new JTextField();
    protected JComponent editorComponent = this.textField;
    protected EditorDelegate delegate = new EditorDelegate(){

        public void setValue(Object value) {
            if (value instanceof XMLifiable) {
                value = ((XMLifiable)value).toEditableString();
            }
            XMLEditor.this.textField.setText(value != null ? value.toString() : "");
        }

        public Object getCellEditorValue() {
            return XMLEditor.this.textField.getText();
        }
    };
    protected int clickCountToStart = 2;

    public XMLEditor() {
        this.textField.addActionListener(this.delegate);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegate.shouldSelectCell(anEvent);
    }

    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, false);
        this.delegate.setValue(stringValue);
        return this.editorComponent;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.delegate.setValue(value);
        return this.editorComponent;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener {
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= XMLEditor.this.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            XMLEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            XMLEditor.this.fireEditingCanceled();
        }

        public void actionPerformed(ActionEvent e) {
            XMLEditor.this.stopCellEditing();
        }

        public void itemStateChanged(ItemEvent e) {
            XMLEditor.this.stopCellEditing();
        }
    }
}

