/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.Log;
import abbot.finder.ComponentNotFoundException;
import abbot.finder.ComponentSearchException;
import abbot.finder.MultipleComponentsFoundException;
import abbot.script.ComponentReference;
import abbot.script.NoSuchReferenceException;
import abbot.script.Resolver;
import abbot.script.Step;
import abbot.tester.ComponentTester;
import abbot.util.AWT;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;

public class Event
extends Step {
    private static final String USAGE = "<event type=\"...\" kind=\"...\" [...]/>";
    private String componentID = null;
    private String type = null;
    private String kind = null;
    private Map eventAttributes = new HashMap();

    public Event(Resolver resolver, Map attributes) {
        super(resolver, attributes);
        this.componentID = (String)attributes.get("component");
        this.parseEvent(attributes);
    }

    public Event(Resolver resolver, String desc, AWTEvent event) {
        super(resolver, desc);
        int id = event.getID();
        this.type = this.simpleClassName(event.getClass());
        this.kind = ComponentTester.getEventID(event);
        Component comp = ((ComponentEvent)event).getComponent();
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            ComponentReference ref = resolver.addComponent(comp);
            this.componentID = ref.getID();
            this.eventAttributes.put("x", String.valueOf(me.getX()));
            this.eventAttributes.put("y", String.valueOf(me.getY()));
            if (id == 504 || id == 505 || id == 506) {
                this.kind = "MOUSE_MOVED";
            }
            if (me.isPopupTrigger()) {
                this.eventAttributes.put("trigger", "true");
            }
        } else if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            ComponentReference ref = resolver.addComponent(comp);
            this.componentID = ref.getID();
            if (ke.getModifiers() != 0) {
                this.eventAttributes.put("modifiers", AWT.getModifiers(ke));
            }
            if (id == 400) {
                this.eventAttributes.put("keyChar", String.valueOf(ke.getKeyChar()));
            } else {
                this.eventAttributes.put("keyCode", AWT.getKeyCode(ke.getKeyCode()));
            }
        } else {
            throw new IllegalArgumentException("Unimplemented event type " + event);
        }
    }

    public String getDefaultDescription() {
        String desc = this.type + "." + this.kind;
        if (this.type.equals("KeyEvent")) {
            desc = desc + " (" + this.eventAttributes.get("keyCode") + ")";
        }
        if (this.componentID != null) {
            desc = desc + " on ${" + this.componentID + "}";
        }
        return desc;
    }

    public String getXMLTag() {
        return "event";
    }

    public String getUsage() {
        return USAGE;
    }

    public Map getAttributes() {
        Map map = super.getAttributes();
        map.put("component", this.componentID);
        map.put("type", this.type);
        if (this.kind != null) {
            map.put("kind", this.kind);
        }
        map.putAll(this.eventAttributes);
        return map;
    }

    public void runStep() throws Throwable {
        ComponentTester.getTester(Component.class).sendEvent(this.createEvent(System.currentTimeMillis()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseEvent(Map map) {
        this.type = (String)map.get("type");
        this.componentID = (String)map.get("component");
        this.kind = (String)map.get("kind");
        if (this.type == null) {
            this.usage("AWT event type missing");
        }
        if (this.type.endsWith("MouseEvent")) {
            String modifiers = (String)map.get("modifiers");
            String x = (String)map.get("x");
            String y = (String)map.get("y");
            String count = (String)map.get("count");
            String trigger = (String)map.get("trigger");
            if (this.kind == null) {
                this.usage("MouseEvent must specify a kind");
            }
            if (modifiers != null) {
                this.eventAttributes.put("modifiers", modifiers);
            }
            if (x != null) {
                this.eventAttributes.put("x", x);
            }
            if (y != null) {
                this.eventAttributes.put("y", y);
            }
            if (count != null) {
                this.eventAttributes.put("count", count);
            }
            if (trigger != null) {
                this.eventAttributes.put("trigger", trigger);
            }
            if (!this.type.equals("MenuDragMouseEvent")) return;
        }
        if (this.type.equals("KeyEvent")) {
            if (this.kind == null) {
                this.usage("KeyEvent must specify a kind");
            }
            String keyCode = (String)map.get("keyCode");
            String modifiers = (String)map.get("modifiers");
            String keyChar = (String)map.get("keyChar");
            if (keyCode == null) {
                if (!this.kind.equals("KEY_TYPED")) {
                    this.usage("KeyPress/Release require a keyCode");
                }
            } else if (!this.kind.equals("KEY_TYPED")) {
                this.eventAttributes.put("keyCode", keyCode);
            }
            if (keyChar == null) {
                if (this.kind.equals("KEY_TYPED")) {
                    this.usage("KeyTyped requires a keyChar");
                }
            } else if (this.kind.equals("KEY_TYPED")) {
                this.eventAttributes.put("keyChar", keyChar);
            }
            if (modifiers == null || "".equals(modifiers)) return;
            this.eventAttributes.put("modifiers", modifiers);
            return;
        } else {
            Log.warn("Unimplemented event type '" + this.type + "', placeholder");
        }
    }

    protected Component resolve(String name) throws NoSuchReferenceException, ComponentNotFoundException, MultipleComponentsFoundException {
        ComponentReference ref = this.getResolver().getComponentReference(name);
        if (ref != null) {
            return ref.getComponent();
        }
        throw new NoSuchReferenceException(name);
    }

    private AWTEvent createEvent(long timestamp) throws ComponentSearchException, NoSuchReferenceException {
        Component comp = null;
        if (this.componentID != null) {
            comp = this.resolve(this.componentID);
        }
        long when = timestamp;
        if (this.type.endsWith("MouseEvent")) {
            int x = (comp.getSize().width + 1) / 2;
            int y = (comp.getSize().height + 1) / 2;
            int count = 1;
            boolean trigger = false;
            String modifiers = (String)this.eventAttributes.get("modifiers");
            int mods = modifiers != null ? AWT.getModifiers(modifiers) : 0;
            try {
                x = Integer.parseInt((String)this.eventAttributes.get("x"));
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                y = Integer.parseInt((String)this.eventAttributes.get("y"));
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                count = Integer.parseInt((String)this.eventAttributes.get("count"));
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                trigger = Boolean.getBoolean((String)this.eventAttributes.get("trigger"));
            }
            catch (Exception exc) {
                // empty catch block
            }
            int id = ComponentTester.getEventID(MouseEvent.class, this.kind);
            return new MouseEvent(comp, id, when, mods, x, y, count, trigger);
        }
        if (this.type.equals("KeyEvent")) {
            String modifiers = (String)this.eventAttributes.get("modifiers");
            int mods = modifiers != null ? AWT.getModifiers(modifiers) : 0;
            int code = AWT.getKeyCode((String)this.eventAttributes.get("keyCode"));
            String ch = (String)this.eventAttributes.get("keyChar");
            char keyChar = ch != null ? ch.charAt(0) : (char)code;
            int id = ComponentTester.getEventID(KeyEvent.class, this.kind);
            return new KeyEvent(comp, id, when, mods, code, keyChar);
        }
        throw new IllegalArgumentException("Bad event type " + this.type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getComponentID() {
        return this.componentID;
    }

    public void setComponentID(String id) {
        this.componentID = id;
    }

    public String getAttribute(String tag) {
        return (String)this.eventAttributes.get(tag);
    }

    public void setAttribute(String tag, String value) {
        this.eventAttributes.put(tag, value);
    }
}

