/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;

public class FileComparator
implements Comparator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compare(Object f1, Object f2) {
        File file2;
        File file1;
        if (f1 == f2) return 0;
        if (f1 != null && f1.equals(f2)) {
            return 0;
        }
        if (f1 == null) {
            return -1;
        }
        if (f2 == null) {
            return 1;
        }
        if (f1 instanceof File) {
            file1 = (File)f1;
        } else {
            if (!(f1 instanceof String)) throw new IllegalArgumentException("Expecting a File or String");
            file1 = new File((String)f1);
        }
        if (f2 instanceof File) {
            file2 = (File)f2;
        } else {
            if (!(f2 instanceof String)) throw new IllegalArgumentException("Expecting a File or String");
            file2 = new File((String)f2);
        }
        if (file1.equals(file2)) {
            return 0;
        }
        if (!file1.exists()) throw new IllegalArgumentException("File '" + file1 + "' does not exist");
        if (!file1.isFile()) {
            throw new IllegalArgumentException("File '" + file1 + "' does not exist");
        }
        if (!file2.exists()) throw new IllegalArgumentException("File '" + file2 + "' does not exist");
        if (!file2.isFile()) {
            throw new IllegalArgumentException("File '" + file2 + "' does not exist");
        }
        if (file1.length() != file2.length()) {
            return (int)(file1.length() - file2.length());
        }
        BufferedInputStream is1 = null;
        BufferedInputStream is2 = null;
        try {
            is1 = new BufferedInputStream(new FileInputStream(file1));
            is2 = new BufferedInputStream(new FileInputStream(file2));
            int b1 = -2;
            int b2 = -2;
            try {
                while ((b1 = ((InputStream)is1).read()) != -1) {
                    b2 = ((InputStream)is2).read();
                    if (b2 == -1) return 0;
                    if (b1 != b2) {
                        int n = b1 - b2;
                        return n;
                    }
                    b2 = -2;
                    b1 = -2;
                }
                return 0;
            }
            catch (IOException io) {
                int n = b1 == -2 ? -1 : 1;
                return n;
            }
            finally {
                ((InputStream)is1).close();
                is1 = null;
                ((InputStream)is2).close();
                is2 = null;
            }
        }
        catch (FileNotFoundException fnf) {
            if (is1 != null) return 1;
            return -1;
        }
        catch (IOException io) {
            if (is1 != null) return 1;
            return -1;
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(this.getClass());
    }
}

