/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.editor.recorder.DialogRecorder;
import abbot.script.Action;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Sequence;
import abbot.script.Step;
import java.awt.AWTEvent;
import java.awt.FileDialog;
import java.awt.event.WindowEvent;

public class FileDialogRecorder
extends DialogRecorder {
    private FileDialog dialog = null;
    private String originalFile = null;
    private String originalDir = null;

    public FileDialogRecorder(Resolver resolver) {
        super(resolver);
    }

    protected void init(int type) {
        super.init(type);
        this.dialog = null;
        this.originalFile = null;
        this.originalDir = null;
    }

    protected boolean parseWindowEvent(AWTEvent event) {
        boolean consumed = true;
        if (event.getSource() instanceof FileDialog) {
            if (this.isOpen(event)) {
                this.dialog = (FileDialog)event.getSource();
                this.originalFile = this.dialog.getFile();
                this.originalDir = this.dialog.getDirectory();
            }
            if (event instanceof FileDialogTerminator) {
                this.setFinished(true);
            } else if (event.getSource() == this.dialog && this.isClose(event)) {
                FileDialogTerminator terminator = new FileDialogTerminator(this.dialog, event.getID());
                this.dialog.getToolkit().getSystemEventQueue().postEvent(terminator);
            }
        }
        return consumed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Step createFileDialogEvents(FileDialog d, String oldDir, String oldFile) {
        ComponentReference ref = this.getResolver().addComponent(d);
        String file = d.getFile();
        boolean accepted = file != null;
        boolean fileChanged = accepted && !file.equals(oldFile);
        String dir = d.getDirectory();
        boolean dirChanged = dir != oldDir && (dir == null || !dir.equals(oldDir));
        String desc = d.getMode() == 1 ? "Save File" : "Load File";
        desc = accepted ? desc + " (" + file + ")" : desc + " (canceled)";
        Sequence seq = new Sequence(this.getResolver(), desc);
        if (dirChanged) {
            seq.addStep(new Action(this.getResolver(), null, "actionSetDirectory", new String[]{ref.getID(), dir}, FileDialog.class));
        }
        if (accepted) {
            Action accept = new Action(this.getResolver(), null, "actionAccept", new String[]{ref.getID()}, FileDialog.class);
            if (!fileChanged) return accept;
            seq.addStep(new Action(this.getResolver(), null, "actionSetFile", new String[]{ref.getID(), file}, FileDialog.class));
            seq.addStep(accept);
            return seq;
        } else {
            Action cancel = new Action(this.getResolver(), null, "actionCancel", new String[]{ref.getID()}, FileDialog.class);
            if (!dirChanged) return cancel;
            seq.addStep(cancel);
        }
        return seq;
    }

    protected Step createStep() {
        if (this.getRecordingType() == 1) {
            return this.createFileDialogEvents(this.dialog, this.originalDir, this.originalFile);
        }
        return super.createStep();
    }

    private class FileDialogTerminator
    extends WindowEvent {
        public FileDialogTerminator(FileDialog fd, int id) {
            super(fd, id);
        }
    }
}

