/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.Log;
import abbot.Platform;
import abbot.finder.AWTHierarchy;
import abbot.finder.Hierarchy;
import abbot.i18n.Strings;
import abbot.script.ArgumentParser;
import abbot.script.ComponentReference;
import abbot.script.Interpreter;
import abbot.script.InvalidScriptException;
import abbot.script.Resolver;
import abbot.script.Sequence;
import abbot.script.Step;
import abbot.script.StepRunner;
import abbot.script.Terminate;
import abbot.script.UIContext;
import abbot.script.parsers.FileParser;
import abbot.script.parsers.Parser;
import abbot.tester.Robot;
import abbot.util.Properties;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Script
extends Sequence
implements Resolver {
    public static final String INTERPRETER = "bsh";
    private static final String USAGE = "<AWTTestScript [desc=\"\"] [forked=\"true\"] [slow=\"true\"] [awt=\"true\"] [vmargs=\"...\"]>...</AWTTestScript>\n";
    private static int slowDelay = 250;
    static boolean validate = true;
    private String filename;
    private File relativeDirectory;
    private boolean fork;
    private boolean slow;
    private boolean awt;
    private int lastSaved;
    private String vmargs;
    private Map properties = new HashMap();
    private Hierarchy hierarchy;
    public static final String UNTITLED_FILE = Strings.get("script.untitled_filename");
    protected static final String UNTITLED = Strings.get("script.untitled");
    private Map refs = Collections.unmodifiableMap(new HashMap());
    private Map components = new WeakHashMap();
    private static final String XML_INFO = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private boolean formatForSave = false;

    protected static Map createDefaultMap(String filename) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filename", filename);
        return map;
    }

    public Script() {
        this(AWTHierarchy.getDefault());
    }

    public Script(String filename) {
        this(filename, AWTHierarchy.getDefault());
    }

    public Script(Hierarchy h) {
        this(null, new HashMap());
        this.setHierarchy(h);
    }

    public Script(String filename, Hierarchy h) {
        this(null, Script.createDefaultMap(filename));
        this.setHierarchy(h);
    }

    public Script(Resolver parent, Map attributes) {
        super(parent, attributes);
        String filename = (String)attributes.get("filename");
        File file = filename != null ? new File(filename) : this.getTempFile(parent != null ? parent.getDirectory() : null);
        this.setFile(file);
        if (parent != null) {
            this.setRelativeTo(parent.getDirectory());
        }
        try {
            this.load();
        }
        catch (IOException e) {
            this.setScriptError(e);
        }
    }

    private synchronized void synchReferenceIDs() {
        HashMap<String, ComponentReference> map = new HashMap<String, ComponentReference>();
        for (ComponentReference ref : this.refs.values()) {
            map.put(ref.getID(), ref);
        }
        if (!((Object)this.refs).equals(map)) {
            this.refs = Collections.unmodifiableMap(map);
        }
    }

    public void setHierarchy(Hierarchy h) {
        this.hierarchy = h;
        this.components.clear();
    }

    private File getTempFile(File dir) {
        File file;
        try {
            file = dir != null ? File.createTempFile(UNTITLED_FILE, ".xml", dir) : File.createTempFile(UNTITLED_FILE, ".xml");
            file.delete();
        }
        catch (IOException io) {
            file = dir != null ? new File(dir, UNTITLED_FILE + ".xml") : new File(UNTITLED_FILE + ".xml");
        }
        return file;
    }

    public String getName() {
        return this.filename;
    }

    public void setForked(boolean fork) {
        this.fork = fork;
    }

    public boolean isForked() {
        return this.fork;
    }

    public void setVMArgs(String args) {
        if (args != null && "".equals(args)) {
            args = null;
        }
        this.vmargs = args;
    }

    public String getVMArgs() {
        return this.vmargs;
    }

    public boolean isSlowPlayback() {
        return this.slow;
    }

    public void setSlowPlayback(boolean slow) {
        this.slow = slow;
    }

    public boolean isAWTMode() {
        return this.awt;
    }

    public void setAWTMode(boolean awt) {
        this.awt = awt;
    }

    public File getFile() {
        File file = new File(this.filename);
        if (!file.isAbsolute()) {
            String path = this.getRelativeTo().getPath() + File.separator + this.filename;
            file = new File(path);
        }
        return file;
    }

    public void changeFile(File file) {
        this.setFile(file);
    }

    public void setFile(File file) {
        Log.debug("Script file set to " + file);
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (this.filename == null || !file.equals(this.getFile())) {
            this.filename = file.getPath();
            Log.debug("Script filename set to " + this.filename);
            if (this.relativeDirectory != null) {
                this.setRelativeTo(this.relativeDirectory);
            }
        }
        this.lastSaved = this.getHash() + 1;
    }

    public void save(Writer writer) throws IOException {
        this.formatForSave = true;
        Element el = this.toXML();
        this.formatForSave = false;
        el.setName("AWTTestScript");
        Document doc = new Document(el);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(doc, writer);
    }

    public String toEditableString() {
        return this.getFilename();
    }

    public boolean isDirty() {
        return this.getHash() != this.lastSaved;
    }

    public void save() throws IOException {
        File file = this.getFile();
        Log.debug("Saving script to '" + file + "' " + this.hashCode());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        this.save(new BufferedWriter(writer));
        writer.close();
        this.lastSaved = this.getHash();
    }

    private synchronized void verify() throws InvalidScriptException {
        Log.debug("verifying all referenced refs exist");
        for (ComponentReference ref : this.refs.values()) {
            String id = ref.getAttribute("parent");
            if (id != null && this.refs.get(id) == null) {
                String msg = Strings.get("script.parent_missing", new Object[]{id});
                throw new InvalidScriptException(msg);
            }
            id = ref.getAttribute("window");
            if (id == null || this.refs.get(id) != null) continue;
            String msg = Strings.get("script.window_missing", new Object[]{id});
            throw new InvalidScriptException(msg);
        }
    }

    private void updateRelativePath(Step child) {
        if (child instanceof Script) {
            ((Script)child).setRelativeTo(this.getDirectory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseChild(Element el) throws InvalidScriptException {
        if (el.getName().equals("component")) {
            this.addComponentReference(el);
        } else {
            List list = this.steps();
            synchronized (list) {
                super.parseChild(el);
                this.updateRelativePath((Step)this.steps().get(this.size() - 1));
            }
        }
    }

    protected void parseAttributes(Map map) {
        this.parseStepAttributes(map);
        this.fork = Boolean.valueOf((String)map.get("forked"));
        this.slow = Boolean.valueOf((String)map.get("slow"));
        this.awt = Boolean.valueOf((String)map.get("awt"));
        this.vmargs = (String)map.get("vmargs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader reader) throws InvalidScriptException, IOException {
        this.clear();
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
            if (validate) {
                URL url = this.getClass().getClassLoader().getResource("abbot/abbot.xsd");
                if (url != null) {
                    builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
                    builder.setFeature("http://apache.org/xml/features/validation/schema", true);
                    builder.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", url.toString());
                } else {
                    Log.warn("Could not find abbot/abbot.xsd, disabling XML validation");
                    validate = false;
                }
            }
            Document doc = builder.build(reader);
            Element root = doc.getRootElement();
            Map map = Script.createAttributeMap(root);
            this.parseAttributes(map);
            this.parseChildren(root);
        }
        catch (JDOMException e) {
            throw new InvalidScriptException(e.getMessage());
        }
        Script script = this;
        synchronized (script) {
            this.synchReferenceIDs();
            this.verify();
        }
        this.lastSaved = this.getHash();
    }

    public void addStep(int index, Step step) {
        super.addStep(index, step);
        this.updateRelativePath(step);
    }

    public void addStep(Step step) {
        super.addStep(step);
        this.updateRelativePath(step);
    }

    public void setStep(int index, Step step) {
        super.setStep(index, step);
        this.updateRelativePath(step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        File file = this.getFile();
        if (!file.exists()) {
            if (this.getFilename().indexOf(UNTITLED_FILE) == -1) {
                Log.warn("Script " + this + " does not exist, ignoring it");
            }
            return;
        }
        if (!file.isFile()) {
            throw new InvalidScriptException("Path " + this.getFilename() + " refers to a directory");
        }
        if (file.length() != 0L) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                try {
                    this.load(new BufferedReader(reader));
                }
                finally {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (FileNotFoundException e) {
                Log.warn("File '" + file + "' exists but is not found");
            }
        } else {
            Log.warn("Script file " + this + " is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFullXMLString() {
        try {
            this.formatForSave = true;
            String string = Script.toXMLString(this);
            return string;
        }
        finally {
            this.formatForSave = false;
        }
    }

    private int getHash() {
        return this.getFullXMLString().hashCode();
    }

    public String getXMLTag() {
        return "script";
    }

    public Element addContent(Element el) {
        if (this.formatForSave) {
            this.synchReferenceIDs();
            for (ComponentReference cref : new TreeSet(this.refs.values())) {
                el.addContent(cref.toXML());
            }
            return super.addContent(el);
        }
        return el;
    }

    public String getFilename() {
        return this.filename;
    }

    public Map getAttributes() {
        HashMap<String, String> map;
        if (!this.formatForSave) {
            map = new HashMap<String, String>();
            map.put("filename", this.getFilename());
        } else {
            map = super.getAttributes();
            if (this.fork) {
                map.put("forked", "true");
                if (this.vmargs != null) {
                    map.put("vmargs", this.vmargs);
                }
            }
            if (this.slow) {
                map.put("slow", "true");
            }
            if (this.awt) {
                map.put("awt", "true");
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runStep(StepRunner runner) throws Throwable {
        this.components.clear();
        this.properties.clear();
        FileParser fc = new FileParser(){

            public String relativeTo() {
                Log.debug("All file references will be relative to " + Script.this.getDirectory().getAbsolutePath());
                return Script.this.getDirectory().getAbsolutePath();
            }
        };
        Parser oldfc = ArgumentParser.setParser(File.class, fc);
        int oldDelay = Robot.getAutoDelay();
        int oldMode = Robot.getEventMode();
        if (this.slow) {
            Robot.setAutoDelay(slowDelay);
        }
        if (this.awt) {
            Robot.setEventMode(Robot.EM_AWT);
        }
        try {
            super.runStep(runner);
        }
        finally {
            Robot.setAutoDelay(oldDelay);
            Robot.setEventMode(oldMode);
            ArgumentParser.setParser(File.class, oldfc);
        }
    }

    public void clear() {
        this.setScriptError(null);
        this.refs = Collections.unmodifiableMap(new HashMap());
        this.components.clear();
        super.clear();
    }

    public String getUsage() {
        return USAGE;
    }

    public String getDefaultDescription() {
        String ext = this.fork ? " &" : "";
        String desc = Strings.get("script.desc", new Object[]{this.getFilename(), ext});
        return desc.indexOf(UNTITLED_FILE) != -1 ? UNTITLED : desc;
    }

    public boolean hasLaunch() {
        return this.size() > 0 && (Step)this.steps().get(0) instanceof UIContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIContext getUIContext() {
        List list = this.steps();
        synchronized (list) {
            if (this.hasLaunch()) {
                return (UIContext)this.steps().get(0);
            }
        }
        return null;
    }

    public ClassLoader getContextClassLoader() {
        UIContext context = this.getUIContext();
        return context != null ? context.getContextClassLoader() : Thread.currentThread().getContextClassLoader();
    }

    public boolean hasTerminate() {
        return this.size() > 0 && (Step)this.steps().get(this.size() - 1) instanceof Terminate;
    }

    public File getRelativeTo() {
        if (this.relativeDirectory == null) {
            return new File(System.getProperty("user.dir"));
        }
        return this.relativeDirectory;
    }

    public void setRelativeTo(File dir) {
        char ch;
        String relPath;
        Log.debug("Want relative dir " + dir);
        this.relativeDirectory = dir;
        if (dir != null && this.filename.startsWith(relPath = dir.getPath()) && relPath.length() < this.filename.length() && ((ch = this.filename.charAt(relPath.length())) == '/' || ch == '\\')) {
            this.filename = this.filename.substring(relPath.length() + 1);
        }
        Log.debug("Relative dir set to " + this.relativeDirectory + " for " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isScript(File file) {
        if (file.length() == 0L) {
            return true;
        }
        if (!file.exists() || !file.isFile() || file.length() < (long)("AWTTestScript".length() * 2 + 5)) {
            return false;
        }
        InputStream is = null;
        try {
            int len = XML_INFO.length() + "AWTTestScript".length() + 15;
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[len];
            is.read(buf, 0, buf.length);
            String str = new String(buf, 0, buf.length);
            boolean bl = str.indexOf("AWTTestScript") != -1;
            return bl;
        }
        catch (Exception exc) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exc) {}
            }
        }
    }

    public File getDirectory() {
        return this.getFile().getParentFile();
    }

    public Collection getComponentReferences() {
        return new TreeSet(this.refs.values());
    }

    public void addComponentReference(ComponentReference ref) {
        Log.debug("adding " + ref);
        this.synchReferenceIDs();
        HashMap<String, ComponentReference> map = new HashMap<String, ComponentReference>(this.refs);
        map.put(ref.getID(), ref);
        this.refs = Collections.unmodifiableMap(map);
    }

    public ComponentReference addComponent(Component comp) {
        this.synchReferenceIDs();
        Log.debug("look up existing for " + Robot.toString(comp));
        HashMap newRefs = new HashMap();
        ComponentReference ref = ComponentReference.getReference(this, comp, newRefs);
        Log.debug("adding " + Robot.toString(comp));
        HashMap map = new HashMap(this.refs);
        map.putAll(newRefs);
        for (ComponentReference r : newRefs.values()) {
            Component c = r.getCachedLookup(this.getHierarchy());
            if (c == null) continue;
            this.components.put(c, r);
        }
        this.refs = Collections.unmodifiableMap(map);
        return ref;
    }

    ComponentReference addComponentReference(Element el) throws InvalidScriptException {
        this.synchReferenceIDs();
        ComponentReference ref = new ComponentReference((Resolver)this, el);
        Log.debug("adding " + el);
        HashMap<String, ComponentReference> map = new HashMap<String, ComponentReference>(this.refs);
        map.put(ref.getID(), ref);
        this.refs = Collections.unmodifiableMap(map);
        return ref;
    }

    public ComponentReference getComponentReference(Component comp) {
        ComponentReference ref;
        if (!this.getHierarchy().contains(comp)) {
            String msg = Strings.get("script.not_in_hierarchy", new Object[]{comp.toString()});
            throw new IllegalArgumentException(msg);
        }
        this.synchReferenceIDs();
        for (ComponentReference cr : this.refs.values()) {
            if (cr.getCachedLookup(this.getHierarchy()) != null) continue;
            this.components.clear();
            break;
        }
        if ((ref = (ComponentReference)this.components.get(comp)) != null) {
            if (ref.getCachedLookup(this.getHierarchy()) != null) {
                return ref;
            }
            this.components.remove(comp);
        }
        if ((ref = ComponentReference.matchExisting(comp, this.refs.values())) != null) {
            this.components.put(comp, ref);
        }
        return ref;
    }

    public ComponentReference getComponentReference(String name) {
        this.synchReferenceIDs();
        return (ComponentReference)this.refs.get(name);
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public Object getProperty(String name) {
        Object value = this.properties.get(name);
        if (value == null && INTERPRETER.equals(name)) {
            Interpreter bsh = new Interpreter(this);
            value = bsh;
            this.properties.put(name, value);
        }
        return value;
    }

    public Hierarchy getHierarchy() {
        Resolver r = this.getResolver();
        if (r != null && r != this) {
            return r.getHierarchy();
        }
        return this.hierarchy != null ? this.hierarchy : AWTHierarchy.getDefault();
    }

    public String getContext(Step step) {
        return this.getFile().toString() + ":" + Script.getLine(this, step);
    }

    public static File getFile(Step step) {
        String context = step.getResolver().getContext(step);
        int colon = context.indexOf(":");
        if (colon == 1 && Character.isLetter(context.charAt(0)) && Platform.isWindows() && context.length() > 2) {
            colon = context.indexOf(":", 2);
        }
        if (colon != -1) {
            context = context.substring(0, colon);
        }
        return new File(context);
    }

    public static int getLine(Step step) {
        String context = step.getResolver().getContext(step);
        int colon = context.indexOf(":");
        if (colon == 1 && Character.isLetter(context.charAt(0)) && Platform.isWindows() && context.length() > 2) {
            colon = context.indexOf(":", 2);
        }
        context = context.substring(colon + 1);
        try {
            return Integer.parseInt(context);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static int getLine(Sequence seq, Step step) {
        int line = -1;
        int index = seq.indexOf(step);
        if (index == -1) {
            List list = seq.steps();
            for (int i = 0; i < list.size(); ++i) {
                int subline;
                Step sub = (Step)list.get(i);
                if (!(sub instanceof Sequence) || (subline = Script.getLine((Sequence)sub, step)) == -1) continue;
                line = Script.countLines(seq, i) + subline;
                break;
            }
        } else {
            line = Script.countLines(seq, index);
        }
        return line;
    }

    public static int countLines(Sequence seq, int index) {
        int count = 1;
        int limit = index;
        if (limit == -1) {
            limit = seq.size();
            if (limit == 0) {
                return 1;
            }
            count = 2;
        }
        if (seq instanceof Script) {
            count += ((Script)seq).getComponentReferences().size() + 2;
        }
        for (int i = 0; i < limit; ++i) {
            Step step = seq.getStep(i);
            if (step instanceof Script) {
                ++count;
                continue;
            }
            if (step instanceof Sequence) {
                count += Script.countLines((Sequence)step, -1);
                continue;
            }
            ++count;
        }
        return count;
    }

    static {
        slowDelay = Properties.getProperty("abbot.script.slow_delay", slowDelay, 0, 60000);
        String defValue = Platform.JAVA_VERSION < 5120 ? "false" : "true";
        validate = "true".equals(System.getProperty("abbot.script.validate", defValue));
    }
}

