/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.Log;
import abbot.i18n.Strings;
import abbot.script.Comment;
import abbot.script.InvalidScriptException;
import abbot.script.Resolver;
import abbot.script.XMLConstants;
import abbot.script.XMLifiable;
import abbot.tester.ComponentTester;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public abstract class Step
implements XMLConstants,
XMLifiable,
Serializable {
    private String description = null;
    private Resolver resolver;
    private Throwable invalidScriptError = null;

    public Step(Resolver resolver, Map attributes) {
        this(resolver, "");
        Log.debug("Instantiating " + this.getClass());
        if (Log.isClassDebugEnabled(Step.class)) {
            for (String key : attributes.keySet()) {
                Log.debug(key + "=" + attributes.get(key));
            }
        }
        this.parseStepAttributes(attributes);
    }

    public Step(Resolver resolver, String description) {
        if (resolver == null) {
            if (!(this instanceof Resolver)) {
                throw new Error("Resolver must be provided");
            }
            resolver = (Resolver)((Object)this);
        } else if (this instanceof Resolver) {
            resolver = (Resolver)((Object)this);
        }
        this.resolver = resolver;
        if ("".equals(description)) {
            description = null;
        }
        this.description = description;
    }

    protected final void parseStepAttributes(Map attributes) {
        Log.debug("Parsing attributes for " + this.getClass());
        this.description = (String)attributes.get("desc");
    }

    public final void run() throws Throwable {
        if (this.invalidScriptError != null) {
            throw this.invalidScriptError;
        }
        Log.debug("Running " + this.toString());
        this.runStep();
    }

    protected abstract void runStep() throws Throwable;

    public String getDescription() {
        return this.description != null ? this.description : this.getDefaultDescription();
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public abstract String getXMLTag();

    public abstract String getUsage();

    public abstract String getDefaultDescription();

    protected void setScriptError(Throwable thr) {
        if (this.invalidScriptError == null) {
            this.invalidScriptError = thr;
        } else {
            Log.warn("More than one script error encountered: " + thr);
            Log.warn("Already have: " + this.invalidScriptError);
        }
    }

    protected void usage() {
        this.usage(null);
    }

    protected void usage(String details) {
        String msg = this.getUsage();
        if (details != null) {
            msg = Strings.get("step.usage", new Object[]{msg, details});
        }
        this.setScriptError(new InvalidScriptException(msg));
    }

    public Map getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.description != null && !this.description.equals(this.getDefaultDescription())) {
            map.put("desc", this.description);
        }
        return map;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    protected Element addContent(Element el) {
        return el;
    }

    protected Element addAttributes(Element el) {
        TreeMap atts = new TreeMap(this.getAttributes());
        for (String key : atts.keySet()) {
            String value = (String)atts.get(key);
            if (value == null) {
                Log.warn("Attribute '" + key + "' value was null in step " + this.getXMLTag());
                value = "";
            }
            el.setAttribute(key, value);
        }
        return el;
    }

    public String toEditableString() {
        return Step.toXMLString(this);
    }

    public static String toXMLString(XMLifiable obj) {
        if (obj instanceof Comment) {
            return "<!-- " + ((Comment)obj).getDescription() + " -->";
        }
        Element el = obj.toXML();
        StringWriter writer = new StringWriter();
        try {
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(el, (Writer)writer);
        }
        catch (IOException io) {
            Log.warn(io);
        }
        return writer.toString();
    }

    public Element toXML() {
        return this.addAttributes(this.addContent(new Element(this.getXMLTag())));
    }

    public static Step createStep(Resolver resolver, String str) throws InvalidScriptException, IOException {
        StringReader reader = new StringReader(str);
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(reader);
            Element el = doc.getRootElement();
            return Step.createStep(resolver, el);
        }
        catch (JDOMException e) {
            throw new InvalidScriptException(e.getMessage());
        }
    }

    protected static Map createAttributeMap(Element el) {
        Log.debug("Creating attribute map for " + el);
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Attribute att : el.getAttributes()) {
            attributes.put(att.getName(), att.getValue());
        }
        return attributes;
    }

    public static Step createStep(Resolver resolver, Element el) throws InvalidScriptException {
        String tag = el.getName();
        Map attributes = Step.createAttributeMap(el);
        String name = tag.substring(0, 1).toUpperCase() + tag.substring(1);
        if (tag.equals("wait")) {
            attributes.put("wait", "true");
            name = "Assert";
        }
        try {
            name = "abbot.script." + name;
            Log.debug("Instantiating " + name);
            Class<?> cls = Class.forName(name);
            try {
                Class[] argTypes = new Class[]{Resolver.class, Element.class, Map.class};
                Constructor<?> ctor = cls.getConstructor(argTypes);
                return (Step)ctor.newInstance(resolver, el, attributes);
            }
            catch (NoSuchMethodException nsm) {
                Class[] argTypes = new Class[]{Resolver.class, Map.class};
                Constructor<?> ctor = cls.getConstructor(argTypes);
                return (Step)ctor.newInstance(resolver, attributes);
            }
        }
        catch (ClassNotFoundException cnf) {
            String msg = Strings.get("step.unknown_tag", new Object[]{tag});
            throw new InvalidScriptException(msg);
        }
        catch (InvocationTargetException ite) {
            Log.warn(ite);
            throw new InvalidScriptException(ite.getTargetException().getMessage());
        }
        catch (Exception exc) {
            Log.warn(exc);
            throw new InvalidScriptException(exc.getMessage());
        }
    }

    protected String simpleClassName(Class cls) {
        return ComponentTester.simpleClassName(cls);
    }

    public String toString() {
        return this.getDescription();
    }

    public Class resolveClass(String className) throws ClassNotFoundException {
        ClassLoader cl = this.getResolver().getContextClassLoader();
        return Class.forName(className, true, cl);
    }

    protected ComponentTester resolveTester(String className) throws ClassNotFoundException {
        Class testedClass = this.resolveClass(className);
        if (Component.class.isAssignableFrom(testedClass)) {
            return ComponentTester.getTester(testedClass);
        }
        if (ComponentTester.class.isAssignableFrom(testedClass)) {
            try {
                return (ComponentTester)testedClass.newInstance();
            }
            catch (Exception e) {
                String msg = "Custom ComponentTesters must provide an accessible no-args Constructor: " + e.getMessage();
                throw new IllegalArgumentException(msg);
            }
        }
        String msg = "The given class '" + className + "' is neither a Component nor a ComponentTester";
        throw new IllegalArgumentException(msg);
    }

    private void writeObject(ObjectOutputStream out) {
        out = null;
    }

    private void readObject(ObjectInputStream in) {
        in = null;
    }
}

