/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.i18n.Strings;
import abbot.tester.ActionFailedException;
import abbot.tester.JComponentTester;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JScrollBar;

public class JScrollBarTester
extends JComponentTester {
    private static final int BLOCK_OFFSET = 4;

    protected Point getThumbLocation(JScrollBar bar, int value) {
        boolean horizontal = bar.getOrientation() == 0;
        double fraction = (double)value / (double)(bar.getMaximum() - bar.getMinimum());
        if (horizontal) {
            int arrow = bar.getHeight();
            return new Point(arrow + (int)(fraction * (double)(bar.getWidth() - 2 * arrow)), arrow / 2);
        }
        int arrow = bar.getWidth();
        return new Point(arrow / 2, arrow + (int)(fraction * (double)(bar.getHeight() - 2 * arrow)));
    }

    protected Point getUnitLocation(JScrollBar bar, boolean up) {
        int arrow;
        boolean horizontal = bar.getOrientation() == 0;
        int n = arrow = horizontal ? bar.getHeight() : bar.getWidth();
        if (up) {
            return horizontal ? new Point(bar.getWidth() - arrow / 2, arrow / 2) : new Point(arrow / 2, bar.getHeight() - arrow / 2);
        }
        return new Point(arrow / 2, arrow / 2);
    }

    protected Point getBlockLocation(JScrollBar bar, boolean up) {
        int offset;
        boolean horizontal = bar.getOrientation() == 0;
        Point p = this.getUnitLocation(bar, up);
        int n = offset = up ? 4 : -4;
        if (horizontal) {
            p.x += offset;
        } else {
            p.y += offset;
        }
        return p;
    }

    protected void scroll(final JScrollBar bar, final int value) {
        this.invokeLater(bar, new Runnable(){

            public void run() {
                bar.setValue(value);
            }
        });
    }

    protected void scroll(JScrollBar bar, int count, boolean block) {
        Point where = block ? this.getBlockLocation(bar, count >= 0) : this.getUnitLocation(bar, count >= 0);
        this.mouseMove(bar, where.x, where.y);
        int value = bar.getValue() + count * (block ? bar.getBlockIncrement() : bar.getUnitIncrement());
        this.scroll(bar, value);
    }

    public void actionScrollUnitUp(Component c) {
        this.scroll((JScrollBar)c, 1, false);
        this.waitForIdle();
    }

    public void actionScrollUnitDown(Component c) {
        this.scroll((JScrollBar)c, -1, false);
        this.waitForIdle();
    }

    public void actionScrollBlockUp(Component c) {
        this.scroll((JScrollBar)c, 1, true);
        this.waitForIdle();
    }

    public void actionScrollBlockDown(Component c) {
        this.scroll((JScrollBar)c, -1, true);
        this.waitForIdle();
    }

    public void actionScrollTo(Component c, int position) {
        JScrollBar bar = (JScrollBar)c;
        int min = bar.getMinimum();
        int max = bar.getMaximum();
        if (position < min || position > max) {
            String msg = Strings.get("tester.JScrollBar.out_of_range", new Object[]{new Integer(position), new Integer(min), new Integer(max)});
            throw new ActionFailedException(msg);
        }
        Point thumb = this.getThumbLocation(bar, bar.getValue());
        this.mouseMove(bar, thumb.x, thumb.y);
        thumb = this.getThumbLocation(bar, position);
        this.mouseMove(bar, thumb.x, thumb.y);
        this.scroll(bar, position);
        this.waitForIdle();
    }
}

