/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.script.ArgumentParser;
import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import abbot.tester.JTableLocation;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JTable;

public class JTableTester
extends JComponentTester {
    public static String valueToString(JTable table, int row, int col) {
        String toString;
        Object value = table.getValueAt(row, col);
        Component cr = table.getCellRenderer(row, col).getTableCellRendererComponent(table, value, false, false, row, col);
        if (cr instanceof JLabel) {
            String label = ((JLabel)cr).getText();
            if (label == null) {
                label = "";
            }
            if (!"".equals(label = label.trim()) && !ArgumentParser.isDefaultToString(label)) {
                return label;
            }
        }
        return (toString = ArgumentParser.toString(value)) == "<default-tostring>" ? null : toString;
    }

    public void actionSelectCell(Component c, JTableLocation loc) {
        JTable table = (JTable)c;
        JTableLocation.Cell cell = loc.getCell(table);
        if (table.isRowSelected(cell.row) && table.isColumnSelected(cell.col) && table.getSelectedRowCount() == 1) {
            return;
        }
        this.actionClick(c, loc);
    }

    public void actionSelectCell(Component c, int row, int col) {
        this.actionSelectCell(c, new JTableLocation(row, col));
    }

    public ComponentLocation parseLocation(String encoded) {
        return new JTableLocation().parse(encoded);
    }

    public ComponentLocation getLocation(Component c, Point p) {
        JTable table = (JTable)c;
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        if (row != -1 && col != -1) {
            String value = JTableTester.valueToString(table, row, col);
            if (value != null) {
                return new JTableLocation(value);
            }
            return new JTableLocation(row, col);
        }
        return new JTableLocation(p);
    }
}

