/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.DetailTextureImage;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureRetained;
import javax.vecmath.Point2f;

class Texture2DRetained
extends TextureRetained {
    int detailTextureId = -1;
    ImageComponent2DRetained detailImage = null;
    DetailTextureImage detailTexture = null;
    int detailTextureMode = 1;
    int detailTextureLevel = 2;
    int numDetailTextureFuncPts = 0;
    float[] detailTextureFuncPts = null;

    Texture2DRetained() {
    }

    final void initDetailImage(ImageComponent2D imageComponent2D) {
        if (imageComponent2D == null) {
            this.detailImage = null;
        } else {
            this.detailImage = (ImageComponent2DRetained)imageComponent2D.retained;
            this.detailImage.setTextureRef();
        }
    }

    final ImageComponent2D getDetailImage() {
        if (this.detailImage != null) {
            return (ImageComponent2D)this.detailImage.source;
        }
        return null;
    }

    final void initDetailTextureMode(int n) {
        this.detailTextureMode = n;
    }

    final int getDetailTextureMode() {
        return this.detailTextureMode;
    }

    final void initDetailTextureLevel(int n) {
        this.detailTextureLevel = n;
    }

    final int getDetailTextureLevel() {
        return this.detailTextureLevel;
    }

    final void initDetailTextureFunc(float[] fArray, float[] fArray2) {
        if (fArray == null) {
            this.detailTextureFuncPts = null;
            this.numDetailTextureFuncPts = 0;
        } else {
            this.numDetailTextureFuncPts = fArray.length;
            if (this.detailTextureFuncPts == null || this.detailTextureFuncPts.length != fArray.length * 2) {
                this.detailTextureFuncPts = new float[fArray.length * 2];
            }
            int n = 0;
            for (int i = 0; i < fArray.length; ++i) {
                this.detailTextureFuncPts[n++] = fArray[i];
                this.detailTextureFuncPts[n++] = fArray2[i];
            }
        }
    }

    final void initDetailTextureFunc(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.detailTextureFuncPts = null;
            this.numDetailTextureFuncPts = 0;
        } else {
            this.numDetailTextureFuncPts = point2fArray.length;
            if (this.detailTextureFuncPts == null || this.detailTextureFuncPts.length != point2fArray.length * 2) {
                this.detailTextureFuncPts = new float[point2fArray.length * 2];
            }
            int n = 0;
            for (int i = 0; i < point2fArray.length; ++i) {
                this.detailTextureFuncPts[n++] = point2fArray[i].x;
                this.detailTextureFuncPts[n++] = point2fArray[i].y;
            }
        }
    }

    final void initDetailTextureFunc(float[] fArray) {
        if (fArray == null) {
            this.detailTextureFuncPts = null;
            this.numDetailTextureFuncPts = 0;
        } else {
            this.numDetailTextureFuncPts = fArray.length / 2;
            if (this.detailTextureFuncPts == null || this.detailTextureFuncPts.length != fArray.length) {
                this.detailTextureFuncPts = new float[fArray.length];
            }
            for (int i = 0; i < fArray.length; ++i) {
                this.detailTextureFuncPts[i] = fArray[i];
            }
        }
    }

    final int getDetailTextureFuncPointsCount() {
        return this.numDetailTextureFuncPts;
    }

    final void getDetailTextureFunc(float[] fArray, float[] fArray2) {
        if (this.detailTextureFuncPts != null) {
            int n = 0;
            for (int i = 0; i < this.numDetailTextureFuncPts; ++i) {
                fArray[i] = this.detailTextureFuncPts[n++];
                fArray2[i] = this.detailTextureFuncPts[n++];
            }
        }
    }

    final void getDetailTextureFunc(Point2f[] point2fArray) {
        if (this.detailTextureFuncPts != null) {
            int n = 0;
            for (int i = 0; i < this.numDetailTextureFuncPts; ++i) {
                point2fArray[i].x = this.detailTextureFuncPts[n++];
                point2fArray[i].y = this.detailTextureFuncPts[n++];
            }
        }
    }

    final float[] getDetailTextureFunc() {
        return this.detailTextureFuncPts;
    }

    synchronized void initMirrorObject() {
        super.initMirrorObject();
        Texture2DRetained texture2DRetained = (Texture2DRetained)this.mirror;
        texture2DRetained.detailImage = this.detailImage;
        texture2DRetained.detailTextureMode = this.detailTextureMode;
        texture2DRetained.detailTextureLevel = this.detailTextureLevel;
        texture2DRetained.detailTexture = null;
        texture2DRetained.numDetailTextureFuncPts = this.numDetailTextureFuncPts;
        if (this.detailTextureFuncPts == null) {
            texture2DRetained.detailTextureFuncPts = null;
        } else {
            if (texture2DRetained.detailTextureFuncPts == null || texture2DRetained.detailTextureFuncPts.length != this.detailTextureFuncPts.length) {
                texture2DRetained.detailTextureFuncPts = new float[this.detailTextureFuncPts.length];
            }
            for (int i = 0; i < this.detailTextureFuncPts.length; ++i) {
                texture2DRetained.detailTextureFuncPts[i] = this.detailTextureFuncPts[i];
            }
            if (texture2DRetained.detailImage != null && texture2DRetained.magFilter >= 6 && texture2DRetained.magFilter <= 8) {
                texture2DRetained.detailImage.addUser(texture2DRetained);
            }
        }
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.detailImage != null && this.magFilter >= 6 && this.magFilter <= 8) {
            this.detailImage.removeUser(this.mirror);
        }
    }

    void incTextureBinRefCount(TextureBin textureBin) {
        super.incTextureBinRefCount(textureBin);
        if (this.detailImage != null && this.magFilter >= 6 && this.magFilter <= 8) {
            if (this.detailTexture == null) {
                this.detailTexture = this.detailImage.getDetailTexture();
            }
            this.detailTexture.incTextureBinRefCount(this.format, textureBin);
        }
    }

    void decTextureBinRefCount(TextureBin textureBin) {
        super.decTextureBinRefCount(textureBin);
        if (this.detailTexture != null) {
            this.detailTexture.decTextureBinRefCount(this.format, textureBin);
        }
    }

    native void bindDetailTexture(long var1, int var3);

    native void updateTextureImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10);

    native void updateTextureSubImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, byte[] var13);

    native void updateDetailTextureParameters(long var1, int var3, int var4, int var5, float[] var6);

    void updateTextureImage(Canvas3D canvas3D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        this.updateTextureImage(canvas3D.ctx, n2, n3, n4, n5, n6, n7, n8, byArray);
    }

    void updateTextureSubImage(Canvas3D canvas3D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, byte[] byArray) {
        this.updateTextureSubImage(canvas3D.ctx, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, byArray);
    }

    void updateNative(Canvas3D canvas3D) {
        super.updateNative(canvas3D);
        if (this.detailTexture != null) {
            this.detailTexture.updateNative(canvas3D, this.format);
        }
    }

    void updateTextureFields(Canvas3D canvas3D) {
        super.updateTextureFields(canvas3D);
        if (this.detailTexture != null) {
            this.updateDetailTextureParameters(canvas3D.ctx, this.detailTextureMode, this.detailTextureLevel, this.numDetailTextureFuncPts, this.detailTextureFuncPts);
        }
    }
}

