/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DetailTextureImage;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.VirtualUniverse;

class ImageComponent2DRetained
extends ImageComponentRetained {
    private int rasterRefCnt = 0;
    private int textureRefCnt = 0;
    private DetailTextureImage detailTexture = null;
    int hashId;
    float[] lastAlpha = new float[1];
    static final double EPSILON = 1.0E-6;
    int imageChanged = 0;

    native void freeD3DSurface(int var1);

    ImageComponent2DRetained() {
        this.hashId = this.hashCode();
    }

    final void set(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        if (n != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
        }
        if (n2 != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
        }
        this.geomLock.getLock();
        if (!this.byReference || this.byReference && this.willBeCopied(bufferedImage)) {
            int n3 = n2 * n * this.bytesPerPixelIfStored;
            if (this.usedByTexture || !this.usedByRaster) {
                if (this.imageYup == null || this.imageYup.length < n3) {
                    this.imageYup = new byte[n3];
                    this.imageYupAllocated = true;
                }
                this.storedYupFormat = this.internalFormat;
                this.bytesPerYupPixelStored = this.getBytesStored(this.storedYupFormat);
                this.copyImage(bufferedImage, this.imageYup, true, 0, this.storedYupFormat, this.bytesPerYupPixelStored);
                this.imageYupClass = 1;
            }
            if (this.usedByRaster) {
                this.imageYdownClass = 1;
                this.storedYdownFormat = this.internalFormat;
                this.bytesPerYdownPixelStored = this.getBytesStored(this.storedYdownFormat);
                if (this.imageYdown[0] == null || this.imageYdown[0].length < n3) {
                    this.imageYdown[0] = new byte[n3];
                    this.imageYdownAllocated = true;
                }
                if (this.imageYup != null) {
                    this.setImageYdown(this.imageYup, this.imageYdown[0]);
                } else {
                    this.copyImage(bufferedImage, this.imageYdown[0], false, 0, this.storedYdownFormat, this.bytesPerYdownPixelStored);
                }
            }
            if (this.byReference) {
                this.bImage[0] = bufferedImage;
                this.imageYupCacheDirty = !this.usedByTexture && this.usedByRaster;
                this.imageYdownCacheDirty = !this.usedByRaster;
            } else {
                this.imageDirty[0] = true;
            }
        } else {
            this.imageYupCacheDirty = true;
            this.imageYdownCacheDirty = true;
            this.bImage[0] = bufferedImage;
        }
        this.imageChanged = 65535;
        this.lastAlpha[0] = 1.0f;
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.freeSurface();
            this.sendMessage(1, null);
        }
    }

    boolean willBeCopied(RenderedImage renderedImage) {
        return this.shouldImageBeCopied(this.getImageType(renderedImage), 6, renderedImage);
    }

    final boolean shouldImageBeCopied(int n, int n2, RenderedImage renderedImage) {
        if (!this.byReference) {
            return true;
        }
        return !((n2 & 2) != 0 && n == 6 && this.format == 2 || (n2 & 4) != 0 && n == 5 && this.format == 1 || n == 10 && this.format == 10) && !this.is4ByteRGBAOr3ByteRGB(renderedImage);
    }

    final int getStoredFormat(int n, RenderedImage renderedImage) {
        int n2 = 0;
        switch (n) {
            case 6: {
                n2 = 2;
                break;
            }
            case 10: {
                n2 = 4;
                break;
            }
            case 11: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 32;
                break;
            }
            case 0: {
                if (!this.is4ByteRGBAOr3ByteRGB(renderedImage)) break;
                SampleModel sampleModel = renderedImage.getSampleModel();
                if (sampleModel.getNumBands() == 3) {
                    n2 = 64;
                    break;
                }
                n2 = 1;
                break;
            }
        }
        return n2;
    }

    final void set(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            this.set((BufferedImage)renderedImage);
        } else {
            int n = renderedImage.getWidth();
            int n2 = renderedImage.getHeight();
            if (n != this.width) {
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
            }
            if (n2 != this.height) {
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
            }
            this.geomLock.getLock();
            if (!this.byReference || this.byReference && this.willBeCopied(renderedImage)) {
                int n3 = n2 * n * this.bytesPerPixelIfStored;
                if (this.usedByTexture || !this.usedByRaster) {
                    if (this.imageYup == null || this.imageYup.length < n3) {
                        this.imageYup = new byte[n3];
                        this.imageYupAllocated = true;
                    }
                    this.storedYupFormat = this.internalFormat;
                    this.bytesPerYupPixelStored = this.getBytesStored(this.storedYupFormat);
                    this.copyImage(renderedImage, this.imageYup, true, 0, this.storedYupFormat, this.bytesPerYupPixelStored);
                    this.imageYupClass = 1;
                }
                if (this.usedByRaster) {
                    this.imageYdownClass = 1;
                    this.storedYdownFormat = this.internalFormat;
                    this.bytesPerYdownPixelStored = this.getBytesStored(this.storedYdownFormat);
                    if (this.imageYdown[0] == null || this.imageYdown[0].length < n3) {
                        this.imageYdown[0] = new byte[n3];
                        this.imageYdownAllocated = true;
                    }
                    if (this.imageYup != null) {
                        this.setImageYdown(this.imageYup, this.imageYdown[0]);
                    } else {
                        this.copyImage(renderedImage, this.imageYdown[0], false, 0, this.storedYdownFormat, this.bytesPerYdownPixelStored);
                    }
                }
                if (this.byReference) {
                    this.bImage[0] = renderedImage;
                    this.imageYupCacheDirty = !this.usedByTexture && this.usedByRaster;
                    this.imageYdownCacheDirty = !this.usedByRaster;
                } else {
                    this.imageDirty[0] = true;
                }
            } else {
                this.imageYupCacheDirty = true;
                this.imageYdownCacheDirty = true;
                this.bImage[0] = renderedImage;
            }
        }
        this.imageChanged = 65535;
        this.lastAlpha[0] = 1.0f;
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.freeSurface();
            this.sendMessage(1, null);
        }
    }

    final RenderedImage getImage() {
        if (!this.byReference && this.imageDirty[0]) {
            this.imageDirty[0] = false;
            this.retrieveBufferedImage(0);
        }
        return this.bImage[0];
    }

    final void setRasterRef() {
        if (this.usedByRaster) {
            return;
        }
        this.usedByRaster = true;
        if (this.format == 10) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained2"));
        }
        if (!this.byReference) {
            if (this.imageYdown[0] == null && this.imageYup != null) {
                this.imageYdown[0] = new byte[this.height * this.width * this.bytesPerYupPixelStored];
                this.imageYdownAllocated = true;
                this.imageYdownClass = 1;
                this.storedYdownFormat = this.storedYupFormat;
                this.bytesPerYdownPixelStored = this.bytesPerYupPixelStored;
                this.setImageYdown(this.imageYup, this.imageYdown[0]);
            }
            if (!this.usedByTexture) {
                this.imageYup = null;
                this.imageYupAllocated = false;
            }
        } else if (this.willBeCopied(this.bImage[0])) {
            this.geomLock.getLock();
            if (this.imageYdownCacheDirty) {
                if (this.imageYdown[0] == null) {
                    if (this.imageYup != null) {
                        this.storedYdownFormat = this.storedYupFormat;
                        this.bytesPerYdownPixelStored = this.bytesPerYupPixelStored;
                        this.imageYdown[0] = new byte[this.height * this.width * this.bytesPerYdownPixelStored];
                        this.setImageYdown(this.imageYup, this.imageYdown[0]);
                    } else {
                        this.imageYdown[0] = new byte[this.height * this.width * this.bytesPerPixelIfStored];
                        this.bytesPerYdownPixelStored = this.bytesPerPixelIfStored;
                        this.storedYdownFormat = this.internalFormat;
                        if (this.bImage[0] instanceof BufferedImage) {
                            this.copyImage((BufferedImage)this.bImage[0], this.imageYdown[0], false, 0, this.storedYdownFormat, this.bytesPerYdownPixelStored);
                        } else {
                            this.copyImage(this.bImage[0], this.imageYdown[0], false, 0, this.storedYdownFormat, this.bytesPerYdownPixelStored);
                        }
                    }
                    this.imageYdownClass = 1;
                    this.imageYdownAllocated = true;
                }
                this.imageYdownCacheDirty = false;
            }
            this.geomLock.unLock();
        } else {
            this.geomLock.getLock();
            this.imageYdownCacheDirty = true;
            this.geomLock.unLock();
        }
    }

    final void setTextureRef() {
        if (this.usedByTexture) {
            return;
        }
        this.usedByTexture = true;
        if (!this.byReference) {
            if (this.imageYup == null && this.imageYdown[0] != null) {
                this.storedYupFormat = this.storedYdownFormat;
                this.bytesPerYupPixelStored = this.bytesPerYdownPixelStored;
                this.imageYup = new byte[this.height * this.width * this.bytesPerYupPixelStored];
                this.setImageYup(this.imageYdown[0], this.imageYup);
                this.imageYupClass = 1;
                this.imageYupAllocated = true;
            }
            if (!this.usedByRaster) {
                this.imageYdown[0] = null;
                this.imageYdownAllocated = false;
            }
        } else if (this.willBeCopied(this.bImage[0])) {
            this.geomLock.getLock();
            if (this.imageYupCacheDirty) {
                if (this.imageYup == null) {
                    if (this.imageYdown[0] != null) {
                        this.storedYupFormat = this.storedYdownFormat;
                        this.bytesPerYupPixelStored = this.bytesPerYdownPixelStored;
                        this.imageYup = new byte[this.height * this.width * this.bytesPerYupPixelStored];
                        this.setImageYup(this.imageYdown[0], this.imageYup);
                    } else {
                        this.imageYup = new byte[this.height * this.width * this.bytesPerPixelIfStored];
                        this.bytesPerYupPixelStored = this.bytesPerPixelIfStored;
                        this.storedYupFormat = this.internalFormat;
                        if (this.bImage[0] instanceof BufferedImage) {
                            this.copyImage((BufferedImage)this.bImage[0], this.imageYup, true, 0, this.storedYupFormat, this.bytesPerYupPixelStored);
                        } else {
                            this.copyImage(this.bImage[0], this.imageYup, true, 0, this.storedYupFormat, this.bytesPerYupPixelStored);
                        }
                    }
                    this.imageYupClass = 1;
                    this.imageYupAllocated = true;
                }
                this.imageYupCacheDirty = false;
            }
            this.geomLock.unLock();
        } else {
            this.geomLock.getLock();
            this.imageYupCacheDirty = true;
            this.geomLock.unLock();
        }
    }

    final void setImageYdown(byte[] byArray, byte[] byArray2) {
        int n = this.width * this.bytesPerYdownPixelStored;
        int n2 = (this.height - 1) * n;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.height) {
            System.arraycopy(byArray, n2, byArray2, n3, n);
            ++n4;
            n2 -= n;
            n3 += n;
        }
    }

    final void copyRImage(RenderedImage renderedImage, byte[] byArray, boolean bl, int n) {
        int n2;
        int n3 = renderedImage.getNumXTiles();
        int n4 = renderedImage.getNumYTiles();
        int n5 = renderedImage.getTileWidth();
        int n6 = renderedImage.getTileHeight();
        int n7 = n5 * n;
        int n8 = renderedImage.getMinTileX();
        int n9 = renderedImage.getMinTileY();
        int n10 = 0;
        int n11 = n6 * n5 * n3 * n;
        if (bl) {
            n10 = this.width * n;
            n2 = (this.height - 1) * n10;
            n10 = -n10;
        } else {
            n2 = 0;
            n10 = this.width * n;
        }
        int n12 = renderedImage.getMinX();
        int n13 = renderedImage.getMinY();
        int n14 = renderedImage.getTileGridXOffset();
        int n15 = renderedImage.getTileGridYOffset();
        int n16 = n8 * n5 + n14 + n5;
        int n17 = n9 * n6 + n15 + n6;
        int n18 = this.width;
        int n19 = this.height;
        int n20 = n16 - n12;
        int n21 = n17 - n13;
        if (n18 < n20) {
            n20 = n18;
        }
        if (n19 < n21) {
            n21 = n19;
        }
        int n22 = n20;
        int n23 = (n5 - n20) * n;
        int n24 = n5 * (n6 - n21) * n;
        int n25 = 0;
        int n26 = n23 + n24;
        for (int i = n9; i < n9 + n4; ++i) {
            int n27 = n2;
            n20 = n22;
            n18 = this.width;
            for (int j = n8; j < n8 + n3; ++j) {
                Raster raster = renderedImage.getTile(j, i);
                byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                int n28 = n27;
                n25 = n20 * n;
                for (int k = 0; k < n21; ++k) {
                    System.arraycopy(byArray2, n26, byArray, n28, n25);
                    n26 += n7;
                    n28 += n10;
                }
                n26 = n24;
                n27 += n20 * n;
                n20 = (n18 -= n20) < n5 ? n18 : n5;
            }
            n26 = n23;
            n24 = 0;
            n2 += n21 * n10;
            n21 = (n19 -= n21) < n6 ? n19 : n6;
        }
    }

    final void setImageYup(byte[] byArray, byte[] byArray2) {
        int n = this.width * this.bytesPerYupPixelStored;
        int n2 = 0;
        int n3 = (this.height - 1) * n;
        int n4 = 0;
        while (n4 < this.height) {
            System.arraycopy(byArray, n2, byArray2, n3, n);
            ++n4;
            n2 += n;
            n3 -= n;
        }
    }

    final void evaluateExtensions(int n) {
        RenderedImage renderedImage = this.bImage[0];
        if (!this.imageYupCacheDirty && !this.imageYdownCacheDirty) {
            return;
        }
        int n2 = this.getImageType(renderedImage);
        if (this.usedByTexture || !this.usedByRaster) {
            if (!this.imageYupCacheDirty) {
                this.evaluateRaster(n2, n);
                return;
            }
            if (this.shouldImageBeCopied(n2, n, renderedImage)) {
                int n3 = this.height * this.width * this.bytesPerPixelIfStored;
                if (this.imageYup == null || !this.imageYupAllocated) {
                    this.imageYup = new byte[n3];
                    this.imageYupAllocated = true;
                }
                this.bytesPerYupPixelStored = this.bytesPerPixelIfStored;
                this.storedYupFormat = this.internalFormat;
                this.copyImage(renderedImage, this.imageYup, true, 0, this.storedYupFormat, this.bytesPerYupPixelStored);
                this.imageYupClass = 1;
                this.imageYupCacheDirty = false;
            } else {
                if (!this.imageYupCacheDirty) {
                    this.evaluateRaster(n2, n);
                    return;
                }
                this.storedYupFormat = this.getStoredFormat(n2, renderedImage);
                this.bytesPerYupPixelStored = this.getBytesStored(this.storedYupFormat);
                if (!this.yUp) {
                    this.storeTextureImageWithFlip(renderedImage);
                } else if (renderedImage instanceof BufferedImage) {
                    byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
                    this.imageYup = byArray;
                    this.imageYupAllocated = false;
                    this.imageYupClass = 1;
                } else {
                    this.numXTiles = renderedImage.getNumXTiles();
                    this.numYTiles = renderedImage.getNumYTiles();
                    this.tilew = renderedImage.getTileWidth();
                    this.tileh = renderedImage.getTileHeight();
                    this.minTileX = renderedImage.getMinTileX();
                    this.minTileY = renderedImage.getMinTileY();
                    this.minX = renderedImage.getMinX();
                    this.minY = renderedImage.getMinY();
                    this.tileGridXOffset = renderedImage.getTileGridXOffset();
                    this.tileGridYOffset = renderedImage.getTileGridYOffset();
                    this.imageYupAllocated = false;
                    this.imageYupClass = 2;
                    this.imageYup = null;
                }
            }
            if (!this.usedByRaster) {
                this.imageYdown[0] = null;
                this.imageYdownAllocated = false;
            }
        }
        this.evaluateRaster(n2, n);
    }

    void evaluateRaster(int n, int n2) {
        RenderedImage renderedImage = this.bImage[0];
        if (this.usedByRaster) {
            if (!this.imageYdownCacheDirty) {
                return;
            }
            if (this.shouldImageBeCopied(n, n2, renderedImage)) {
                int n3 = this.height * this.width * this.bytesPerPixelIfStored;
                if (this.imageYdown[0] == null || !this.imageYdownAllocated || this.imageYdown[0].length < n3) {
                    this.imageYdown[0] = new byte[n3];
                    this.imageYdownAllocated = true;
                }
                if (this.imageYup != null) {
                    this.storedYdownFormat = this.storedYupFormat;
                    this.bytesPerYdownPixelStored = this.bytesPerYupPixelStored;
                    this.setImageYdown(this.imageYup, this.imageYdown[0]);
                } else {
                    this.storedYdownFormat = this.internalFormat;
                    this.bytesPerYdownPixelStored = this.bytesPerPixelIfStored;
                    this.copyImage(renderedImage, this.imageYdown[0], false, 0, this.storedYdownFormat, this.bytesPerYdownPixelStored);
                }
                this.imageYdownCacheDirty = false;
                this.imageYdownClass = 1;
            } else {
                if (!this.imageYdownCacheDirty) {
                    return;
                }
                this.storedYdownFormat = this.getStoredFormat(n, renderedImage);
                this.bytesPerYdownPixelStored = this.getBytesStored(this.storedYdownFormat);
                if (this.yUp) {
                    this.storeRasterImageWithFlip(renderedImage);
                } else {
                    if (renderedImage instanceof BufferedImage) {
                        byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
                        this.imageYdown[0] = byArray;
                        this.imageYdownAllocated = false;
                        this.imageYdownClass = 1;
                    } else {
                        int n4 = this.width * this.height * this.bytesPerYdownPixelStored;
                        if (this.imageYdown[0] == null || !this.imageYdownAllocated || this.imageYdown[0].length < n4) {
                            this.imageYdown[0] = new byte[n4];
                            this.imageYdownAllocated = true;
                        }
                        this.imageYdownClass = 1;
                        this.copyRImage(renderedImage, this.imageYdown[0], false, this.bytesPerYdownPixelStored);
                    }
                    this.imageYdownCacheDirty = false;
                }
            }
            if (!this.usedByTexture) {
                this.imageYup = null;
                this.imageYupAllocated = false;
            }
        }
    }

    void storeRasterImageWithFlip(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            int n = this.width * this.height * this.bytesPerYdownPixelStored;
            if (this.imageYdown[0] == null || !this.imageYdownAllocated || this.imageYdown[0].length < n) {
                this.imageYdown[0] = new byte[n];
                this.imageYdownAllocated = true;
            }
            this.imageYdownClass = 1;
            this.imageYdownCacheDirty = false;
            byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
            this.setImageYdown(byArray, this.imageYdown[0]);
        } else {
            int n = this.width * this.height * this.bytesPerYdownPixelStored;
            if (this.imageYdown[0] == null || !this.imageYdownAllocated || this.imageYdown[0].length < n) {
                this.imageYdown[0] = new byte[n];
                this.imageYdownAllocated = true;
            }
            this.imageYdownClass = 1;
            this.imageYdownCacheDirty = false;
            this.copyRImage(renderedImage, this.imageYdown[0], true, this.bytesPerYdownPixelStored);
        }
    }

    void storeTextureImageWithFlip(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
            if (this.imageYup == null || !this.imageYupAllocated) {
                int n = this.width * this.height * this.bytesPerYupPixelStored;
                this.imageYup = new byte[n];
                this.imageYupAllocated = true;
            }
            this.imageYupClass = 1;
            this.setImageYup(byArray, this.imageYup);
            this.imageYupCacheDirty = false;
        } else {
            if (this.imageYup == null || !this.imageYupAllocated) {
                int n = this.width * this.height * this.bytesPerYupPixelStored;
                this.imageYup = new byte[n];
                this.imageYupAllocated = true;
            }
            this.imageYupClass = 1;
            this.copyRImage(renderedImage, this.imageYup, true, this.bytesPerYupPixelStored);
            this.imageYupCacheDirty = false;
        }
    }

    void setLive(boolean bl, int n) {
        super.setLive(bl, n);
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.refCount <= 0) {
            this.freeSurface();
        }
    }

    void freeSurface() {
        if (VirtualUniverse.mc.isD3D()) {
            this.freeD3DSurface(this.hashId);
        }
    }

    protected void finalize() {
        this.freeSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAlpha(Canvas3D canvas3D, int n, float f) {
        float f2 = 0.0f;
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        ImageComponent2DRetained imageComponent2DRetained = this;
        synchronized (imageComponent2DRetained) {
            int n2;
            int n3;
            if (this.isByReference() && (this.storedYdownFormat != this.internalFormat || (this.imageChanged & 1) != 0)) {
                n3 = this.height * this.width * this.bytesPerPixelIfStored;
                if (this.imageYdown[0] == null || !this.imageYdownAllocated || this.imageYdown[0].length < n3) {
                    this.imageYdown[0] = new byte[n3];
                }
                this.bytesPerYdownPixelStored = this.bytesPerPixelIfStored;
                this.storedYdownFormat = this.internalFormat;
                this.copyImage(this.bImage[0], this.imageYdown[0], false, 0, this.storedYdownFormat, this.bytesPerYdownPixelStored);
                this.imageYdownCacheDirty = false;
                this.imageYdownClass = 1;
                this.imageYdownAllocated = true;
                this.imageChanged &= 0xFFFFFFFE;
                this.freeSurface();
            }
            if (this.lastAlpha == null) {
                this.lastAlpha = new float[n + 1];
                this.lastAlpha[n] = 1.0f;
            } else if (this.lastAlpha.length <= n) {
                float[] fArray = new float[n + 1];
                for (n2 = 0; n2 < this.lastAlpha.length; ++n2) {
                    fArray[n2] = this.lastAlpha[n2];
                }
                this.lastAlpha = fArray;
                this.lastAlpha[n] = 1.0f;
            }
            if (this.imageYdown.length <= n) {
                byte[][] byArrayArray = new byte[n + 1][];
                int n4 = -1;
                int n5 = this.height * this.width * this.bytesPerYdownPixelStored;
                byArrayArray[n] = new byte[n5];
                byte[] byArray = byArrayArray[n];
                for (n2 = 0; n2 < this.imageYdown.length; ++n2) {
                    byArrayArray[n2] = this.imageYdown[n2];
                    if (!((double)Math.abs(this.lastAlpha[n2] - f) < 1.0E-6)) continue;
                    n4 = n2;
                }
                if (this.noAlpha) {
                    byte by = (byte)((double)(f * 255.0f) + 0.5);
                    int n6 = 3;
                    n2 = 0;
                    while (n2 < this.width * this.height) {
                        byArray[n6] = by;
                        ++n2;
                        n6 += 4;
                    }
                } else if (n4 >= 0) {
                    System.arraycopy(this.imageYdown[n4], 0, byArray, 0, n5);
                    this.lastAlpha[n] = this.lastAlpha[n4];
                } else {
                    float f3 = f / this.lastAlpha[0];
                    f2 = f3 < 1.0f ? 0.5f : -0.5f;
                    byte[] byArray2 = this.imageYdown[0];
                    n2 = 0;
                    int n7 = 0;
                    while (n2 < this.width * this.height) {
                        System.arraycopy(byArray2, n7, byArray, n7, 3);
                        byArray[n7 + 3] = (byte)((float)(byArray2[n7 + 3] & 0xFF) * f3 + f2);
                        ++n2;
                        n7 += 4;
                    }
                    this.lastAlpha[n] = f;
                }
                this.imageYdown = byArrayArray;
                this.imageChanged &= ~(1 << n);
                this.freeSurface();
                return;
            }
            if ((this.imageChanged & 1 << n) == 0) {
                n3 = -1;
                if ((double)Math.abs(this.lastAlpha[n] - f) > 1.0E-6) {
                    byte[] byArray = this.imageYdown[n];
                    if (this.noAlpha) {
                        byte by = (byte)((double)(f * 255.0f) + 0.5);
                        int n8 = 3;
                        n2 = 0;
                        while (n2 < this.width * this.height) {
                            byArray[n8] = by;
                            ++n2;
                            n8 += 4;
                        }
                    } else {
                        float f4 = f / this.lastAlpha[n];
                        f2 = f4 < 1.0f ? 0.5f : -0.5f;
                        n2 = 0;
                        int n9 = 3;
                        while (n2 < this.width * this.height) {
                            byArray[n9] = (byte)((float)(byArray[n9] & 0xFF) * f4 + f2);
                            ++n2;
                            n9 += 4;
                        }
                    }
                    this.freeSurface();
                }
            } else {
                if (n == 0) {
                    byte[] byArray = this.imageYdown[0];
                    if (this.noAlpha) {
                        byte by = (byte)((double)(f * 255.0f) + 0.5);
                        int n10 = 3;
                        n2 = 0;
                        while (n2 < this.width * this.height) {
                            byArray[n10] = by;
                            ++n2;
                            n10 += 4;
                        }
                    } else {
                        n2 = 0;
                        int n11 = 3;
                        while (n2 < this.width * this.height) {
                            byArray[n11] = (byte)((double)((float)(byArray[n11] & 0xFF) * f) + 0.5);
                            ++n2;
                            n11 += 4;
                        }
                    }
                } else {
                    byte[] byArray = this.imageYdown[n];
                    if (this.noAlpha) {
                        byte by = (byte)((double)(f * 255.0f) + 0.5);
                        int n12 = 3;
                        n2 = 0;
                        while (n2 < this.width * this.height) {
                            byArray[n12] = by;
                            ++n2;
                            n12 += 4;
                        }
                    } else {
                        float f5 = (this.imageChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
                        f2 = f5 < 1.0f ? 0.5f : -0.5f;
                        byte[] byArray3 = this.imageYdown[0];
                        n2 = 0;
                        int n13 = 0;
                        while (n2 < this.width * this.height) {
                            System.arraycopy(byArray3, n13, byArray, n13, 3);
                            byArray[n13 + 3] = (byte)((float)(byArray3[n13 + 3] & 0xFF) * f5 + f2);
                            ++n2;
                            n13 += 4;
                        }
                    }
                }
                this.freeSurface();
            }
            this.lastAlpha[n] = f;
            this.imageChanged &= ~(1 << n);
        }
    }

    int getEffectiveBytesPerPixel() {
        if (this.byReference) {
            if (this.usedByTexture || !this.usedByRaster) {
                return this.bytesPerYupPixelStored;
            }
            return this.bytesPerYdownPixelStored;
        }
        return this.bytesPerPixelIfStored;
    }

    int getEffectiveFormat() {
        if (this.byReference) {
            if (this.usedByTexture || !this.usedByRaster) {
                return this.storedYupFormat;
            }
            return this.storedYdownFormat;
        }
        return this.internalFormat;
    }

    final void retrieveImage(byte[] byArray, int n, int n2) {
        this.retrieveImage(byArray, 0, 0, n, n2);
    }

    final void retrieveImage(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2;
        int n6;
        int n7;
        int n8;
        int n9 = this.getEffectiveBytesPerPixel();
        int n10 = this.getEffectiveFormat();
        if (!this.byReference) {
            n8 = this.width * this.bytesPerPixelIfStored;
            if ((this.usedByTexture || !this.usedByRaster) && this.imageYup == null) {
                this.imageYup = new byte[this.height * n8];
                this.bytesPerYupPixelStored = this.bytesPerPixelIfStored;
                this.storedYupFormat = this.internalFormat;
                this.imageYupAllocated = true;
            }
            if (this.usedByRaster && this.imageYdown[0] == null) {
                this.imageYdown[0] = new byte[this.height * n8];
                this.bytesPerYdownPixelStored = this.bytesPerPixelIfStored;
                this.storedYdownFormat = this.internalFormat;
                this.imageYdownAllocated = true;
            }
        }
        int n11 = n3 * n9;
        int n12 = this.width * n9;
        this.imageDirty[0] = true;
        if (this.usedByRaster) {
            n8 = this.width * this.bytesPerYdownPixelStored;
            n7 = n2 * n12 + n * n9;
            n6 = (this.height - n2 - 1) * n8 + n * this.bytesPerYdownPixelStored;
            if (this.byReference && this.storedYdownFormat != this.internalFormat) {
                byArray2 = ((DataBufferByte)((BufferedImage)this.bImage[0]).getRaster().getDataBuffer()).getData();
                this.imageDirty[0] = false;
            } else {
                byArray2 = this.imageYdown[0];
            }
            if (this.storedYdownFormat == n10) {
                n5 = 0;
                while (n5 < n4) {
                    System.arraycopy(byArray, n7, byArray2, n6, n11);
                    ++n5;
                    n7 += n12;
                    n6 -= n8;
                }
            } else {
                switch (n10) {
                    case 2: {
                        int n13;
                        int n14;
                        n5 = 0;
                        while (n5 < n4) {
                            n14 = n6;
                            for (n13 = 0; n13 < n11; n13 += n9) {
                                byArray2[n14++] = byArray[n7 + n13 + 3];
                                byArray2[n14++] = byArray[n7 + n13 + 2];
                                byArray2[n14++] = byArray[n7 + n13 + 1];
                                byArray2[n14++] = byArray[n7 + n13];
                            }
                            ++n5;
                            n7 += n12;
                            n6 -= n8;
                        }
                        break;
                    }
                    case 32: {
                        int n13;
                        int n14;
                        n5 = 0;
                        while (n5 < n4) {
                            n14 = n6;
                            for (n13 = 0; n13 < n11; n13 += n9) {
                                byArray2[n14++] = byArray[n7 + n13 + 2];
                                byArray2[n14++] = byArray[n7 + n13 + 1];
                                byArray2[n14++] = byArray[n7 + n13];
                                byArray2[n14++] = -1;
                            }
                            ++n5;
                            n7 += n12;
                            n6 -= n8;
                        }
                        break;
                    }
                }
            }
        }
        if (this.usedByTexture || !this.usedByRaster) {
            this.imageYupCacheDirty = true;
            n8 = this.width * this.bytesPerYupPixelStored;
            n7 = n2 * n12 + n * n9;
            if (this.byReference && this.storedYupFormat != this.internalFormat) {
                byArray2 = ((DataBufferByte)((BufferedImage)this.bImage[0]).getRaster().getDataBuffer()).getData();
                this.imageDirty[0] = false;
            } else {
                byArray2 = this.imageYup;
            }
            if (this.storedYupFormat == n10) {
                n6 = n7;
                n5 = 0;
                while (n5 < n4) {
                    System.arraycopy(byArray, n7, byArray2, n6, n11);
                    ++n5;
                    n7 += n12;
                    n6 += n8;
                }
            }
        }
        if (this.byReference && this.imageDirty[0]) {
            this.imageDirty[0] = false;
            if (this.usedByTexture || !this.usedByRaster) {
                this.copyBufferedImageWithFormatConversion(true, 0);
            } else {
                this.copyBufferedImageWithFormatConversion(false, 0);
            }
        }
        this.imageChanged = 65535;
        this.lastAlpha[0] = 1.0f;
    }

    void updateData(ImageComponent2D.Updater updater, int n, int n2, int n3, int n4) {
        this.geomLock.getLock();
        updater.updateData((ImageComponent2D)this.source, n, n2, n3, n4);
        if (this.imageYupAllocated) {
            this.copyImage(this.bImage[0], n + this.bImage[0].getMinX(), n2 + this.bImage[0].getMinY(), this.imageYup, n, n2, true, 0, n3, n4, this.storedYupFormat, this.bytesPerYupPixelStored);
        }
        if (this.imageYdownAllocated) {
            this.copyImage(this.bImage[0], n + this.bImage[0].getMinX(), n2 + this.bImage[0].getMinY(), this.imageYdown[0], n, n2, false, 0, n3, n4, this.storedYdownFormat, this.bytesPerYdownPixelStored);
        }
        this.imageDirty[0] = true;
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.freeSurface();
            ImageComponentUpdateInfo imageComponentUpdateInfo = VirtualUniverse.mc.getFreeImageUpdateInfo();
            imageComponentUpdateInfo.x = n;
            imageComponentUpdateInfo.y = n2;
            imageComponentUpdateInfo.z = 0;
            imageComponentUpdateInfo.width = n3;
            imageComponentUpdateInfo.height = n4;
            this.sendMessage(2, imageComponentUpdateInfo);
        }
    }

    void setSubImage(RenderedImage renderedImage, int n, int n2, int n3, int n4, int n5, int n6) {
        this.geomLock.getLock();
        if (this.imageYupAllocated) {
            this.copyImage(renderedImage, n3, n4, this.imageYup, n5, n6, true, 0, n, n2, this.storedYupFormat, this.bytesPerYupPixelStored);
        }
        if (this.imageYdownAllocated) {
            this.copyImage(renderedImage, n3, n4, this.imageYdown[0], n5, n6, false, 0, n, n2, this.storedYdownFormat, this.bytesPerYdownPixelStored);
        }
        this.imageDirty[0] = true;
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.freeSurface();
            ImageComponentUpdateInfo imageComponentUpdateInfo = VirtualUniverse.mc.getFreeImageUpdateInfo();
            imageComponentUpdateInfo.x = n5;
            imageComponentUpdateInfo.y = n6;
            imageComponentUpdateInfo.z = 0;
            imageComponentUpdateInfo.width = n;
            imageComponentUpdateInfo.height = n2;
            this.sendMessage(2, imageComponentUpdateInfo);
        }
    }

    synchronized void updateMirrorObject(int n, Object object) {
        super.updateMirrorObject(n, object);
        if (this.detailTexture != null && ((n & 1) != 0 || (n & 2) != 0)) {
            this.detailTexture.notifyImageComponentImageChanged(this, object);
        }
    }

    synchronized void setDetailTexture(DetailTextureImage detailTextureImage) {
        this.detailTexture = detailTextureImage;
    }

    synchronized DetailTextureImage getDetailTexture() {
        if (this.detailTexture == null) {
            this.detailTexture = new DetailTextureImage(this);
        }
        return this.detailTexture;
    }
}

