/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.util.Hashtable;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.J3dGraphicsConfig;
import javax.media.j3d.NativeScreenInfo;
import javax.media.j3d.VirtualUniverse;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;

class NativeConfigTemplate3D {
    private static final boolean debug = false;
    static final int RED_SIZE = 0;
    static final int GREEN_SIZE = 1;
    static final int BLUE_SIZE = 2;
    static final int ALPHA_SIZE = 3;
    static final int ACCUM_BUFFER = 4;
    static final int DEPTH_SIZE = 5;
    static final int DOUBLEBUFFER = 6;
    static final int STEREO = 7;
    static final int ANTIALIASING = 8;
    static final int NUM_ITEMS = 9;

    NativeConfigTemplate3D() {
    }

    native int choosePixelFormat(long var1, int var3, int[] var4, long[] var5);

    static native void freePixelFormatInfo(long var0);

    native boolean isStereoAvailable(long var1, boolean var3);

    native boolean isDoubleBufferAvailable(long var1, boolean var3);

    native boolean isSceneAntialiasingAccumAvailable(long var1, boolean var3);

    native boolean isSceneAntialiasingMultisampleAvailable(long var1, boolean var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration[] graphicsConfigurationArray) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfigurationArray[0]).getDevice();
        int[] nArray = new int[9];
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[5] = graphicsConfigTemplate3D.getDepthSize();
        nArray[6] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[7] = graphicsConfigTemplate3D.getStereo();
        nArray[8] = graphicsConfigTemplate3D.getSceneAntialiasing();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getScreen();
        long[] lArray = new long[]{-1L};
        int n2 = this.choosePixelFormat(0L, n, nArray, lArray);
        if (n2 < 0) {
            return null;
        }
        J3dGraphicsConfig j3dGraphicsConfig = new J3dGraphicsConfig((GraphicsDevice)win32GraphicsDevice, 0);
        Hashtable hashtable = Canvas3D.fbConfigTable;
        synchronized (hashtable) {
            if (Canvas3D.fbConfigTable.get((Object)j3dGraphicsConfig) == null) {
                Canvas3D.fbConfigTable.put(j3dGraphicsConfig, new Long(lArray[0]));
            } else {
                NativeConfigTemplate3D.freePixelFormatInfo(lArray[0]);
            }
        }
        return j3dGraphicsConfig;
    }

    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration graphicsConfiguration) {
        long[] lArray;
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        int[] nArray = new int[9];
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[5] = graphicsConfigTemplate3D.getDepthSize();
        nArray[6] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[7] = graphicsConfigTemplate3D.getStereo();
        nArray[8] = graphicsConfigTemplate3D.getSceneAntialiasing();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getScreen();
        int n2 = this.choosePixelFormat(0L, n, nArray, lArray = new long[1]);
        return n2 >= 0;
    }

    boolean hasStereo(Canvas3D canvas3D) {
        return this.isStereoAvailable(canvas3D.fbConfig, canvas3D.offScreen);
    }

    boolean hasDoubleBuffer(Canvas3D canvas3D) {
        return this.isDoubleBufferAvailable(canvas3D.fbConfig, canvas3D.offScreen);
    }

    boolean hasSceneAntialiasingAccum(Canvas3D canvas3D) {
        return this.isSceneAntialiasingAccumAvailable(canvas3D.fbConfig, canvas3D.offScreen);
    }

    boolean hasSceneAntialiasingMultisample(Canvas3D canvas3D) {
        GraphicsConfiguration graphicsConfiguration = canvas3D.graphicsConfiguration;
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getScreen();
        return this.isSceneAntialiasingMultisampleAvailable(canvas3D.fbConfig, canvas3D.offScreen, n);
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

