/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LightRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

class DirectionalLightRetained
extends LightRetained {
    static final int DIRECTION_CHANGED = 128;
    Vector3f direction = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, -1.0f);

    DirectionalLightRetained() {
        this.nodeType = 6;
        this.lightType = 2;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void initDirection(Vector3f vector3f) {
        this.direction.set((Tuple3f)vector3f);
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction, this.direction);
        }
    }

    void setDirection(Vector3f vector3f) {
        this.initDirection(vector3f);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 19;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(128);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        j3dMessage.args[3] = this.mirrorLights.clone();
        j3dMessage.args[4] = new Vector3f(vector3f);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void initDirection(float f, float f2, float f3) {
        this.direction.x = f;
        this.direction.y = f2;
        this.direction.z = f3;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction, this.direction);
        }
    }

    void setDirection(float f, float f2, float f3) {
        this.setDirection(new Vector3f(f, f2, f3));
    }

    void getDirection(Vector3f vector3f) {
        vector3f.set((Tuple3f)this.direction);
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getInvTransform();
            transform3D.transform(vector3f, vector3f);
        }
    }

    void setLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
        J3dMessage j3dMessage = super.initMessage(8);
        Object[] objectArray = (Object[])j3dMessage.args[4];
        objectArray[7] = new Vector3f(this.direction);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void updateMirrorObject(Object[] objectArray) {
        DirectionalLightRetained directionalLightRetained;
        int n;
        int n2 = (Integer)objectArray[1];
        int n3 = (Integer)objectArray[2];
        LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
        if ((n2 & 0x80) != 0) {
            for (n = 0; n < n3; ++n) {
                if (lightRetainedArray[n].nodeType != 6) continue;
                directionalLightRetained = (DirectionalLightRetained)lightRetainedArray[n];
                directionalLightRetained.direction = (Vector3f)objectArray[4];
                directionalLightRetained.getLastLocalToVworld().transform(directionalLightRetained.direction, directionalLightRetained.xformDirection);
                directionalLightRetained.xformDirection.normalize();
            }
        }
        if ((n2 & 0x20) != 0) {
            for (n = 0; n < n3; ++n) {
                if (lightRetainedArray[n].nodeType != 6) continue;
                directionalLightRetained = (DirectionalLightRetained)lightRetainedArray[n];
                directionalLightRetained.direction = (Vector3f)((Object[])objectArray[4])[7];
                directionalLightRetained.getLastLocalToVworld().transform(directionalLightRetained.direction, directionalLightRetained.xformDirection);
                directionalLightRetained.xformDirection.normalize();
            }
        }
        super.updateMirrorObject(objectArray);
    }

    native void updateLight(long var1, int var3, float var4, float var5, float var6, float var7, float var8, float var9);

    void update(long l, int n, double d) {
        this.updateLight(l, n, this.color.x, this.color.y, this.color.z, this.xformDirection.x, this.xformDirection.y, this.xformDirection.z);
    }

    protected Object clone() {
        DirectionalLightRetained directionalLightRetained = (DirectionalLightRetained)super.clone();
        directionalLightRetained.direction = new Vector3f(this.direction);
        directionalLightRetained.xformDirection = new Vector3f(0.0f, 0.0f, -1.0f);
        return directionalLightRetained;
    }

    void updateTransformChange() {
        super.updateTransformChange();
        this.getLastLocalToVworld().transform(this.direction, this.xformDirection);
        this.xformDirection.normalize();
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        transformGroupRetained.transform.transform(this.direction, this.direction);
    }
}

