/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.GeometryLock;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.VirtualUniverse;

abstract class ImageComponentRetained
extends NodeComponentRetained {
    int format;
    int width;
    int height;
    byte[][] imageYdown = new byte[1][];
    byte[] imageYup;
    int bytesPerPixel;
    boolean usedByRaster = false;
    boolean usedByTexture = false;
    boolean byReference = false;
    boolean yUp = false;
    RenderedImage[] bImage;
    boolean[] imageDirty;
    boolean noAlpha = false;
    int bytesPerPixelIfStored;
    int storedYupFormat;
    int storedYdownFormat;
    int bytesPerYupPixelStored;
    int bytesPerYdownPixelStored;
    int internalFormat;
    boolean imageYupAllocated = false;
    boolean imageYdownAllocated = false;
    boolean imageYupCacheDirty = false;
    boolean imageYdownCacheDirty = false;
    static final int BYTE_RGBA = 1;
    static final int BYTE_ABGR = 2;
    static final int BYTE_GRAY = 4;
    static final int USHORT_GRAY = 8;
    static final int BYTE_LA = 16;
    static final int BYTE_BGR = 32;
    static final int BYTE_RGB = 64;
    int imageYupClass = 0;
    int imageYdownClass = 0;
    static final int BUFFERED_IMAGE = 1;
    static final int RENDERED_IMAGE = 2;
    static final int IMAGE_CHANGED = 1;
    static final int SUBIMAGE_CHANGED = 2;
    GeometryLock geomLock = new GeometryLock();
    int minTileX = 0;
    int minTileY = 0;
    int minTileZ = 0;
    int tilew = 0;
    int tileh = 0;
    int tiled = 0;
    int numXTiles = 0;
    int numYTiles = 0;
    int numZTiles = 0;
    int tileGridXOffset = 0;
    int tileGridYOffset = 0;
    int minX = 0;
    int minY = 0;
    ArrayList userList = new ArrayList();

    ImageComponentRetained() {
    }

    final int getWidth() {
        return this.width;
    }

    final int getHeight() {
        return this.height;
    }

    final int getFormat() {
        return this.format;
    }

    void processParams(int n, int n2, int n3, int n4) {
        if (n2 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained0"));
        }
        if (n3 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained1"));
        }
        if (n4 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained2"));
        }
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained3"));
        }
        this.format = n;
        this.width = n2;
        this.height = n3;
        this.imageDirty = new boolean[n4];
        for (int i = 0; i < n4; ++i) {
            this.imageDirty[i] = false;
        }
        this.bImage = new RenderedImage[n4];
        this.noAlpha = n == 1 || n == 5 || n == 9 || n == 3;
        switch (n) {
            case 1: {
                this.bytesPerPixel = 3;
                this.bytesPerPixelIfStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 2: {
                this.bytesPerPixel = 4;
                this.bytesPerPixelIfStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 3: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelIfStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 4: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelIfStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 5: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelIfStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 6: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelIfStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 9: {
                this.bytesPerPixel = 1;
                this.bytesPerPixelIfStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 7: {
                this.bytesPerPixel = 1;
                this.bytesPerPixelIfStored = 2;
                this.internalFormat = 16;
                break;
            }
            case 8: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelIfStored = 2;
                this.internalFormat = 16;
                break;
            }
            case 10: {
                this.bytesPerPixel = 1;
                this.bytesPerPixelIfStored = 1;
                this.internalFormat = 4;
                break;
            }
        }
    }

    void setTextureRef() {
        this.usedByTexture = true;
    }

    void setRasterRef() {
        this.usedByRaster = true;
    }

    boolean formatMatches(int n, RenderedImage renderedImage) {
        if (n == 16) {
            return false;
        }
        int n2 = this.getImageType(renderedImage);
        if (n == 2 && n2 == 6 || n == 32 && n2 == 5 || n == 4 && n2 == 10 || n == 8 && n2 == 11) {
            return true;
        }
        if (n2 == 0 && this.is4ByteRGBAOr3ByteRGB(renderedImage)) {
            int n3 = renderedImage.getSampleModel().getNumBands();
            if (n3 == 3 && n == 64) {
                return true;
            }
            if (n3 == 4 && n == 1) {
                return true;
            }
        }
        return false;
    }

    final void copyImage(RenderedImage renderedImage, byte[] byArray, boolean bl, int n, int n2, int n3) {
        if (renderedImage instanceof BufferedImage) {
            this.copyImage((BufferedImage)renderedImage, 0, 0, byArray, 0, 0, bl, n, this.width, this.height, n2, n3);
        } else {
            this.copyImage(renderedImage, renderedImage.getMinX(), renderedImage.getMinY(), byArray, 0, 0, bl, n, this.width, this.height, n2, n3);
        }
    }

    final void copyImage(RenderedImage renderedImage, int n, int n2, byte[] byArray, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        int n11;
        int n12;
        if (renderedImage instanceof BufferedImage) {
            this.copyImage((BufferedImage)renderedImage, n, n2, byArray, n3, n4, bl, n5, n6, n7, n8, n9);
            return;
        }
        Object object = null;
        int n13 = this.width * n9;
        ColorModel colorModel = renderedImage.getColorModel();
        int n14 = renderedImage.getTileGridXOffset();
        int n15 = renderedImage.getTileGridYOffset();
        int n16 = renderedImage.getMinTileX();
        int n17 = renderedImage.getMinTileY();
        this.tilew = renderedImage.getTileWidth();
        this.tileh = renderedImage.getTileHeight();
        float f = (float)(n - n14) / (float)this.tilew;
        n16 = f < 0.0f ? (int)(f - 1.0f) : (int)f;
        f = (float)(n2 - n15) / (float)this.tileh;
        n17 = f < 0.0f ? (int)(f - 1.0f) : (int)f;
        int n18 = n16 * this.tilew + n14;
        int n19 = n17 * this.tileh + n15;
        int n20 = n18 + this.tilew - n;
        int n21 = n19 + this.tileh - n2;
        if (n20 > n6) {
            n20 = n6;
        }
        if (n21 > n7) {
            n21 = n7;
        }
        int n22 = n20;
        int n23 = n6;
        int n24 = n7;
        int n25 = n - n18;
        int n26 = n2 - n19;
        this.numXTiles = (n6 + n25) / this.tilew;
        this.numYTiles = (n7 + n26) / this.tileh;
        if ((float)(n6 + n25) % (float)this.tilew > 0.0f) {
            ++this.numXTiles;
        }
        if ((float)(n7 + n26) % (float)this.tileh > 0.0f) {
            ++this.numYTiles;
        }
        if (!this.yUp && bl || this.yUp && !bl) {
            n12 = ((this.height - n4 - 1) * this.width + n3) * n9;
            n11 = -1;
            n10 = -n13;
        } else {
            n12 = (n4 * this.width + n3) * n9;
            n11 = 1;
            n10 = n13;
        }
        Raster raster = renderedImage.getTile(n16, n17);
        object = ImageComponentRetained.getDataElementBuffer(raster);
        if (this.formatMatches(n8, renderedImage)) {
            int n27 = this.tilew * n9;
            for (int i = n17; i < n17 + this.numYTiles; ++i) {
                int n28 = n12;
                n23 = n6;
                n20 = n22;
                n25 = n - n18;
                for (int j = n16; j < n16 + this.numXTiles; ++j) {
                    raster = renderedImage.getTile(j, i);
                    byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                    int n29 = (n26 * this.tilew + n25) * n9;
                    int n30 = n28;
                    int n31 = n20 * n9;
                    for (int k = 0; k < n21; ++k) {
                        System.arraycopy(byArray2, n29, byArray, n30, n31);
                        n29 += n27;
                        n30 += n10;
                    }
                    n28 += n20 * n9;
                    n25 = 0;
                    n20 = (n23 -= n20) < this.tilew ? n23 : this.tilew;
                }
                n12 += this.width * n9 * n21 * n11;
                n26 = 0;
                n21 = (n24 -= n21) < this.tileh ? n24 : this.tileh;
            }
            return;
        }
        switch (this.format) {
            case 2: 
            case 4: 
            case 6: {
                for (int i = n17; i < n17 + this.numYTiles; ++i) {
                    int n32 = n12;
                    n23 = n6;
                    n20 = n22;
                    n25 = n - n18;
                    for (int j = n16; j < n16 + this.numXTiles; ++j) {
                        raster = renderedImage.getTile(j, i);
                        int n33 = n32;
                        int n34 = 0;
                        for (int k = n26; k < n26 + n21; ++k) {
                            for (int i2 = n25; i2 < n25 + n20; ++i2) {
                                raster.getDataElements(i2, k, object);
                                byArray[n33++] = (byte)colorModel.getRed(object);
                                byArray[n33++] = (byte)colorModel.getGreen(object);
                                byArray[n33++] = (byte)colorModel.getBlue(object);
                                byArray[n33++] = (byte)colorModel.getAlpha(object);
                            }
                            n33 = n32 + (n34 += n10);
                        }
                        n32 += n20 * n9;
                        n25 = 0;
                        n20 = (n23 -= n20) < this.tilew ? n23 : this.tilew;
                    }
                    n12 += this.width * n9 * n21 * n11;
                    n26 = 0;
                    n21 = (n24 -= n21) < this.tileh ? n24 : this.tileh;
                }
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                for (int i = n17; i < n17 + this.numYTiles; ++i) {
                    int n35 = n12;
                    n23 = n6;
                    n20 = n22;
                    n25 = n - n18;
                    for (int j = n16; j < n16 + this.numXTiles; ++j) {
                        raster = renderedImage.getTile(j, i);
                        int n36 = n35;
                        int n37 = 0;
                        for (int k = n26; k < n26 + n21; ++k) {
                            for (int i3 = n25; i3 < n25 + n20; ++i3) {
                                raster.getDataElements(i3, k, object);
                                byArray[n36++] = (byte)colorModel.getRed(object);
                                byArray[n36++] = (byte)colorModel.getGreen(object);
                                byArray[n36++] = (byte)colorModel.getBlue(object);
                                byArray[n36++] = -1;
                            }
                            n36 = n35 + (n37 += n10);
                        }
                        n35 += n20 * n9;
                        n25 = 0;
                        n20 = (n23 -= n20) < this.tilew ? n23 : this.tilew;
                    }
                    n12 += this.width * n9 * n21 * n11;
                    n26 = 0;
                    n21 = (n24 -= n21) < this.tileh ? n24 : this.tileh;
                }
                break;
            }
            case 7: 
            case 8: {
                for (int i = n17; i < n17 + this.numYTiles; ++i) {
                    int n38 = n12;
                    n23 = n6;
                    n20 = n22;
                    n25 = n - n18;
                    for (int j = n16; j < n16 + this.numXTiles; ++j) {
                        raster = renderedImage.getTile(j, i);
                        int n39 = n38;
                        int n40 = 0;
                        for (int k = n26; k < n26 + n21; ++k) {
                            for (int i4 = n25; i4 < n25 + n20; ++i4) {
                                raster.getDataElements(i4, k, object);
                                byArray[n39++] = (byte)colorModel.getRed(object);
                                byArray[n39++] = (byte)colorModel.getAlpha(object);
                            }
                            n39 = n38 + (n40 += n10);
                        }
                        n38 += n20 * n9;
                        n25 = 0;
                        n20 = (n23 -= n20) < this.tilew ? n23 : this.tilew;
                    }
                    n12 += this.width * n9 * n21 * n11;
                    n26 = 0;
                    n21 = (n24 -= n21) < this.tileh ? n24 : this.tileh;
                }
                break;
            }
            case 10: {
                for (int i = n17; i < n17 + this.numYTiles; ++i) {
                    int n41 = n12;
                    n23 = n6;
                    n20 = n22;
                    n25 = n - n18;
                    for (int j = n16; j < n16 + this.numXTiles; ++j) {
                        raster = renderedImage.getTile(j, i);
                        int n42 = n41;
                        int n43 = 0;
                        for (int k = n26; k < n26 + n21; ++k) {
                            for (int i5 = n25; i5 < n25 + n20; ++i5) {
                                raster.getDataElements(i5, k, object);
                                byArray[n42++] = (byte)colorModel.getRed(object);
                            }
                            n42 = n41 + (n43 += n10);
                        }
                        n41 += n20 * n9;
                        n25 = 0;
                        n20 = (n23 -= n20) < this.tilew ? n23 : this.tilew;
                    }
                    n12 += this.width * n9 * n21 * n11;
                    n26 = 0;
                    n21 = (n24 -= n21) < this.tileh ? n24 : this.tileh;
                }
                break;
            }
        }
    }

    final void copyImage(BufferedImage bufferedImage, byte[] byArray, boolean bl, int n, int n2, int n3) {
        this.copyImage(bufferedImage, 0, 0, byArray, 0, 0, bl, n, this.width, this.height, n2, n3);
    }

    final void copyImage(BufferedImage bufferedImage, int n, int n2, byte[] byArray, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        Object object = null;
        int n11 = n2;
        int n12 = 1;
        int n13 = this.width * n9;
        if (!this.yUp && bl || this.yUp && !bl) {
            n10 = (n5 * this.width * this.height + (this.height - n4 - 1) * this.width + n3) * n9;
            n13 = -1 * n13;
        } else {
            n10 = (n4 * this.width + n3) * n9;
        }
        if (this.formatMatches(n8, bufferedImage)) {
            byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            int n14 = n6 * n9;
            int n15 = this.width * n9;
            int n16 = (n11 * this.width + n) * n9;
            for (int i = 0; i < n7; ++i) {
                System.arraycopy(byArray2, n16, byArray, n10, n14);
                n10 += n13;
                n16 += n15;
            }
        } else {
            int n17 = bufferedImage.getType();
            if (!(n17 != 2 && n17 != 1 || this.format != 2 && this.format != 1)) {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n18 = n12 * this.width;
                int n19 = n11 * this.width + n;
                if (n17 == 2 && this.format == 2) {
                    for (int i = 0; i < n7; ++i) {
                        int n20 = n19;
                        int n21 = n10;
                        int n22 = 0;
                        while (n22 < n6) {
                            int n23 = nArray[n20];
                            byArray[n21++] = (byte)(n23 >> 16 & 0xFF);
                            byArray[n21++] = (byte)(n23 >> 8 & 0xFF);
                            byArray[n21++] = (byte)(n23 & 0xFF);
                            byArray[n21++] = (byte)(n23 >> 24 & 0xFF);
                            ++n22;
                            ++n20;
                        }
                        n19 += n18;
                        n10 += n13;
                    }
                } else {
                    for (int i = 0; i < n7; ++i) {
                        int n24 = n19;
                        int n25 = n10;
                        int n26 = 0;
                        while (n26 < n6) {
                            int n27 = nArray[n24];
                            byArray[n25++] = (byte)(n27 >> 16 & 0xFF);
                            byArray[n25++] = (byte)(n27 >> 8 & 0xFF);
                            byArray[n25++] = (byte)(n27 & 0xFF);
                            byArray[n25++] = -1;
                            ++n26;
                            ++n24;
                        }
                        n19 += n18;
                        n10 += n13;
                    }
                }
            } else if (n17 == 10 && this.format == 10) {
                byte[] byArray3 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n28 = n12 * this.width;
                int n29 = n10;
                int n30 = n11 * this.width + n;
                int n31 = 0;
                while (n31 < n7) {
                    System.arraycopy(byArray3, n30, byArray, n29, n6);
                    ++n31;
                    n29 += this.width;
                    n30 += n28;
                }
            } else {
                WritableRaster writableRaster = bufferedImage.getRaster();
                ColorModel colorModel = bufferedImage.getColorModel();
                object = ImageComponentRetained.getDataElementBuffer(writableRaster);
                switch (this.format) {
                    case 2: 
                    case 4: 
                    case 6: {
                        int n32 = n11;
                        int n33 = 0;
                        while (n33 < n7) {
                            int n34 = n10;
                            for (int i = n; i < n6 + n; ++i) {
                                writableRaster.getDataElements(i, n32, object);
                                byArray[n34++] = (byte)colorModel.getRed(object);
                                byArray[n34++] = (byte)colorModel.getGreen(object);
                                byArray[n34++] = (byte)colorModel.getBlue(object);
                                byArray[n34++] = (byte)colorModel.getAlpha(object);
                            }
                            n10 += n13;
                            ++n33;
                            n32 += n12;
                        }
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 9: {
                        int n35 = n11;
                        int n36 = 0;
                        while (n36 < n7) {
                            int n37 = n10;
                            for (int i = n; i < n6 + n; ++i) {
                                writableRaster.getDataElements(i, n35, object);
                                byArray[n37++] = (byte)colorModel.getRed(object);
                                byArray[n37++] = (byte)colorModel.getGreen(object);
                                byArray[n37++] = (byte)colorModel.getBlue(object);
                                byArray[n37++] = -1;
                            }
                            n10 += n13;
                            ++n36;
                            n35 += n12;
                        }
                        break;
                    }
                    case 7: 
                    case 8: {
                        int n38 = n11;
                        int n39 = 0;
                        while (n39 < n7) {
                            int n40 = n10;
                            for (int i = n; i < n6 + n; ++i) {
                                writableRaster.getDataElements(i, n38, object);
                                byArray[n40++] = (byte)colorModel.getRed(object);
                                byArray[n40++] = (byte)colorModel.getAlpha(object);
                            }
                            n10 += n13;
                            ++n39;
                            n38 += n12;
                        }
                        break;
                    }
                    case 10: {
                        int n41 = n11;
                        int n42 = 0;
                        while (n42 < n7) {
                            int n43 = n10;
                            for (int i = n; i < n6 + n; ++i) {
                                writableRaster.getDataElements(i, n41, object);
                                byArray[n43++] = (byte)colorModel.getRed(object);
                            }
                            n10 += n13;
                            ++n42;
                            n41 += n12;
                        }
                        break;
                    }
                }
            }
        }
    }

    final int getBytesStored(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
            case 32: {
                n2 = 3;
                break;
            }
            case 64: {
                n2 = 3;
            }
        }
        return n2;
    }

    boolean is4ByteRGBAOr3ByteRGB(RenderedImage renderedImage) {
        boolean bl = false;
        int n = this.getImageType(renderedImage);
        if (n != 0) {
            return false;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl2 = colorModel.isAlphaPremultiplied();
        int n2 = colorSpace.getType();
        if (n2 == 5) {
            int n3 = sampleModel.getNumBands();
            if (sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
                PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                int[] nArray2 = componentColorModel.getComponentSize();
                boolean bl3 = true;
                for (int i = 0; i < n3; ++i) {
                    if (nArray2[i] == 8) continue;
                    bl3 = false;
                    break;
                }
                if (bl3 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                    if (n3 == 3) {
                        if (this.format == 1) {
                            bl = true;
                        }
                    } else if (nArray[3] == 3 && !bl2 && this.format == 2) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    final int getImageType(RenderedImage renderedImage) {
        int n = 0;
        if (renderedImage instanceof BufferedImage) {
            return ((BufferedImage)renderedImage).getType();
        }
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = colorSpace.getType();
        boolean bl = colorModel.isAlphaPremultiplied();
        if (n2 != 5) {
            if (n2 == 6 && colorModel instanceof ComponentColorModel) {
                if (sampleModel.getDataType() == 0) {
                    n = 10;
                } else if (sampleModel.getDataType() == 1) {
                    n = 11;
                }
            }
        } else {
            int n3 = sampleModel.getNumBands();
            if (sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
                PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                int[] nArray2 = componentColorModel.getComponentSize();
                boolean bl2 = true;
                for (int i = 0; i < n3; ++i) {
                    if (nArray2[i] == 8) continue;
                    bl2 = false;
                    break;
                }
                if (bl2 && nArray[0] == n3 - 1 && nArray[1] == n3 - 2 && nArray[2] == n3 - 3) {
                    if (n3 == 3) {
                        n = 5;
                    } else if (nArray[3] == 0) {
                        n = bl ? 7 : 6;
                    }
                }
            }
        }
        return n;
    }

    final void retrieveBufferedImage(int n) {
        if (this.bImage[n] == null) {
            this.bImage[n] = this.format == 2 || this.format == 6 || this.format == 4 || this.format == 7 || this.format == 8 ? new BufferedImage(this.width, this.height, 2) : new BufferedImage(this.width, this.height, 1);
        }
        if (this.usedByTexture || !this.usedByRaster) {
            this.copyToBufferedImage(this.imageYup, n, true);
        } else {
            this.copyToBufferedImage(this.imageYdown[0], n, false);
        }
        this.imageDirty[n] = false;
    }

    final void copyBufferedImageWithFormatConversion(boolean bl, int n) {
        byte[] byArray;
        int n2;
        int n3;
        int n4;
        int n5;
        BufferedImage bufferedImage = (BufferedImage)this.bImage[n];
        int n6 = bufferedImage.getType();
        if (!this.yUp) {
            if (bl) {
                n5 = -1 * this.width;
                n4 = (this.height - 1) * this.width;
                n3 = this.height - 1;
                n2 = -1;
                byArray = this.imageYup;
            } else {
                n5 = this.width;
                n4 = 0;
                n3 = 0;
                n2 = 1;
                byArray = this.imageYdown[0];
            }
        } else if (bl) {
            n5 = this.width;
            n4 = 0;
            n3 = 0;
            n2 = 1;
            byArray = this.imageYup;
        } else {
            n5 = -1 * this.width;
            n4 = (this.height - 1) * this.width;
            n3 = this.height - 1;
            n2 = -1;
            byArray = this.imageYdown[0];
        }
        switch (n6) {
            case 2: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n7 = 0;
                int n8 = 0;
                while (n8 < this.height) {
                    int n9 = n4;
                    int n10 = 0;
                    while (n10 < this.width) {
                        nArray[n9] = (byArray[n7 + 3] & 0xFF) << 24 | (byArray[n7] & 0xFF) << 16 | (byArray[n7 + 1] & 0xFF) << 8 | byArray[n7 + 2] & 0xFF;
                        ++n10;
                        n7 += 4;
                        ++n9;
                    }
                    ++n8;
                    n4 += n5;
                }
                break;
            }
            case 1: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n11 = 0;
                int n12 = 0;
                while (n12 < this.height) {
                    int n13 = n4;
                    int n14 = 0;
                    while (n14 < this.width) {
                        nArray[n13] = 0xFF000000 | (byArray[n11] & 0xFF) << 16 | (byArray[n11 + 1] & 0xFF) << 8 | byArray[n11 + 2] & 0xFF;
                        ++n14;
                        n11 += 4;
                        ++n13;
                    }
                    ++n12;
                    n4 += n5;
                }
                break;
            }
            case 6: {
                byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n15 = 0;
                int n16 = 0;
                while (n16 < this.height) {
                    int n17 = n4;
                    int n18 = 0;
                    while (n18 < this.width) {
                        byArray2[n17++] = byArray[n15 + 3];
                        byArray2[n17++] = byArray[n15 + 2];
                        byArray2[n17++] = byArray[n15 + 1];
                        byArray2[n17++] = byArray[n15];
                        ++n18;
                        n15 += 4;
                    }
                    ++n16;
                    n4 += n5 << 2;
                }
                break;
            }
            case 4: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n19 = 0;
                int n20 = 0;
                while (n20 < this.height) {
                    int n21 = n4;
                    int n22 = 0;
                    while (n22 < this.width) {
                        nArray[n21] = 0xFF000000 | byArray[n19] & 0xFF | (byArray[n19 + 1] & 0xFF) << 8 | (byArray[n19 + 2] & 0xFF) << 16;
                        ++n22;
                        n19 += 4;
                        ++n21;
                    }
                    ++n20;
                    n4 += n5;
                }
                break;
            }
            case 10: {
                byte[] byArray3 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n23 = 0;
                int n24 = 0;
                while (n24 < this.height) {
                    System.arraycopy(byArray3, n4, byArray, n23, this.width);
                    n23 += this.width;
                    ++n24;
                    n4 += n5;
                }
                break;
            }
            case 11: {
                int n25 = 0;
                short[] sArray = ((DataBufferShort)bufferedImage.getRaster().getDataBuffer()).getData();
                int n26 = 0;
                while (n26 < this.height) {
                    int n27 = n4;
                    int n28 = 0;
                    while (n28 < this.width) {
                        sArray[n27] = byArray[n25];
                        ++n28;
                        ++n27;
                        ++n25;
                    }
                    ++n26;
                    n4 += n5;
                }
                break;
            }
            default: {
                int n29 = 0;
                int n30 = 0;
                while (n30 < this.height) {
                    int n31 = n3;
                    int n32 = 0;
                    while (n32 < this.width) {
                        int n33 = (byArray[n29 + 3] & 0xFF) << 24 | (byArray[n29] & 0xFF) << 16 | (byArray[n29 + 1] & 0xFF) << 8 | byArray[n29 + 2] & 0xFF;
                        bufferedImage.setRGB(n32, n31, n33);
                        ++n32;
                        n29 += 4;
                    }
                    ++n30;
                    n3 += n2;
                }
                break block0;
            }
        }
    }

    final void copyToBufferedImage(byte[] byArray, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (!this.yUp) {
            if (bl) {
                n4 = n * this.width * this.height * this.bytesPerYupPixelStored;
                n3 = -1 * this.width;
                n2 = (this.height - 1) * this.width;
            } else {
                n4 = 0;
                n3 = this.width;
                n2 = 0;
            }
        } else if (bl) {
            n4 = 0;
            n3 = this.width;
            n2 = 0;
        } else {
            n4 = n * this.width * this.height * this.bytesPerYdownPixelStored;
            n3 = -1 * this.width;
            n2 = (this.height - 1) * this.width;
        }
        int[] nArray = ((DataBufferInt)((BufferedImage)this.bImage[n]).getRaster().getDataBuffer()).getData();
        switch (this.format) {
            case 2: 
            case 4: 
            case 6: {
                int n5 = n4;
                int n6 = 0;
                while (n6 < this.height) {
                    int n7 = n2;
                    int n8 = 0;
                    while (n8 < this.width) {
                        nArray[n7] = (byArray[n5 + 3] & 0xFF) << 24 | (byArray[n5] & 0xFF) << 16 | (byArray[n5 + 1] & 0xFF) << 8 | byArray[n5 + 2] & 0xFF;
                        ++n8;
                        n5 += 4;
                        ++n7;
                    }
                    ++n6;
                    n2 += n3;
                }
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                int n9 = n4;
                int n10 = 0;
                while (n10 < this.height) {
                    int n11 = n2;
                    int n12 = 0;
                    while (n12 < this.width) {
                        nArray[n11] = (byArray[n9] & 0xFF) << 16 | (byArray[n9 + 1] & 0xFF) << 8 | byArray[n9 + 2] & 0xFF;
                        ++n12;
                        n9 += 4;
                        ++n11;
                    }
                    ++n10;
                    n2 += n3;
                }
                break;
            }
            case 7: 
            case 8: {
                int n13 = n4;
                int n14 = 0;
                while (n14 < this.height) {
                    int n15 = n2;
                    int n16 = 0;
                    while (n16 < this.width) {
                        nArray[n15] = (byArray[n13 + 1] & 0xFF) << 24 | (byArray[n13] & 0xFF) << 16;
                        ++n16;
                        n13 += 2;
                        ++n15;
                    }
                    ++n14;
                    n2 += n3;
                }
                break;
            }
            case 10: {
                int n17 = n4;
                int n18 = 0;
                while (n18 < this.height) {
                    int n19 = n2;
                    int n20 = 0;
                    while (n20 < this.width) {
                        nArray[n19] = (byArray[n17] & 0xFF) << 16;
                        ++n20;
                        ++n17;
                        ++n19;
                    }
                    ++n18;
                    n2 += n3;
                }
                break;
            }
        }
    }

    Object getData(DataBuffer dataBuffer) {
        Object[] objectArray = null;
        switch (dataBuffer.getDataType()) {
            case 0: {
                objectArray = ((DataBufferByte)dataBuffer).getData();
                break;
            }
            case 3: {
                objectArray = ((DataBufferInt)dataBuffer).getData();
                break;
            }
            case 2: {
                objectArray = ((DataBufferShort)dataBuffer).getData();
            }
        }
        return objectArray;
    }

    final void setByReference(boolean bl) {
        this.byReference = bl;
    }

    final boolean isByReference() {
        return this.byReference;
    }

    final void setYUp(boolean bl) {
        this.yUp = bl;
    }

    final boolean isYUp() {
        return this.yUp;
    }

    synchronized void addUser(NodeComponentRetained nodeComponentRetained) {
        this.userList.add(nodeComponentRetained);
    }

    synchronized void removeUser(NodeComponentRetained nodeComponentRetained) {
        int n = this.userList.indexOf(nodeComponentRetained);
        if (n >= 0) {
            this.userList.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateMirrorObject(int n, Object object) {
        if ((n & 1) != 0 || (n & 2) != 0) {
            ArrayList arrayList = this.userList;
            synchronized (arrayList) {
                for (int i = this.userList.size() - 1; i >= 0; --i) {
                    Object e = this.userList.get(i);
                    if (e == null) continue;
                    if (e instanceof TextureRetained) {
                        ((TextureRetained)e).notifyImageComponentImageChanged(this, (ImageComponentUpdateInfo)object);
                        continue;
                    }
                    if (e instanceof RasterRetained) {
                        ((RasterRetained)e).notifyImageComponentImageChanged(this, (ImageComponentUpdateInfo)object);
                        continue;
                    }
                    if (!(e instanceof BackgroundRetained)) continue;
                    ((BackgroundRetained)e).notifyImageComponentImageChanged(this, (ImageComponentUpdateInfo)object);
                }
            }
            if (object != null) {
                VirtualUniverse.mc.addFreeImageUpdateInfo((ImageComponentUpdateInfo)object);
            }
        }
    }

    final void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1152;
        j3dMessage.type = 54;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void handleFrequencyChange(int n) {
        if (n == 3) {
            this.setFrequencyChangeMask(3, 1);
        }
    }

    static Object getDataElementBuffer(Raster raster) {
        int n = raster.getNumDataElements();
        switch (raster.getTransferType()) {
            case 3: {
                return new int[n];
            }
            case 0: {
                return new byte[n];
            }
            case 1: 
            case 2: {
                return new short[n];
            }
            case 4: {
                return new float[n];
            }
            case 5: {
                return new double[n];
            }
        }
        return null;
    }
}

