/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3DCompileRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Text3DRetained;
import javax.vecmath.Point4d;

class Picking {
    Picking() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath[] pickAll(Locale locale, PickShape pickShape) {
        if (locale == null) {
            return null;
        }
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Object object = locale.universe.sceneGraphLock;
        synchronized (object) {
            return Picking.getSceneGraphPath(null, null, geometryAtomArray, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath[] pickAll(BranchGroup branchGroup, PickShape pickShape) {
        if (branchGroup == null) {
            return null;
        }
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        if (branchGroupRetained.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("Picking0"));
        }
        Locale locale = branchGroupRetained.locale;
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Object object = branchGroupRetained.universe.sceneGraphLock;
        synchronized (object) {
            return Picking.getSceneGraphPath(Picking.initSceneGraphPath(branchGroupRetained), branchGroupRetained, geometryAtomArray, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath[] pickAllSorted(Locale locale, PickShape pickShape) {
        if (locale == null) {
            return null;
        }
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Picking.sortGeomAtoms(geometryAtomArray, pickShape);
        Object object = locale.universe.sceneGraphLock;
        synchronized (object) {
            return Picking.getSceneGraphPath(null, null, geometryAtomArray, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath[] pickAllSorted(BranchGroup branchGroup, PickShape pickShape) {
        if (branchGroup == null) {
            return null;
        }
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        if (branchGroupRetained.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("Picking0"));
        }
        Locale locale = branchGroupRetained.locale;
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Picking.sortGeomAtoms(geometryAtomArray, pickShape);
        Object object = branchGroupRetained.universe.sceneGraphLock;
        synchronized (object) {
            return Picking.getSceneGraphPath(Picking.initSceneGraphPath(branchGroupRetained), branchGroupRetained, geometryAtomArray, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath pickClosest(Locale locale, PickShape pickShape) {
        if (locale == null) {
            return null;
        }
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        GeometryAtom geometryAtom = Picking.selectClosest(geometryAtomArray, pickShape);
        Object object = locale.universe.sceneGraphLock;
        synchronized (object) {
            return Picking.getSceneGraphPath(null, null, geometryAtom, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath pickClosest(BranchGroup branchGroup, PickShape pickShape) {
        if (branchGroup == null) {
            return null;
        }
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        if (branchGroupRetained.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("Picking0"));
        }
        Locale locale = branchGroupRetained.locale;
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Picking.sortGeomAtoms(geometryAtomArray, pickShape);
        Object object = branchGroupRetained.universe.sceneGraphLock;
        synchronized (object) {
            return Picking.getFirstSceneGraphPath(Picking.initSceneGraphPath(branchGroupRetained), branchGroupRetained, geometryAtomArray, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath pickAny(Locale locale, PickShape pickShape) {
        if (locale == null) {
            return null;
        }
        GeometryAtom geometryAtom = locale.universe.geometryStructure.pickAny(locale, pickShape);
        if (geometryAtom == null) {
            return null;
        }
        Object object = locale.universe.sceneGraphLock;
        synchronized (object) {
            return Picking.getSceneGraphPath(null, null, geometryAtom, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath pickAny(BranchGroup branchGroup, PickShape pickShape) {
        if (branchGroup == null) {
            return null;
        }
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        if (branchGroupRetained.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("Picking0"));
        }
        Locale locale = branchGroupRetained.locale;
        GeometryAtom[] geometryAtomArray = locale.universe.geometryStructure.pickAll(locale, pickShape);
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        Object object = branchGroupRetained.universe.sceneGraphLock;
        synchronized (object) {
            return Picking.getFirstSceneGraphPath(Picking.initSceneGraphPath(branchGroupRetained), branchGroupRetained, geometryAtomArray, locale);
        }
    }

    private static ArrayList initSceneGraphPath(NodeRetained nodeRetained) {
        ArrayList<NodeRetained> arrayList = new ArrayList<NodeRetained>(5);
        do {
            if (!nodeRetained.source.getCapability(1)) continue;
            arrayList.add(nodeRetained);
        } while ((nodeRetained = nodeRetained.parent) != null);
        return arrayList;
    }

    private static SceneGraphPath[] getSceneGraphPath(ArrayList arrayList, BranchGroupRetained branchGroupRetained, GeometryAtom[] geometryAtomArray, Locale locale) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>(5);
        ArrayList<NodeRetained> arrayList3 = null;
        if (geometryAtomArray == null) {
            return null;
        }
        for (int i = 0; i < geometryAtomArray.length; ++i) {
            int n;
            Object object;
            Cloneable cloneable;
            NodeRetained nodeRetained;
            GeometryAtom geometryAtom = geometryAtomArray[i];
            Shape3DRetained shape3DRetained = geometryAtom.source;
            if (!Picking.inside(shape3DRetained.branchGroupPath, branchGroupRetained) || (nodeRetained = shape3DRetained.sourceNode) == null) continue;
            if (nodeRetained instanceof Shape3DRetained) {
                int n2;
                cloneable = (Shape3DRetained)nodeRetained;
                object = null;
                for (n2 = 0; n2 < cloneable.geometryList.size() && (object = (GeometryRetained)cloneable.geometryList.get(n2)) == null; ++n2) {
                }
                if (object == null) continue;
                if (object instanceof Text3DRetained) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<NodeRetained>(3);
                    } else {
                        n2 = arrayList3.size();
                        n = 0;
                        for (int j = 0; j < n2; ++j) {
                            if (arrayList3.get(j) != nodeRetained) continue;
                            n = 1;
                            break;
                        }
                        if (n != 0) continue;
                    }
                    arrayList3.add(nodeRetained);
                }
            }
            if ((cloneable = Picking.retrievePath(nodeRetained, branchGroupRetained, geometryAtom.source.key)) == null) continue;
            if (nodeRetained instanceof Shape3DCompileRetained) {
                object = (Shape3DCompileRetained)nodeRetained;
                Node[] nodeArray = Picking.mergePath((ArrayList)cloneable, arrayList);
                for (n = 0; n < ((Shape3DCompileRetained)object).srcList.length; ++n) {
                    SceneGraphPath sceneGraphPath = new SceneGraphPath(locale, nodeArray, (Node)((Shape3DCompileRetained)object).srcList[n]);
                    sceneGraphPath.setTransform(shape3DRetained.getCurrentLocalToVworld(0));
                    arrayList2.add(sceneGraphPath);
                }
                continue;
            }
            object = new SceneGraphPath(locale, Picking.mergePath((ArrayList)cloneable, arrayList), (Node)nodeRetained.source);
            ((SceneGraphPath)object).setTransform(shape3DRetained.getCurrentLocalToVworld(0));
            arrayList2.add(object);
        }
        SceneGraphPath[] sceneGraphPathArray = new SceneGraphPath[arrayList2.size()];
        return arrayList2.toArray(sceneGraphPathArray);
    }

    private static SceneGraphPath getSceneGraphPath(ArrayList arrayList, BranchGroupRetained branchGroupRetained, GeometryAtom geometryAtom, Locale locale) {
        if (geometryAtom == null) {
            return null;
        }
        Shape3DRetained shape3DRetained = geometryAtom.source;
        NodeRetained nodeRetained = shape3DRetained.sourceNode;
        if (nodeRetained == null) {
            return null;
        }
        if (!Picking.inside(shape3DRetained.branchGroupPath, branchGroupRetained)) {
            return null;
        }
        ArrayList arrayList2 = Picking.retrievePath(nodeRetained, branchGroupRetained, shape3DRetained.key);
        if (arrayList2 == null) {
            return null;
        }
        SceneGraphPath sceneGraphPath = new SceneGraphPath(locale, Picking.mergePath(arrayList2, arrayList), (Node)nodeRetained.source);
        sceneGraphPath.setTransform(shape3DRetained.getCurrentLocalToVworld(0));
        return sceneGraphPath;
    }

    private static boolean inside(BranchGroupRetained[] branchGroupRetainedArray, BranchGroupRetained branchGroupRetained) {
        if (branchGroupRetained == null || branchGroupRetainedArray == null) {
            return true;
        }
        for (int i = 0; i < branchGroupRetainedArray.length; ++i) {
            if (branchGroupRetainedArray[i] != branchGroupRetained) continue;
            return true;
        }
        return false;
    }

    private static SceneGraphPath getFirstSceneGraphPath(ArrayList arrayList, BranchGroupRetained branchGroupRetained, GeometryAtom[] geometryAtomArray, Locale locale) {
        if (geometryAtomArray == null) {
            return null;
        }
        for (int i = 0; i < geometryAtomArray.length; ++i) {
            ArrayList arrayList2;
            Shape3DRetained shape3DRetained = geometryAtomArray[i].source;
            NodeRetained nodeRetained = shape3DRetained.sourceNode;
            if (nodeRetained == null || !Picking.inside(shape3DRetained.branchGroupPath, branchGroupRetained) || (arrayList2 = Picking.retrievePath(nodeRetained, branchGroupRetained, geometryAtomArray[i].source.key)) == null) continue;
            SceneGraphPath sceneGraphPath = new SceneGraphPath(locale, Picking.mergePath(arrayList2, arrayList), (Node)nodeRetained.source);
            sceneGraphPath.setTransform(shape3DRetained.getCurrentLocalToVworld(0));
            return sceneGraphPath;
        }
        return null;
    }

    private static ArrayList retrievePath(NodeRetained nodeRetained, NodeRetained nodeRetained2, HashKey hashKey) {
        ArrayList<NodeRetained> arrayList = new ArrayList<NodeRetained>(5);
        NodeRetained nodeRetained3 = nodeRetained;
        if (nodeRetained3.inSharedGroup) {
            hashKey = new HashKey(hashKey);
        }
        do {
            if (nodeRetained3 == nodeRetained2) {
                return arrayList;
            }
            if (nodeRetained3.source.getCapability(1)) {
                arrayList.add(nodeRetained3);
            }
            if (!(nodeRetained3 instanceof SharedGroupRetained)) continue;
            String string = hashKey.getLastNodeId();
            Vector vector = ((SharedGroupRetained)nodeRetained3).parents;
            int n = vector.size();
            NodeRetained nodeRetained4 = nodeRetained3;
            for (int i = 0; i < n; ++i) {
                NodeRetained nodeRetained5 = (NodeRetained)vector.elementAt(i);
                if (!nodeRetained5.nodeId.equals(string)) continue;
                nodeRetained3 = nodeRetained5;
                arrayList.add(nodeRetained3);
                break;
            }
            if (nodeRetained3 != nodeRetained4) continue;
            return null;
        } while ((nodeRetained3 = nodeRetained3.parent) != null);
        if (nodeRetained2 == null) {
            return arrayList;
        }
        return null;
    }

    private static Node[] mergePath(ArrayList arrayList, ArrayList arrayList2) {
        int n;
        int n2 = arrayList.size();
        int n3 = arrayList2 == null ? n2 : n2 + arrayList2.size();
        Node[] nodeArray = new Node[n3];
        int n4 = n3 - 1;
        for (n = 0; n < n2; ++n) {
            nodeArray[n4 - n] = (Node)((NodeRetained)arrayList.get((int)n)).source;
        }
        int n5 = 0;
        while (n < n3) {
            nodeArray[n4 - n] = (Node)((NodeRetained)arrayList2.get((int)n5)).source;
            ++n;
            ++n5;
        }
        return nodeArray;
    }

    private static GeometryAtom selectClosest(GeometryAtom[] geometryAtomArray, PickShape pickShape) {
        Point4d point4d = new Point4d();
        GeometryAtom geometryAtom = geometryAtomArray[0];
        pickShape.intersect(geometryAtom.source.vwcBounds, point4d);
        double d = point4d.w;
        for (int i = 1; i < geometryAtomArray.length; ++i) {
            pickShape.intersect(geometryAtomArray[i].source.vwcBounds, point4d);
            if (!(point4d.w < d)) continue;
            d = point4d.w;
            geometryAtom = geometryAtomArray[i];
        }
        return geometryAtom;
    }

    private static void sortGeomAtoms(GeometryAtom[] geometryAtomArray, PickShape pickShape) {
        double[] dArray = new double[geometryAtomArray.length];
        Point4d point4d = new Point4d();
        for (int i = 0; i < geometryAtomArray.length; ++i) {
            pickShape.intersect(geometryAtomArray[i].source.vwcBounds, point4d);
            dArray[i] = point4d.w;
        }
        class Sort {
            GeometryAtom[] atoms;
            private final /* synthetic */ double[] val$distance;

            Sort(GeometryAtom[] geometryAtomArray, double[] dArray) {
                this.val$distance = dArray;
                this.atoms = geometryAtomArray;
            }

            void sorting() {
                if (this.atoms.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.atoms.length - 1);
                }
            }

            final void insertSort() {
                for (int i = 0; i < this.atoms.length; ++i) {
                    for (int j = i; j > 0 && this.val$distance[j - 1] > this.val$distance[j]; --j) {
                        double d = this.val$distance[j];
                        this.val$distance[j] = this.val$distance[j - 1];
                        this.val$distance[j - 1] = d;
                        GeometryAtom geometryAtom = this.atoms[j];
                        this.atoms[j] = this.atoms[j - 1];
                        this.atoms[j - 1] = geometryAtom;
                    }
                }
            }

            final void quicksort(int n, int n2) {
                int n3 = n;
                int n4 = n2;
                double d = this.val$distance[(n + n2) / 2];
                while (true) {
                    if (this.val$distance[n3] < d) {
                        ++n3;
                        continue;
                    }
                    while (d < this.val$distance[n4]) {
                        --n4;
                    }
                    if (n3 <= n4) {
                        double d2 = this.val$distance[n3];
                        this.val$distance[n3] = this.val$distance[n4];
                        this.val$distance[n4] = d2;
                        GeometryAtom geometryAtom = this.atoms[n3];
                        this.atoms[n3] = this.atoms[n4];
                        this.atoms[n4] = geometryAtom;
                        ++n3;
                        --n4;
                    }
                    if (n3 > n4) break;
                }
                if (n < n4) {
                    this.quicksort(n, n4);
                }
                if (n < n2) {
                    this.quicksort(n3, n2);
                }
            }
        }
        new Sort(geometryAtomArray, dArray).sorting();
    }
}

