/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SharedGroup;

public class Group
extends Node {
    public static final int ALLOW_CHILDREN_READ = 12;
    public static final int ALLOW_CHILDREN_WRITE = 13;
    public static final int ALLOW_CHILDREN_EXTEND = 14;
    public static final int ALLOW_COLLISION_BOUNDS_READ = 15;
    public static final int ALLOW_COLLISION_BOUNDS_WRITE = 16;

    void createRetained() {
        this.retained = new GroupRetained();
        this.retained.setSource(this);
    }

    public void setCollisionBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group0"));
        }
        ((GroupRetained)this.retained).setCollisionBounds(bounds);
    }

    public Bounds getCollisionBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group1"));
        }
        return ((GroupRetained)this.retained).getCollisionBounds();
    }

    public void setChild(Node node, int n) {
        if (node instanceof SharedGroup) {
            throw new IllegalArgumentException(J3dI18N.getString("Group2"));
        }
        if (this.isLiveOrCompiled()) {
            Node node2 = ((GroupRetained)this.retained).getChild(n);
            if (!(node instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group3"));
            }
            if (!this.getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group13"));
            }
            if (node2 != null && !((BranchGroup)node2).getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group4"));
            }
        }
        ((GroupRetained)this.retained).setChild(node, n);
    }

    public void insertChild(Node node, int n) {
        if (node instanceof SharedGroup) {
            throw new IllegalArgumentException(J3dI18N.getString("Group2"));
        }
        if (this.isLiveOrCompiled()) {
            if (!(node instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group6"));
            }
            if (!this.getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group14"));
            }
        }
        ((GroupRetained)this.retained).insertChild(node, n);
    }

    public void removeChild(int n) {
        if (this.isLiveOrCompiled()) {
            Node node = ((GroupRetained)this.retained).getChild(n);
            if (!(node instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group7"));
            }
            if (!this.getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group15"));
            }
            if (!((BranchGroup)node).getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group4"));
            }
        }
        ((GroupRetained)this.retained).removeChild(n);
    }

    public Node getChild(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group9"));
        }
        return ((GroupRetained)this.retained).getChild(n);
    }

    public Enumeration getAllChildren() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group9"));
        }
        return ((GroupRetained)this.retained).getAllChildren();
    }

    public void addChild(Node node) {
        if (node instanceof SharedGroup) {
            throw new IllegalArgumentException(J3dI18N.getString("Group2"));
        }
        if (this.isLiveOrCompiled()) {
            if (!(node instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group12"));
            }
            if (!this.getCapability(14)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group16"));
            }
        }
        ((GroupRetained)this.retained).addChild(node);
    }

    public void moveTo(BranchGroup branchGroup) {
        if (this.isLiveOrCompiled()) {
            if (!this.getCapability(14)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group16"));
            }
            if (!branchGroup.getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group4"));
            }
        }
        ((GroupRetained)this.retained).moveTo(branchGroup);
    }

    public int numChildren() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group9"));
        }
        return ((GroupRetained)this.retained).numChildren();
    }

    public int indexOfChild(Node node) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group9"));
        }
        return ((GroupRetained)this.retained).indexOfChild(node);
    }

    public void removeChild(Node node) {
        if (this.isLiveOrCompiled()) {
            if (!(node instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group7"));
            }
            if (!this.getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group15"));
            }
            if (!((BranchGroup)node).getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group4"));
            }
        }
        ((GroupRetained)this.retained).removeChild(node);
    }

    public void removeAllChildren() {
        if (this.isLiveOrCompiled()) {
            GroupRetained groupRetained = (GroupRetained)this.retained;
            for (int i = groupRetained.numChildren() - 1; i >= 0; --i) {
                Node node = groupRetained.getChild(i);
                if (!(node instanceof BranchGroup)) {
                    throw new RestrictedAccessException(J3dI18N.getString("Group7"));
                }
                if (!this.getCapability(13)) {
                    throw new CapabilityNotSetException(J3dI18N.getString("Group15"));
                }
                if (((BranchGroup)node).getCapability(17)) continue;
                throw new CapabilityNotSetException(J3dI18N.getString("Group4"));
            }
        }
        ((GroupRetained)this.retained).removeAllChildren();
    }

    public void setAlternateCollisionTarget(boolean bl) {
        ((GroupRetained)this.retained).setAlternateCollisionTarget(bl);
    }

    public boolean getAlternateCollisionTarget() {
        return ((GroupRetained)this.retained).getAlternateCollisionTarget();
    }

    Node cloneTree(boolean bl, Hashtable hashtable) {
        Group group = (Group)super.cloneTree(bl, hashtable);
        GroupRetained groupRetained = (GroupRetained)this.retained;
        int n = groupRetained.numChildren();
        for (int i = 0; i < n; ++i) {
            Node node = groupRetained.getChild(i);
            Node node2 = node.cloneTree(bl, hashtable);
            ((GroupRetained)group.retained).addChild(node2);
        }
        return group;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        GroupRetained groupRetained = (GroupRetained)node.retained;
        GroupRetained groupRetained2 = (GroupRetained)this.retained;
        groupRetained2.setCollisionBounds(groupRetained.getCollisionBounds());
        groupRetained2.setAlternateCollisionTarget(groupRetained.getAlternateCollisionTarget());
        groupRetained2.children.clear();
    }

    public Node cloneNode(boolean bl) {
        Group group = new Group();
        group.duplicateNode(this, bl);
        return group;
    }
}

