/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.vp;

import com.sun.j3d.utils.behaviors.sensor.SensorBeamEcho;
import com.sun.j3d.utils.behaviors.sensor.SensorButtonListener;
import com.sun.j3d.utils.behaviors.sensor.SensorEvent;
import com.sun.j3d.utils.behaviors.sensor.SensorEventAgent;
import com.sun.j3d.utils.behaviors.sensor.SensorGnomonEcho;
import com.sun.j3d.utils.behaviors.sensor.SensorInputAdaptor;
import com.sun.j3d.utils.behaviors.sensor.SensorReadListener;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.ConfiguredUniverse;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Sensor;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.View;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class WandViewBehavior
extends ViewPlatformBehavior {
    public static final int NONE = 0;
    public static final int GRAB_VIEW = 1;
    public static final int TRANSLATE_FORWARD = 2;
    public static final int TRANSLATE_BACKWARD = 3;
    public static final int ROTATE_CCW = 4;
    public static final int ROTATE_CW = 5;
    public static final int SCALE_UP = 6;
    public static final int SCALE_DOWN = 7;
    public static final int TRANSLATION = 8;
    public static final int SCALE = 9;
    public static final int ROTATION = 10;
    public static final int PER_FRAME = 11;
    public static final int PER_SECOND = 12;
    public static final int VIRTUAL_UNITS = 13;
    public static final int PHYSICAL_METERS = 14;
    public static final int RADIANS = 15;
    public static final int DEGREES = 16;
    public static final int VIEW_PLATFORM = 17;
    public static final int HEAD = 18;
    public static final int SENSOR = 19;
    public static final int VWORLD_FIXED = 20;
    public static final int HOTSPOT = 21;
    public static final int ECHO = 22;
    public static final int GNOMON = 23;
    public static final int BEAM = 24;
    private static final int UNSET = -1;
    private View view = null;
    private SensorEventAgent eventAgent = null;
    private String sensor6DName = null;
    private String sensor2DName = null;
    private Shape3D echoGeometry = null;
    private BranchGroup echoBranchGroup = null;
    private TransformGroup echoTransformGroup = null;
    private SensorReadListener echoReadListener6D = null;
    private boolean echoBranchGroupAttached = false;
    private WakeupCondition wakeupConditions = new WakeupOnElapsedFrames(0);
    private boolean configured = false;
    private Sensor sensor6D = null;
    private Sensor sensor2D = null;
    private int x2D = 3;
    private int y2D = 7;
    private double threshold2D = 0.0;
    private int readAction6D = -1;
    private int readAction2D = -1;
    private ArrayList buttonActions6D = new ArrayList();
    private ArrayList buttonActions2D = new ArrayList();
    private double translationSpeed = 0.1;
    private int translationUnits = 14;
    private int translationTimeBase = 12;
    private double accelerationTime = 1.0;
    private double constantSpeedTime = 8.0;
    private double fastSpeedFactor = 10.0;
    private double rotationSpeed = 180.0;
    private int rotationUnits = 16;
    private int rotationTimeBase = 12;
    private int rotationCoords = 19;
    private double scaleSpeed = 2.0;
    private int scaleTimeBase = 12;
    private int transformCenterSource = 21;
    private Point3d transformCenter = new Point3d(0.0, 0.0, 0.0);
    private int resetViewButtonCount6D = 3;
    private int resetViewButtonCount2D = 0;
    private int echoType = 23;
    private double echoSize = 0.01;
    private Color3f echoColor = null;
    private float echoTransparency = 0.0f;
    private Transform3D nominalSensorRotation = null;

    public WandViewBehavior() {
        this.eventAgent = new SensorEventAgent((Object)this);
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
    }

    public WandViewBehavior(Sensor sensor, Sensor sensor2, int n, double d) {
        this();
        this.sensor6D = sensor;
        this.sensor2D = sensor2;
        this.echoType = n;
        this.echoSize = d;
    }

    public WandViewBehavior(Sensor sensor, Sensor sensor2, TransformGroup transformGroup) {
        this();
        this.sensor6D = sensor;
        this.sensor2D = sensor2;
        if (transformGroup != null) {
            transformGroup.setCapability(18);
            transformGroup.setCapability(12);
            transformGroup.setCapability(13);
            transformGroup.setCapability(14);
        }
        this.echoTransformGroup = transformGroup;
    }

    public WandViewBehavior(Sensor sensor, Sensor sensor2, View view, TransformGroup transformGroup, Transform3D transform3D, TransformGroup transformGroup2) {
        this();
        this.sensor6D = sensor;
        this.sensor2D = sensor2;
        this.view = view;
        this.targetTG = transformGroup;
        this.echoTransformGroup = transformGroup2;
        if (transform3D == null) {
            this.setHomeTransform(new Transform3D());
        } else {
            this.setHomeTransform(transform3D);
        }
    }

    public void initialize() {
        if (!this.configured) {
            this.configureSensorActions();
            if (this.vp != null) {
                if (this.echoTransformGroup == null && this.sensor6D != null && this.readAction6D == 22) {
                    this.configureEcho();
                }
                if (this.echoTransformGroup != null) {
                    this.echoBranchGroup = new BranchGroup();
                    this.echoBranchGroup.setCapability(17);
                    this.echoBranchGroup.setCapability(12);
                    this.echoBranchGroup.setCapability(13);
                    this.echoBranchGroup.addChild((Node)this.echoTransformGroup);
                    this.echoBranchGroup.compile();
                }
                this.attachEcho();
            }
            this.configured = true;
        }
        this.wakeupOn(this.wakeupConditions);
    }

    public void processStimulus(Enumeration enumeration) {
        this.eventAgent.dispatchEvents();
        this.wakeupOn(this.wakeupConditions);
    }

    public void setEnable(boolean bl) {
        if (bl == this.getEnable()) {
            return;
        }
        if (bl) {
            this.attachEcho();
        } else {
            this.detachEcho();
        }
        super.setEnable(bl);
    }

    public void setViewingPlatform(ViewingPlatform viewingPlatform) {
        super.setViewingPlatform(viewingPlatform);
        if (viewingPlatform == null) {
            this.detachEcho();
            return;
        }
        Viewer[] viewerArray = viewingPlatform.getViewers();
        if (viewerArray != null) {
            if (viewerArray.length != 0 && viewerArray[0] != null) {
                this.view = viewerArray[0].getView();
            }
            if (viewerArray.length > 1) {
                throw new RuntimeException("multiple Viewers not supported");
            }
        }
        if (this.view == null) {
            this.view = this.getView();
        }
        if (this.view == null) {
            throw new RuntimeException("a view is not available");
        }
        this.targetTG = viewingPlatform.getMultiTransformGroup().getTransformGroup(0);
        if (this.homeTransform == null) {
            this.setHomeTransform(new Transform3D());
        }
        this.attachEcho();
    }

    private void attachEcho() {
        if (this.vp != null && this.echoBranchGroup != null && !this.echoBranchGroupAttached) {
            this.vp.addChild((Node)this.echoBranchGroup);
            this.echoBranchGroupAttached = true;
        }
    }

    private void detachEcho() {
        if (this.echoBranchGroup != null && this.echoBranchGroupAttached) {
            this.echoBranchGroup.detach();
            this.echoBranchGroupAttached = false;
        }
    }

    protected void configureSensorActions() {
        int n;
        Integer n2;
        SensorButtonListener[] sensorButtonListenerArray;
        int n3;
        int n4;
        Object object;
        SimpleUniverse simpleUniverse = null;
        if (this.vp != null) {
            simpleUniverse = this.vp.getUniverse();
        }
        if (simpleUniverse != null && simpleUniverse instanceof ConfiguredUniverse) {
            object = ((ConfiguredUniverse)simpleUniverse).getNamedSensors();
            if (this.sensor2D == null && this.sensor2DName != null) {
                this.sensor2D = (Sensor)object.get(this.sensor2DName);
                if (this.sensor2D == null) {
                    throw new IllegalArgumentException("\nsensor " + this.sensor2DName + " not found");
                }
            }
            if (this.sensor6D == null && this.sensor6DName != null) {
                this.sensor6D = (Sensor)object.get(this.sensor6DName);
                if (this.sensor6D == null) {
                    throw new IllegalArgumentException("\nsensor " + this.sensor6DName + " not found");
                }
            }
        }
        if (this.sensor6D != null) {
            if (this.readAction6D == -1) {
                this.readAction6D = 22;
            }
            if (this.readAction6D == 22) {
                this.echoReadListener6D = new EchoReadListener6D();
                this.eventAgent.addSensorReadListener(this.sensor6D, this.echoReadListener6D);
            }
            n4 = this.sensor6D.getSensorButtonCount();
            n3 = this.buttonActions6D.size();
            if (n3 > n4) {
                throw new IllegalArgumentException("\nbutton index " + (n3 - 1) + " >= number of buttons (" + n4 + ")");
            }
            if (n4 > 2 && (n3 < 3 || this.buttonActions6D.get(2) == null)) {
                this.setButtonAction6D(2, 3);
            }
            if (n4 > 1 && (n3 < 2 || this.buttonActions6D.get(1) == null)) {
                this.setButtonAction6D(1, 2);
            }
            if (n4 > 0 && (n3 < 1 || this.buttonActions6D.get(0) == null)) {
                this.setButtonAction6D(0, 1);
            }
            if ((n3 = this.buttonActions6D.size()) > 0) {
                sensorButtonListenerArray = new SensorButtonListener[n4];
                for (int i = 0; i < n3; ++i) {
                    n2 = (Integer)this.buttonActions6D.get(i);
                    if (n2 == null) continue;
                    n = n2;
                    if (n == 0) {
                        sensorButtonListenerArray[i] = null;
                        continue;
                    }
                    if (n == 1) {
                        sensorButtonListenerArray[i] = new GrabViewListener6D();
                        continue;
                    }
                    if (n == 2) {
                        sensorButtonListenerArray[i] = new TranslationListener6D(false);
                        continue;
                    }
                    if (n == 3) {
                        sensorButtonListenerArray[i] = new TranslationListener6D(true);
                        continue;
                    }
                    if (n == 4) {
                        sensorButtonListenerArray[i] = new RotationListener6D(false);
                        continue;
                    }
                    if (n == 5) {
                        sensorButtonListenerArray[i] = new RotationListener6D(true);
                        continue;
                    }
                    if (n == 6) {
                        sensorButtonListenerArray[i] = new ScaleListener6D(false);
                        continue;
                    }
                    if (n != 7) continue;
                    sensorButtonListenerArray[i] = new ScaleListener6D(true);
                }
                this.eventAgent.addSensorButtonListeners(this.sensor6D, sensorButtonListenerArray);
            }
            if (this.resetViewButtonCount6D != 0) {
                object = new ResetViewListener(this.sensor6D, this.resetViewButtonCount6D);
                this.eventAgent.addSensorButtonListener(this.sensor6D, (SensorButtonListener)object);
                this.eventAgent.addSensorReadListener(this.sensor6D, (SensorReadListener)object);
            }
        }
        if (this.sensor2D != null) {
            if (this.readAction2D == -1) {
                this.readAction2D = 10;
            }
            if (this.readAction2D == 10) {
                object = new RotationListener2D(this.sensor2D, this.sensor6D);
                this.eventAgent.addSensorReadListener(this.sensor2D, (SensorReadListener)object);
            } else if (this.readAction2D == 8) {
                object = new TranslationListener2D(this.sensor2D, this.sensor6D);
                this.eventAgent.addSensorReadListener(this.sensor2D, (SensorReadListener)object);
            } else if (this.readAction2D == 9) {
                object = new ScaleListener2D(this.sensor2D, this.sensor6D);
                this.eventAgent.addSensorReadListener(this.sensor2D, (SensorReadListener)object);
            }
            n4 = this.sensor2D.getSensorButtonCount();
            n3 = this.buttonActions2D.size();
            if (n3 > n4) {
                throw new IllegalArgumentException("\nbutton index " + (n3 - 1) + " >= number of buttons (" + n4 + ")");
            }
            if (n3 > 0) {
                sensorButtonListenerArray = new SensorButtonListener[n4];
                for (int i = 0; i < n3; ++i) {
                    n2 = (Integer)this.buttonActions2D.get(i);
                    if (n2 == null) continue;
                    n = n2;
                    if (n == 0) {
                        sensorButtonListenerArray[i] = null;
                        continue;
                    }
                    if (n == 10) {
                        sensorButtonListenerArray[i] = new RotationListener2D(this.sensor2D, this.sensor6D);
                        continue;
                    }
                    if (n == 8) {
                        sensorButtonListenerArray[i] = new TranslationListener2D(this.sensor2D, this.sensor6D);
                        continue;
                    }
                    if (n != 9) continue;
                    sensorButtonListenerArray[i] = new ScaleListener2D(this.sensor2D, this.sensor6D);
                }
                this.eventAgent.addSensorButtonListeners(this.sensor2D, sensorButtonListenerArray);
            }
            if (this.resetViewButtonCount2D != 0) {
                ResetViewListener resetViewListener = new ResetViewListener(this.sensor2D, this.resetViewButtonCount2D);
                this.eventAgent.addSensorButtonListener(this.sensor2D, resetViewListener);
                this.eventAgent.addSensorReadListener(this.sensor2D, resetViewListener);
            }
        }
    }

    protected void configureEcho() {
        Transform3D transform3D;
        Point3d point3d = new Point3d();
        this.sensor6D.getHotspot(point3d);
        if (this.echoType == 23) {
            transform3D = new Transform3D();
            if (this.nominalSensorRotation != null) {
                transform3D.set(this.nominalSensorRotation);
                transform3D.invert();
            }
            transform3D.setTranslation(new Vector3d((Tuple3d)point3d));
            this.echoGeometry = new SensorGnomonEcho(transform3D, 0.1 * this.echoSize, 0.5 * this.echoSize, true);
        } else if (this.echoType == 24) {
            this.echoGeometry = new SensorBeamEcho(point3d, this.echoSize, true);
        }
        if (this.echoGeometry != null) {
            Material material;
            transform3D = this.echoGeometry.getAppearance();
            if (this.echoColor != null) {
                material = transform3D.getMaterial();
                material.setDiffuseColor(this.echoColor);
            }
            if (this.echoTransparency != 0.0f) {
                material = transform3D.getTransparencyAttributes();
                material.setTransparencyMode(2);
                material.setTransparency(this.echoTransparency);
                if (this.echoGeometry instanceof SensorGnomonEcho) {
                    material.setDstBlendFunction(1);
                }
            }
            this.echoTransformGroup = new TransformGroup();
            this.echoTransformGroup.setCapability(18);
            this.echoTransformGroup.setCapability(12);
            this.echoTransformGroup.setCapability(13);
            this.echoTransformGroup.setCapability(14);
            this.echoTransformGroup.addChild((Node)this.echoGeometry);
        }
    }

    protected void updateEcho(Sensor sensor, Transform3D transform3D) {
        this.echoTransformGroup.setTransform(transform3D);
    }

    public void Sensor6D(Object[] objectArray) {
        if (objectArray.length != 1) {
            throw new IllegalArgumentException("Sensor6D requires a single name or Sensor instance");
        }
        if (objectArray[0] instanceof String) {
            this.sensor6DName = (String)objectArray[0];
        } else if (objectArray[0] instanceof Sensor) {
            this.sensor6D = (Sensor)objectArray[0];
        } else {
            throw new IllegalArgumentException("Sensor6D must be a name or a Sensor instance");
        }
    }

    public Sensor getSensor6D() {
        return this.sensor6D;
    }

    public void Sensor2D(Object[] objectArray) {
        if (objectArray.length != 1) {
            throw new IllegalArgumentException("Sensor2D requires a single name or Sensor instance");
        }
        if (objectArray[0] instanceof String) {
            this.sensor2DName = (String)objectArray[0];
        } else if (objectArray[0] instanceof Sensor) {
            this.sensor2D = (Sensor)objectArray[0];
        } else {
            throw new IllegalArgumentException("Sensor2D must be a name or a Sensor instance");
        }
    }

    public Sensor getSensor2D() {
        return this.sensor2D;
    }

    public void ButtonAction6D(Object[] objectArray) {
        if (objectArray.length != 2 || !(objectArray[0] instanceof Double) || !(objectArray[1] instanceof String)) {
            throw new IllegalArgumentException("\nButtonAction6D must be a number and a string");
        }
        int n = ((Double)objectArray[0]).intValue();
        String string = (String)objectArray[1];
        if (string.equals("GrabView")) {
            this.setButtonAction6D(n, 1);
        } else if (string.equals("TranslateForward")) {
            this.setButtonAction6D(n, 2);
        } else if (string.equals("TranslateBackward")) {
            this.setButtonAction6D(n, 3);
        } else if (string.equals("RotateCCW")) {
            this.setButtonAction6D(n, 4);
        } else if (string.equals("RotateCW")) {
            this.setButtonAction6D(n, 5);
        } else if (string.equals("ScaleUp")) {
            this.setButtonAction6D(n, 6);
        } else if (string.equals("ScaleDown")) {
            this.setButtonAction6D(n, 7);
        } else if (string.equals("None")) {
            this.setButtonAction6D(n, 0);
        } else {
            throw new IllegalArgumentException("\nButtonAction6D must be GrabView, TranslateForward, TranslateBackward, RotateCCW, RotateCW, ScaleUp, ScaleDown, or None");
        }
    }

    public synchronized void setButtonAction6D(int n, int n2) {
        if (n2 != 2 && n2 != 3 && n2 != 1 && n2 != 4 && n2 != 5 && n2 != 6 && n2 != 7 && n2 != 0) {
            throw new IllegalArgumentException("\naction must be TRANSLATE_FORWARD, TRANSLATE_BACKWARD, GRAB_VIEW, ROTATE_CCW, ROTATE_CW, SCALE_UP, SCALE_DOWN, or NONE");
        }
        while (n >= this.buttonActions6D.size()) {
            this.buttonActions6D.add(null);
        }
        this.buttonActions6D.set(n, new Integer(n2));
    }

    public int getButtonAction6D(int n) {
        if (n >= this.buttonActions6D.size()) {
            return 0;
        }
        Integer n2 = (Integer)this.buttonActions6D.get(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public void ReadAction2D(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof String)) {
            throw new IllegalArgumentException("\nReadAction2D must be a String");
        }
        String string = (String)objectArray[0];
        if (string.equals("Rotation")) {
            this.setReadAction2D(10);
        } else if (string.equals("Translation")) {
            this.setReadAction2D(8);
        } else if (string.equals("Scale")) {
            this.setReadAction2D(9);
        } else if (string.equals("None")) {
            this.setReadAction2D(0);
        } else {
            throw new IllegalArgumentException("\nReadAction2D must be Rotation, Translation, Scale, or None");
        }
    }

    public void setReadAction2D(int n) {
        if (n != 10 && n != 8 && n != 9 && n != 0) {
            throw new IllegalArgumentException("\nReadAction2D must be ROTATION, TRANSLATION, SCALE, or NONE");
        }
        this.readAction2D = n;
    }

    public int getReadAction2D() {
        if (this.readAction2D == -1) {
            return 0;
        }
        return this.readAction2D;
    }

    public void ButtonAction2D(Object[] objectArray) {
        if (objectArray.length != 2 || !(objectArray[0] instanceof Double) || !(objectArray[1] instanceof String)) {
            throw new IllegalArgumentException("\nButtonAction2D must be a number and a string");
        }
        int n = ((Double)objectArray[0]).intValue();
        String string = (String)objectArray[1];
        if (string.equals("Rotation")) {
            this.setButtonAction2D(n, 10);
        } else if (string.equals("Translation")) {
            this.setButtonAction2D(n, 8);
        } else if (string.equals("Scale")) {
            this.setButtonAction2D(n, 9);
        } else if (string.equals("None")) {
            this.setButtonAction2D(n, 0);
        } else {
            throw new IllegalArgumentException("\nButtonAction2D must be Rotation, Translation, Scale or None");
        }
    }

    public synchronized void setButtonAction2D(int n, int n2) {
        if (n2 != 10 && n2 != 8 && n2 != 9 && n2 != 0) {
            throw new IllegalArgumentException("\naction must be ROTATION, TRANSLATION, SCALE, or NONE");
        }
        while (n >= this.buttonActions2D.size()) {
            this.buttonActions2D.add(null);
        }
        this.buttonActions2D.set(n, new Integer(n2));
    }

    public int getButtonAction2D(int n) {
        if (n >= this.buttonActions2D.size()) {
            return 0;
        }
        Integer n2 = (Integer)this.buttonActions2D.get(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public void ReadAction6D(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof String)) {
            throw new IllegalArgumentException("\nReadAction6D must be a String");
        }
        String string = (String)objectArray[0];
        if (string.equals("Echo")) {
            this.setReadAction6D(22);
        } else if (string.equals("None")) {
            this.setReadAction6D(0);
        } else {
            throw new IllegalArgumentException("\nReadAction6D must be Echo or None");
        }
    }

    public void setReadAction6D(int n) {
        if (n != 22 && n != 0) {
            throw new IllegalArgumentException("\naction must be ECHO or NONE");
        }
        this.readAction6D = n;
    }

    public int getReadAction6D() {
        if (this.readAction6D == -1) {
            return 0;
        }
        return this.readAction6D;
    }

    public void TranslationSpeed(Object[] objectArray) {
        int n;
        int n2;
        if (!(objectArray.length == 3 && objectArray[0] instanceof Double && objectArray[1] instanceof String && objectArray[2] instanceof String)) {
            throw new IllegalArgumentException("\nTranslationSpeed must be number, units, and time base");
        }
        double d = (Double)objectArray[0];
        String string = (String)objectArray[1];
        String string2 = (String)objectArray[2];
        if (string.equals("PhysicalMeters")) {
            n2 = 14;
        } else if (string.equals("VirtualUnits")) {
            n2 = 13;
        } else {
            throw new IllegalArgumentException("\nTranslationSpeed units must be PhysicalMeters or VirtualUnits");
        }
        if (string2.equals("PerFrame")) {
            n = 11;
        } else if (string2.equals("PerSecond")) {
            n = 12;
        } else {
            throw new IllegalArgumentException("\ntime base must be PerFrame or PerSecond");
        }
        this.setTranslationSpeed(d, n2, n);
    }

    public void setTranslationSpeed(double d, int n, int n2) {
        this.translationSpeed = d;
        if (n != 14 && n != 13) {
            throw new IllegalArgumentException("\ntranslation speed units must be PHYSICAL_METERS or VIRTUAL_UNITS");
        }
        this.translationUnits = n;
        if (n2 != 11 && n2 != 12) {
            throw new IllegalArgumentException("\ntranslation time base must be PER_FRAME or PER_SECOND");
        }
        this.translationTimeBase = n2;
    }

    public double getTranslationSpeed() {
        return this.translationSpeed;
    }

    public int getTranslationUnits() {
        return this.translationUnits;
    }

    public int getTranslationTimeBase() {
        return this.translationTimeBase;
    }

    public void AccelerationTime(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof Double)) {
            throw new IllegalArgumentException("\nAccelerationTime must be a number");
        }
        this.setAccelerationTime((Double)objectArray[0]);
    }

    public void setAccelerationTime(double d) {
        this.accelerationTime = d;
    }

    public double getAccelerationTime() {
        return this.accelerationTime;
    }

    public void ConstantSpeedTime(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof Double)) {
            throw new IllegalArgumentException("\nConstantSpeedTime must be a number");
        }
        this.setConstantSpeedTime((Double)objectArray[0]);
    }

    public void setConstantSpeedTime(double d) {
        this.constantSpeedTime = d;
    }

    public double getConstantSpeedTime() {
        return this.constantSpeedTime;
    }

    public void FastSpeedFactor(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof Double)) {
            throw new IllegalArgumentException("\nFastSpeedFactor must be a number");
        }
        this.setFastSpeedFactor((Double)objectArray[0]);
    }

    public void setFastSpeedFactor(double d) {
        this.fastSpeedFactor = d;
    }

    public double getFastSpeedFactor() {
        return this.fastSpeedFactor;
    }

    public void Threshold2D(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof Double)) {
            throw new IllegalArgumentException("\nThreshold2D must be a number");
        }
        this.setThreshold2D((Double)objectArray[0]);
    }

    public void setThreshold2D(double d) {
        this.threshold2D = d;
    }

    public double getThreshold2D() {
        return this.threshold2D;
    }

    public void MatrixIndices2D(Object[] objectArray) {
        if (objectArray.length != 2 || !(objectArray[0] instanceof Double) || !(objectArray[1] instanceof Double)) {
            throw new IllegalArgumentException("\nMatrixIndices2D must be a numbers");
        }
        this.setMatrixIndices2D(((Double)objectArray[0]).intValue(), ((Double)objectArray[1]).intValue());
    }

    public void setMatrixIndices2D(int n, int n2) {
        this.x2D = n;
        this.y2D = n2;
    }

    public int getMatrixXIndex2D() {
        return this.x2D;
    }

    public int getMatrixYIndex2D() {
        return this.y2D;
    }

    public void RotationSpeed(Object[] objectArray) {
        int n;
        int n2;
        if (!(objectArray.length == 3 && objectArray[0] instanceof Double && objectArray[1] instanceof String && objectArray[2] instanceof String)) {
            throw new IllegalArgumentException("\nRotationSpeed must be number, units, and time base");
        }
        double d = (Double)objectArray[0];
        String string = (String)objectArray[1];
        String string2 = (String)objectArray[2];
        if (string.equals("Degrees")) {
            n2 = 16;
        } else if (string.equals("Radians")) {
            n2 = 15;
        } else {
            throw new IllegalArgumentException("\nRotationSpeed units must be Degrees or Radians");
        }
        if (string2.equals("PerFrame")) {
            n = 11;
        } else if (string2.equals("PerSecond")) {
            n = 12;
        } else {
            throw new IllegalArgumentException("\nRotationSpeed time base must be PerFrame or PerSecond");
        }
        this.setRotationSpeed(d, n2, n);
    }

    public void setRotationSpeed(double d, int n, int n2) {
        this.rotationSpeed = d;
        if (n != 16 && n != 15) {
            throw new IllegalArgumentException("\nrotation speed units must be DEGREES or RADIANS");
        }
        this.rotationUnits = n;
        if (n2 != 11 && n2 != 12) {
            throw new IllegalArgumentException("\nrotation time base must be PER_FRAME or PER_SECOND");
        }
        this.rotationTimeBase = n2;
    }

    public double getRotationSpeed() {
        return this.rotationSpeed;
    }

    public int getRotationUnits() {
        return this.rotationUnits;
    }

    public int getRotationTimeBase() {
        return this.rotationTimeBase;
    }

    public void RotationCoords(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof String)) {
            throw new IllegalArgumentException("\nRotationCoords must be a String");
        }
        String string = (String)objectArray[0];
        if (string.equals("Sensor")) {
            this.setRotationCoords(19);
        } else if (string.equals("ViewPlatform")) {
            this.setRotationCoords(17);
        } else if (string.equals("Head")) {
            this.setRotationCoords(18);
        } else {
            throw new IllegalArgumentException("\nRotationCoords must be Sensor, ViewPlatform, or Head");
        }
    }

    public void setRotationCoords(int n) {
        if (n != 19 && n != 17 && n != 18) {
            throw new IllegalArgumentException("\nrotation coordinates be SENSOR, VIEW_PLATFORM, or HEAD");
        }
        this.rotationCoords = n;
    }

    public int getRotationCoords() {
        return this.rotationCoords;
    }

    public void ScaleSpeed(Object[] objectArray) {
        int n;
        if (objectArray.length != 2 || !(objectArray[0] instanceof Double) || !(objectArray[1] instanceof String)) {
            throw new IllegalArgumentException("\nScalingSpeed must be a number and a string");
        }
        double d = (Double)objectArray[0];
        String string = (String)objectArray[2];
        if (string.equals("PerFrame")) {
            n = 11;
        } else if (string.equals("PerSecond")) {
            n = 12;
        } else {
            throw new IllegalArgumentException("\nScalingSpeed time base must be PerFrame or PerSecond");
        }
        this.setScaleSpeed(d, n);
    }

    public void setScaleSpeed(double d, int n) {
        this.scaleSpeed = d;
        if (n != 11 && n != 12) {
            throw new IllegalArgumentException("\nscaling time base must be PER_FRAME or PER_SECOND");
        }
        this.scaleTimeBase = n;
    }

    public double getScaleSpeed() {
        return this.scaleSpeed;
    }

    public int getScaleTimeBase() {
        return this.scaleTimeBase;
    }

    public void TransformCenterSource(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof String)) {
            throw new IllegalArgumentException("\nTransformCenterSource must be a String");
        }
        String string = (String)objectArray[0];
        if (string.equals("Hotspot")) {
            this.setTransformCenterSource(21);
        } else if (string.equals("VworldFixed")) {
            this.setTransformCenterSource(20);
        } else {
            throw new IllegalArgumentException("\nTransformCenterSource must be Hotspot or VworldFixed");
        }
    }

    public void setTransformCenterSource(int n) {
        if (n != 21 && n != 20) {
            throw new IllegalArgumentException("\nrotation/scale center source must be HOTSPOT or VWORLD_FIXED");
        }
        this.transformCenterSource = n;
    }

    public int getTransformCenterSource() {
        return this.transformCenterSource;
    }

    public void TransformCenter(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof Point3d)) {
            throw new IllegalArgumentException("\nTransformCenter must be a Point3d");
        }
        this.setTransformCenter((Point3d)objectArray[0]);
    }

    public void setTransformCenter(Point3d point3d) {
        this.transformCenter.set((Tuple3d)point3d);
    }

    public void getTransformCenter(Point3d point3d) {
        point3d.set((Tuple3d)this.transformCenter);
    }

    public void NominalSensorRotation(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof Matrix3d) && !(objectArray[0] instanceof Matrix4d)) {
            throw new IllegalArgumentException("\nNominalSensorRotation must be a Matrix3d or Matrix4d");
        }
        Transform3D transform3D = new Transform3D();
        if (objectArray[0] instanceof Matrix3d) {
            transform3D.set((Matrix3d)objectArray[0]);
        } else {
            transform3D.set((Matrix4d)objectArray[0]);
        }
        this.setNominalSensorRotation(transform3D);
    }

    public void setNominalSensorRotation(Transform3D transform3D) {
        if (transform3D == null) {
            this.nominalSensorRotation = null;
            return;
        }
        if (this.nominalSensorRotation == null) {
            this.nominalSensorRotation = new Transform3D();
        }
        this.nominalSensorRotation.set(transform3D);
        this.nominalSensorRotation.setTranslation(new Vector3d());
    }

    public void getNominalSensorRotation(Transform3D transform3D) {
        transform3D.set(this.nominalSensorRotation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ResetViewButtonCount6D(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof Double) && !(objectArray[0] instanceof String)) {
            throw new IllegalArgumentException("\nResetViewButtonCount6D must be a number or None");
        }
        if (objectArray[0] instanceof String) {
            String string = (String)objectArray[0];
            if (!string.equals("None")) throw new IllegalArgumentException("\nResetViewButtonCount6D string value must be None");
            this.setResetViewButtonCount6D(0);
            return;
        } else {
            this.setResetViewButtonCount6D(((Double)objectArray[0]).intValue());
        }
    }

    public void setResetViewButtonCount6D(int n) {
        if (n != 0 && n <= 1) {
            throw new IllegalArgumentException("reset view button count must be > 1");
        }
        this.resetViewButtonCount6D = n;
    }

    public int getResetViewButtonCount6D() {
        return this.resetViewButtonCount6D;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ResetViewButtonCount2D(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof Double) && !(objectArray[0] instanceof String)) {
            throw new IllegalArgumentException("\nResetViewButtonCount2D must be a number or None");
        }
        if (objectArray[0] instanceof String) {
            String string = (String)objectArray[0];
            if (!string.equals("None")) throw new IllegalArgumentException("\nResetViewButtonCount2D string value must be None");
            this.setResetViewButtonCount2D(0);
            return;
        } else {
            this.setResetViewButtonCount2D(((Double)objectArray[0]).intValue());
        }
    }

    public void setResetViewButtonCount2D(int n) {
        if (n != 0 && n <= 1) {
            throw new IllegalArgumentException("reset view button count must be > 1");
        }
        this.resetViewButtonCount2D = n;
    }

    public int getResetViewButtonCount2D() {
        return this.resetViewButtonCount2D;
    }

    public void EchoType(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof String)) {
            throw new IllegalArgumentException("\nEchoType must be a String");
        }
        String string = (String)objectArray[0];
        if (string.equals("Gnomon")) {
            this.setEchoType(23);
        } else if (string.equals("Beam")) {
            this.setEchoType(24);
        } else if (string.equals("None")) {
            this.setEchoType(0);
        } else {
            throw new IllegalArgumentException("\nEchoType must be Gnomon, Beam, or None");
        }
    }

    public void setEchoType(int n) {
        this.echoType = n;
    }

    public int getEchoType() {
        return this.echoType;
    }

    public void EchoSize(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof Double)) {
            throw new IllegalArgumentException("\nEchoSize must be a Double");
        }
        this.setEchoSize((Double)objectArray[0]);
    }

    public void setEchoSize(double d) {
        this.echoSize = d;
    }

    public double getEchoSize() {
        return this.echoSize;
    }

    public void EchoColor(Object[] objectArray) {
        if (!(objectArray.length == 3 && objectArray[0] instanceof Double && objectArray[1] instanceof Double && objectArray[2] instanceof Double)) {
            throw new IllegalArgumentException("\nEchoColor must be 3 numbers for red, green, and blue");
        }
        this.setEchoColor(new Color3f(((Double)objectArray[0]).floatValue(), ((Double)objectArray[1]).floatValue(), ((Double)objectArray[2]).floatValue()));
    }

    public void setEchoColor(Color3f color3f) {
        if (this.echoColor == null) {
            this.echoColor = new Color3f(color3f);
        } else {
            this.echoColor.set((Tuple3f)color3f);
        }
        if (this.echoGeometry != null) {
            Appearance appearance = this.echoGeometry.getAppearance();
            Material material = appearance.getMaterial();
            material.setDiffuseColor(this.echoColor);
        }
    }

    public void getEchoColor(Color3f color3f) {
        if (this.echoColor == null) {
            color3f.set(1.0f, 1.0f, 1.0f);
        } else {
            color3f.set((Tuple3f)this.echoColor);
        }
    }

    public void EchoTransparency(Object[] objectArray) {
        if (objectArray.length != 1 || !(objectArray[0] instanceof Double)) {
            throw new IllegalArgumentException("\nEchoTransparency must be a number");
        }
        this.setEchoTransparency(((Double)objectArray[0]).floatValue());
    }

    public void setEchoTransparency(float f) {
        this.echoTransparency = f;
        if (this.echoGeometry != null) {
            Appearance appearance = this.echoGeometry.getAppearance();
            TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
            if (this.echoTransparency == 0.0f) {
                transparencyAttributes.setTransparencyMode(4);
                transparencyAttributes.setTransparency(0.0f);
            } else {
                transparencyAttributes.setTransparencyMode(2);
                transparencyAttributes.setTransparency(this.echoTransparency);
                if (this.echoGeometry instanceof SensorGnomonEcho) {
                    transparencyAttributes.setDstBlendFunction(1);
                }
            }
        }
    }

    public float getEchoTransparency() {
        return this.echoTransparency;
    }

    public void setEchoTransformGroup(TransformGroup transformGroup) {
        transformGroup.setCapability(18);
        transformGroup.setCapability(12);
        transformGroup.setCapability(13);
        transformGroup.setCapability(14);
        this.echoTransformGroup = transformGroup;
    }

    public TransformGroup getEchoTransformGroup() {
        return this.echoTransformGroup;
    }

    public Shape3D getEchoGeometry() {
        return this.echoGeometry;
    }

    public SensorEventAgent getSensorEventAgent() {
        return this.eventAgent;
    }

    public class ResetViewListener
    extends SensorInputAdaptor {
        private int resetCount;
        private int[] buttonState = null;
        private boolean goHomeNextRead = false;

        public ResetViewListener(Sensor sensor, int n) {
            this.resetCount = n;
            this.buttonState = new int[sensor.getSensorButtonCount()];
        }

        public void pressed(SensorEvent sensorEvent) {
            int n = 0;
            sensorEvent.getButtonState(this.buttonState);
            for (int i = 0; i < this.buttonState.length; ++i) {
                if (this.buttonState[i] != 1) continue;
                ++n;
            }
            if (n >= this.resetCount) {
                this.goHomeNextRead = true;
            }
        }

        public void read(SensorEvent sensorEvent) {
            if (this.goHomeNextRead) {
                WandViewBehavior.this.goHome();
                this.goHomeNextRead = false;
            }
        }
    }

    public class ScaleListener2D
    extends ListenerBase {
        private Sensor sensor2D;
        private Sensor sensor6D;
        private double[] m;
        private Point3d center;
        private Transform3D t3d;
        private Transform3D sensor2DRead;

        protected void initAction(Sensor sensor) {
            super.initAction(sensor);
            if (sensor != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.removeSensorReadListener(sensor, WandViewBehavior.this.echoReadListener6D);
            }
        }

        protected void endAction(Sensor sensor) {
            super.endAction(sensor);
            this.conditionViewScale(this.viewPlatformToVworld);
            if (sensor != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.addSensorReadListener(sensor, WandViewBehavior.this.echoReadListener6D);
            }
        }

        public ScaleListener2D(Sensor sensor, Sensor sensor2) {
            this.m = new double[16];
            this.center = new Point3d();
            this.t3d = new Transform3D();
            this.sensor2DRead = new Transform3D();
            this.sensor2D = sensor;
            this.sensor6D = sensor2;
        }

        public void read(SensorEvent sensorEvent) {
            this.sensor2D.getRead(this.sensor2DRead);
            this.sensor2DRead.get(this.m);
            if (this.m[WandViewBehavior.this.y2D] > WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.y2D] < -WandViewBehavior.this.threshold2D) {
                if (!this.isActive()) {
                    this.initAction(this.sensor6D);
                }
                if (this.sensor6D != null) {
                    this.sensor6D.getRead(this.sensorToTracker);
                    this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
                }
                if (this.sensor6D != null && WandViewBehavior.this.transformCenterSource == 21) {
                    this.sensor6D.getHotspot(this.center);
                    this.sensorToVworld.transform(this.center);
                } else {
                    this.center.set((Tuple3d)WandViewBehavior.this.transformCenter);
                }
                double d = 1.0;
                if (WandViewBehavior.this.scaleTimeBase == 12) {
                    d = (double)(sensorEvent.getTime() - sensorEvent.getLastTime()) / 1.0E9;
                }
                double d2 = Math.pow(WandViewBehavior.this.scaleSpeed, -this.m[WandViewBehavior.this.y2D] * d);
                this.t3d.set(d2);
                this.transformAboutCenter(this.viewPlatformToVworld, this.center, this.t3d);
                try {
                    WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
                }
                catch (BadTransformException badTransformException) {
                    this.conditionViewScale(this.viewPlatformToVworld);
                }
                if (this.sensor6D != null) {
                    this.transformAboutCenter(this.trackerToVworld, this.center, this.t3d);
                }
                if (this.sensor6D != null && WandViewBehavior.this.readAction6D == 22) {
                    this.transformAboutCenter(this.sensorToVworld, this.center, this.t3d);
                    WandViewBehavior.this.updateEcho(this.sensor6D, this.sensorToVworld);
                }
            } else if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        public void pressed(SensorEvent sensorEvent) {
            this.initAction(this.sensor6D);
        }

        public void released(SensorEvent sensorEvent) {
            if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        public void dragged(SensorEvent sensorEvent) {
            this.read(sensorEvent);
        }
    }

    public class TranslationListener2D
    extends ListenerBase {
        private Sensor sensor2D;
        private Sensor sensor6D;
        private double[] m;
        private Vector3d v3d;
        private Transform3D sensor2DRead;
        private double speedScaled;

        protected void initAction(Sensor sensor) {
            super.initAction(sensor);
            if (sensor != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.removeSensorReadListener(sensor, WandViewBehavior.this.echoReadListener6D);
            }
        }

        protected void endAction(Sensor sensor) {
            super.endAction(sensor);
            if (sensor != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.addSensorReadListener(sensor, WandViewBehavior.this.echoReadListener6D);
            }
        }

        public TranslationListener2D(Sensor sensor, Sensor sensor2) {
            this.m = new double[16];
            this.v3d = new Vector3d();
            this.sensor2DRead = new Transform3D();
            this.sensor2D = sensor;
            this.sensor6D = sensor2;
            this.speedScaled = WandViewBehavior.this.translationUnits == 13 ? WandViewBehavior.this.translationSpeed * WandViewBehavior.this.fastSpeedFactor / this.getPhysicalToVirtualScale() : WandViewBehavior.this.translationSpeed * WandViewBehavior.this.fastSpeedFactor;
            if (sensor2 == null) {
                this.speedScaled *= this.getPhysicalToViewPlatformScale();
            }
        }

        public void read(SensorEvent sensorEvent) {
            this.sensor2D.getRead(this.sensor2DRead);
            this.sensor2DRead.get(this.m);
            if (this.m[WandViewBehavior.this.x2D] > WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.x2D] < -WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.y2D] > WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.y2D] < -WandViewBehavior.this.threshold2D) {
                if (!this.isActive()) {
                    this.initAction(this.sensor6D);
                }
                double d = Math.sqrt(this.m[WandViewBehavior.this.x2D] * this.m[WandViewBehavior.this.x2D] + this.m[WandViewBehavior.this.y2D] * this.m[WandViewBehavior.this.y2D]);
                double d2 = 1.0 / d;
                this.v3d.set(this.m[WandViewBehavior.this.x2D] * d2, 0.0, -this.m[WandViewBehavior.this.y2D] * d2);
                if (this.sensor6D != null) {
                    if (WandViewBehavior.this.nominalSensorRotation != null) {
                        WandViewBehavior.this.nominalSensorRotation.transform(this.v3d);
                    }
                    this.sensor6D.getRead(this.sensorToTracker);
                    this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
                    this.sensorToVworld.transform(this.v3d);
                } else {
                    this.viewPlatformToVworld.transform(this.v3d);
                }
                double d3 = 1.0;
                if (WandViewBehavior.this.translationTimeBase == 12) {
                    d3 = (double)(sensorEvent.getTime() - sensorEvent.getLastTime()) / 1.0E9;
                }
                this.v3d.scale(d3 * this.speedScaled * d);
                this.translateTransform(this.viewPlatformToVworld, this.v3d);
                WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
                if (this.sensor6D != null) {
                    this.translateTransform(this.trackerToVworld, this.v3d);
                }
                if (this.sensor6D != null && WandViewBehavior.this.readAction6D == 22) {
                    this.translateTransform(this.sensorToVworld, this.v3d);
                    WandViewBehavior.this.updateEcho(this.sensor6D, this.sensorToVworld);
                }
            } else if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        public void pressed(SensorEvent sensorEvent) {
            this.initAction(this.sensor6D);
        }

        public void released(SensorEvent sensorEvent) {
            if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        public void dragged(SensorEvent sensorEvent) {
            this.read(sensorEvent);
        }
    }

    public class RotationListener2D
    extends ListenerBase {
        private Sensor sensor2D;
        private Sensor sensor6D;
        private double[] m;
        private Vector3d axis;
        private Point3d center;
        private Transform3D t3d;
        private AxisAngle4d aa4d;
        private Transform3D sensor2DRead;
        private Transform3D headToVworld;
        private double speedScaled;

        protected void initAction(Sensor sensor) {
            super.initAction(sensor);
            if (WandViewBehavior.this.rotationCoords == 18) {
                WandViewBehavior.this.view.setUserHeadToVworldEnable(true);
            }
            if (sensor != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.removeSensorReadListener(sensor, WandViewBehavior.this.echoReadListener6D);
            }
        }

        protected void endAction(Sensor sensor) {
            super.endAction(sensor);
            this.viewPlatformToVworld.normalize();
            WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
            if (WandViewBehavior.this.rotationCoords == 18) {
                WandViewBehavior.this.view.setUserHeadToVworldEnable(false);
            }
            if (sensor != null && WandViewBehavior.this.readAction6D == 22) {
                WandViewBehavior.this.eventAgent.addSensorReadListener(sensor, WandViewBehavior.this.echoReadListener6D);
            }
        }

        public RotationListener2D(Sensor sensor, Sensor sensor2) {
            this.m = new double[16];
            this.axis = new Vector3d();
            this.center = new Point3d();
            this.t3d = new Transform3D();
            this.aa4d = new AxisAngle4d();
            this.sensor2DRead = new Transform3D();
            this.headToVworld = new Transform3D();
            this.sensor2D = sensor;
            this.sensor6D = sensor2;
            this.speedScaled = WandViewBehavior.this.rotationUnits == 16 ? WandViewBehavior.this.rotationSpeed * Math.PI / 180.0 : WandViewBehavior.this.rotationSpeed;
        }

        public void read(SensorEvent sensorEvent) {
            this.sensor2D.getRead(this.sensor2DRead);
            this.sensor2DRead.get(this.m);
            if (this.m[WandViewBehavior.this.x2D] > WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.x2D] < -WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.y2D] > WandViewBehavior.this.threshold2D || this.m[WandViewBehavior.this.y2D] < -WandViewBehavior.this.threshold2D) {
                if (!this.isActive()) {
                    this.initAction(this.sensor6D);
                }
                double d = Math.sqrt(this.m[WandViewBehavior.this.x2D] * this.m[WandViewBehavior.this.x2D] + this.m[WandViewBehavior.this.y2D] * this.m[WandViewBehavior.this.y2D]);
                double d2 = 1.0 / d;
                this.axis.set(this.m[WandViewBehavior.this.y2D] * d2, -this.m[WandViewBehavior.this.x2D] * d2, 0.0);
                if (this.sensor6D != null) {
                    this.sensor6D.getRead(this.sensorToTracker);
                    this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
                }
                if (this.sensor6D != null && WandViewBehavior.this.rotationCoords == 19) {
                    if (WandViewBehavior.this.nominalSensorRotation != null) {
                        WandViewBehavior.this.nominalSensorRotation.transform(this.axis);
                    }
                    this.sensorToVworld.transform(this.axis);
                } else if (WandViewBehavior.this.rotationCoords == 18) {
                    WandViewBehavior.this.view.getUserHeadToVworld(this.headToVworld);
                    this.headToVworld.transform(this.axis);
                } else {
                    this.viewPlatformToVworld.transform(this.axis);
                }
                if (WandViewBehavior.this.transformCenterSource == 21 && this.sensor6D != null) {
                    this.sensor6D.getHotspot(this.center);
                    this.sensorToVworld.transform(this.center);
                } else {
                    this.center.set((Tuple3d)WandViewBehavior.this.transformCenter);
                }
                double d3 = 1.0;
                if (WandViewBehavior.this.rotationTimeBase == 12) {
                    d3 = (double)(sensorEvent.getTime() - sensorEvent.getLastTime()) / 1.0E9;
                }
                this.aa4d.set(this.axis, this.speedScaled * d3 * d);
                this.t3d.set(this.aa4d);
                this.transformAboutCenter(this.viewPlatformToVworld, this.center, this.t3d);
                WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
                if (this.sensor6D != null) {
                    this.transformAboutCenter(this.trackerToVworld, this.center, this.t3d);
                }
                if (this.sensor6D != null && WandViewBehavior.this.readAction6D == 22) {
                    this.transformAboutCenter(this.sensorToVworld, this.center, this.t3d);
                    WandViewBehavior.this.updateEcho(this.sensor6D, this.sensorToVworld);
                }
            } else if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        public void pressed(SensorEvent sensorEvent) {
            this.initAction(this.sensor6D);
        }

        public void released(SensorEvent sensorEvent) {
            if (this.isActive()) {
                this.endAction(this.sensor6D);
            }
        }

        public void dragged(SensorEvent sensorEvent) {
            this.read(sensorEvent);
        }
    }

    public class EchoReadListener6D
    implements SensorReadListener {
        private Transform3D sensorToVworld = new Transform3D();

        public void read(SensorEvent sensorEvent) {
            Sensor sensor = sensorEvent.getSensor();
            WandViewBehavior.this.view.getSensorToVworld(sensor, this.sensorToVworld);
            WandViewBehavior.this.updateEcho(sensor, this.sensorToVworld);
        }
    }

    public class ScaleListener6D
    extends ListenerBase {
        private double direction;
        private long buttonDownTime;
        private Point3d center;
        private Transform3D t3d;

        protected void endAction(Sensor sensor) {
            super.endAction(sensor);
            this.conditionViewScale(this.viewPlatformToVworld);
        }

        public ScaleListener6D(boolean bl) {
            this.center = new Point3d();
            this.t3d = new Transform3D();
            this.direction = bl ? -1.0 : 1.0;
        }

        public void pressed(SensorEvent sensorEvent) {
            this.initAction(sensorEvent.getSensor());
            this.buttonDownTime = sensorEvent.getTime();
        }

        public void dragged(SensorEvent sensorEvent) {
            double d;
            long l = sensorEvent.getTime();
            long l2 = sensorEvent.getLastTime();
            double d2 = 1.0;
            if (WandViewBehavior.this.scaleTimeBase == 12) {
                d2 = (double)(l - l2) / 1.0E9;
            }
            double d3 = (d = (double)(l - this.buttonDownTime) / 1.0E9) <= WandViewBehavior.this.accelerationTime ? d / WandViewBehavior.this.accelerationTime * d2 * this.direction : d2 * this.direction;
            double d4 = Math.pow(WandViewBehavior.this.scaleSpeed, d3);
            Sensor sensor = sensorEvent.getSensor();
            sensor.getRead(this.sensorToTracker);
            this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
            if (WandViewBehavior.this.transformCenterSource == 21) {
                sensor.getHotspot(this.center);
                this.sensorToVworld.transform(this.center);
            } else {
                this.center.set((Tuple3d)WandViewBehavior.this.transformCenter);
            }
            this.t3d.set(d4);
            this.transformAboutCenter(this.viewPlatformToVworld, this.center, this.t3d);
            try {
                WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
            }
            catch (BadTransformException badTransformException) {
                this.conditionViewScale(this.viewPlatformToVworld);
            }
            this.transformAboutCenter(this.trackerToVworld, this.center, this.t3d);
            if (WandViewBehavior.this.readAction6D == 22) {
                this.transformAboutCenter(this.sensorToVworld, this.center, this.t3d);
                WandViewBehavior.this.updateEcho(sensor, this.sensorToVworld);
            }
        }
    }

    public class RotationListener6D
    extends ListenerBase {
        private boolean reverse;
        private long buttonDownTime;
        private Vector3d axis;
        private Point3d center;
        private Transform3D t3d;
        private AxisAngle4d aa4d;
        private Transform3D headToVworld;
        private double speedScaled;

        protected void initAction(Sensor sensor) {
            super.initAction(sensor);
            if (WandViewBehavior.this.rotationCoords == 18) {
                WandViewBehavior.this.view.setUserHeadToVworldEnable(true);
            }
        }

        protected void endAction(Sensor sensor) {
            super.endAction(sensor);
            this.viewPlatformToVworld.normalize();
            WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
            if (WandViewBehavior.this.rotationCoords == 18) {
                WandViewBehavior.this.view.setUserHeadToVworldEnable(false);
            }
        }

        public RotationListener6D(boolean bl) {
            this.axis = new Vector3d();
            this.center = new Point3d();
            this.t3d = new Transform3D();
            this.aa4d = new AxisAngle4d();
            this.headToVworld = new Transform3D();
            this.reverse = bl;
            this.speedScaled = WandViewBehavior.this.rotationUnits == 16 ? WandViewBehavior.this.rotationSpeed * Math.PI / 180.0 : WandViewBehavior.this.rotationSpeed;
        }

        public void pressed(SensorEvent sensorEvent) {
            this.initAction(sensorEvent.getSensor());
            this.buttonDownTime = sensorEvent.getTime();
        }

        public void dragged(SensorEvent sensorEvent) {
            double d;
            long l = sensorEvent.getTime();
            long l2 = sensorEvent.getLastTime();
            double d2 = 1.0;
            if (WandViewBehavior.this.rotationTimeBase == 12) {
                d2 = (double)(l - l2) / 1.0E9;
            }
            double d3 = (d = (double)(l - this.buttonDownTime) / 1.0E9) <= WandViewBehavior.this.accelerationTime ? d / WandViewBehavior.this.accelerationTime * this.speedScaled : this.speedScaled;
            if (this.reverse) {
                this.axis.set(0.0, -1.0, 0.0);
            } else {
                this.axis.set(0.0, 1.0, 0.0);
            }
            Sensor sensor = sensorEvent.getSensor();
            sensor.getRead(this.sensorToTracker);
            this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
            if (WandViewBehavior.this.rotationCoords == 19) {
                if (WandViewBehavior.this.nominalSensorRotation != null) {
                    WandViewBehavior.this.nominalSensorRotation.transform(this.axis);
                }
                this.sensorToVworld.transform(this.axis);
            } else if (WandViewBehavior.this.rotationCoords == 18) {
                WandViewBehavior.this.view.getUserHeadToVworld(this.headToVworld);
                this.headToVworld.transform(this.axis);
            } else {
                this.viewPlatformToVworld.transform(this.axis);
            }
            if (WandViewBehavior.this.transformCenterSource == 21) {
                sensor.getHotspot(this.center);
                this.sensorToVworld.transform(this.center);
            } else {
                this.center.set((Tuple3d)WandViewBehavior.this.transformCenter);
            }
            this.aa4d.set(this.axis, d3 * d2);
            this.t3d.set(this.aa4d);
            this.transformAboutCenter(this.viewPlatformToVworld, this.center, this.t3d);
            WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
            this.transformAboutCenter(this.trackerToVworld, this.center, this.t3d);
            if (WandViewBehavior.this.readAction6D == 22) {
                this.transformAboutCenter(this.sensorToVworld, this.center, this.t3d);
                WandViewBehavior.this.updateEcho(sensor, this.sensorToVworld);
            }
        }
    }

    public class TranslationListener6D
    extends ListenerBase {
        private long buttonDownTime;
        private double speedScaled;
        private double interval0;
        private double interval1;
        private double interval2;
        private Vector3d v3d;

        public TranslationListener6D(boolean bl) {
            this.v3d = new Vector3d();
            this.interval0 = WandViewBehavior.this.accelerationTime;
            this.interval1 = this.interval0 + WandViewBehavior.this.constantSpeedTime;
            this.interval2 = this.interval1 + WandViewBehavior.this.accelerationTime;
            this.speedScaled = WandViewBehavior.this.translationUnits == 13 ? WandViewBehavior.this.translationSpeed / this.getPhysicalToVirtualScale() : WandViewBehavior.this.translationSpeed;
            if (bl) {
                this.speedScaled = -this.speedScaled;
            }
        }

        public void pressed(SensorEvent sensorEvent) {
            this.initAction(sensorEvent.getSensor());
            this.buttonDownTime = sensorEvent.getTime();
        }

        public void dragged(SensorEvent sensorEvent) {
            double d;
            long l = sensorEvent.getTime();
            long l2 = sensorEvent.getLastTime();
            double d2 = 1.0;
            if (WandViewBehavior.this.translationTimeBase == 12) {
                d2 = (double)(l - l2) / 1.0E9;
            }
            double d3 = (d = (double)(l - this.buttonDownTime) / 1.0E9) <= this.interval0 ? d / WandViewBehavior.this.accelerationTime * this.speedScaled : (d > this.interval1 && d < this.interval2 ? ((d - this.interval1) / WandViewBehavior.this.accelerationTime * (WandViewBehavior.this.fastSpeedFactor - 1.0) + 1.0) * this.speedScaled : (d >= this.interval2 ? WandViewBehavior.this.fastSpeedFactor * this.speedScaled : this.speedScaled));
            this.v3d.set(0.0, 0.0, -1.0);
            if (WandViewBehavior.this.nominalSensorRotation != null) {
                WandViewBehavior.this.nominalSensorRotation.transform(this.v3d);
            }
            Sensor sensor = sensorEvent.getSensor();
            sensor.getRead(this.sensorToTracker);
            this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
            this.sensorToVworld.transform(this.v3d);
            this.v3d.scale(d2 * d3);
            this.translateTransform(this.viewPlatformToVworld, this.v3d);
            WandViewBehavior.this.targetTG.setTransform(this.viewPlatformToVworld);
            this.translateTransform(this.trackerToVworld, this.v3d);
            if (WandViewBehavior.this.readAction6D == 22) {
                this.translateTransform(this.sensorToVworld, this.v3d);
                WandViewBehavior.this.updateEcho(sensor, this.sensorToVworld);
            }
        }
    }

    public class GrabViewListener6D
    extends ListenerBase {
        private Transform3D t3d;
        private Transform3D initialVworldToSensor;

        public GrabViewListener6D() {
            this.t3d = new Transform3D();
            this.initialVworldToSensor = new Transform3D();
        }

        public void pressed(SensorEvent sensorEvent) {
            this.initAction(sensorEvent.getSensor());
            this.initialVworldToSensor.invert(this.sensorToVworld);
        }

        public void dragged(SensorEvent sensorEvent) {
            Sensor sensor = sensorEvent.getSensor();
            sensor.getRead(this.sensorToTracker);
            this.sensorToVworld.mul(this.trackerToVworld, this.sensorToTracker);
            this.t3d.mul(this.sensorToVworld, this.initialVworldToSensor);
            this.t3d.invert();
            this.t3d.mul(this.viewPlatformToVworld);
            WandViewBehavior.this.targetTG.setTransform(this.t3d);
        }
    }

    public class ListenerBase
    extends SensorInputAdaptor {
        protected Transform3D viewPlatformToVworld = new Transform3D();
        protected Transform3D trackerToVworld = new Transform3D();
        protected Transform3D sensorToVworld = new Transform3D();
        protected Transform3D sensorToTracker = new Transform3D();
        private Transform3D trackerToSensor = new Transform3D();
        private boolean active = false;
        private double[] s3Tmp = new double[3];
        private double[] m16Tmp = new double[16];
        private Vector3d v3dTmp = new Vector3d();
        private Transform3D t3dTmp = new Transform3D();

        protected void initAction(Sensor sensor) {
            WandViewBehavior.this.targetTG.getTransform(this.viewPlatformToVworld);
            this.active = true;
            if (sensor == null) {
                return;
            }
            sensor.getRead(this.sensorToTracker);
            WandViewBehavior.this.view.getSensorToVworld(sensor, this.sensorToVworld);
            this.trackerToSensor.invert(this.sensorToTracker);
            this.trackerToVworld.mul(this.sensorToVworld, this.trackerToSensor);
        }

        protected void endAction(Sensor sensor) {
            this.active = false;
        }

        protected boolean isActive() {
            return this.active;
        }

        public void pressed(SensorEvent sensorEvent) {
            this.initAction(sensorEvent.getSensor());
        }

        public void released(SensorEvent sensorEvent) {
            this.endAction(sensorEvent.getSensor());
        }

        protected double getPhysicalToVirtualScale() {
            WandViewBehavior.this.view.getCanvas3D(0).getImagePlateToVworld(this.t3dTmp);
            this.t3dTmp.get(this.m16Tmp);
            return Math.sqrt(this.m16Tmp[0] * this.m16Tmp[0] + this.m16Tmp[1] * this.m16Tmp[1] + this.m16Tmp[2] * this.m16Tmp[2]);
        }

        protected double getPhysicalToViewPlatformScale() {
            WandViewBehavior.this.targetTG.getTransform(this.t3dTmp);
            this.t3dTmp.get(this.m16Tmp);
            double d = Math.sqrt(this.m16Tmp[0] * this.m16Tmp[0] + this.m16Tmp[1] * this.m16Tmp[1] + this.m16Tmp[2] * this.m16Tmp[2]);
            return this.getPhysicalToVirtualScale() / d;
        }

        protected void translateTransform(Transform3D transform3D, Vector3d vector3d) {
            transform3D.get(this.v3dTmp);
            this.v3dTmp.add((Tuple3d)vector3d);
            transform3D.setTranslation(this.v3dTmp);
        }

        protected void transformAboutCenter(Transform3D transform3D, Point3d point3d, Transform3D transform3D2) {
            transform3D.get(this.v3dTmp);
            this.v3dTmp.sub((Tuple3d)point3d);
            transform3D.setTranslation(this.v3dTmp);
            transform3D.mul(transform3D2, transform3D);
            transform3D.get(this.v3dTmp);
            this.v3dTmp.add((Tuple3d)point3d);
            transform3D.setTranslation(this.v3dTmp);
        }

        protected void conditionViewScale(Transform3D transform3D) {
            transform3D.normalize();
            transform3D.get(this.m16Tmp);
            this.s3Tmp[0] = this.m16Tmp[0] * this.m16Tmp[0] + this.m16Tmp[4] * this.m16Tmp[4] + this.m16Tmp[8] * this.m16Tmp[8];
            this.s3Tmp[1] = this.m16Tmp[1] * this.m16Tmp[1] + this.m16Tmp[5] * this.m16Tmp[5] + this.m16Tmp[9] * this.m16Tmp[9];
            this.s3Tmp[2] = this.m16Tmp[2] * this.m16Tmp[2] + this.m16Tmp[6] * this.m16Tmp[6] + this.m16Tmp[10] * this.m16Tmp[10];
            if (this.s3Tmp[0] == this.s3Tmp[1] && this.s3Tmp[0] == this.s3Tmp[2]) {
                return;
            }
            this.s3Tmp[0] = Math.sqrt(this.s3Tmp[0]);
            this.s3Tmp[1] = Math.sqrt(this.s3Tmp[1]);
            this.s3Tmp[2] = Math.sqrt(this.s3Tmp[2]);
            int n = 0;
            if (Math.abs(this.s3Tmp[1] - 1.0) < Math.abs(this.s3Tmp[0] - 1.0)) {
                n = 1;
            }
            if (Math.abs(this.s3Tmp[2] - 1.0) < Math.abs(this.s3Tmp[n] - 1.0)) {
                n = 2;
            }
            for (int i = 0; i < 3; ++i) {
                if (i == n) continue;
                double d = this.s3Tmp[n] / this.s3Tmp[i];
                int n2 = i + 0;
                this.m16Tmp[n2] = this.m16Tmp[n2] * d;
                int n3 = i + 4;
                this.m16Tmp[n3] = this.m16Tmp[n3] * d;
                int n4 = i + 8;
                this.m16Tmp[n4] = this.m16Tmp[n4] * d;
            }
            transform3D.set(this.m16Tmp);
            if ((transform3D.getType() & 0x40) == 0) {
                WandViewBehavior.this.goHome();
            } else {
                WandViewBehavior.this.targetTG.setTransform(transform3D);
            }
        }
    }
}

