/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.Background;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.DetailTextureImage;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.Fog;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dThread;
import javax.media.j3d.Light;
import javax.media.j3d.MasterControl;
import javax.media.j3d.ModelClip;
import javax.media.j3d.NativeConfigTemplate3D;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Raster;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RendererStructure;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Sound;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class Renderer
extends J3dThread {
    int objectId = -1;
    static final int WAIT = 0;
    static final int NOTIFY_AND_WAIT = 1;
    static final int NOTIFY = 2;
    static final int DECAL_NONE = 0;
    static final int DECAL_1ST_CHILD = 1;
    static final int DECAL_NTH_CHILD = 2;
    static final int NUM_ACCUMULATION_SAMPLES = 8;
    static final float[] ACCUM_SAMPLES_X = new float[]{-0.54818f, 0.56438f, 0.39462f, -0.54498f, -0.8379f, -0.39263f, 0.32254f, 0.84216f};
    static final float[] ACCUM_SAMPLES_Y = new float[]{0.55331f, -0.53495f, 0.4154f, -0.52829f, 0.82102f, -0.27383f, 0.09133f, -0.84399f};
    static final float accumValue = 0.125f;
    static final int RENDER = 0;
    static final int SWAP = 1;
    static final int REQUESTRENDER = 2;
    static final int REQUESTCLEANUP = 3;
    RendererStructure rendererStructure = new RendererStructure();
    Transform3D bgVworldToVpc = new Transform3D();
    long lasttime;
    long currtime;
    float numframes = 0.0f;
    static final boolean doTiming = false;
    private static int numInstances = 0;
    private int instanceNum = -1;
    boolean sharedStereoZBuffer;
    long sharedCtx = 0L;
    long sharedCtxTimeStamp = 0L;
    long display;
    int window;
    long currentCtx = -1L;
    int rendererBit = 0;
    ArrayList dirtyRenderMoleculeList = new ArrayList();
    ArrayList dirtyRenderAtomList = new ArrayList();
    ArrayList dirtyDlistPerRinfoList = new ArrayList();
    ArrayList textureIdResourceFreeList = new ArrayList();
    ArrayList displayListResourceFreeList = new ArrayList();
    ArrayList textureReloadList = new ArrayList();
    CanvasViewCache copyOfCvCache = new CanvasViewCache(null, null, null);
    J3dMessage[] renderMessage;
    Screen3D onScreen;
    Screen3D offScreen;
    double[] accumLeftProjMat = new double[16];
    double[] accumRightProjMat = new double[16];
    double[] accumInfLeftProjMat = new double[16];
    double[] accumInfRightProjMat = new double[16];
    J3dMessage[] m;
    int nmesg = 0;
    ArrayList listOfCtxs = new ArrayList();
    ArrayList listOfCanvases = new ArrayList();
    boolean needToRebuildDisplayList = false;
    boolean needToResendTextureDown = false;
    boolean dirtyDisplayList = false;
    ArrayList textureIDResourceTable = new ArrayList(5);

    native void D3DCleanUp();

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    Renderer(ThreadGroup threadGroup) {
        super(threadGroup);
        this.setName("J3D-Renderer-" + this.getInstanceNum());
        this.type = 16;
        this.rendererBit = VirtualUniverse.mc.getRendererBit();
        this.renderMessage = new J3dMessage[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork(long l) {
        block200: {
            RenderBin renderBin = null;
            Canvas3D canvas3D = null;
            View view = null;
            int n = 1;
            boolean bl = false;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 1.0;
            double d4 = 1.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            boolean bl2 = false;
            Transform3D transform3D = null;
            int n2 = (Integer)this.args[0];
            try {
                if (n2 == 1) {
                    Object[] objectArray = (Object[])this.args[2];
                    view = (View)this.args[3];
                    for (int i = 0; i < objectArray.length; ++i) {
                        Canvas3D canvas3D2 = (Canvas3D)objectArray[i];
                        if (!canvas3D2.isRunning) continue;
                        try {
                            if (!canvas3D2.validCanvas || !canvas3D2.active || canvas3D2.ctx == 0L || canvas3D2.view == null || !canvas3D2.imageReady) continue;
                            if (canvas3D2.useDoubleBuffer) {
                                DrawingSurfaceObject drawingSurfaceObject = canvas3D2.drawingSurfaceObject;
                                synchronized (drawingSurfaceObject) {
                                    if (canvas3D2.validCtx) {
                                        int n3;
                                        if (VirtualUniverse.mc.doDsiRenderLock) {
                                            if (!canvas3D2.drawingSurfaceObject.renderLock()) {
                                                continue;
                                            }
                                            canvas3D2.makeCtxCurrent();
                                            canvas3D2.syncRender(canvas3D2.ctx, true);
                                            n3 = canvas3D2.swapBuffers(canvas3D2.ctx, canvas3D2.screen.display, canvas3D2.window);
                                            if (n3 != 0) {
                                                canvas3D2.resetRendering(n3);
                                            }
                                            canvas3D2.drawingSurfaceObject.unLock();
                                        } else {
                                            canvas3D2.makeCtxCurrent();
                                            canvas3D2.syncRender(canvas3D2.ctx, true);
                                            n3 = canvas3D2.swapBuffers(canvas3D2.ctx, canvas3D2.screen.display, canvas3D2.window);
                                            if (n3 != 0) {
                                                canvas3D2.resetRendering(n3);
                                            }
                                        }
                                    }
                                }
                            }
                            canvas3D2.view.inCanvasCallback = true;
                            try {
                                canvas3D2.postSwap();
                            }
                            catch (RuntimeException runtimeException) {
                                System.err.println("Exception occurred during Canvas3D callback:");
                                runtimeException.printStackTrace();
                            }
                            canvas3D2.imageReady = false;
                            canvas3D2.view.inCanvasCallback = false;
                            if (!canvas3D2.ctxChanged) {
                                canvas3D2.canvasDirty = 7743;
                                canvas3D2.modelMatrix = null;
                                canvas3D2.ra = null;
                                continue;
                            }
                            canvas3D2.ctxChanged = false;
                            continue;
                        }
                        catch (NullPointerException nullPointerException) {
                            if (!VirtualUniverse.mc.doDsiRenderLock) continue;
                            canvas3D2.drawingSurfaceObject.unLock();
                        }
                    }
                    if (view != null && view.viewCache.getDoHeadTracking()) {
                        VirtualUniverse.mc.sendRunMessage(view, 16);
                    }
                    break block200;
                }
                if (n2 == 3) {
                    Integer n4 = (Integer)this.args[2];
                    if (n4 == MasterControl.REMOVEALLCTXS_CLEANUP) {
                        this.removeAllCtxs();
                    } else if (n4 == MasterControl.FREECONTEXT_CLEANUP) {
                        Canvas3D canvas3D3 = (Canvas3D)this.args[1];
                        this.removeCtx(canvas3D3, canvas3D3.screen.display, canvas3D3.window, canvas3D3.ctx, true, true, false);
                    } else if (n4 == MasterControl.RESETCANVAS_CLEANUP) {
                        Canvas3D canvas3D4 = (Canvas3D)this.args[1];
                        if (canvas3D4.ctx != 0L) {
                            canvas3D4.makeCtxCurrent();
                        }
                        canvas3D4.freeContextResources(canvas3D4.screen.renderer, true, canvas3D4.ctx);
                    } else if (n4 == MasterControl.REMOVECTX_CLEANUP) {
                        Object[] objectArray = (Object[])this.args[1];
                        Canvas3D canvas3D5 = (Canvas3D)objectArray[0];
                        this.removeCtx(canvas3D5, (Long)objectArray[1], (Integer)objectArray[2], (Long)objectArray[3], false, !canvas3D5.offScreen, (Boolean)objectArray[4]);
                    }
                    return;
                }
                this.nmesg = 0;
                int n5 = 0;
                if (n2 == 0) {
                    this.m = this.renderMessage;
                    this.m[0] = VirtualUniverse.mc.getMessage();
                    this.m[0].type = 43;
                    this.m[0].incRefcount();
                    this.m[0].args[0] = this.args[1];
                    n5 = 1;
                } else {
                    this.m = this.rendererStructure.getMessages();
                    n5 = this.rendererStructure.getNumMessage();
                    if (n5 <= 0) {
                        return;
                    }
                }
                block55: while (this.nmesg < n5) {
                    Object object;
                    Object object2 = this.m[this.nmesg].args[0];
                    if (object2 == null) {
                        Object object3 = this.m[this.nmesg].args[1];
                        if (object3 instanceof Canvas3D) {
                            Integer n6 = (Integer)this.m[this.nmesg].args[2];
                            Canvas3D canvas3D6 = (Canvas3D)object3;
                            if (n6 == MasterControl.SET_GRAPHICSCONFIG_FEATURES) {
                                object = GraphicsConfigTemplate3D.nativeTemplate;
                                if (canvas3D6.offScreen) {
                                    canvas3D6.doubleBufferAvailable = false;
                                    canvas3D6.stereoAvailable = false;
                                } else {
                                    canvas3D6.doubleBufferAvailable = ((NativeConfigTemplate3D)object).hasDoubleBuffer(canvas3D6);
                                    canvas3D6.stereoAvailable = ((NativeConfigTemplate3D)object).hasStereo(canvas3D6);
                                }
                                canvas3D6.sceneAntialiasingMultiSamplesAvailable = ((NativeConfigTemplate3D)object).hasSceneAntialiasingMultisample(canvas3D6);
                                canvas3D6.sceneAntialiasingAvailable = canvas3D6.sceneAntialiasingMultiSamplesAvailable ? true : ((NativeConfigTemplate3D)object).hasSceneAntialiasingAccum(canvas3D6);
                                GraphicsConfigTemplate3D.runMonitor(2);
                            } else if (n6 == MasterControl.SET_QUERYPROPERTIES) {
                                canvas3D6.createQueryContext();
                                GraphicsConfigTemplate3D.runMonitor(2);
                                this.currentCtx = -1L;
                            }
                        } else if (object3 instanceof Integer) {
                            this.freeTextureID((Integer)object3, (String)this.m[this.nmesg].args[2]);
                        } else if (object3 instanceof GeometryArrayRetained) {
                            ((GeometryArrayRetained)object3).freeD3DArray(false);
                        } else if (object3 instanceof GraphicsConfigTemplate3D) {
                            GraphicsConfigTemplate3D graphicsConfigTemplate3D = (GraphicsConfigTemplate3D)object3;
                            Integer n7 = (Integer)this.m[this.nmesg].args[2];
                            if (n7 == MasterControl.GETBESTCONFIG) {
                                graphicsConfigTemplate3D.testCfg = GraphicsConfigTemplate3D.nativeTemplate.getBestConfiguration(graphicsConfigTemplate3D, (GraphicsConfiguration[])graphicsConfigTemplate3D.testCfg);
                            } else if (n7 == MasterControl.ISCONFIGSUPPORT) {
                                graphicsConfigTemplate3D.testCfg = GraphicsConfigTemplate3D.nativeTemplate.isGraphicsConfigSupported(graphicsConfigTemplate3D, (GraphicsConfiguration)graphicsConfigTemplate3D.testCfg) ? Boolean.TRUE : Boolean.FALSE;
                            }
                            GraphicsConfigTemplate3D.runMonitor(2);
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    canvas3D = (Canvas3D)object2;
                    int n8 = this.m[this.nmesg].type;
                    if (n8 == 61) {
                        canvas3D.window = canvas3D.createOffScreenBuffer(canvas3D.ctx, canvas3D.screen.display, canvas3D.vid, canvas3D.fbConfig, canvas3D.offScreenCanvasSize.width, canvas3D.offScreenCanvasSize.height);
                        canvas3D.offScreenBufferPending = false;
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (canvas3D.view == null || !canvas3D.firstPaintCalled) {
                        if (n8 == 42) {
                            canvas3D.offScreenRendering = false;
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (!canvas3D.validCanvas && n8 != 42) {
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (n8 == 52) {
                        canvas3D.d3dResize();
                        VirtualUniverse.mc.sendRunMessage(canvas3D.view, 16);
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (n8 == 53) {
                        canvas3D.d3dToggle();
                        VirtualUniverse.mc.sendRunMessage(canvas3D.view, 16);
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (n8 == 44) {
                        int n9 = (Integer)this.m[this.nmesg].args[1];
                        if (this.needToResendTextureDown) {
                            ++VirtualUniverse.mc.resendTexTimestamp;
                            this.needToResendTextureDown = false;
                        }
                        if (canvas3D.ctx != 0L) {
                            canvas3D.beginScene();
                        }
                        switch (n9) {
                            case 0: {
                                canvas3D.graphicsContext3D.doClear();
                                break;
                            }
                            case 1: {
                                canvas3D.graphicsContext3D.doDraw((Geometry)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 2: {
                                canvas3D.doSwap();
                                break;
                            }
                            case 3: {
                                canvas3D.graphicsContext3D.doReadRaster((Raster)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 4: {
                                canvas3D.graphicsContext3D.doSetAppearance((Appearance)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 5: {
                                canvas3D.graphicsContext3D.doSetBackground((Background)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 6: {
                                canvas3D.graphicsContext3D.doSetFog((Fog)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 7: {
                                canvas3D.graphicsContext3D.doSetLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 8: {
                                canvas3D.graphicsContext3D.doInsertLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 9: {
                                canvas3D.graphicsContext3D.doRemoveLight((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 10: {
                                canvas3D.graphicsContext3D.doAddLight((Light)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 11: {
                                canvas3D.graphicsContext3D.doSetHiRes((HiResCoord)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 12: {
                                transform3D = (Transform3D)this.m[this.nmesg].args[2];
                                canvas3D.graphicsContext3D.doSetModelTransform(transform3D);
                                FreeListManager.freeObject(2, transform3D);
                                break;
                            }
                            case 13: {
                                transform3D = (Transform3D)this.m[this.nmesg].args[2];
                                canvas3D.graphicsContext3D.doMultiplyModelTransform(transform3D);
                                FreeListManager.freeObject(2, transform3D);
                                break;
                            }
                            case 14: {
                                canvas3D.graphicsContext3D.doSetSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 15: {
                                canvas3D.graphicsContext3D.doInsertSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 16: {
                                canvas3D.graphicsContext3D.doRemoveSound((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 17: {
                                canvas3D.graphicsContext3D.doAddSound((Sound)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 18: {
                                canvas3D.graphicsContext3D.doSetAuralAttributes((AuralAttributes)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 19: {
                                canvas3D.graphicsContext3D.doSetBufferOverride((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 20: {
                                canvas3D.graphicsContext3D.doSetFrontBufferRendering((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 21: {
                                canvas3D.graphicsContext3D.doSetStereoMode((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 22: {
                                canvas3D.graphicsContext3D.doFlush((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 23: {
                                canvas3D.graphics2D.doFlush();
                                break;
                            }
                            case 24: {
                                Object[] objectArray = this.m[this.nmesg].args;
                                canvas3D.graphics2D.doDrawAndFlushImage((BufferedImage)objectArray[2], ((Point)objectArray[3]).x, ((Point)objectArray[3]).y, (ImageObserver)objectArray[4]);
                                break;
                            }
                            case 25: {
                                canvas3D.graphicsContext3D.doSetModelClip((ModelClip)this.m[this.nmesg].args[2]);
                                break;
                            }
                        }
                        if (canvas3D.ctx != 0L) {
                            canvas3D.endScene();
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    this.m[this.nmesg++].decRefcount();
                    ImageComponent2DRetained imageComponent2DRetained = null;
                    if (n8 == 42) {
                        if (canvas3D.window == 0 || !canvas3D.active) {
                            canvas3D.offScreenRendering = false;
                            continue;
                        }
                        imageComponent2DRetained = (ImageComponent2DRetained)canvas3D.offScreenBuffer.retained;
                        if (imageComponent2DRetained.isByReference()) {
                            imageComponent2DRetained.geomLock.getLock();
                            imageComponent2DRetained.evaluateExtensions(canvas3D.extensionsSupported);
                        }
                    } else if (!canvas3D.active) continue;
                    boolean bl3 = false;
                    renderBin = canvas3D.view.renderBin;
                    if (canvas3D.useSharedCtx && this.sharedCtx == 0L) {
                        this.display = canvas3D.screen.display;
                        if (!canvas3D.drawingSurfaceObject.renderLock()) {
                            if (imageComponent2DRetained == null || !imageComponent2DRetained.isByReference()) break;
                            imageComponent2DRetained.geomLock.unLock();
                            break;
                        }
                        Object object4 = VirtualUniverse.mc.contextCreationLock;
                        synchronized (object4) {
                            this.sharedCtx = canvas3D.createNewContext(canvas3D.screen.display, canvas3D.window, canvas3D.vid, canvas3D.fbConfig, 0L, true, canvas3D.offScreen);
                            if (this.sharedCtx == 0L) {
                                canvas3D.drawingSurfaceObject.unLock();
                                if (imageComponent2DRetained != null && imageComponent2DRetained.isByReference()) {
                                    imageComponent2DRetained.geomLock.unLock();
                                }
                                break;
                            }
                            this.sharedCtxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                            this.needToRebuildDisplayList = true;
                        }
                        canvas3D.drawingSurfaceObject.unLock();
                    }
                    if (canvas3D.ctx == 0L) {
                        this.display = canvas3D.screen.display;
                        if (!canvas3D.drawingSurfaceObject.renderLock()) {
                            if (imageComponent2DRetained == null || !imageComponent2DRetained.isByReference()) break;
                            imageComponent2DRetained.geomLock.unLock();
                            break;
                        }
                        Object object5 = VirtualUniverse.mc.contextCreationLock;
                        synchronized (object5) {
                            canvas3D.ctx = canvas3D.createNewContext(canvas3D.screen.display, canvas3D.window, canvas3D.vid, canvas3D.fbConfig, this.sharedCtx, false, canvas3D.offScreen);
                            if (canvas3D.ctx == 0L) {
                                canvas3D.drawingSurfaceObject.unLock();
                                if (imageComponent2DRetained != null && imageComponent2DRetained.isByReference()) {
                                    imageComponent2DRetained.geomLock.unLock();
                                }
                                break;
                            }
                            if (canvas3D.graphics2D != null) {
                                canvas3D.graphics2D.init();
                            }
                            canvas3D.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                            this.listOfCtxs.add(new Long(canvas3D.ctx));
                            this.listOfCanvases.add(canvas3D);
                            if (renderBin.nodeComponentList.size() > 0) {
                                for (int i = 0; i < renderBin.nodeComponentList.size(); ++i) {
                                    object = (NodeComponentRetained)renderBin.nodeComponentList.get(i);
                                    ((NodeComponentRetained)object).evaluateExtensions(canvas3D.extensionsSupported);
                                }
                            }
                            if (canvas3D.multiTexAccelerated) {
                                canvas3D.numTexUnitSupported = canvas3D.getTextureUnitCount(canvas3D.ctx);
                                if (VirtualUniverse.mc.textureUnitMax < canvas3D.numTexUnitSupported) {
                                    canvas3D.numTexUnitSupported = VirtualUniverse.mc.textureUnitMax;
                                }
                            }
                            canvas3D.enableSeparateSpecularColor();
                        }
                        if (canvas3D.texUnitState == null) {
                            canvas3D.texUnitState = new TextureUnitStateRetained[canvas3D.numTexCoordSupported];
                            for (int i = 0; i < canvas3D.numTexCoordSupported; ++i) {
                                canvas3D.texUnitState[i] = new TextureUnitStateRetained();
                                canvas3D.texUnitState[i].texture = null;
                                canvas3D.texUnitState[i].mirror = null;
                            }
                        }
                        if (canvas3D.texUnitStateMap == null) {
                            canvas3D.texUnitStateMap = new int[canvas3D.numTexCoordSupported];
                        }
                        canvas3D.resetImmediateRendering(0);
                        canvas3D.drawingSurfaceObject.contextValidated();
                        if (!canvas3D.useSharedCtx) {
                            canvas3D.needToRebuildDisplayList = true;
                        }
                        canvas3D.drawingSurfaceObject.unLock();
                    } else if (canvas3D.isRunning) {
                        canvas3D.makeCtxCurrent();
                    }
                    if (renderBin != null) {
                        Object object6;
                        int n10;
                        int n11;
                        boolean bl4;
                        if (VirtualUniverse.mc.doDsiRenderLock && !canvas3D.drawingSurfaceObject.renderLock()) {
                            if (imageComponent2DRetained == null || !imageComponent2DRetained.isByReference()) break;
                            imageComponent2DRetained.geomLock.unLock();
                            break;
                        }
                        if (this.needToResendTextureDown) {
                            ++VirtualUniverse.mc.resendTexTimestamp;
                            this.needToResendTextureDown = false;
                        }
                        if (canvas3D.useSharedCtx) {
                            this.freeResourcesInFreeList(canvas3D);
                        } else {
                            canvas3D.freeResourcesInFreeList(canvas3D.ctx);
                        }
                        boolean bl5 = bl3 = (canvas3D.cvDirtyMask & 0x20) != 0;
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            canvas3D.drawingSurfaceObject.unLock();
                        }
                        canvas3D.updateViewCache(false, this.copyOfCvCache, null, renderBin.geometryBackground != null);
                        if (VirtualUniverse.mc.doDsiRenderLock && !canvas3D.drawingSurfaceObject.renderLock()) {
                            if (imageComponent2DRetained == null || !imageComponent2DRetained.isByReference()) break;
                            imageComponent2DRetained.geomLock.unLock();
                            break;
                        }
                        canvas3D.setViewport(canvas3D.ctx, 0, 0, this.copyOfCvCache.getCanvasWidth(), this.copyOfCvCache.getCanvasHeight());
                        if (canvas3D.useSharedCtx) {
                            int n12;
                            if (this.needToRebuildDisplayList) {
                                renderBin.updateAllRenderMolecule(this, canvas3D);
                                this.needToRebuildDisplayList = false;
                            }
                            if (this.dirtyDisplayList) {
                                renderBin.updateDirtyDisplayLists(canvas3D, this.dirtyRenderMoleculeList, this.dirtyDlistPerRinfoList, this.dirtyRenderAtomList, true);
                                this.dirtyDisplayList = false;
                            }
                            if ((n12 = this.textureReloadList.size()) > 0) {
                                for (int i = n12 - 1; i >= 0; --i) {
                                    ((TextureRetained)this.textureReloadList.get(i)).reloadTextureSharedContext(canvas3D);
                                }
                                this.textureReloadList.clear();
                            }
                        } else {
                            if (canvas3D.needToRebuildDisplayList) {
                                renderBin.updateAllRenderMolecule(canvas3D);
                                canvas3D.needToRebuildDisplayList = false;
                            }
                            if (canvas3D.dirtyDisplayList) {
                                renderBin.updateDirtyDisplayLists(canvas3D, canvas3D.dirtyRenderMoleculeList, canvas3D.dirtyDlistPerRinfoList, canvas3D.dirtyRenderAtomList, false);
                                canvas3D.dirtyDisplayList = false;
                            }
                        }
                        if (canvas3D.view.localEyeLightingEnable != canvas3D.ctxEyeLightingEnable) {
                            canvas3D.ctxUpdateEyeLightingEnable(canvas3D.ctx, canvas3D.view.localEyeLightingEnable);
                            canvas3D.ctxEyeLightingEnable = canvas3D.view.localEyeLightingEnable;
                        }
                        if (bl4 = this.copyOfCvCache.getUseStereo()) {
                            n11 = 2;
                            n10 = 0;
                            this.sharedStereoZBuffer = VirtualUniverse.mc.sharedStereoZBuffer;
                        } else {
                            n11 = 1;
                            n10 = 2;
                            this.sharedStereoZBuffer = false;
                        }
                        if (canvas3D.view.getSceneAntialiasingEnable() && canvas3D.sceneAntialiasingAvailable) {
                            if (!VirtualUniverse.mc.isD3D() && (canvas3D.extensionsSupported & 0x200) == 0 || !canvas3D.sceneAntialiasingMultiSamplesAvailable) {
                                bl = true;
                                n = 8;
                                System.arraycopy(this.copyOfCvCache.getLeftProjection().mat, 0, this.accumLeftProjMat, 0, 16);
                                d3 = canvas3D.canvasViewCache.getPhysicalWindowWidth() / (double)canvas3D.canvasViewCache.getCanvasWidth() * canvas3D.view.fieldOfView;
                                d4 = canvas3D.canvasViewCache.getPhysicalWindowHeight() / (double)canvas3D.canvasViewCache.getCanvasHeight() * canvas3D.view.fieldOfView;
                                d5 = this.accumLeftProjMat[3];
                                d6 = this.accumLeftProjMat[7];
                                if (bl4) {
                                    System.arraycopy(this.copyOfCvCache.getRightProjection().mat, 0, this.accumRightProjMat, 0, 16);
                                    d7 = this.accumRightProjMat[3];
                                    d8 = this.accumRightProjMat[7];
                                }
                                if (renderBin.geometryBackground != null) {
                                    System.arraycopy(this.copyOfCvCache.getInfLeftProjection().mat, 0, this.accumInfLeftProjMat, 0, 16);
                                    d9 = this.accumInfLeftProjMat[3];
                                    d10 = this.accumInfLeftProjMat[7];
                                    if (bl4) {
                                        System.arraycopy(this.copyOfCvCache.getInfRightProjection().mat, 0, this.accumInfRightProjMat, 0, 16);
                                        d11 = this.accumInfRightProjMat[3];
                                        d12 = this.accumInfRightProjMat[7];
                                    }
                                }
                            } else if (!canvas3D.antialiasingSet) {
                                canvas3D.setFullSceneAntialiasing(canvas3D.ctx, true);
                                canvas3D.antialiasingSet = true;
                            }
                        } else if (canvas3D.antialiasingSet) {
                            canvas3D.setFullSceneAntialiasing(canvas3D.ctx, false);
                            canvas3D.antialiasingSet = false;
                        }
                        if (renderBin.geometryBackground != null) {
                            renderBin.updateInfVworldToVpc();
                        }
                        canvas3D.setRenderMode(canvas3D.ctx, 2, canvas3D.useDoubleBuffer);
                        if (canvas3D.supportVideoResize()) {
                            if (canvas3D.view.dvrResizeCompensation != canvas3D.cachedDvrResizeCompensation) {
                                canvas3D.videoResizeCompensation(canvas3D.ctx, canvas3D.view.dvrResizeCompensation);
                                canvas3D.cachedDvrResizeCompensation = canvas3D.view.dvrResizeCompensation;
                            }
                            if (canvas3D.view.dvrFactor != canvas3D.cachedDvrFactor) {
                                canvas3D.videoResize(canvas3D.ctx, canvas3D.screen.display, canvas3D.window, canvas3D.view.dvrFactor);
                                canvas3D.cachedDvrFactor = canvas3D.view.dvrFactor;
                            }
                        }
                        canvas3D.beginScene();
                        int n13 = this.copyOfCvCache.getCanvasWidth();
                        int n14 = this.copyOfCvCache.getCanvasHeight();
                        if (!bl && !this.sharedStereoZBuffer) {
                            object6 = renderBin.background;
                            if (!VirtualUniverse.mc.isBackgroundTexture) {
                                canvas3D.clear(canvas3D.ctx, ((BackgroundRetained)object6).color.x, ((BackgroundRetained)object6).color.y, ((BackgroundRetained)object6).color.z, n13, n14, ((BackgroundRetained)object6).image, ((BackgroundRetained)object6).imageScaleMode, ((BackgroundRetained)object6).image != null ? ((BackgroundRetained)object6).image.imageYdown[0] : null);
                            } else {
                                if (((BackgroundRetained)object6).texImage != null && this.objectId == -1) {
                                    this.objectId = VirtualUniverse.mc.getTexture2DId();
                                }
                                canvas3D.textureclear(canvas3D.ctx, ((BackgroundRetained)object6).xmax, ((BackgroundRetained)object6).ymax, ((BackgroundRetained)object6).color.x, ((BackgroundRetained)object6).color.y, ((BackgroundRetained)object6).color.z, n13, n14, this.objectId, ((BackgroundRetained)object6).imageScaleMode, ((BackgroundRetained)object6).texImage, bl3);
                            }
                        }
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            canvas3D.drawingSurfaceObject.unLock();
                        }
                        canvas3D.view.inCanvasCallback = true;
                        try {
                            canvas3D.preRender();
                        }
                        catch (RuntimeException runtimeException) {
                            System.err.println("Exception occurred during Canvas3D callback:");
                            runtimeException.printStackTrace();
                        }
                        canvas3D.view.inCanvasCallback = false;
                        if (VirtualUniverse.mc.doDsiRenderLock && !canvas3D.drawingSurfaceObject.renderLock()) {
                            if (imageComponent2DRetained == null || !imageComponent2DRetained.isByReference()) break;
                            imageComponent2DRetained.geomLock.unLock();
                            break;
                        }
                        for (int i = 0; i < n11; ++i) {
                            if (bl) {
                                canvas3D.clearAccum(canvas3D.ctx);
                            }
                            canvas3D.setRenderMode(canvas3D.ctx, n10, canvas3D.useDoubleBuffer);
                            for (int j = 0; j < n; ++j) {
                                if (bl) {
                                    d = (double)ACCUM_SAMPLES_X[j] * d3;
                                    d2 = (double)ACCUM_SAMPLES_Y[j] * d4;
                                    this.accumLeftProjMat[3] = d5 + this.accumLeftProjMat[0] * d + this.accumLeftProjMat[1] * d2;
                                    this.accumLeftProjMat[7] = d6 + this.accumLeftProjMat[4] * d + this.accumLeftProjMat[5] * d2;
                                    if (bl4) {
                                        this.accumRightProjMat[3] = d7 + this.accumRightProjMat[0] * d + this.accumRightProjMat[1] * d2;
                                        this.accumRightProjMat[7] = d8 + this.accumRightProjMat[4] * d + this.accumRightProjMat[5] * d2;
                                    }
                                    if (renderBin.geometryBackground != null) {
                                        this.accumInfLeftProjMat[3] = d9 + this.accumInfLeftProjMat[0] * d + this.accumInfLeftProjMat[1] * d2;
                                        this.accumInfLeftProjMat[7] = d10 + this.accumInfLeftProjMat[4] * d + this.accumInfLeftProjMat[5] * d2;
                                        if (bl4) {
                                            this.accumInfRightProjMat[3] = d11 + this.accumInfRightProjMat[0] * d + this.accumInfRightProjMat[1] * d2;
                                            this.accumInfRightProjMat[7] = d12 + this.accumInfRightProjMat[4] * d + this.accumInfRightProjMat[5] * d2;
                                        }
                                    }
                                }
                                if (bl || this.sharedStereoZBuffer) {
                                    object6 = renderBin.background;
                                    if (!VirtualUniverse.mc.isBackgroundTexture) {
                                        canvas3D.clear(canvas3D.ctx, ((BackgroundRetained)object6).color.x, ((BackgroundRetained)object6).color.y, ((BackgroundRetained)object6).color.z, n13, n14, ((BackgroundRetained)object6).image, ((BackgroundRetained)object6).imageScaleMode, ((BackgroundRetained)object6).image != null ? ((BackgroundRetained)object6).image.imageYdown[0] : null);
                                    } else {
                                        if (((BackgroundRetained)object6).texImage != null && this.objectId == -1) {
                                            this.objectId = VirtualUniverse.mc.getTexture2DId();
                                        }
                                        canvas3D.textureclear(canvas3D.ctx, ((BackgroundRetained)object6).xmax, ((BackgroundRetained)object6).ymax, ((BackgroundRetained)object6).color.x, ((BackgroundRetained)object6).color.y, ((BackgroundRetained)object6).color.z, n13, n14, this.objectId, ((BackgroundRetained)object6).imageScaleMode, ((BackgroundRetained)object6).texImage, bl3);
                                    }
                                }
                                if (renderBin.geometryBackground != null) {
                                    if (i == 0) {
                                        canvas3D.vpcToEc = this.copyOfCvCache.getInfLeftVpcToEc();
                                        if (bl) {
                                            canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumInfLeftProjMat);
                                        } else {
                                            canvas3D.setProjectionMatrix(canvas3D.ctx, this.copyOfCvCache.getInfLeftProjection().mat);
                                        }
                                    } else {
                                        canvas3D.vpcToEc = this.copyOfCvCache.getInfRightVpcToEc();
                                        if (bl) {
                                            canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumInfRightProjMat);
                                        } else {
                                            canvas3D.setProjectionMatrix(canvas3D.ctx, this.copyOfCvCache.getInfRightProjection().mat);
                                        }
                                    }
                                    canvas3D.vworldToEc.mul(canvas3D.vpcToEc, this.copyOfCvCache.getInfVworldToVpc());
                                    renderBin.renderBackground(canvas3D);
                                }
                                if (i == 0) {
                                    canvas3D.vpcToEc = this.copyOfCvCache.getLeftVpcToEc();
                                    if (bl) {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumLeftProjMat);
                                    } else {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, this.copyOfCvCache.getLeftProjection().mat);
                                    }
                                } else {
                                    canvas3D.vpcToEc = this.copyOfCvCache.getRightVpcToEc();
                                    if (bl) {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumRightProjMat);
                                    } else {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, this.copyOfCvCache.getRightProjection().mat);
                                    }
                                }
                                canvas3D.vworldToEc.mul(canvas3D.vpcToEc, this.copyOfCvCache.getVworldToVpc());
                                object6 = this.copyOfCvCache;
                                synchronized (object6) {
                                    if (i == 0) {
                                        canvas3D.setFrustumPlanes(this.copyOfCvCache.getLeftFrustumPlanesInVworld());
                                    } else {
                                        canvas3D.setFrustumPlanes(this.copyOfCvCache.getRightFrustumPlanesInVworld());
                                    }
                                }
                                if (bl4) {
                                    canvas3D.canvasDirty |= 0x8000;
                                }
                                renderBin.renderOpaque(canvas3D);
                                renderBin.renderOrdered(canvas3D);
                                if (VirtualUniverse.mc.doDsiRenderLock) {
                                    canvas3D.drawingSurfaceObject.unLock();
                                }
                                canvas3D.view.inCanvasCallback = true;
                                try {
                                    canvas3D.renderField(n10);
                                }
                                catch (RuntimeException runtimeException) {
                                    System.err.println("Exception occurred during Canvas3D callback:");
                                    runtimeException.printStackTrace();
                                }
                                canvas3D.view.inCanvasCallback = false;
                                if (VirtualUniverse.mc.doDsiRenderLock && !canvas3D.drawingSurfaceObject.renderLock()) {
                                    if (imageComponent2DRetained == null || !imageComponent2DRetained.isByReference()) break block55;
                                    imageComponent2DRetained.geomLock.unLock();
                                    break block55;
                                }
                                renderBin.renderTransparent(canvas3D);
                                if (!bl) continue;
                                canvas3D.accum(canvas3D.ctx, 0.125f);
                            }
                            if (bl) {
                                canvas3D.accumReturn(canvas3D.ctx);
                            }
                            if (!bl4) continue;
                            n10 = 1;
                            canvas3D.rightStereoPass = true;
                        }
                        canvas3D.imageReady = true;
                        canvas3D.rightStereoPass = false;
                        canvas3D.setRenderMode(canvas3D.ctx, 2, canvas3D.useDoubleBuffer);
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            canvas3D.drawingSurfaceObject.unLock();
                        }
                        canvas3D.view.inCanvasCallback = true;
                        try {
                            canvas3D.postRender();
                        }
                        catch (RuntimeException runtimeException) {
                            System.err.println("Exception occurred during Canvas3D callback:");
                            runtimeException.printStackTrace();
                        }
                        canvas3D.view.inCanvasCallback = false;
                        if (canvas3D.offScreenRendering) {
                            canvas3D.syncRender(canvas3D.ctx, true);
                            canvas3D.endOffScreenRendering();
                            canvas3D.view.inCanvasCallback = true;
                            try {
                                canvas3D.postSwap();
                            }
                            catch (RuntimeException runtimeException) {
                                System.err.println("Exception occurred during Canvas 3D callback:");
                                runtimeException.printStackTrace();
                            }
                            if (imageComponent2DRetained.isByReference()) {
                                imageComponent2DRetained.geomLock.unLock();
                            }
                            canvas3D.offScreenRendering = false;
                            canvas3D.view.inCanvasCallback = false;
                        }
                        canvas3D.endScene();
                        continue;
                    }
                    if (imageComponent2DRetained == null || !imageComponent2DRetained.isByReference()) continue;
                    imageComponent2DRetained.geomLock.unLock();
                }
                if (n2 == 0) {
                    this.m[0] = null;
                } else {
                    Arrays.fill(this.m, 0, n5, null);
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                if (canvas3D == null) break block200;
                if (canvas3D.ctx != 0L) {
                    canvas3D.endScene();
                }
                canvas3D.drawingSurfaceObject.unLock();
            }
        }
    }

    void shutdown() {
        this.removeAllCtxs();
        if (VirtualUniverse.mc.isD3D()) {
            this.D3DCleanUp();
        }
    }

    void cleanup() {
        super.cleanup();
        this.renderMessage = new J3dMessage[1];
        this.rendererStructure = new RendererStructure();
        this.bgVworldToVpc = new Transform3D();
        this.numframes = 0.0f;
        this.sharedCtx = 0L;
        this.sharedCtxTimeStamp = 0L;
        this.dirtyRenderMoleculeList.clear();
        this.dirtyRenderAtomList.clear();
        this.dirtyDlistPerRinfoList.clear();
        this.textureIdResourceFreeList.clear();
        this.displayListResourceFreeList.clear();
        this.copyOfCvCache = new CanvasViewCache(null, null, null);
        this.onScreen = null;
        this.offScreen = null;
        this.m = null;
        this.nmesg = 0;
        this.lasttime = 0L;
        this.currtime = 0L;
        this.display = 0L;
    }

    final void makeCtxCurrent(long l, long l2, int n) {
        if (l != this.currentCtx) {
            Canvas3D.useCtx(l, l2, n);
            this.currentCtx = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCtx(Canvas3D canvas3D, long l, int n, long l2, boolean bl, boolean bl2, boolean bl3) {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (bl3) {
                canvas3D.destroyOffScreenBuffer(l2, l, canvas3D.fbConfig, n);
                canvas3D.offScreenBufferPending = false;
            }
            if (l2 != 0L) {
                int n2 = this.listOfCtxs.indexOf(new Long(l2));
                if (n2 >= 0) {
                    this.listOfCtxs.remove(n2);
                    this.listOfCanvases.remove(n2);
                    if ((MasterControl.isWin32 || l != 0L) && n != 0 && canvas3D.added && canvas3D.drawingSurfaceObject.renderLock()) {
                        if (this.sharedCtx != 0L) {
                            if (this.listOfCtxs.isEmpty()) {
                                this.makeCtxCurrent(this.sharedCtx, l, n);
                                this.freeResourcesInFreeList(null);
                                this.freeContextResources();
                                Canvas3D.destroyContext(l, n, this.sharedCtx);
                                this.currentCtx = -1L;
                            } else {
                                this.freeResourcesInFreeList(canvas3D);
                            }
                            canvas3D.makeCtxCurrent(l2, l, n);
                        } else {
                            canvas3D.makeCtxCurrent(l2, l, n);
                            canvas3D.freeResourcesInFreeList(l2);
                        }
                        canvas3D.freeContextResources(this, bl2, l2);
                        Canvas3D.destroyContext(l, n, l2);
                        this.currentCtx = -1L;
                        canvas3D.drawingSurfaceObject.unLock();
                    }
                }
                if (bl) {
                    canvas3D.ctx = 0L;
                }
                if (this.sharedCtx != 0L && this.listOfCtxs.isEmpty()) {
                    this.sharedCtx = 0L;
                    this.sharedCtxTimeStamp = 0L;
                }
                canvas3D.ctxTimeStamp = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllCtxs() {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            for (int i = this.listOfCanvases.size() - 1; i >= 0; --i) {
                Canvas3D canvas3D = (Canvas3D)this.listOfCanvases.get(i);
                if (canvas3D.screen != null && canvas3D.ctx != 0L && (MasterControl.isWin32 || this.display != 0L) && canvas3D.window != 0 && canvas3D.added && canvas3D.drawingSurfaceObject.renderLock()) {
                    if (i == 0 && this.sharedCtx != 0L) {
                        this.makeCtxCurrent(this.sharedCtx, this.display, this.window);
                        this.freeResourcesInFreeList(null);
                        this.freeContextResources();
                        Canvas3D.destroyContext(this.display, this.window, this.sharedCtx);
                        this.currentCtx = -1L;
                    }
                    canvas3D.makeCtxCurrent();
                    canvas3D.freeResourcesInFreeList(canvas3D.ctx);
                    canvas3D.freeContextResources(this, true, canvas3D.ctx);
                    Canvas3D.destroyContext(canvas3D.screen.display, canvas3D.window, canvas3D.ctx);
                    this.currentCtx = -1L;
                    canvas3D.drawingSurfaceObject.unLock();
                }
                canvas3D.ctx = 0L;
                canvas3D.ctxTimeStamp = 0L;
            }
            if (this.sharedCtx != 0L) {
                this.sharedCtx = 0L;
                this.sharedCtxTimeStamp = 0L;
            }
            this.listOfCanvases.clear();
            this.listOfCtxs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeTextureID(int n, String string) {
        Canvas3D canvas3D = null;
        for (int i = this.listOfCtxs.size() - 1; i >= 0; --i) {
            Canvas3D canvas3D2 = (Canvas3D)this.listOfCanvases.get(i);
            if (canvas3D2.ctx != this.currentCtx) continue;
            canvas3D = canvas3D2;
            break;
        }
        if (canvas3D == null) {
            return;
        }
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (this.sharedCtx != 0L) {
                canvas3D.makeCtxCurrent(this.sharedCtx);
                Canvas3D.freeTexture(this.sharedCtx, n);
            } else {
                for (int i = this.listOfCtxs.size() - 1; i >= 0; --i) {
                    Canvas3D canvas3D3 = (Canvas3D)this.listOfCanvases.get(i);
                    canvas3D3.makeCtxCurrent();
                    Canvas3D.freeTexture(canvas3D3.ctx, n);
                }
            }
            canvas3D.makeCtxCurrent();
        }
        if (string.equals("2D")) {
            VirtualUniverse.mc.freeTexture2DId(n);
        } else if (string.equals("3D")) {
            VirtualUniverse.mc.freeTexture3DId(n);
        }
    }

    void freeResourcesInFreeList(Canvas3D canvas3D) {
        boolean bl;
        boolean bl2 = this.textureIdResourceFreeList.size() > 0;
        boolean bl3 = bl = this.displayListResourceFreeList.size() > 0;
        if (bl2 || bl) {
            int n;
            Iterator iterator;
            if (canvas3D != null) {
                canvas3D.makeCtxCurrent(this.sharedCtx);
            }
            if (bl) {
                iterator = this.displayListResourceFreeList.iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    if (n <= 0) continue;
                    Canvas3D.freeDisplayList(this.sharedCtx, n);
                }
                this.displayListResourceFreeList.clear();
            }
            if (bl2) {
                iterator = this.textureIdResourceFreeList.iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    if (n <= 0) continue;
                    if (n >= this.textureIDResourceTable.size()) {
                        System.out.println("Error in freeResourcesInFreeList : ResourceIDTableSize = " + this.textureIDResourceTable.size() + " val = " + n);
                    } else {
                        this.textureIDResourceTable.set(n, null);
                    }
                    Canvas3D.freeTexture(this.sharedCtx, n);
                }
                this.textureIdResourceFreeList.clear();
            }
            if (canvas3D != null) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
            }
        }
    }

    final void addTextureResource(int n, Object object) {
        if (this.textureIDResourceTable.size() <= n) {
            for (int i = this.textureIDResourceTable.size(); i < n; ++i) {
                this.textureIDResourceTable.add(null);
            }
            this.textureIDResourceTable.add(object);
        } else {
            this.textureIDResourceTable.set(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeContextResources() {
        for (int i = this.textureIDResourceTable.size() - 1; i > 0; --i) {
            Object e = this.textureIDResourceTable.get(i);
            if (e == null) continue;
            Canvas3D.freeTexture(this.sharedCtx, i);
            if (e instanceof TextureRetained) {
                TextureRetained textureRetained = (TextureRetained)e;
                Object object = textureRetained.resourceLock;
                synchronized (object) {
                    textureRetained.resourceCreationMask &= ~this.rendererBit;
                    if (textureRetained.resourceCreationMask == 0) {
                        textureRetained.freeTextureId(i);
                    }
                    continue;
                }
            }
            if (!(e instanceof DetailTextureImage)) continue;
            DetailTextureImage detailTextureImage = (DetailTextureImage)e;
            detailTextureImage.freeDetailTextureId(i, this.rendererBit);
        }
        this.textureIDResourceTable.clear();
    }
}

