/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;

class TextureAttributesRetained
extends NodeComponentRetained {
    static final int TRANSFORM_CHANGED = 1;
    static final int MODE_CHANGED = 2;
    static final int COLOR_CHANGED = 4;
    static final int CORRECTION_CHANGED = 8;
    static final int TEXTURE_COLOR_TABLE_CHANGED = 16;
    static final int COMBINE_RGB_MODE_CHANGED = 32;
    static final int COMBINE_ALPHA_MODE_CHANGED = 64;
    static final int COMBINE_RGB_SRC_CHANGED = 128;
    static final int COMBINE_ALPHA_SRC_CHANGED = 256;
    static final int COMBINE_RGB_FCN_CHANGED = 512;
    static final int COMBINE_ALPHA_FCN_CHANGED = 1024;
    static final int COMBINE_RGB_SCALE_CHANGED = 2048;
    static final int COMBINE_ALPHA_SCALE_CHANGED = 4096;
    static Integer[] commandInt = null;
    static Integer[] enums = null;
    Transform3D transform = new Transform3D();
    int textureMode = 5;
    Color4f textureBlendColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    int[] textureColorTable = null;
    int numTextureColorTableComponents = 0;
    int textureColorTableSize = 0;
    int combineRgbMode = 1;
    int combineAlphaMode = 1;
    int[] combineRgbSrc = null;
    int[] combineAlphaSrc = null;
    int[] combineRgbFcn = null;
    int[] combineAlphaFcn = null;
    int combineRgbScale = 1;
    int combineAlphaScale = 1;
    int perspCorrectionMode = 1;
    boolean mirrorCompDirty = false;

    static final void initTextureEnums() {
        if (enums == null) {
            enums = new Integer[10];
            for (int i = 0; i < 10; ++i) {
                TextureAttributesRetained.enums[i] = new Integer(i);
            }
        }
    }

    TextureAttributesRetained() {
        TextureAttributesRetained.initTextureEnums();
    }

    final void initCombineMode(TextureAttributesRetained textureAttributesRetained) {
        textureAttributesRetained.combineRgbSrc = new int[3];
        textureAttributesRetained.combineAlphaSrc = new int[3];
        textureAttributesRetained.combineRgbFcn = new int[3];
        textureAttributesRetained.combineAlphaFcn = new int[3];
        textureAttributesRetained.combineRgbSrc[0] = 1;
        textureAttributesRetained.combineRgbSrc[1] = 3;
        textureAttributesRetained.combineRgbSrc[2] = 2;
        textureAttributesRetained.combineAlphaSrc[0] = 1;
        textureAttributesRetained.combineAlphaSrc[1] = 3;
        textureAttributesRetained.combineAlphaSrc[2] = 2;
        textureAttributesRetained.combineRgbFcn[0] = 0;
        textureAttributesRetained.combineRgbFcn[1] = 0;
        textureAttributesRetained.combineRgbFcn[2] = 0;
        textureAttributesRetained.combineAlphaFcn[0] = 2;
        textureAttributesRetained.combineAlphaFcn[1] = 2;
        textureAttributesRetained.combineAlphaFcn[2] = 2;
    }

    final void initTextureMode(int n) {
        this.textureMode = n;
        if (n == 6 && this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
    }

    final void setTextureMode(int n) {
        this.initTextureMode(n);
        this.sendMessage(2, enums[n], null);
    }

    final int getTextureMode() {
        return this.textureMode;
    }

    final void initTextureBlendColor(Color4f color4f) {
        this.textureBlendColor.set((Tuple4f)color4f);
    }

    final void setTextureBlendColor(Color4f color4f) {
        this.textureBlendColor.set((Tuple4f)color4f);
        this.sendMessage(4, new Color4f(color4f), null);
    }

    final void initTextureBlendColor(float f, float f2, float f3, float f4) {
        this.textureBlendColor.set(f, f2, f3, f4);
    }

    final void setTextureBlendColor(float f, float f2, float f3, float f4) {
        this.textureBlendColor.set(f, f2, f3, f4);
        this.sendMessage(4, new Color4f(f, f2, f3, f4), null);
    }

    final void getTextureBlendColor(Color4f color4f) {
        color4f.set((Tuple4f)this.textureBlendColor);
    }

    final void initTextureTransform(Transform3D transform3D) {
        this.transform.set(transform3D);
    }

    final void setTextureTransform(Transform3D transform3D) {
        this.transform.set(transform3D);
        this.sendMessage(1, VirtualUniverse.mc.getTransform3D(transform3D), null);
    }

    final void getTextureTransform(Transform3D transform3D) {
        transform3D.set(this.transform);
    }

    final void initPerspectiveCorrectionMode(int n) {
        this.perspCorrectionMode = n;
    }

    final void setPerspectiveCorrectionMode(int n) {
        this.perspCorrectionMode = n;
        this.sendMessage(8, enums[n], null);
    }

    final int getPerspectiveCorrectionMode() {
        return this.perspCorrectionMode;
    }

    final void setTextureColorTable(int[][] nArray) {
        this.initTextureColorTable(nArray);
        if (nArray == null) {
            this.sendMessage(16, null, null);
        } else {
            int[] nArray2 = new int[this.textureColorTableSize * this.numTextureColorTableComponents];
            System.arraycopy(this.textureColorTable, 0, nArray2, 0, this.textureColorTable.length);
            Object[] objectArray = new Object[]{new Integer(this.numTextureColorTableComponents), new Integer(this.textureColorTableSize), nArray2};
            this.sendMessage(16, objectArray, null);
        }
    }

    final void initTextureColorTable(int[][] nArray) {
        int n;
        this.numTextureColorTableComponents = 0;
        this.textureColorTableSize = 0;
        if (nArray == null) {
            this.textureColorTable = null;
            return;
        }
        if (nArray.length < 3 || nArray.length > 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes13"));
        }
        if (Texture.getPowerOf2(nArray[0].length) == -1) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes14"));
        }
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n].length == nArray[0].length) continue;
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes15"));
        }
        this.numTextureColorTableComponents = nArray.length;
        this.textureColorTableSize = nArray[0].length;
        if (this.textureColorTable == null || this.textureColorTable.length != this.numTextureColorTableComponents * this.textureColorTableSize) {
            this.textureColorTable = new int[this.numTextureColorTableComponents * this.textureColorTableSize];
        }
        n = 0;
        for (int i = 0; i < this.textureColorTableSize; ++i) {
            for (int j = 0; j < this.numTextureColorTableComponents; ++j) {
                this.textureColorTable[n++] = nArray[j][i];
            }
        }
    }

    final void getTextureColorTable(int[][] nArray) {
        if (this.textureColorTable == null) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.textureColorTableSize; ++i) {
            for (int j = 0; j < this.numTextureColorTableComponents; ++j) {
                nArray[j][i] = this.textureColorTable[n++];
            }
        }
    }

    final int getNumTextureColorTableComponents() {
        return this.numTextureColorTableComponents;
    }

    final int getTextureColorTableSize() {
        return this.textureColorTableSize;
    }

    final void initCombineRgbMode(int n) {
        this.combineRgbMode = n;
    }

    final void setCombineRgbMode(int n) {
        this.initCombineRgbMode(n);
        this.sendMessage(32, enums[n], null);
    }

    final int getCombineRgbMode() {
        return this.combineRgbMode;
    }

    final void initCombineAlphaMode(int n) {
        this.combineAlphaMode = n;
    }

    final void setCombineAlphaMode(int n) {
        this.initCombineAlphaMode(n);
        this.sendMessage(64, enums[n], null);
    }

    final int getCombineAlphaMode() {
        return this.combineAlphaMode;
    }

    final void initCombineRgbSource(int n, int n2) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        this.combineRgbSrc[n] = n2;
    }

    final void setCombineRgbSource(int n, int n2) {
        this.initCombineRgbSource(n, n2);
        this.sendMessage(128, enums[n], enums[n2]);
    }

    final int getCombineRgbSource(int n) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        return this.combineRgbSrc[n];
    }

    final void initCombineAlphaSource(int n, int n2) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        this.combineAlphaSrc[n] = n2;
    }

    final void setCombineAlphaSource(int n, int n2) {
        this.initCombineAlphaSource(n, n2);
        this.sendMessage(256, enums[n], enums[n2]);
    }

    final int getCombineAlphaSource(int n) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        return this.combineAlphaSrc[n];
    }

    final void initCombineRgbFunction(int n, int n2) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        this.combineRgbFcn[n] = n2;
    }

    final void setCombineRgbFunction(int n, int n2) {
        this.initCombineRgbFunction(n, n2);
        this.sendMessage(512, enums[n], enums[n2]);
    }

    final int getCombineRgbFunction(int n) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        return this.combineRgbFcn[n];
    }

    final void initCombineAlphaFunction(int n, int n2) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        this.combineAlphaFcn[n] = n2;
    }

    final void setCombineAlphaFunction(int n, int n2) {
        this.initCombineAlphaFunction(n, n2);
        this.sendMessage(1024, enums[n], enums[n2]);
    }

    final int getCombineAlphaFunction(int n) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        return this.combineAlphaFcn[n];
    }

    final void initCombineRgbScale(int n) {
        this.combineRgbScale = n;
    }

    final void setCombineRgbScale(int n) {
        this.initCombineRgbScale(n);
        this.sendMessage(2048, enums[n], null);
    }

    final int getCombineRgbScale() {
        return this.combineRgbScale;
    }

    final void initCombineAlphaScale(int n) {
        this.combineAlphaScale = n;
    }

    final void setCombineAlphaScale(int n) {
        this.initCombineAlphaScale(n);
        this.sendMessage(4096, enums[n], null);
    }

    final int getCombineAlphaScale() {
        return this.combineAlphaScale;
    }

    native void updateNative(long var1, double[] var3, boolean var4, int var5, int var6, float var7, float var8, float var9, float var10, int var11);

    native void updateNativeRegisterCombiners(long var1, double[] var3, boolean var4, int var5, int var6, float var7, float var8, float var9, float var10, int var11, int var12, int var13, int[] var14, int[] var15, int[] var16, int[] var17, int var18, int var19);

    native void updateTextureColorTableNative(long var1, int var3, int var4, int[] var5);

    native void updateCombinerNative(long var1, int var3, int var4, int[] var5, int[] var6, int[] var7, int[] var8, int var9, int var10);

    native void restoreBlend1Pass(long var1);

    native void updateBlend2Pass(long var1);

    void updateNative(Canvas3D canvas3D, boolean bl, int n) {
        boolean bl2;
        boolean bl3 = bl2 = (this.transform.getType() & 2) != 0;
        if (!bl) {
            if (VirtualUniverse.mc.useCombiners && (canvas3D.textureExtendedFeatures & 0x40) != 0) {
                this.updateNativeRegisterCombiners(canvas3D.ctx, this.transform.mat, bl2, this.textureMode, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, n, this.combineRgbMode, this.combineAlphaMode, this.combineRgbSrc, this.combineAlphaSrc, this.combineRgbFcn, this.combineAlphaFcn, this.combineRgbScale, this.combineAlphaScale);
            } else if (this.textureMode == 6) {
                if ((canvas3D.textureExtendedFeatures & 8) != 0) {
                    int n2 = this.combineRgbMode;
                    int n3 = this.combineAlphaMode;
                    this.updateNative(canvas3D.ctx, this.transform.mat, bl2, this.textureMode, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, n);
                    if (this.combineRgbMode == 6 && (canvas3D.textureExtendedFeatures & 0x10) == 0 || this.combineRgbMode == 4 && (canvas3D.textureExtendedFeatures & 0x20) == 0) {
                        n2 = 0;
                    }
                    if (this.combineAlphaMode == 6 && (canvas3D.textureExtendedFeatures & 0x10) == 0 || this.combineAlphaMode == 4 && (canvas3D.textureExtendedFeatures & 0x20) == 0) {
                        n3 = 0;
                    }
                    this.updateCombinerNative(canvas3D.ctx, n2, n3, this.combineRgbSrc, this.combineAlphaSrc, this.combineRgbFcn, this.combineAlphaFcn, this.combineRgbScale, this.combineAlphaScale);
                } else {
                    this.updateNative(canvas3D.ctx, this.transform.mat, bl2, 5, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, n);
                }
            } else {
                this.updateNative(canvas3D.ctx, this.transform.mat, bl2, this.textureMode, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, n);
            }
            if ((canvas3D.textureExtendedFeatures & 2) != 0 && this.textureColorTable != null) {
                this.updateTextureColorTableNative(canvas3D.ctx, this.numTextureColorTableComponents, this.textureColorTableSize, this.textureColorTable);
            }
        } else {
            this.updateNative(canvas3D.ctx, this.transform.mat, bl2, 5, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, n);
            if ((canvas3D.textureExtendedFeatures & 2) != 0 && this.textureColorTable != null) {
                this.updateTextureColorTableNative(canvas3D.ctx, this.numTextureColorTableComponents, this.textureColorTableSize, this.textureColorTable);
            }
            switch (this.textureMode) {
                case 5: 
                case 6: {
                    canvas3D.setBlendFunc(canvas3D.ctx, 1, 0);
                    break;
                }
                case 2: {
                    canvas3D.setBlendFunc(canvas3D.ctx, 4, 0);
                    break;
                }
                case 3: {
                    if (n == 6) {
                        canvas3D.setBlendFunc(canvas3D.ctx, 2, 3);
                        break;
                    }
                    canvas3D.setBlendFunc(canvas3D.ctx, 1, 0);
                    break;
                }
                case 4: {
                    canvas3D.setBlendColor(canvas3D.ctx, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w);
                    canvas3D.setBlendFunc(canvas3D.ctx, 7, 6);
                }
            }
        }
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                TextureAttributesRetained textureAttributesRetained = new TextureAttributesRetained();
                textureAttributesRetained.source = this.source;
                textureAttributesRetained.set(this);
                this.mirror = textureAttributesRetained;
            }
        } else {
            ((TextureAttributesRetained)this.mirror).set(this);
        }
    }

    synchronized void initMirrorObject() {
        ((TextureAttributesRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int n, Object object, Object object2) {
        TextureAttributesRetained textureAttributesRetained = (TextureAttributesRetained)this.mirror;
        textureAttributesRetained.mirrorCompDirty = true;
        if ((n & 1) != 0) {
            textureAttributesRetained.transform.set((Transform3D)object);
            FreeListManager.freeObject(2, (Transform3D)object);
        } else if ((n & 2) != 0) {
            textureAttributesRetained.textureMode = (Integer)object;
            if (textureAttributesRetained.textureMode == 6 && textureAttributesRetained.combineRgbSrc == null) {
                this.initCombineMode(textureAttributesRetained);
            }
        } else if ((n & 4) != 0) {
            textureAttributesRetained.textureBlendColor.set((Tuple4f)((Color4f)object));
        } else if ((n & 8) != 0) {
            textureAttributesRetained.perspCorrectionMode = (Integer)object;
        } else if ((n & 0x10) != 0) {
            if (object == null) {
                textureAttributesRetained.textureColorTable = null;
                textureAttributesRetained.numTextureColorTableComponents = 0;
                textureAttributesRetained.textureColorTableSize = 0;
            } else {
                Object[] objectArray = (Object[])object;
                textureAttributesRetained.textureColorTable = (int[])objectArray[2];
                textureAttributesRetained.numTextureColorTableComponents = (Integer)objectArray[0];
                textureAttributesRetained.textureColorTableSize = (Integer)objectArray[1];
            }
        } else if ((n & 0x20) != 0) {
            textureAttributesRetained.combineRgbMode = (Integer)object;
        } else if ((n & 0x40) != 0) {
            textureAttributesRetained.combineAlphaMode = (Integer)object;
        } else if ((n & 0x80) != 0) {
            if (textureAttributesRetained.combineRgbSrc == null) {
                this.initCombineMode(textureAttributesRetained);
            }
            int n2 = (Integer)object;
            textureAttributesRetained.combineRgbSrc[n2] = (Integer)object2;
        } else if ((n & 0x100) != 0) {
            if (textureAttributesRetained.combineRgbSrc == null) {
                this.initCombineMode(textureAttributesRetained);
            }
            int n3 = (Integer)object;
            textureAttributesRetained.combineAlphaSrc[n3] = (Integer)object2;
        } else if ((n & 0x200) != 0) {
            if (textureAttributesRetained.combineRgbSrc == null) {
                this.initCombineMode(textureAttributesRetained);
            }
            int n4 = (Integer)object;
            textureAttributesRetained.combineRgbFcn[n4] = (Integer)object2;
        } else if ((n & 0x400) != 0) {
            if (textureAttributesRetained.combineRgbSrc == null) {
                this.initCombineMode(textureAttributesRetained);
            }
            int n5 = (Integer)object;
            textureAttributesRetained.combineAlphaFcn[n5] = (Integer)object2;
        } else if ((n & 0x800) != 0) {
            textureAttributesRetained.combineRgbScale = (Integer)object;
        } else if ((n & 0x1000) != 0) {
            textureAttributesRetained.combineAlphaScale = (Integer)object;
        }
    }

    boolean equivalent(TextureAttributesRetained textureAttributesRetained) {
        int n;
        if (textureAttributesRetained == null) {
            return false;
        }
        if (this.changedFrequent != 0 || textureAttributesRetained.changedFrequent != 0) {
            return this == textureAttributesRetained;
        }
        if (!textureAttributesRetained.transform.equals(this.transform) || !textureAttributesRetained.textureBlendColor.equals((Tuple4f)this.textureBlendColor) || textureAttributesRetained.textureMode != this.textureMode || textureAttributesRetained.perspCorrectionMode != this.perspCorrectionMode) {
            return false;
        }
        if (this.textureMode == 6) {
            if (textureAttributesRetained.combineRgbMode != this.combineRgbMode || textureAttributesRetained.combineAlphaMode != this.combineAlphaMode || textureAttributesRetained.combineRgbScale != this.combineRgbScale || textureAttributesRetained.combineAlphaScale != this.combineAlphaScale) {
                return false;
            }
            n = 0;
            n = this.combineRgbMode == 0 ? 1 : (this.combineRgbMode == 5 ? 3 : 2);
            for (int i = 0; i < n; ++i) {
                if (textureAttributesRetained.combineRgbSrc[i] == this.combineRgbSrc[i] && textureAttributesRetained.combineAlphaSrc[i] == this.combineAlphaSrc[i] && textureAttributesRetained.combineRgbFcn[i] == this.combineRgbFcn[i] && textureAttributesRetained.combineAlphaFcn[i] == this.combineAlphaFcn[i]) continue;
                return false;
            }
        }
        if (textureAttributesRetained.textureColorTable == null) {
            return this.textureColorTable == null;
        }
        if (this.textureColorTable == null) {
            return false;
        }
        if (textureAttributesRetained.textureColorTable.length != this.textureColorTable.length) {
            return false;
        }
        for (n = 0; n < this.textureColorTable.length; ++n) {
            if (this.textureColorTable[n] == textureAttributesRetained.textureColorTable[n]) continue;
            return false;
        }
        return true;
    }

    protected Object clone() {
        TextureAttributesRetained textureAttributesRetained = (TextureAttributesRetained)super.clone();
        textureAttributesRetained.transform = new Transform3D(this.transform);
        textureAttributesRetained.textureBlendColor = new Color4f(this.textureBlendColor);
        if (this.textureColorTable != null) {
            textureAttributesRetained.textureColorTable = new int[this.textureColorTable.length];
            System.arraycopy(this.textureColorTable, 0, textureAttributesRetained.textureColorTable, 0, this.textureColorTable.length);
        } else {
            textureAttributesRetained.textureColorTable = null;
        }
        if (this.combineRgbSrc != null) {
            textureAttributesRetained.combineRgbSrc = new int[3];
            textureAttributesRetained.combineAlphaSrc = new int[3];
            textureAttributesRetained.combineRgbFcn = new int[3];
            textureAttributesRetained.combineAlphaFcn = new int[3];
            for (int i = 0; i < 3; ++i) {
                textureAttributesRetained.combineRgbSrc[i] = this.combineRgbSrc[i];
                textureAttributesRetained.combineAlphaSrc[i] = this.combineAlphaSrc[i];
                textureAttributesRetained.combineRgbFcn[i] = this.combineRgbFcn[i];
                textureAttributesRetained.combineAlphaFcn[i] = this.combineAlphaFcn[i];
            }
        }
        return textureAttributesRetained;
    }

    protected void set(TextureAttributesRetained textureAttributesRetained) {
        super.set(textureAttributesRetained);
        this.transform.set(textureAttributesRetained.transform);
        this.textureBlendColor.set((Tuple4f)textureAttributesRetained.textureBlendColor);
        this.textureMode = textureAttributesRetained.textureMode;
        this.perspCorrectionMode = textureAttributesRetained.perspCorrectionMode;
        if (textureAttributesRetained.textureColorTable != null) {
            if (this.textureColorTable == null || this.textureColorTable.length != textureAttributesRetained.textureColorTable.length) {
                this.textureColorTable = new int[textureAttributesRetained.textureColorTable.length];
            }
            System.arraycopy(textureAttributesRetained.textureColorTable, 0, this.textureColorTable, 0, textureAttributesRetained.textureColorTable.length);
        } else {
            this.textureColorTable = null;
        }
        this.numTextureColorTableComponents = textureAttributesRetained.numTextureColorTableComponents;
        this.textureColorTableSize = textureAttributesRetained.textureColorTableSize;
        this.combineRgbMode = textureAttributesRetained.combineRgbMode;
        this.combineAlphaMode = textureAttributesRetained.combineAlphaMode;
        this.combineRgbScale = textureAttributesRetained.combineRgbScale;
        this.combineAlphaScale = textureAttributesRetained.combineAlphaScale;
        if (textureAttributesRetained.combineRgbSrc != null) {
            if (this.combineRgbSrc == null) {
                this.combineRgbSrc = new int[3];
                this.combineAlphaSrc = new int[3];
                this.combineRgbFcn = new int[3];
                this.combineAlphaFcn = new int[3];
            }
            for (int i = 0; i < 3; ++i) {
                this.combineRgbSrc[i] = textureAttributesRetained.combineRgbSrc[i];
                this.combineAlphaSrc[i] = textureAttributesRetained.combineAlphaSrc[i];
                this.combineRgbFcn[i] = textureAttributesRetained.combineRgbFcn[i];
                this.combineAlphaFcn[i] = textureAttributesRetained.combineAlphaFcn[i];
            }
        }
    }

    final void sendMessage(int n, Object object, Object object2) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 11;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = object2;
        j3dMessage.args[4] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 11;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void handleFrequencyChange(int n) {
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                this.setFrequencyChangeMask(n, n);
            }
        }
    }
}

