/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.finder.Hierarchy;
import abbot.i18n.Strings;
import abbot.tester.Robot;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ComponentNode
extends DefaultMutableTreeNode {
    private Hierarchy hierarchy;
    private Map map;
    private boolean loaded;

    public ComponentNode(Hierarchy hierarchy) {
        super(null, true);
        this.hierarchy = hierarchy;
        this.map = new WeakHashMap();
    }

    protected ComponentNode(ComponentNode parent, Object obj) {
        super(obj, obj == null || obj instanceof Container || obj instanceof MenuContainer);
        this.hierarchy = parent.hierarchy;
        this.map = parent.map;
        this.map.put(obj, this);
    }

    public ComponentNode(ComponentNode parent, Component comp) {
        this(parent, (Object)comp);
    }

    public ComponentNode(ComponentNode parent, MenuComponent comp) {
        this(parent, (Object)comp);
    }

    public ComponentNode(ComponentNode parent, MenuItem comp) {
        this(parent, (Object)comp);
    }

    public TreeNode getChildAt(int index) {
        this.load();
        return super.getChildAt(index);
    }

    public int getChildCount() {
        this.load();
        return super.getChildCount();
    }

    public void reload() {
        this.reload(this.hierarchy);
    }

    public void reload(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.map.clear();
        this.loaded = false;
    }

    private void load() {
        block7: {
            Object obj;
            block9: {
                block8: {
                    Frame f;
                    block6: {
                        if (this.loaded) {
                            return;
                        }
                        this.loaded = true;
                        this.removeAllChildren();
                        obj = this.getUserObject();
                        if (!this.isRoot()) break block6;
                        Iterator iter = this.hierarchy.getRoots().iterator();
                        while (iter.hasNext()) {
                            this.add(new ComponentNode(this, (Component)iter.next()));
                        }
                        break block7;
                    }
                    if (!(obj instanceof Container)) break block8;
                    if (obj instanceof Frame && (f = (Frame)obj).getMenuBar() != null) {
                        this.add(new ComponentNode(this, f.getMenuBar()));
                    }
                    Collection children = this.hierarchy.getComponents(this.getComponent());
                    Iterator iter = children.iterator();
                    while (iter.hasNext()) {
                        this.add(new ComponentNode(this, (Component)iter.next()));
                    }
                    break block7;
                }
                if (!(obj instanceof MenuBar)) break block9;
                MenuBar mb = (MenuBar)obj;
                for (int i = 0; i < mb.getMenuCount(); ++i) {
                    this.add(new ComponentNode(this, mb.getMenu(i)));
                }
                break block7;
            }
            if (!(obj instanceof Menu)) break block7;
            Menu menu = (Menu)obj;
            for (int i = 0; i < menu.getItemCount(); ++i) {
                this.add(new ComponentNode(this, menu.getItem(i)));
            }
        }
    }

    Component getParent(Component c) {
        return this.hierarchy.getParent(c);
    }

    public Component getComponent() {
        if (this.getUserObject() instanceof Component) {
            return (Component)this.getUserObject();
        }
        return null;
    }

    public int hashCode() {
        return this.isRoot() ? super.hashCode() : this.getUserObject().hashCode();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ComponentNode && this.getUserObject() == ((ComponentNode)other).getUserObject();
    }

    public String toString() {
        if (this.isRoot()) {
            return this.getChildCount() == 0 ? Strings.get("NoComponents") : Strings.get("AllFrames");
        }
        return Robot.toString(this.getUserObject());
    }

    public ComponentNode getNode(Component comp) {
        if (comp == null) {
            return (ComponentNode)this.getRoot();
        }
        ComponentNode node = (ComponentNode)this.map.get(comp);
        if (node == null) {
            Component parentComp = this.getParent(comp);
            ComponentNode parent = this.getNode(parentComp);
            if (parent == null) {
                return this.getNode(parentComp);
            }
            node = parent;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                ComponentNode child = (ComponentNode)parent.getChildAt(i);
                if (child.getComponent() != comp) continue;
                node = child;
                break;
            }
        }
        return node;
    }

    public TreePath getPath(Component comp) {
        ComponentNode node = this.getNode(comp);
        return new TreePath(node.getPath());
    }
}

