/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.finder.Hierarchy;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Script;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class HierarchyWriter {
    private Hierarchy hierarchy;

    public HierarchyWriter(Hierarchy h) {
        this.hierarchy = h;
    }

    public void writeHierarchy(Writer writer) throws IOException {
        Script r = new Script(this.hierarchy);
        writer.write("<awtHierarchy>\r\n");
        Iterator iter = this.hierarchy.getRoots().iterator();
        while (iter.hasNext()) {
            this.writeComponent(writer, r, (Window)iter.next(), 1);
        }
        writer.write("</awtHierarchy>\r\n");
        writer.close();
    }

    private void writeComponent(Writer writer, Resolver r, Component c, int level) throws IOException {
        ComponentReference ref = new ComponentReference(r, c);
        String INDENT = "  ";
        String xml = ref.toXMLString();
        for (int i = 0; i < level; ++i) {
            writer.write("  ");
        }
        Collection set = this.hierarchy.getComponents(c);
        if (set.size() != 0) {
            writer.write(xml.substring(0, xml.length() - 2));
            writer.write(">\r\n");
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                this.writeComponent(writer, r, (Component)iter.next(), level + 1);
            }
            for (int i = 0; i < level; ++i) {
                writer.write("  ");
            }
            writer.write("</component>\r\n");
        } else {
            writer.write(xml);
            writer.write("\r\n");
        }
    }
}

