/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.Log;
import abbot.editor.ScriptModel;
import abbot.editor.StepTransferable;
import abbot.script.Script;
import abbot.script.Sequence;
import abbot.script.Step;
import abbot.script.Terminate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;

public class ScriptTable
extends JTable
implements Autoscroll {
    private int cursorRow = 0;
    private Sequence cursorParent = null;
    private int cursorParentIndex = 0;
    private int cursorDepth = 0;
    private boolean isDragging = false;
    private DragSource dragSource;
    private DragSourceListener dragSourceListener;
    private static Icon openIcon;
    private static Icon closedIcon;
    private static int baseIndent;
    private static final int MARGIN = 4;
    private ScriptModel model;
    private static final int AUTOSCROLL_MARGIN = 12;

    public ScriptTable() {
        this(new ScriptModel());
    }

    public ScriptTable(ScriptModel scriptModel) {
        super(scriptModel);
        this.setSelectionModel(new SelectionModel());
        this.model = scriptModel;
        ScriptTableCellRenderer cr = new ScriptTableCellRenderer();
        this.setDefaultRenderer(Object.class, cr);
        Dimension spacing = this.getIntercellSpacing();
        spacing.height = 2;
        this.setIntercellSpacing(spacing);
        this.initDragDrop();
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getModifiers() != 16) {
                    return;
                }
                if (me.getClickCount() == 2) {
                    int row = ScriptTable.this.rowAtPoint(me.getPoint());
                    Log.debug("Toggling row at " + row);
                    ScriptTable.this.toggle(row);
                } else {
                    ScriptTable.this.click(me.getPoint());
                }
            }
        };
        this.addMouseListener(ml);
        ActionMap map = this.getActionMap();
        map.put("move-rows-up", new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                ScriptTable.this.moveUp();
            }
        });
        map.put("move-rows-down", new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                ScriptTable.this.moveDown();
            }
        });
        map.put("toggle", new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                int selRow = ScriptTable.this.getSelectedRow();
                if (selRow != -1) {
                    ScriptTable.this.toggle(selRow);
                }
            }
        });
    }

    public void toggle(int row) {
        int[] rows = this.getSelectedRows();
        if (rows.length > 0) {
            int anchor = this.getSelectionModel().getAnchorSelectionIndex();
            Step first = this.model.getStepAt(rows[0]);
            int lastRow = rows[rows.length - 1];
            Step last = this.model.getStepAt(lastRow);
            Step afterLast = lastRow < this.getRowCount() - 1 ? this.model.getStepAt(lastRow + 1) : null;
            this.clearSelection();
            this.model.toggle(row);
            int index0 = this.model.getRowOf(first);
            int index1 = this.model.getRowOf(last);
            if (index1 == -1) {
                int n = index1 = afterLast == null ? row : this.model.getRowOf(afterLast) - 1;
            }
            if (anchor == index0) {
                Log.debug("Updating selection to " + index0 + " to " + index1);
                this.setRowSelectionInterval(index0, index1);
            } else {
                Log.debug("Updating selection to " + index1 + " to " + index0);
                this.setRowSelectionInterval(index1, index0);
            }
        } else {
            this.model.toggle(row);
        }
    }

    public Rectangle getCellRect(int row, int col, boolean includeBorder) {
        Rectangle rect = super.getCellRect(row, col, includeBorder);
        int indent = this.getIndentation(row);
        rect.x += indent;
        rect.width -= indent;
        return rect;
    }

    public int getIndentation(int row) {
        return this.getDepthIndentation(this.model.getNestingDepthAt(row));
    }

    public int getDepthIndentation(int depth) {
        return baseIndent * depth;
    }

    private void click(Point pt) {
        int row = this.rowAtPoint(pt);
        if (row == -1) {
            this.clearSelection();
            this.setCursorLocation(this.getRowCount());
        } else {
            Rectangle rect = this.getCellRect(row, 0, true);
            if (this.model.getStepAt(row) instanceof Sequence && pt.x >= rect.x && pt.x < rect.x + baseIndent && pt.y > rect.y + rect.height / 4 && pt.y < rect.y + rect.height * 3 / 4) {
                this.toggle(row);
            } else {
                this.setCursorLocation(pt);
            }
        }
    }

    private void initDragDrop() {
        int action = 2;
        this.dragSource = DragSource.getDefaultDragSource();
        DGListener dgl = new DGListener();
        this.dragSource.createDefaultDragGestureRecognizer(this, action, dgl);
        this.dragSourceListener = new DSListener();
        DropTarget dt = new DropTarget(this, new DTListener());
        dt.setDefaultActions(2);
    }

    protected Color getStepColor(Step step, boolean selected) {
        return selected ? this.getSelectionBackground() : this.getBackground();
    }

    public Script getScriptContext() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return this.model.getScript();
        }
        return this.model.getScriptOf(row);
    }

    public int getCursorRow() {
        return this.cursorRow;
    }

    public Sequence getCursorParent() {
        return this.cursorParent;
    }

    public int getCursorParentIndex() {
        return this.cursorParentIndex;
    }

    protected Rectangle getCursorBounds() {
        Insets insets = this.getInsets();
        Dimension d = this.getSize();
        Dimension m = this.getIntercellSpacing();
        if (m.height == 0) {
            m.height = 1;
        }
        int width = d.width - insets.left - insets.right;
        int row = Math.min(this.cursorRow, this.getRowCount() - 1);
        Rectangle cellRect = super.getCellRect(row, 0, false);
        int y = cellRect.y;
        if (this.cursorRow == this.getRowCount()) {
            y += cellRect.height + m.height;
        }
        int indent = this.getDepthIndentation(this.cursorDepth);
        return new Rectangle(indent, y - m.height, width - indent, m.height);
    }

    private int getCursorRowAtPoint(Point where) {
        int row = this.rowAtPoint(where);
        if (row == -1) {
            row = where.y < 0 ? 0 : this.getRowCount();
        } else {
            Rectangle rect = super.getCellRect(row, 0, true);
            if (where.getY() > (double)(rect.y + rect.height / 2)) {
                ++row;
            }
        }
        if (this.isDragging) {
            int selStart = this.getSelectedRow();
            int count = this.getSelectedRowCount();
            if (row > selStart && row <= selStart + count) {
                row = row > count / 2 && selStart + count + 1 < this.getRowCount() ? selStart + count + 1 : selStart;
            }
        }
        return row;
    }

    public void setCursorLocation(Point where) {
        int row = this.getCursorRowAtPoint(where);
        this.setCursorLocation(row, where.x);
    }

    private void setCursorLocation(int row, int indentation) {
        Rectangle oldRect = this.getCursorBounds();
        Script script = this.model.getScript();
        if (script == null) {
            return;
        }
        if (script.hasTerminate() && row == this.getRowCount()) {
            --row;
        } else if (script.hasLaunch() && row == 0) {
            ++row;
        }
        this.cursorRow = row;
        Sequence parent = script;
        int index = row == this.getRowCount() ? parent.size() : parent.indexOf(this.model.getStepAt(row));
        int depth = 0;
        if (row > 0) {
            Step prev = this.model.getStepAt(row - 1);
            if (this.model.isOpen(prev)) {
                parent = (Sequence)prev;
                index = 0;
                depth = this.model.getNestingDepthAt(row - 1) + 1;
            } else {
                parent = this.model.getParent(prev);
                index = parent.indexOf(prev) + 1;
                depth = this.model.getNestingDepthAt(row - 1);
            }
            int indent = this.getDepthIndentation(depth);
            while (indent > indentation && parent != script) {
                Sequence nextUp = this.model.getParent(parent);
                index = nextUp.indexOf(parent) + 1;
                parent = nextUp;
                indent = this.getDepthIndentation(--depth);
            }
        }
        this.cursorParent = parent;
        this.cursorParentIndex = index;
        this.cursorDepth = depth;
        if (oldRect != null) {
            this.repaint(oldRect);
        }
        this.repaint(this.getCursorBounds());
    }

    public void setCursorLocation(int row) {
        this.setCursorLocation(row, 0);
    }

    protected void drawCursor(Graphics g, int row) {
        g.setColor(Color.green);
        ((Graphics2D)g).fill(this.getCursorBounds());
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.drawCursor(g, this.cursorRow == this.getRowCount() ? this.cursorRow - 1 : this.cursorRow);
    }

    public void autoscroll(Point pt) {
        Rectangle bounds = this.getBounds();
        Log.debug("autoscroll at " + pt + " bounds " + bounds);
        int row = this.rowAtPoint(pt);
        if (row < 0) {
            return;
        }
        if (pt.y + bounds.y <= 12) {
            if (row > 0) {
                --row;
            }
        } else if (row < this.getRowCount() - 1) {
            ++row;
        }
        this.scrollRectToVisible(this.getCellRect(row, 0, true));
    }

    public Insets getAutoscrollInsets() {
        Rectangle tree = this.getBounds();
        Rectangle view = this.getParent().getBounds();
        return new Insets(view.y - tree.y + 12, view.x - tree.x + 12, tree.height - view.height - view.y + tree.y + 12, tree.width - view.width - view.x + tree.x + 12);
    }

    public Step getSelectedStep() {
        return this.getSelectedRowCount() > 0 ? this.model.getStepAt(this.getSelectedRow()) : null;
    }

    public List getSelectedSteps() {
        ArrayList<Step> list = new ArrayList<Step>();
        int[] rows = this.getSelectedRows();
        if (rows.length > 0) {
            Step step = this.model.getStepAt(rows[0]);
            Sequence parent = this.model.getParent(step);
            for (int i = 0; i < rows.length; ++i) {
                step = this.model.getStepAt(rows[i]);
                if (this.model.getParent(step) != parent) continue;
                list.add(step);
            }
        }
        return list;
    }

    public boolean canMoveDown() {
        int[] rows = this.getSelectedRows();
        int max = this.getRowCount() - (this.model.getScript().hasTerminate() ? 2 : 1);
        return rows[rows.length - 1] < max;
    }

    public boolean canMoveUp() {
        int row = this.getSelectedRow();
        int min = this.model.getScript().hasLaunch() ? 1 : 0;
        return row > min && !(this.model.getStepAt(row) instanceof Terminate);
    }

    public void moveUp() {
        if (!this.canMoveUp()) {
            return;
        }
        List list = this.getSelectedSteps();
        int leadRow = this.getSelectedRow();
        Step lead = (Step)list.get(0);
        Sequence parent = this.model.getParent(lead);
        Step prev = this.model.getStepAt(leadRow - 1);
        int targetIndex = 0;
        if (parent.indexOf(lead) == 0) {
            Log.debug("Move out of sequence");
            Sequence newParent = this.model.getParent(parent);
            targetIndex = newParent.indexOf(parent);
            parent = newParent;
        } else if (this.model.isOpen(prev)) {
            Log.debug("Move to previous empty open sequence");
            parent = (Sequence)prev;
            targetIndex = 0;
        } else if (this.model.getParent(prev) != parent) {
            Log.debug("Move to previous open sequence");
            parent = this.model.getParent(prev);
            targetIndex = parent.indexOf(prev) + 1;
        } else {
            Log.debug("Move previous");
            targetIndex = parent.indexOf(prev);
        }
        this.moveSelectedRows(parent, targetIndex);
    }

    public void moveDown() {
        if (!this.canMoveDown()) {
            Log.warn("Unexpected move down state");
            return;
        }
        List list = this.getSelectedSteps();
        Step lead = (Step)list.get(0);
        Sequence leadParent = this.model.getParent(lead);
        int[] rows = this.getSelectedRows();
        Step next = this.model.getStepAt(rows[rows.length - 1] + 1);
        Sequence parent = this.model.getParent(next);
        int targetIndex = parent.indexOf(next) + 1;
        if (leadParent != parent) {
            Sequence nextParent = this.model.getParent(leadParent);
            targetIndex = nextParent.indexOf(leadParent) + 1;
            parent = nextParent;
        } else if (this.model.isOpen(next)) {
            parent = (Sequence)next;
            targetIndex = 0;
        }
        this.moveSelectedRows(parent, targetIndex);
    }

    public void moveSelectedRows(Sequence parent, int index) {
        List steps = this.getSelectedSteps();
        Step first = (Step)steps.get(0);
        if (parent.indexOf(first) == index) {
            return;
        }
        ListSelectionModel lsm = this.getSelectionModel();
        boolean firstIsAnchor = this.getSelectedRow() == lsm.getAnchorSelectionIndex();
        this.model.moveSteps(parent, steps, index);
        int firstRow = this.model.getRowOf(first);
        if (firstIsAnchor) {
            lsm.setSelectionInterval(firstRow, firstRow + steps.size() - 1);
        } else {
            lsm.setSelectionInterval(firstRow + steps.size() - 1, firstRow);
        }
    }

    static {
        URL url1 = ScriptTable.class.getResource("icons/triangle-dn.gif");
        URL url2 = ScriptTable.class.getResource("icons/triangle-rt.gif");
        if (url1 != null && url2 != null) {
            openIcon = new ImageIcon(url1);
            closedIcon = new ImageIcon(url2);
        } else {
            BasicTreeUI ui = (BasicTreeUI)new JTree().getUI();
            openIcon = ui.getExpandedIcon();
            closedIcon = ui.getCollapsedIcon();
        }
        baseIndent = openIcon.getIconWidth();
    }

    private class SelectionModel
    extends DefaultListSelectionModel {
        public SelectionModel() {
            this.setSelectionMode(1);
        }

        private void fixSelection() {
            int last;
            int i;
            int loDepth;
            int hi;
            int lo;
            int lead;
            if (ScriptTable.this.getSelectedRowCount() == 0 || ScriptTable.this.getSelectedRowCount() == 1 && !ScriptTable.this.model.isOpen(ScriptTable.this.getSelectedRow())) {
                return;
            }
            int anchor = this.getAnchorSelectionIndex();
            if (anchor < (lead = this.getLeadSelectionIndex())) {
                lo = anchor;
                hi = lead;
            } else {
                lo = lead;
                hi = anchor;
            }
            int minDepth = loDepth = ScriptTable.this.model.getNestingDepthAt(lo);
            for (i = lo + 1; i <= hi; ++i) {
                minDepth = Math.min(minDepth, ScriptTable.this.model.getNestingDepthAt(i));
            }
            if (loDepth > minDepth) {
                for (i = lo - 1; i >= 0; --i) {
                    if (ScriptTable.this.model.getNestingDepthAt(i) != minDepth) continue;
                    Log.debug("Changing low end to " + i);
                    if (lo == anchor) {
                        lo = i;
                        this.setSelectionInterval(lo, hi);
                        break;
                    }
                    lo = i;
                    this.setSelectionInterval(hi, lo);
                    break;
                }
            }
            for (last = hi + 1; last < ScriptTable.this.getRowCount() && ScriptTable.this.model.getNestingDepthAt(last) > minDepth; ++last) {
            }
            if (last > hi + 1) {
                Log.debug("Changing hi end to " + (last - 1));
                if (hi == lead) {
                    this.setSelectionInterval(lo, last - 1);
                } else {
                    this.setSelectionInterval(last - 1, lo);
                }
            }
        }

        public void addSelectionInterval(int index0, int index1) {
            super.addSelectionInterval(index0, index1);
            this.fixSelection();
        }

        public void removeSelectionInterval(int index0, int index1) {
            super.removeSelectionInterval(index0, index1);
            this.fixSelection();
        }

        public void setAnchorSelectionIndex(int index) {
            super.setAnchorSelectionIndex(index);
            this.fixSelection();
        }

        public void setLeadSelectionIndex(int index) {
            super.setLeadSelectionIndex(index);
            this.fixSelection();
        }

        public void setSelectionInterval(int index0, int index1) {
            super.setSelectionInterval(index0, index1);
            this.fixSelection();
        }

        public void insertIndexInterval(int index, int length, boolean bfore) {
            super.insertIndexInterval(index, length, bfore);
            this.fixSelection();
        }

        public void removeIndexInterval(int idx0, int idx1) {
            super.removeIndexInterval(idx0, idx1);
            this.fixSelection();
        }
    }

    private class DTListener
    implements DropTargetListener {
        private DTListener() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            if (!this.isDragAcceptable(e)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(2);
            }
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            if (!this.isDragAcceptable(e)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(2);
            }
        }

        public void dragOver(DropTargetDragEvent e) {
            Log.debug("drag over target " + e.getDropAction());
            if (this.isDragAcceptable(e)) {
                e.acceptDrag(2);
                Rectangle last = ScriptTable.this.getCursorBounds();
                ScriptTable.this.setCursorLocation(e.getLocation());
                Rectangle current = ScriptTable.this.getCursorBounds();
                ScriptTable.this.paintImmediately(last);
                ScriptTable.this.paintImmediately(current);
            } else {
                e.rejectDrag();
            }
        }

        public void drop(DropTargetDropEvent e) {
            Log.debug("drop successful " + e.getDropAction());
            if (!this.isDropAcceptable(e)) {
                e.rejectDrop();
            } else {
                e.acceptDrop(2);
                ScriptTable.this.moveSelectedRows(ScriptTable.this.cursorParent, ScriptTable.this.cursorParentIndex);
            }
            e.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            Log.debug("drag action is " + e.getDropAction());
            return e.isDataFlavorSupported(StepTransferable.STEP_FLAVOR);
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            Log.debug("drop action is " + e.getDropAction());
            return e.isDataFlavorSupported(StepTransferable.STEP_FLAVOR);
        }
    }

    private class DSListener
    implements DragSourceListener {
        private DSListener() {
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            Log.debug("drag drop end " + e.getDropAction());
            if (!e.getDropSuccess()) {
                Log.debug("drop failed");
            }
        }

        public void dragEnter(DragSourceDragEvent e) {
            Log.debug("drag enter " + e.getDropAction());
            DragSourceContext context = e.getDragSourceContext();
            int action = e.getDropAction();
            if ((action & 2) != 0) {
                context.setCursor(DragSource.DefaultMoveDrop);
            } else {
                context.setCursor(DragSource.DefaultMoveNoDrop);
            }
        }

        public void dragOver(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
        }

        public void dropActionChanged(DragSourceDragEvent e) {
            Log.debug("action changed " + e.getDropAction());
            DragSourceContext context = e.getDragSourceContext();
            context.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    private class DGListener
    implements DragGestureListener {
        private DGListener() {
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            Point where = e.getDragOrigin();
            int firstRow = ScriptTable.this.getSelectedRow();
            if (firstRow == -1) {
                return;
            }
            if ((e.getDragAction() & 2) != 0) {
                StepTransferable tf = ScriptTable.this.getSelectedRowCount() > 1 ? new StepTransferable(ScriptTable.this.getSelectedSteps()) : new StepTransferable(ScriptTable.this.getSelectedStep());
                try {
                    Rectangle rect = ScriptTable.this.getCellRect(firstRow, 0, true);
                    int count = ScriptTable.this.getSelectedRowCount();
                    rect.height *= count;
                    Point offset = new Point(rect.x - where.x, rect.y - where.y);
                    rect.y = 0;
                    rect.x = 0;
                    BufferedImage image = new BufferedImage(rect.width, rect.height, 3);
                    Graphics2D graphics = image.createGraphics();
                    graphics.setColor(Color.gray);
                    --rect.width;
                    --rect.height;
                    graphics.draw(rect);
                    graphics.dispose();
                    e.startDrag(DragSource.DefaultMoveDrop, image, offset, tf, ScriptTable.this.dragSourceListener);
                    ScriptTable.this.isDragging = true;
                }
                catch (InvalidDnDOperationException exc) {
                    Log.warn(exc);
                }
            }
        }
    }

    private class ScriptTableCellRenderer
    extends DefaultTableCellRenderer {
        private ScriptTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean sel, boolean focus, int row, int col) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, sel, focus, row, col);
            Step step = ScriptTable.this.model.getStepAt(row);
            Icon icon = null;
            if (step instanceof Sequence) {
                icon = ScriptTable.this.model.isOpen(row) ? openIcon : closedIcon;
            }
            renderer.setIcon(icon);
            super.setBackground(ScriptTable.this.getStepColor(step, sel));
            this.setOpaque(true);
            return renderer;
        }
    }
}

