/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.script.ArgumentParser;
import abbot.script.Call;
import abbot.script.Resolver;
import abbot.tester.ComponentLocation;
import abbot.tester.ComponentTester;
import abbot.util.AWT;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Action
extends Call {
    private static final String USAGE = "<action method=\"...\" args=\"...\" [class=\"...\"]/>";
    private static Set stringModifierMethods = new HashSet<String>(Arrays.asList("actionKeyStroke", "actionKeyPress", "actionKeyRelease"));
    private static Set optionalFocusMethods = new HashSet<String>(Arrays.asList("actionKeyStroke", "actionKeyPress", "actionKeyRelease", "actionKeyString"));
    private static final String DEFAULT_CLASS_NAME = "java.awt.Component";

    private static Map patchAttributes(Map map) {
        if (map.get("class") == null) {
            map.put("class", DEFAULT_CLASS_NAME);
        }
        return map;
    }

    public Action(Resolver resolver, Map attributes) {
        super(resolver, Action.patchAttributes(attributes));
        this.patchMethodName();
    }

    public Action(Resolver resolver, String description, String methodName, String[] args) {
        super(resolver, description, DEFAULT_CLASS_NAME, methodName, args);
        this.patchMethodName();
    }

    public Action(Resolver resolver, String description, String methodName, String[] args, Class targetClass) {
        super(resolver, description, targetClass.getName(), methodName, args);
        this.patchMethodName();
    }

    private void patchMethodName() {
        String mn = this.getMethodName();
        if (!mn.startsWith("action")) {
            this.setMethodName("action" + mn);
        }
    }

    public void setTargetClassName(String cn) {
        if (cn == null || "".equals(cn)) {
            cn = DEFAULT_CLASS_NAME;
        }
        super.setTargetClassName(cn);
    }

    public String getXMLTag() {
        return "action";
    }

    public Map getAttributes() {
        Map map = super.getAttributes();
        map.remove("class");
        if (!DEFAULT_CLASS_NAME.equals(this.getTargetClassName())) {
            map.put("class", this.getTargetClassName());
        }
        return map;
    }

    public String getUsage() {
        return USAGE;
    }

    public String getDefaultDescription() {
        String name = this.getMethodName();
        if (name.startsWith("action")) {
            name = name.substring(6);
        }
        return name + this.getArgumentsDescription();
    }

    public Class getTargetClass() throws ClassNotFoundException {
        return this.resolveTester(this.getTargetClassName()).getClass();
    }

    protected Object evaluateParameter(Method m, String param, Class type) throws Exception {
        if (ComponentLocation.class.isAssignableFrom(type)) {
            ComponentTester tester = (ComponentTester)this.getTarget(m);
            String arg = ArgumentParser.substitute(this.getResolver(), param);
            return tester.parseLocation(arg);
        }
        if (!(type != Integer.TYPE && type != Integer.class || !param.startsWith("VK_") && param.indexOf("_MASK") == -1)) {
            if (param.startsWith("VK_")) {
                return new Integer(AWT.getKeyCode(param));
            }
            return new Integer(AWT.getModifiers(param));
        }
        return super.evaluateParameter(m, param, type);
    }

    protected Object getTarget(Method m) throws ClassNotFoundException {
        return this.resolveTester(this.getTargetClassName());
    }

    protected Method[] resolveMethods(String name, Class cls, Class returnType) throws NoSuchMethodException {
        Method[] methods = super.resolveMethods(name, cls, returnType);
        if (stringModifierMethods.contains(name)) {
            ArrayList<Method> list = new ArrayList<Method>(Arrays.asList(methods));
            block0: for (int i = 0; i < methods.length; ++i) {
                Class<?>[] ptypes = methods[i].getParameterTypes();
                for (int j = 0; j < ptypes.length; ++j) {
                    if (ptypes[j] != String.class) continue;
                    list.remove(methods[i]);
                    continue block0;
                }
            }
            methods = list.toArray(new Method[list.size()]);
        }
        return methods;
    }

    public Method getMethod() throws ClassNotFoundException, NoSuchMethodException {
        return this.resolveMethod(this.getMethodName(), this.getTargetClass(), Void.TYPE);
    }

    protected Method disambiguateMethod(Method[] methods) {
        if (methods.length == 2 && optionalFocusMethods.contains(methods[0].getName())) {
            Method crefMethod;
            Method kcMethod;
            Class<?>[] params = methods[0].getParameterTypes();
            if (params[0] == Integer.TYPE) {
                kcMethod = methods[0];
                crefMethod = methods[1];
            } else {
                kcMethod = methods[1];
                crefMethod = methods[0];
            }
            String[] args = this.getArguments();
            if (args.length > 0 && args[0].startsWith("VK_")) {
                return kcMethod;
            }
            return crefMethod;
        }
        return super.disambiguateMethod(methods);
    }
}

