/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.Log;
import abbot.finder.ComponentNotFoundException;
import abbot.finder.ComponentSearchException;
import abbot.finder.Hierarchy;
import abbot.finder.MultipleComponentsFoundException;
import abbot.i18n.Strings;
import abbot.script.ArgumentParser;
import abbot.script.InvalidScriptException;
import abbot.script.Resolver;
import abbot.script.Step;
import abbot.script.XMLConstants;
import abbot.script.XMLifiable;
import abbot.tester.ComponentTester;
import abbot.tester.Robot;
import abbot.util.AWT;
import abbot.util.ExtendedComparator;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Window;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ComponentReference
implements XMLConstants,
XMLifiable,
Comparable {
    public static final String SHARED_FRAME_ID = "shared frame";
    private static final int MW_NAME = 100;
    private static final int MW_ROOT = 25;
    private static final int MW_TAG = 50;
    private static final int MW_PARENT = 25;
    private static final int MW_WINDOW = 25;
    private static final int MW_INVOKER = 25;
    private static final int MW_TITLE = 25;
    private static final int MW_BORDER_TITLE = 25;
    private static final int MW_LABEL = 25;
    private static final int MW_TEXT = 25;
    private static final int MW_ICON = 25;
    private static final int MW_INDEX = 10;
    private static final int MW_CLASS = 1;
    private static final int MW_PARAMS = 1;
    private static final int MW_DOCBASE = 1;
    private static final int MW_HORDER = 1;
    private static final int MW_VORDER = 1;
    private static final int MW_SHOWING = 1;
    public static final int MW_FAILURE = 0;
    static final String ANON_INNER_CLASS = "/^.*\\$[0-9]+$/";
    private Resolver resolver;
    private Map attributes = new HashMap();
    private WeakReference cachedLookup;
    private static ThreadLocal lookupFailures = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashMap();
        }
    };
    private static ThreadLocal nonShowingMatches = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashMap();
        }
    };
    private static ThreadLocal ownsFailureCache = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.TRUE;
        }
    };
    private String xml;
    static boolean cacheOnCreation = true;
    private static final String LABELED_BY_PROPERTY = "labeledBy";
    private static final Comparator HORDER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            Component c1 = (Component)o1;
            Component c2 = (Component)o2;
            int x1 = -100000;
            int x2 = -100000;
            try {
                x1 = c1.getLocationOnScreen().x;
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                x2 = c2.getLocationOnScreen().x;
            }
            catch (Exception e) {
                // empty catch block
            }
            return x1 - x2;
        }
    };
    private static final Comparator VORDER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            Component c1 = (Component)o1;
            Component c2 = (Component)o2;
            int y1 = -100000;
            int y2 = -100000;
            try {
                y1 = c1.getLocationOnScreen().y;
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                y2 = c2.getLocationOnScreen().y;
            }
            catch (Exception e) {
                // empty catch block
            }
            return y1 - y2;
        }
    };

    public ComponentReference(Resolver resolver, Element el) throws InvalidScriptException {
        this.resolver = resolver;
        this.fromXML(el, true);
    }

    public ComponentReference(Resolver r, Class cls, String[][] attributes) {
        this(r, cls, ComponentReference.createAttributeMap(attributes));
    }

    public ComponentReference(Resolver resolver, Class cls, Map attributes) {
        this.resolver = resolver;
        this.attributes.putAll(attributes);
        this.attributes.put("class", Robot.getCanonicalClass(cls).getName());
        if (resolver != null) {
            if (this.attributes.get("id") == null) {
                this.attributes.put("id", this.getUniqueID(new HashMap()));
            }
            resolver.addComponentReference(this);
        }
    }

    public ComponentReference(Resolver resolver, Component comp) {
        this(resolver, comp, false, new HashMap());
    }

    public ComponentReference(Resolver resolver, Component comp, Map newReferences) {
        this(resolver, comp, true, newReferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentReference(Resolver resolver, Component comp, boolean includeHierarchyAttributes, Map newReferences) {
        Container parent;
        String icon;
        String text;
        String label;
        String borderTitle;
        String title;
        String tag;
        String cname;
        boolean cleanup = (Boolean)ownsFailureCache.get();
        ownsFailureCache.set(Boolean.FALSE);
        Log.debug("ctor: " + comp);
        this.resolver = resolver;
        if (AWT.isSharedInvisibleFrame(comp)) {
            this.setAttribute("id", SHARED_FRAME_ID);
            this.setAttribute("class", comp.getClass().getName());
        } else {
            Class refClass = Robot.getCanonicalClass(comp.getClass());
            this.setAttribute("class", refClass.getName());
        }
        String name = ComponentReference.getName(comp);
        if (name != null) {
            this.setAttribute("name", name);
        }
        if (!(cname = comp.getClass().getName()).startsWith("java.awt.") && !cname.startsWith("javax.swing.") && (tag = ComponentTester.getTag(comp)) != null) {
            this.setAttribute("tag", tag);
        }
        if ((title = ComponentReference.getTitle(comp)) != null) {
            this.setAttribute("title", title);
        }
        if ((borderTitle = ComponentReference.getBorderTitle(comp)) != null) {
            this.setAttribute("borderTitle", borderTitle);
        }
        if ((label = ComponentReference.getLabel(comp)) != null) {
            this.setAttribute("label", label);
        }
        if ((text = ComponentReference.getText(comp)) != null) {
            this.setAttribute("text", text);
        }
        if ((icon = ComponentReference.getIconName(comp)) != null) {
            this.setAttribute("icon", icon);
        }
        if (comp instanceof Applet) {
            Applet applet = (Applet)comp;
            this.setAttribute("params", this.encodeParams(applet));
            URL url = applet.getDocumentBase();
            this.setAttribute("docBase", url != null ? url.toString() : "null");
        }
        if (null != (parent = resolver.getHierarchy().getParent(comp))) {
            int index;
            if (!(comp instanceof Window) && (index = ComponentReference.getIndex(parent, comp)) != -1) {
                this.setAttribute("index", String.valueOf(index));
            }
        } else if (comp instanceof Window) {
            this.setAttribute("root", "true");
        }
        try {
            if (includeHierarchyAttributes) {
                Window win;
                boolean needWindow = !(comp instanceof Window);
                Component invoker = null;
                if (comp instanceof JPopupMenu) {
                    invoker = ((JPopupMenu)comp).getInvoker();
                    ComponentReference ref = ComponentReference.getReference(resolver, invoker, newReferences);
                    this.setAttribute("invoker", ref.getID());
                    needWindow = false;
                } else if (parent != null) {
                    needWindow = !(parent instanceof Window);
                    this.addParent(parent, newReferences);
                }
                if (needWindow && !(comp instanceof Window) && (win = AWT.getWindow(comp)) != null) {
                    ComponentReference wref = ComponentReference.getReference(resolver, win, newReferences);
                    this.setAttribute("window", wref.getID());
                }
                this.validate(comp, newReferences);
            }
        }
        finally {
            if (cleanup) {
                ComponentReference.getLookupFailures().clear();
                ComponentReference.getNonShowingMatches().clear();
                ownsFailureCache.set(Boolean.TRUE);
            }
        }
        if (cacheOnCreation || AWT.isSharedInvisibleFrame(comp)) {
            Log.debug("Cacheing initial match");
            this.cachedLookup = new WeakReference<Component>(comp);
        } else {
            this.cachedLookup = null;
        }
        String id = this.getUniqueID(newReferences);
        this.setAttribute("id", id);
        Log.debug("Unique ID is " + id);
        newReferences.put(id, this);
    }

    public static int getIndex(Container parent, Component comp) {
        if (comp instanceof Window) {
            Window[] owned = ((Window)parent).getOwnedWindows();
            for (int i = 0; i < owned.length; ++i) {
                if (owned[i] != comp) continue;
                return i;
            }
        } else {
            Component[] children = parent.getComponents();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] != comp) continue;
                return i;
            }
        }
        return -1;
    }

    public Component getComponent() throws ComponentNotFoundException, MultipleComponentsFoundException {
        if (this.resolver == null) {
            throw new ComponentNotFoundException("No default hierarchy has been provided");
        }
        return this.getComponent(this.resolver.getHierarchy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(Hierarchy hierarchy) throws ComponentNotFoundException, MultipleComponentsFoundException {
        try {
            Component component = this.findInHierarchy(null, hierarchy, 1, new HashMap());
            return component;
        }
        finally {
            ComponentReference.getLookupFailures().clear();
            ComponentReference.getNonShowingMatches().clear();
        }
    }

    private void addParent(Container parent, Map newReferences) {
        ComponentReference ref = ComponentReference.getReference(this.resolver, parent, newReferences);
        this.setAttribute("parent", ref.getID());
    }

    private boolean reachableInHierarchy(Component c) {
        Window w = AWT.getWindow(c);
        if (w == null) {
            return false;
        }
        Window parent = (Window)this.resolver.getHierarchy().getParent(w);
        return parent == null ? this.resolver.getHierarchy().getRoots().contains(w) : this.reachableInHierarchy(parent);
    }

    private void validate(Component comp, Map newReferences) {
        if (!this.reachableInHierarchy(comp)) {
            int exact;
            int wt = this.getMatchWeight(comp, newReferences);
            if (wt < (exact = this.getExactMatchWeight())) {
                String msg = Strings.get("component.creation_mismatch", new Object[]{this.toXMLString(), comp.toString(), new Integer(wt), new Integer(exact)});
                throw new Error(msg);
            }
        } else {
            try {
                Log.debug("Finding in hierarchy (" + this.resolver.getHierarchy() + ")");
                this.findInHierarchy(null, this.resolver.getHierarchy(), this.getExactMatchWeight(), newReferences);
            }
            catch (MultipleComponentsFoundException multiples) {
                try {
                    Log.debug("Disambiguating");
                    this.disambiguate(comp, multiples.getComponents(), newReferences);
                }
                catch (ComponentSearchException e) {
                    if (!(e instanceof MultipleComponentsFoundException)) {
                        Log.warn(e);
                    }
                    throw new Error("Reverse lookup failed to uniquely match " + Robot.toString(comp) + ": " + e);
                }
            }
            catch (ComponentNotFoundException e) {
                throw new Error("Reverse lookup failed looking for " + Robot.toString(comp) + " using " + this.toXMLString() + ": " + e);
            }
        }
    }

    public static String getDescriptiveName(Component c) {
        if (AWT.isSharedInvisibleFrame(c)) {
            return Strings.get("component.default_frame");
        }
        String name = ComponentReference.getName(c);
        if (name != null || (name = ComponentReference.getTitle(c)) != null || (name = ComponentReference.getText(c)) != null || (name = ComponentReference.getLabel(c)) != null || (name = ComponentReference.getIconName(c)) == null) {
            // empty if block
        }
        return name;
    }

    public String getDescriptiveName() {
        String id = this.getAttribute("id");
        if (id == null) {
            String[] attributes = new String[]{"name", "title", "text", "label", "icon"};
            for (int i = 0; i < attributes.length; ++i) {
                String att = this.getAttribute(attributes[i]);
                if (att == null || "".equals(att)) continue;
                id = att;
                break;
            }
            if (id == null) {
                String cname = this.getAttribute("class");
                cname = cname.substring(cname.lastIndexOf(".") + 1);
                id = cname + " Instance";
            }
        }
        return id;
    }

    public String getID() {
        return this.getAttribute("id");
    }

    public String getRefClassName() {
        return this.getAttribute("class");
    }

    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public Map getAttributes() {
        return new TreeMap(this.attributes);
    }

    public void setAttribute(String key, String value) {
        this.xml = null;
        this.attributes.put(key, value);
    }

    private boolean isAssignableFrom(String refClassName, Class cls) {
        return refClassName.equals(cls.getName()) || !Component.class.equals((Object)cls) && this.isAssignableFrom(refClassName, cls.getSuperclass());
    }

    public boolean isAssignableFrom(Class cls) {
        return cls != null && Component.class.isAssignableFrom(cls) && this.isAssignableFrom(this.getAttribute("class"), cls);
    }

    public ComponentReference getParentReference(Map newRefs) {
        String parentID = this.getAttribute("parent");
        ComponentReference pref = null;
        if (parentID != null && (pref = this.resolver.getComponentReference(parentID)) == null) {
            pref = (ComponentReference)newRefs.get(parentID);
        }
        return pref;
    }

    public ComponentReference getWindowReference(Map newReferences) {
        String windowID = this.getAttribute("window");
        ComponentReference wref = null;
        if (windowID != null && (wref = this.resolver.getComponentReference(windowID)) == null) {
            wref = (ComponentReference)newReferences.get(windowID);
        }
        return wref;
    }

    public ComponentReference getInvokerReference(Map newReferences) {
        String invokerID = this.getAttribute("invoker");
        ComponentReference iref = null;
        if (invokerID != null && (iref = this.resolver.getComponentReference(invokerID)) == null) {
            iref = (ComponentReference)newReferences.get(invokerID);
        }
        return iref;
    }

    public void fromXML(String input) throws InvalidScriptException, IOException {
        StringReader reader = new StringReader(input);
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(reader);
            Element el = doc.getRootElement();
            if (el == null) {
                throw new InvalidScriptException("Invalid ComponentReference XML '" + input + "'");
            }
            this.fromXML(el, false);
        }
        catch (JDOMException e) {
            throw new InvalidScriptException(e.getMessage() + " (when parsing " + input + ")");
        }
    }

    private void fromXML(Element el, boolean useIDFromXML) throws InvalidScriptException {
        for (Attribute att : el.getAttributes()) {
            String nodeName = att.getName();
            String value = att.getValue();
            if (nodeName.equals("id") && !useIDFromXML) continue;
            this.setAttribute(nodeName, value);
        }
        if (this.getAttribute("class") == null) {
            throw new InvalidScriptException("Class must be specified", el);
        }
        String id = this.getID();
        if (useIDFromXML && id != null && this.resolver.getComponentReference(id) != null) {
            String msg = "Persistent ID '" + id + "' is already in use";
            throw new InvalidScriptException(msg, el);
        }
        if (id == null) {
            Log.warn("null ID");
            this.setAttribute("id", this.getUniqueID(new HashMap()));
        }
    }

    public Element toXML() {
        Element el = new Element("component");
        for (String key : new TreeMap(this.attributes).keySet()) {
            String value = this.getAttribute(key);
            if (value == null) continue;
            el.setAttribute(key, value);
        }
        return el;
    }

    public String toEditableString() {
        return this.toXMLString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ComponentReference && this.toXMLString().equals(((ComponentReference)obj).toXMLString());
    }

    public String toString() {
        String id = this.getID();
        String cname = this.getAttribute("class");
        if (cname.startsWith("javax.swing.")) {
            cname = cname.substring(12);
        } else if (cname.startsWith("java.awt.")) {
            cname = cname.substring(9);
        }
        StringBuffer buf = new StringBuffer(id != null ? id : cname + " (no id yet)");
        if (id != null && id.indexOf("Instance") == -1) {
            buf.append(" (");
            buf.append(cname);
            buf.append(")");
        }
        return buf.toString();
    }

    public String toXMLString() {
        if (this.xml == null) {
            this.xml = Step.toXMLString(this);
        }
        return this.xml;
    }

    private Component bestMatch(Set set) throws MultipleComponentsFoundException {
        String vorder;
        Component[] matches = set.toArray(new Component[set.size()]);
        int[] weights = new int[matches.length];
        for (int i = 0; i < weights.length; ++i) {
            Window w = AWT.getWindow(matches[i]);
            weights[i] = w != null && w.isShowing() ? 1 : 0;
        }
        String horder = this.getAttribute("hOrder");
        if (horder != null) {
            for (int i = 0; i < matches.length; ++i) {
                String order = ComponentReference.getOrder(matches[i], matches, true);
                if (!horder.equals(order)) continue;
                int n = i;
                weights[n] = weights[n] + 1;
            }
        }
        if ((vorder = this.getAttribute("vOrder")) != null) {
            for (int i = 0; i < matches.length; ++i) {
                String order = ComponentReference.getOrder(matches[i], matches, false);
                if (!vorder.equals(order)) continue;
                int n = i;
                weights[n] = weights[n] + 1;
            }
        }
        ArrayList<Component> best = new ArrayList<Component>();
        best.add(matches[0]);
        int max = 0;
        for (int i = 1; i < weights.length; ++i) {
            if (weights[i] > weights[max]) {
                max = i;
                best.clear();
                best.add(matches[i]);
                continue;
            }
            if (weights[i] != weights[max]) continue;
            best.add(matches[i]);
        }
        if (best.size() == 1) {
            return (Component)best.get(0);
        }
        Component cache = this.getCachedLookup(this.resolver.getHierarchy());
        if (cache != null) {
            for (Component c : best) {
                if (cache != c) continue;
                return cache;
            }
        }
        String msg = "Could not distinguish between " + best.size() + " components using " + this.toXMLString();
        matches = best.toArray(new Component[best.size()]);
        throw new MultipleComponentsFoundException(msg, matches);
    }

    static String getOrder(Component original, Component[] matchList, boolean horizontal) {
        Comparator c = horizontal ? HORDER_COMPARATOR : VORDER_COMPARATOR;
        Component[] matches = (Component[])matchList.clone();
        Arrays.sort(matches, c);
        int order = 0;
        for (int i = 0; i < matches.length; ++i) {
            if (i > 0 && c.compare(matches[i - 1], matches[i]) != 0) {
                ++order;
            }
            if (matches[i] != original) continue;
            return String.valueOf(order);
        }
        return null;
    }

    private void disambiguate(Component original, Component[] matches, Map newReferences) throws ComponentNotFoundException, MultipleComponentsFoundException {
        Log.debug("Attempting to disambiguate multiple matches");
        Container parent = this.resolver.getHierarchy().getParent(original);
        boolean retryOnFailure = false;
        String order = null;
        try {
            String cname = original.getClass().getName();
            if (!cname.equals(this.getAttribute("class")) && !this.expressionMatch(ANON_INNER_CLASS, cname)) {
                this.setAttribute("class", original.getClass().getName());
                retryOnFailure = true;
            } else if (parent != null && this.getAttribute("parent") == null && !(original instanceof JPopupMenu)) {
                Log.debug("Adding parent");
                this.addParent(parent, newReferences);
                retryOnFailure = true;
            } else if (this.getAttribute("hOrder") == null && (order = ComponentReference.getOrder(original, matches, true)) != null) {
                Log.debug("Adding horder");
                this.setAttribute("hOrder", order);
                retryOnFailure = true;
            } else if (this.getAttribute("vOrder") == null && (order = ComponentReference.getOrder(original, matches, false)) != null) {
                Log.debug("Adding vorder");
                this.setAttribute("vOrder", order);
                retryOnFailure = true;
            }
            Log.debug("Retrying lookup with new values");
            ComponentReference.getLookupFailures().remove(this);
            this.findInHierarchy(null, this.resolver.getHierarchy(), this.getExactMatchWeight(), newReferences);
            Log.debug("Success!");
        }
        catch (MultipleComponentsFoundException multiples) {
            if (retryOnFailure) {
                this.disambiguate(original, multiples.getComponents(), newReferences);
            }
            throw multiples;
        }
    }

    int getMatchWeight(Component comp) {
        return this.getMatchWeight(comp, new HashMap());
    }

    private int getMatchWeight(Component comp, Map newReferences) {
        int i;
        Container parent;
        String idx;
        String icon2;
        String icon;
        String text2;
        String text;
        String label2;
        String label;
        String bt2;
        String borderTitle;
        String title;
        String refName;
        int weight = 0;
        if (null == comp) {
            return 0;
        }
        if (!this.isAssignableFrom(comp.getClass())) {
            return 0;
        }
        ++weight;
        if (this.getAttribute("class").equals(comp.getClass().getName())) {
            ++weight;
        }
        String refTag = this.getAttribute("tag");
        String compTag = null;
        if (null != refTag && (compTag = ComponentTester.getTag(comp)) != null && this.expressionMatch(refTag, compTag)) {
            weight += 50;
        }
        if (null != (refName = this.getAttribute("name"))) {
            String compName = ComponentReference.getName(comp);
            weight = compName != null && this.expressionMatch(refName, compName) ? (weight += 100) : (weight -= 100);
        }
        if (null != this.getAttribute("invoker")) {
            Component invoker;
            ComponentReference iref = this.getInvokerReference(newReferences);
            Component component = invoker = comp instanceof JPopupMenu ? ((JPopupMenu)comp).getInvoker() : null;
            weight = invoker == iref.resolveComponent(invoker, newReferences) ? (weight += 25) : (weight -= 25);
        }
        if (null != this.getAttribute("parent")) {
            ComponentReference pref = this.getParentReference(newReferences);
            Container parent2 = this.resolver.getHierarchy().getParent(comp);
            if (parent2 == pref.resolveComponent(parent2, newReferences)) {
                weight += 25;
            }
        } else if (null != this.getAttribute("root")) {
            weight += 25;
        }
        if (null != this.getAttribute("window")) {
            ComponentReference wref = this.getWindowReference(newReferences);
            Window w = AWT.getWindow(comp);
            if (w == wref.resolveComponent(w, newReferences)) {
                weight += 25;
            } else if (w != null) {
                weight -= 25;
            }
        }
        if (null != (title = this.getAttribute("title"))) {
            String title2;
            String string = title2 = comp instanceof Frame || comp instanceof Dialog || comp instanceof JInternalFrame ? ComponentReference.getTitle(comp) : this.getComponentWindowTitle(comp);
            if (title2 != null && this.expressionMatch(title, title2)) {
                weight += 25;
            }
        }
        if (null != (borderTitle = this.getAttribute("borderTitle")) && (bt2 = ComponentReference.getBorderTitle(comp)) != null && this.expressionMatch(borderTitle, bt2)) {
            weight += 25;
        }
        if (null != (label = this.getAttribute("label")) && (label2 = ComponentReference.getLabel(comp)) != null && this.expressionMatch(label, label2)) {
            weight += 25;
        }
        if (null != (text = this.getAttribute("text")) && (text2 = ComponentReference.getText(comp)) != null && this.expressionMatch(text, text2)) {
            weight += 25;
        }
        if (null != (icon = this.getAttribute("icon")) && (icon2 = ComponentReference.getIconName(comp)) != null && this.expressionMatch(icon, icon2)) {
            weight += 25;
        }
        if (null != (idx = this.getAttribute("index")) && null != (parent = this.resolver.getHierarchy().getParent(comp)) && this.expressionMatch(idx, String.valueOf(i = ComponentReference.getIndex(parent, comp)))) {
            weight += 10;
        }
        if (comp instanceof Applet) {
            URL url;
            String docBase;
            String params2;
            Applet applet = (Applet)comp;
            String params = this.getAttribute("params");
            if (null != params && this.expressionMatch(params, params2 = this.encodeParams(applet))) {
                ++weight;
            }
            if (null != (docBase = this.getAttribute("docBase")) && (url = applet.getDocumentBase()) != null && this.expressionMatch(docBase, url.toString())) {
                ++weight;
            }
        }
        if (Log.isClassDebugEnabled(ComponentReference.class)) {
            Log.debug("Compared " + Robot.toString(comp) + " to " + this.toXMLString() + " weight is " + weight);
        }
        return weight;
    }

    private int getExactMatchWeight() {
        int weight = 1;
        if (this.getAttribute("name") != null) {
            weight += 100;
        }
        if (this.getAttribute("tag") != null) {
            weight += 50;
        }
        if (this.getAttribute("invoker") != null) {
            weight += 25;
        }
        if (this.getAttribute("root") != null) {
            weight += 25;
        }
        if (this.getAttribute("parent") != null) {
            weight += 25;
        }
        if (this.getAttribute("window") != null) {
            weight += 25;
        }
        if (this.getAttribute("title") != null) {
            weight += 25;
        }
        if (this.getAttribute("borderTitle") != null) {
            weight += 25;
        }
        if (this.getAttribute("index") != null) {
            weight += 10;
        }
        if (this.getAttribute("label") != null) {
            weight += 25;
        }
        if (this.getAttribute("text") != null) {
            weight += 25;
        }
        if (this.getAttribute("icon") != null) {
            weight += 25;
        }
        if (this.getAttribute("params") != null) {
            ++weight;
        }
        if (this.getAttribute("docBase") != null) {
            ++weight;
        }
        if (Log.isClassDebugEnabled(ComponentReference.class)) {
            Log.debug("Exact match weight for " + this.toXMLString() + " is " + weight);
        }
        return weight;
    }

    private Component resolveComponent(Component preferred, Map newReferences) {
        Component found;
        block7: {
            if (Log.isClassDebugEnabled(ComponentReference.class)) {
                Log.debug("Looking up " + this.toXMLString() + " in hierarchy");
            }
            found = null;
            try {
                found = this.findInHierarchy(null, this.resolver.getHierarchy(), 1, newReferences);
            }
            catch (MultipleComponentsFoundException e) {
                Component[] list = e.getComponents();
                for (int i = 0; i < list.length; ++i) {
                    if (list[i] != preferred) continue;
                    return preferred;
                }
            }
            catch (ComponentNotFoundException e) {
                int minWeight = this.getExactMatchWeight();
                if (this.getAttribute("window") != null) {
                    minWeight -= 25;
                }
                if (this.getAttribute("parent") != null) {
                    minWeight -= 25;
                }
                if (AWT.getWindow(preferred) != null || this.getMatchWeight(preferred) < minWeight) break block7;
                Log.debug("Using preferred component: " + Robot.toString(preferred));
                found = preferred;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentReference getReference(Resolver r, Component comp, Map newReferences) {
        Log.debug("Looking for a reference for " + Robot.toString(comp));
        boolean cleanup = (Boolean)ownsFailureCache.get();
        ownsFailureCache.set(Boolean.FALSE);
        ComponentReference ref = r.getComponentReference(comp);
        try {
            if (ref == null) {
                Log.debug("No existing reference found, creating a new one");
                ref = new ComponentReference(r, comp, newReferences);
            }
        }
        finally {
            if (cleanup) {
                ComponentReference.getLookupFailures().clear();
                ComponentReference.getNonShowingMatches().clear();
                ownsFailureCache.set(Boolean.TRUE);
            }
        }
        return ref;
    }

    public static ComponentReference matchExisting(final Component comp, Collection existing) {
        Log.debug("Matching " + Robot.toString(comp) + " against existing refs");
        boolean cleanup = (Boolean)ownsFailureCache.get();
        ownsFailureCache.set(Boolean.FALSE);
        ComponentReference match = null;
        Iterator iter = existing.iterator();
        TreeMap<ComponentReference, Boolean> matches = new TreeMap<ComponentReference, Boolean>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ComponentReference)o2).getMatchWeight(comp) - ((ComponentReference)o1).getMatchWeight(comp);
            }
        });
        HashMap empty = new HashMap();
        while (iter.hasNext()) {
            ComponentReference ref = (ComponentReference)iter.next();
            if (comp != ref.getCachedLookup(ref.resolver.getHierarchy()) && comp != ref.resolveComponent(comp, empty)) continue;
            matches.put(ref, Boolean.TRUE);
        }
        if (matches.size() > 0) {
            match = (ComponentReference)matches.keySet().iterator().next();
        }
        if (cleanup) {
            ComponentReference.getLookupFailures().clear();
            ComponentReference.getNonShowingMatches().clear();
            ownsFailureCache.set(Boolean.TRUE);
        }
        Log.debug(match != null ? "Found" : "Not found");
        return match;
    }

    boolean expressionMatch(String pattern, String actual) {
        pattern = ArgumentParser.substitute(this.resolver, pattern);
        return ExtendedComparator.stringsMatch(pattern, actual);
    }

    private static String getText(Component c) {
        if (c instanceof AbstractButton) {
            return ComponentTester.stripHTML(((AbstractButton)c).getText());
        }
        if (c instanceof JLabel) {
            return ComponentTester.stripHTML(((JLabel)c).getText());
        }
        if (c instanceof Label) {
            return ((Label)c).getText();
        }
        return null;
    }

    private static String getLabel(Component c) {
        String label = null;
        if (c instanceof JComponent) {
            Object obj = ((JComponent)c).getClientProperty(LABELED_BY_PROPERTY);
            if (obj != null) {
                if (obj instanceof JLabel) {
                    label = ((JLabel)obj).getText();
                } else if (obj instanceof String) {
                    label = (String)obj;
                }
            }
        } else if (c instanceof Button) {
            label = ((Button)c).getLabel();
        } else if (c instanceof Checkbox) {
            label = ((Checkbox)c).getLabel();
        }
        return ComponentTester.stripHTML(label);
    }

    private static String getIconName(Component c) {
        AccessibleIcon[] icons;
        String icon = null;
        AccessibleContext context = c.getAccessibleContext();
        if (context != null && (icons = context.getAccessibleIcon()) != null && icons.length > 0 && (icon = icons[0].getAccessibleIconDescription()) != null) {
            icon = icon.substring(icon.lastIndexOf("/") + 1);
            icon = icon.substring(icon.lastIndexOf("\\") + 1);
        }
        return icon;
    }

    private static String getName(Component c) {
        String name = AWT.hasDefaultName(c) ? null : c.getName();
        return name;
    }

    private String encodeParams(Applet applet) {
        StringBuffer sb = new StringBuffer();
        String[][] info = applet.getParameterInfo();
        if (info == null) {
            return "null";
        }
        for (int i = 0; i < info.length; ++i) {
            sb.append(info[i][0]);
            sb.append("=");
            String param = applet.getParameter(info[i][0]);
            sb.append(param != null ? param : "null");
            sb.append(";");
        }
        return sb.toString();
    }

    Component getCachedLookup(Hierarchy hierarchy) {
        if (this.cachedLookup != null) {
            Component c = (Component)this.cachedLookup.get();
            if (c != null && hierarchy.contains(c) && AWT.getWindow(c) != null) {
                return c;
            }
            Log.debug("Discarding cached value: " + Robot.toString(c));
            this.cachedLookup = null;
        }
        return null;
    }

    private Component findInHierarchy(Container root, Hierarchy hierarchy, int weight, Map newReferences) throws ComponentNotFoundException, MultipleComponentsFoundException {
        Component match = null;
        ComponentSearchException cse = (ComponentSearchException)ComponentReference.getLookupFailures().get(this);
        if (cse instanceof ComponentNotFoundException) {
            Log.debug("lookup already failed: " + cse);
            throw (ComponentNotFoundException)cse;
        }
        if (cse instanceof MultipleComponentsFoundException) {
            Log.debug("lookup already failed: " + cse);
            throw (MultipleComponentsFoundException)cse;
        }
        HashSet set = new HashSet();
        match = this.getCachedLookup(hierarchy);
        if (match != null) {
            if (AWT.isSharedInvisibleFrame(match)) {
                return match;
            }
            Window w = AWT.getWindow(match);
            if (w != null && (w.isShowing() || ComponentReference.getNonShowingMatches().get(this) == match)) {
                Log.debug("Using cached lookup for " + this.getID() + " (hierarchy=" + hierarchy + ")");
                return match;
            }
            Log.debug("Skipping non-showing match (once) " + this.hashCode());
        }
        weight = this.findMatchesInHierarchy(root, hierarchy, weight, set, newReferences);
        Log.debug("Found " + set.size() + " matches for " + this.toXMLString());
        if (set.size() == 1) {
            match = (Component)set.iterator().next();
        } else if (set.size() > 0) {
            try {
                match = this.bestMatch(set);
            }
            catch (MultipleComponentsFoundException e) {
                ComponentReference.getLookupFailures().put(this, e);
                throw e;
            }
        }
        if (match == null) {
            String msg = "No component found which matches " + this.toXMLString();
            ComponentNotFoundException e = new ComponentNotFoundException(msg);
            ComponentReference.getLookupFailures().put(this, e);
            throw e;
        }
        Log.debug("Cacheing match: " + Integer.toHexString(match.hashCode()));
        this.cachedLookup = new WeakReference<Component>(match);
        if (!match.isShowing()) {
            ComponentReference.getNonShowingMatches().put(this, match);
        }
        return match;
    }

    private int findMatchesInHierarchy(Component root, Hierarchy hierarchy, int currentMaxWeight, Set currentSet, Map newReferences) {
        if (root == null) {
            Iterator iter = hierarchy.getRoots().iterator();
            while (iter.hasNext()) {
                currentMaxWeight = this.findMatchesInHierarchy((Window)iter.next(), hierarchy, currentMaxWeight, currentSet, newReferences);
            }
            return currentMaxWeight;
        }
        if (!hierarchy.contains(root)) {
            Log.debug("Component not in hierarchy");
            return currentMaxWeight;
        }
        int weight = this.getMatchWeight(root, newReferences);
        if (weight > currentMaxWeight) {
            currentSet.clear();
            currentMaxWeight = weight;
            currentSet.add(root);
        } else if (weight == currentMaxWeight) {
            currentSet.add(root);
        }
        Collection kids = hierarchy.getComponents(root);
        for (Component child : kids) {
            currentMaxWeight = this.findMatchesInHierarchy(child, hierarchy, currentMaxWeight, currentSet, newReferences);
        }
        return currentMaxWeight;
    }

    private static Map createAttributeMap(String[][] values) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < values.length; ++i) {
            map.put(values[i][0], values[i][1]);
        }
        return map;
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getTag() {
        return this.getAttribute("tag");
    }

    public String getInvokerID() {
        return this.getAttribute("invoker");
    }

    public String getWindowID() {
        return this.getAttribute("window");
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public int getIndex() {
        try {
            return Integer.parseInt(this.getAttribute("index"));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int compareTo(Object o) {
        return this.getID().compareTo(((ComponentReference)o).getID());
    }

    private static String getBorderTitle(Border b) {
        String title = null;
        if (b instanceof TitledBorder) {
            title = ((TitledBorder)b).getTitle();
        } else if (b instanceof CompoundBorder && (title = ComponentReference.getBorderTitle(((CompoundBorder)b).getInsideBorder())) == null) {
            title = ComponentReference.getBorderTitle(((CompoundBorder)b).getOutsideBorder());
        }
        return title;
    }

    private static String getBorderTitle(Component c) {
        String title = null;
        if (c instanceof JComponent) {
            title = ComponentReference.getBorderTitle(((JComponent)c).getBorder());
        }
        return title;
    }

    private static String getTitle(Component c) {
        if (c instanceof Dialog) {
            return ((Dialog)c).getTitle();
        }
        if (c instanceof Frame) {
            return ((Frame)c).getTitle();
        }
        if (c instanceof JInternalFrame) {
            return ((JInternalFrame)c).getTitle();
        }
        return null;
    }

    private String getComponentWindowTitle(Component c) {
        Component parent = c;
        while (!(c instanceof Frame) && !(c instanceof Dialog) && (c = this.resolver.getHierarchy().getParent(parent)) != null) {
            parent = c;
        }
        String title = null;
        if (parent instanceof Frame) {
            title = ((Frame)parent).getTitle();
        } else if (parent instanceof Dialog) {
            title = ((Dialog)parent).getTitle();
        }
        return title;
    }

    private static Map getLookupFailures() {
        return (Map)lookupFailures.get();
    }

    private static Map getNonShowingMatches() {
        return (Map)nonShowingMatches.get();
    }

    public String getUniqueID(Map refs) {
        String id = this.getDescriptiveName();
        String ext = "";
        int count = 2;
        while (refs.get(id + ext) != null || this.resolver.getComponentReference(id + ext) != null) {
            ext = " " + count++;
        }
        return id + ext;
    }
}

