/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.AssertionFailedError;
import abbot.Log;
import abbot.Platform;
import abbot.finder.Hierarchy;
import abbot.i18n.Strings;
import abbot.script.AppClassLoader;
import abbot.script.Call;
import abbot.script.Resolver;
import abbot.script.StepRunner;
import abbot.script.UIContext;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;

public class Launch
extends Call
implements UIContext {
    private static Launch currentLaunch = null;
    private String classpath = null;
    private boolean threaded = false;
    private transient AppClassLoader classLoader;
    private transient ThreadedLaunchListener listener;
    private static final String USAGE = "<launch class=\"...\" method=\"...\" args=\"...\" [threaded=true]>";

    public Launch(Resolver resolver, Map attributes) {
        super(resolver, attributes);
        this.classpath = (String)attributes.get("classpath");
        String thr = (String)attributes.get("threaded");
        if (thr != null) {
            this.threaded = Boolean.valueOf(thr);
        }
    }

    public Launch(Resolver resolver, String description, String className, String methodName, String[] args) {
        this(resolver, description, className, methodName, args, null, false);
    }

    public Launch(Resolver resolver, String description, String className, String methodName, String[] args, String classpath, boolean threaded) {
        super(resolver, description, className, methodName, args);
        this.classpath = classpath;
        this.threaded = threaded;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String cp) {
        this.classpath = cp;
        this.classLoader = null;
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public void setThreaded(boolean thread) {
        this.threaded = thread;
    }

    protected AppClassLoader createClassLoader() {
        return new AppClassLoader(this.classpath);
    }

    protected void install() {
        ClassLoader loader = this.getContextClassLoader();
        if (loader instanceof AppClassLoader && !((AppClassLoader)loader).isInstalled()) {
            ((AppClassLoader)loader).install();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizedRunStep() throws Throwable {
        if (Platform.JAVA_VERSION < 5120 && !this.isThreaded()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            synchronized (toolkit) {
                super.runStep();
            }
        } else {
            super.runStep();
        }
    }

    public void terminate() {
        Log.debug("launch terminate");
        if (currentLaunch == this) {
            Iterator iter = this.getHierarchy().getRoots().iterator();
            while (iter.hasNext()) {
                this.getHierarchy().dispose((Window)iter.next());
            }
            if (this.classLoader != null) {
                this.classLoader.uninstall();
                this.classLoader = null;
            }
            currentLaunch = null;
        }
    }

    public void launch(StepRunner runner) throws Throwable {
        runner.run(this);
    }

    public boolean isLaunched() {
        return currentLaunch == this;
    }

    public Hierarchy getHierarchy() {
        return this.getResolver().getHierarchy();
    }

    public void runStep() throws Throwable {
        if (currentLaunch != null) {
            currentLaunch.terminate();
        }
        currentLaunch = this;
        this.install();
        System.setProperty("abbot.framework.launched", "true");
        if (this.isThreaded()) {
            Thread threaded = new Thread("Threaded " + this.toString()){

                public void run() {
                    block4: {
                        try {
                            Launch.this.synchronizedRunStep();
                        }
                        catch (AssertionFailedError e) {
                            if (Launch.this.listener != null) {
                                Launch.this.listener.stepFailure(Launch.this, e);
                            }
                        }
                        catch (Throwable t) {
                            if (Launch.this.listener == null) break block4;
                            Launch.this.listener.stepError(Launch.this, t);
                        }
                    }
                }
            };
            threaded.setDaemon(true);
            threaded.setContextClassLoader(this.classLoader);
            threaded.start();
        } else {
            this.synchronizedRunStep();
        }
    }

    public Class resolveClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, this.getContextClassLoader());
    }

    public ClassLoader getContextClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.createClassLoader();
        }
        return this.classLoader;
    }

    public Class getTargetClass() throws ClassNotFoundException {
        Class cls = this.resolveClass(this.getTargetClassName());
        Log.debug("Target class is " + cls.getName());
        return cls;
    }

    protected Object getTarget(Method m) {
        return null;
    }

    public Method getMethod() throws ClassNotFoundException, NoSuchMethodException {
        return this.resolveMethod(this.getMethodName(), this.getTargetClass(), null);
    }

    public Map getAttributes() {
        Map map = super.getAttributes();
        if (this.classpath != null) {
            map.put("classpath", this.classpath);
        }
        if (this.threaded) {
            map.put("threaded", "true");
        }
        return map;
    }

    public String getDefaultDescription() {
        String desc = Strings.get("launch.desc", new Object[]{this.getTargetClassName() + "." + this.getMethodName() + "(" + this.getEncodedArguments() + ")"});
        return desc;
    }

    public String getUsage() {
        return USAGE;
    }

    public String getXMLTag() {
        return "launch";
    }

    public void setThreadedLaunchListener(ThreadedLaunchListener l) {
        this.listener = l;
    }

    public boolean equivalent(UIContext context) {
        return false;
    }

    public static interface ThreadedLaunchListener {
        public void stepFailure(Launch var1, AssertionFailedError var2);

        public void stepError(Launch var1, Throwable var2);
    }
}

