/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.tester.Robot;
import abbot.util.AWT;
import abbot.util.NamedTimer;
import abbot.util.Properties;
import abbot.util.WeakAWTEventListener;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;

public class WindowTracker {
    private Map contexts;
    private Map queues;
    private ContextTracker contextTracker;
    private Map pendingWindows = new WeakHashMap();
    private Map openWindows = new WeakHashMap();
    private Map hiddenWindows = new WeakHashMap();
    private Map closedWindows = new WeakHashMap();
    private WindowReadyTracker windowReadyTracker;
    private java.awt.Robot robot;
    static int WINDOW_READY_DELAY = Properties.getProperty("abbot.window_ready_delay", 10000, 0, 60000);
    private Timer windowReadyTimer;
    private static int sign = 1;

    public static WindowTracker getTracker() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WindowTracker() {
        this.contextTracker = new ContextTracker();
        long mask = 65L;
        new WeakAWTEventListener(this.contextTracker, mask);
        this.windowReadyTracker = new WindowReadyTracker();
        mask = 8240L;
        new WeakAWTEventListener(this.windowReadyTracker, mask);
        this.contexts = new WeakHashMap();
        this.contexts.put(Toolkit.getDefaultToolkit().getSystemEventQueue(), new WeakHashMap());
        this.queues = new WeakHashMap();
        Frame[] frames = Frame.getFrames();
        Map map = this.openWindows;
        synchronized (map) {
            for (int i = 0; i < frames.length; ++i) {
                this.scanExistingWindows(frames[i]);
            }
        }
        try {
            this.robot = new java.awt.Robot();
        }
        catch (AWTException e) {
            // empty catch block
        }
        this.windowReadyTimer = new NamedTimer("Window Ready Timer", true);
    }

    private void scanExistingWindows(Window w) {
        new WindowWatcher(w);
        Window[] windows = w.getOwnedWindows();
        for (int i = 0; i < windows.length; ++i) {
            this.scanExistingWindows(windows[i]);
        }
        this.openWindows.put(w, Boolean.TRUE);
        if (!w.isShowing()) {
            this.hiddenWindows.put(w, Boolean.TRUE);
        }
        this.noteContext(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWindowReady(Window w) {
        Map map = this.openWindows;
        synchronized (map) {
            if (this.openWindows.containsKey(w) && !this.hiddenWindows.containsKey(w)) {
                return true;
            }
        }
        if (this.robot != null) {
            this.checkWindow(w, this.robot);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventQueue getQueue(Component c) {
        while (!(c instanceof Applet) && c.getParent() != null) {
            c = c.getParent();
        }
        Map map = this.contexts;
        synchronized (map) {
            EventQueue q;
            WeakReference ref = (WeakReference)this.queues.get(c);
            EventQueue eventQueue = q = ref != null ? (EventQueue)ref.get() : null;
            if (q == null) {
                q = c.getToolkit().getSystemEventQueue();
            }
            return q;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getEventQueues() {
        HashSet<Object> set = new HashSet<Object>();
        Map map = this.contexts;
        synchronized (map) {
            set.addAll(this.contexts.keySet());
            for (WeakReference ref : this.queues.values()) {
                EventQueue q = (EventQueue)ref.get();
                if (q == null) continue;
                set.add(q);
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getRootWindows() {
        HashSet<Object> set = new HashSet<Object>();
        Map map = this.contexts;
        synchronized (map) {
            for (EventQueue queue : this.contexts.keySet()) {
                Map map2 = (Map)this.contexts.get(queue);
                set.addAll(map2.keySet());
            }
        }
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            set.add(frames[i]);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteContext(Component comp) {
        EventQueue queue = comp.getToolkit().getSystemEventQueue();
        Map map = this.contexts;
        synchronized (map) {
            WeakHashMap<Component, Boolean> map2 = (WeakHashMap<Component, Boolean>)this.contexts.get(queue);
            if (map2 == null) {
                map2 = new WeakHashMap<Component, Boolean>();
                this.contexts.put(queue, map2);
            }
            if (comp instanceof Window && comp.getParent() == null) {
                map2.put(comp, Boolean.TRUE);
            }
            this.queues.put(comp, new WeakReference<EventQueue>(queue));
        }
    }

    private void noteOpened(Component comp) {
        this.noteContext(comp);
        if (comp instanceof Window) {
            new WindowWatcher((Window)comp);
            this.markWindowShowing((Window)comp);
            if (comp instanceof FileDialog) {
                this.markWindowReady((Window)comp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteClosed(Component comp) {
        if (comp.getParent() == null) {
            EventQueue queue = comp.getToolkit().getSystemEventQueue();
            Map map = this.contexts;
            synchronized (map) {
                Map whm = (Map)this.contexts.get(queue);
                if (whm != null) {
                    whm.remove(comp);
                } else {
                    EventQueue foundQueue = null;
                    for (EventQueue q : this.contexts.keySet()) {
                        Map map2 = (Map)this.contexts.get(q);
                        if (!map2.containsKey(comp)) continue;
                        foundQueue = q;
                        map2.remove(comp);
                    }
                    if (foundQueue == null) {
                        Log.log("Got WINDOW_CLOSED on " + Robot.toString(comp) + " on a previously unseen context: " + queue + "(" + Thread.currentThread() + ")");
                    } else {
                        Log.log("Window " + Robot.toString(comp) + " sent WINDOW_CLOSED on " + queue + " but sent WINDOW_OPENED on " + foundQueue);
                    }
                }
            }
        }
        Map map = this.openWindows;
        synchronized (map) {
            this.openWindows.remove(comp);
            this.hiddenWindows.remove(comp);
            this.closedWindows.put(comp, Boolean.TRUE);
            this.pendingWindows.remove(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markWindowReady(Window w) {
        Map map = this.openWindows;
        synchronized (map) {
            if (this.pendingWindows.containsKey(w)) {
                this.closedWindows.remove(w);
                this.hiddenWindows.remove(w);
                this.openWindows.put(w, Boolean.TRUE);
                this.pendingWindows.remove(w);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markWindowShowing(final Window w) {
        Map map = this.openWindows;
        synchronized (map) {
            TimerTask task = new TimerTask(){

                public void run() {
                    WindowTracker.this.markWindowReady(w);
                }
            };
            this.windowReadyTimer.schedule(task, WINDOW_READY_DELAY);
            this.pendingWindows.put(w, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWindow(final Window w, java.awt.Robot robot) {
        final Insets insets = AWT.getInsets(w);
        final int width = w.getWidth();
        final int height = w.getHeight();
        int x = w.getX() + insets.left + (width - (insets.left + insets.right)) / 2;
        int y = w.getY() + insets.top + (height - (insets.top + insets.bottom)) / 2;
        if (x != 0 && y != 0) {
            robot.mouseMove(x, y);
            if (width > height) {
                robot.mouseMove(x + sign, y);
            } else {
                robot.mouseMove(x, y + sign);
            }
            sign = -sign;
        }
        Map map = this.openWindows;
        synchronized (map) {
            if (this.pendingWindows.containsKey(w) && this.isEmptyFrame(w)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int nw = Math.max(width, insets.left + insets.right + 3);
                        int nh = Math.max(height, insets.top + insets.bottom + 3);
                        w.setSize(nw, nh);
                    }
                });
            }
        }
    }

    private boolean isEmptyFrame(Window w) {
        Insets insets = AWT.getInsets(w);
        return insets.top + insets.bottom == w.getHeight() || insets.left + insets.right == w.getWidth();
    }

    private class WindowReadyTracker
    implements AWTEventListener {
        private WindowReadyTracker() {
        }

        public void eventDispatched(AWTEvent e) {
            if (e instanceof MouseEvent) {
                Component c = (Component)e.getSource();
                Window w = c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
                WindowTracker.this.markWindowReady(w);
            }
        }
    }

    private class ContextTracker
    implements AWTEventListener {
        private ContextTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventDispatched(AWTEvent ev) {
            Map map;
            ComponentEvent event = (ComponentEvent)ev;
            Component comp = event.getComponent();
            if (!(comp instanceof Applet) && !(comp instanceof Window)) {
                return;
            }
            int id = ev.getID();
            if (id == 200) {
                WindowTracker.this.noteOpened(comp);
            } else if (id == 202) {
                WindowTracker.this.noteClosed(comp);
            } else if (id != 201 && (id >= 200 && id <= 209 || id == 102)) {
                map = WindowTracker.this.openWindows;
                synchronized (map) {
                    if (!WindowTracker.this.getRootWindows().contains(comp) || WindowTracker.this.closedWindows.containsKey(comp)) {
                        WindowTracker.this.noteOpened(comp);
                    }
                }
            }
            map = WindowTracker.this.contexts;
            synchronized (map) {
                WeakReference ref = (WeakReference)WindowTracker.this.queues.get(comp);
                if (ref != null && !comp.getToolkit().getSystemEventQueue().equals(ref.get())) {
                    WindowTracker.this.noteContext(comp);
                }
            }
        }
    }

    private class WindowWatcher
    extends WindowAdapter
    implements ComponentListener {
        public WindowWatcher(Window w) {
            w.addComponentListener(this);
            w.addWindowListener(this);
        }

        public void componentShown(ComponentEvent e) {
            WindowTracker.this.markWindowShowing((Window)e.getSource());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentHidden(ComponentEvent e) {
            Map map = WindowTracker.this.openWindows;
            synchronized (map) {
                WindowTracker.this.hiddenWindows.put(e.getSource(), Boolean.TRUE);
                WindowTracker.this.pendingWindows.remove(e.getSource());
            }
        }

        public void windowClosed(WindowEvent e) {
            e.getWindow().removeWindowListener(this);
            e.getWindow().removeComponentListener(this);
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }
    }

    private static class Holder {
        public static final WindowTracker INSTANCE = new WindowTracker();

        private Holder() {
        }
    }
}

