/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.abbot;

import abbot.Log;
import abbot.finder.BasicFinder;
import abbot.finder.ComponentFinder;
import abbot.finder.Hierarchy;
import abbot.finder.Matcher;
import abbot.finder.TestHierarchy;
import abbot.script.Resolver;
import abbot.script.Script;
import java.awt.Component;
import java.awt.Window;
import java.util.Iterator;
import junit.framework.TestCase;

public abstract class ResolverFixture
extends TestCase {
    private Hierarchy hierarchy;
    private ComponentFinder finder;
    private Resolver resolver;

    protected Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    protected Hierarchy createHierarchy() {
        return new TestHierarchy();
    }

    protected ComponentFinder getFinder() {
        return this.finder;
    }

    protected Resolver getResolver() {
        return this.resolver;
    }

    protected void fixtureSetUp() throws Throwable {
        this.hierarchy = this.createHierarchy();
        this.finder = new BasicFinder(this.hierarchy);
        this.resolver = new Script(this.hierarchy);
    }

    protected void disposeAll() {
        Iterator iter = this.hierarchy.getRoots().iterator();
        while (iter.hasNext()) {
            this.hierarchy.dispose((Window)iter.next());
        }
    }

    protected void fixtureTearDown() throws Throwable {
        this.disposeAll();
        this.hierarchy = null;
        this.resolver = null;
        this.finder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        Log.log("setting up fixture: " + this.getName());
        Throwable exception = null;
        this.fixtureSetUp();
        try {
            super.runBare();
        }
        catch (Throwable e) {
            exception = e;
        }
        finally {
            block13: {
                Log.log("tearing down fixture: " + this.getName());
                try {
                    this.fixtureTearDown();
                }
                catch (Throwable tearingDown) {
                    if (exception != null) break block13;
                    exception = tearingDown;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public ResolverFixture(String name) {
        super(name);
    }

    public ResolverFixture() {
    }

    protected class ComponentMatcher
    implements Matcher {
        private Component component;

        public ComponentMatcher(Component c) {
            this.component = c;
        }

        public boolean matches(Component c) {
            return c == this.component;
        }
    }
}

