/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.abbot;

import abbot.Platform;
import abbot.util.PathClassLoader;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.TestSuite;
import junit.runner.LoadingTestCollector;

public class ScriptTestCollector
extends LoadingTestCollector {
    private ClassLoader loader;
    private static final String PACKAGE = "junit.extensions.abbot.";

    public ScriptTestCollector() {
        this(null);
    }

    public ScriptTestCollector(ClassLoader loader) {
        if (loader == null) {
            String path = System.getProperty("java.class.path");
            loader = new PathClassLoader(path);
        }
        this.loader = loader;
    }

    private String convertURLsToClasspath(URL[] urls) {
        String PS = System.getProperty("path.separator");
        String path = "";
        for (int i = 0; i < urls.length; ++i) {
            URL url;
            if (!"".equals(path)) {
                path = path + PS;
            }
            if (!(url = urls[i]).getProtocol().equals("file")) continue;
            String file = url.getFile();
            if (Platform.isWindows() && file.startsWith("/")) {
                file = file.substring(1);
            }
            path = path + file;
        }
        return path;
    }

    public Enumeration collectTests() {
        String jcp = System.getProperty("java.class.path");
        String classPath = this.loader instanceof URLClassLoader ? this.convertURLsToClasspath(((URLClassLoader)this.loader).getURLs()) : jcp;
        Hashtable hash = this.collectFilesInPath(classPath);
        if (this.loader instanceof URLClassLoader) {
            hash.putAll(this.collectFilesInPath(jcp));
        }
        return hash.elements();
    }

    private ArrayList splitClassPath(String classPath) {
        ArrayList<String> result = new ArrayList<String>();
        String separator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classPath, separator);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public Hashtable collectFilesInPath(String classPath) {
        Hashtable hash = super.collectFilesInPath(classPath);
        ArrayList paths = this.splitClassPath(classPath);
        for (String el : paths) {
            if (!el.endsWith(".zip") && !el.endsWith(".jar")) continue;
            hash.putAll(this.scanArchive(el));
        }
        return hash;
    }

    protected Map scanArchive(String name) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ZipFile zip = new ZipFile(name);
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                String filename;
                ZipEntry entry = en.nextElement();
                if (entry.isDirectory() || !this.isTestClass(filename = entry.getName())) continue;
                String cname = this.classNameFromFile(filename);
                map.put(cname, cname);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map;
    }

    protected boolean isTestClass(String classFileName) {
        boolean isTest;
        boolean bl = isTest = classFileName.endsWith(".class") && classFileName.indexOf("Test") > 0 && classFileName.indexOf(36) == -1;
        if (isTest) {
            String className = this.classNameFromFile(classFileName);
            try {
                Class<?> testClass = Class.forName(className, true, this.loader);
                Class<?> scriptFixture = Class.forName("junit.extensions.abbot.ScriptFixture", true, this.loader);
                Class<?> scriptSuite = Class.forName("junit.extensions.abbot.ScriptTestSuite", true, this.loader);
                return (scriptFixture.isAssignableFrom(testClass) || scriptSuite.isAssignableFrom(testClass)) && Modifier.isPublic(testClass.getModifiers()) && TestSuite.getTestConstructor(testClass) != null;
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return false;
    }

    protected String classNameFromFile(String classFileName) {
        String name = super.classNameFromFile(classFileName);
        return name.replace('/', '.');
    }
}

