/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.abbot;

import java.util.ArrayList;

public class SizeOf {
    private static final int GCCOUNT = 2;

    private static void gc() {
        try {
            System.gc();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void gc(int n) {
        for (int i = 0; i < n; ++i) {
            SizeOf.gc();
        }
    }

    public static long getMemoryUse() {
        SizeOf.gc(2);
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        return total - free;
    }

    public static long sizeof(ObjectCreator oc) {
        int SIZE = 1000;
        ArrayList<Object> list = new ArrayList<Object>(1000);
        long before = SizeOf.getMemoryUse();
        for (int i = 0; i < 1000; ++i) {
            list.add(oc.create());
        }
        long after = SizeOf.getMemoryUse();
        return (after - before) / 1000L;
    }

    public static long sizeof(Class cls) {
        return SizeOf.sizeof(new ClassCreator(cls));
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("Use with a single class name argument");
                System.exit(1);
            }
            Class<?> cls = Class.forName(args[0]);
            System.out.println("Class " + cls.getName() + " size is " + SizeOf.sizeof(cls) + " bytes");
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static class ClassCreator
    implements ObjectCreator {
        private Class cls;

        public ClassCreator(Class cls) {
            this.cls = cls;
        }

        public Object create() {
            try {
                return this.cls.newInstance();
            }
            catch (IllegalAccessException e) {
                String msg = "No-argument constructor is private for " + this.cls;
                throw new IllegalArgumentException(msg);
            }
            catch (InstantiationException e) {
                String msg = "Can't create an instance of " + this.cls;
                throw new IllegalArgumentException(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = "Can't obtain size of " + this.cls;
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public static interface ObjectCreator {
        public Object create();
    }
}

