/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.Log;
import abbot.editor.actions.EditorToggleAction;
import abbot.editor.widgets.Mnemonic;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;

public class CustomCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private PropertyChangeListener pcl;

    public CustomCheckBoxMenuItem(EditorToggleAction a) {
        super(a);
        this.setName((String)a.getValue("Name"));
        Integer i = (Integer)a.getValue("mnemonic-index");
        if (i != null) {
            Mnemonic.setDisplayedMnemonicIndex(this, i);
        }
        this.setAccelerator((KeyStroke)a.getValue("AcceleratorKey"));
    }

    protected void configurePropertiesFromAction(Action a) {
        super.configurePropertiesFromAction(a);
        boolean s = a != null && ((EditorToggleAction)a).isSelected();
        super.setSelected(s);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        this.pcl = super.createActionPropertyChangeListener(a);
        return new CustomCheckBoxPropertyListener();
    }

    private class CustomCheckBoxPropertyListener
    implements PropertyChangeListener {
        private CustomCheckBoxPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Log.debug("Got action prop change: " + e.getPropertyName() + ":" + e.getNewValue());
            CustomCheckBoxMenuItem.this.pcl.propertyChange(e);
            if (e.getPropertyName().equals("STATE")) {
                Boolean val = (Boolean)e.getNewValue();
                CustomCheckBoxMenuItem.this.setSelected(val == Boolean.TRUE);
            } else if (e.getPropertyName().equals("mnemonic-index")) {
                Integer i = (Integer)e.getNewValue();
                int index = i != null ? i : -1;
                Mnemonic.setDisplayedMnemonicIndex(CustomCheckBoxMenuItem.this, index);
            }
        }
    }
}

