/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.script.Step;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StepTransferable
implements Transferable {
    public static final DataFlavor STEP_FLAVOR = new DataFlavor("application/x-java-serialized-object;class=abbot.script.Step", "Abbot script step");
    public static final DataFlavor STEP_LIST_FLAVOR = new DataFlavor("application/x-java-serialized-object;class=java.util.ArrayList", "List of Abbot script steps");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{STEP_FLAVOR, STEP_LIST_FLAVOR};
    private static final DataFlavor[] LIST_FLAVORS = new DataFlavor[]{STEP_LIST_FLAVOR};
    private static List FLAVOR_LIST = Arrays.asList(FLAVORS);
    private static List LIST_FLAVOR_LIST = Arrays.asList(LIST_FLAVORS);
    private Step step;
    private List steps;
    private List flavorList;
    private DataFlavor[] flavors;

    public StepTransferable(Step step) {
        this.step = step;
        this.steps = new ArrayList();
        this.steps.add(step);
        this.flavorList = FLAVOR_LIST;
        this.flavors = FLAVORS;
    }

    public StepTransferable(List steps) {
        this.step = null;
        this.steps = steps;
        this.flavorList = LIST_FLAVOR_LIST;
        this.flavors = LIST_FLAVORS;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavorList.contains(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.isMimeTypeEqual(STEP_FLAVOR.getMimeType())) {
            if (this.step != null) {
                return this.step;
            }
        } else if (flavor.isMimeTypeEqual(STEP_LIST_FLAVOR.getMimeType())) {
            return this.steps;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public String toString() {
        return "Transferable " + (this.step != null ? this.step.toString() : "List of Steps");
    }
}

