/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.widgets;

import abbot.editor.widgets.TextField;
import abbot.i18n.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ArrayEditor
extends Box {
    public static final String ACTION_LIST_CHANGED = "list.changed";
    public static final String ACTION_ITEM_CHANGED = "item.changed";
    public static final String ACTION_ITEM_INSERTED = "item.inserted";
    public static final String ACTION_ITEM_DELETED = "item.deleted";
    private static final int DEFAULT_COLUMNS = 10;
    private ArrayList listeners = new ArrayList();
    private ArrayList data;
    private boolean adjusting = false;
    private ArrayList rows = new ArrayList();

    public ArrayEditor() {
        this(new String[0]);
    }

    public ArrayEditor(Object[] contents) {
        super(1);
        this.setValues(contents, false);
    }

    protected ElementEditor createEditor(Object initialValue) {
        return new TextEditor(initialValue);
    }

    private Row getRow(int row) {
        return (Row)this.rows.get(row);
    }

    private Row addRow(int index, Object value) {
        Row row = new Row(value);
        this.rows.add(index, row);
        this.add((Component)row, index);
        return row;
    }

    private void init() {
        this.removeAll();
        this.rows.clear();
        for (int i = 0; i < this.data.size(); ++i) {
            this.addRow(i, this.data.get(i));
        }
        if (this.data.size() == 0) {
            Row row = this.addRow(0, "");
            row.removeButton.setEnabled(false);
            row.elementEditor.setEnabled(false);
        }
        this.validate();
        this.repaint();
    }

    private void setValues(Object[] contents, boolean fire) {
        block5: {
            block4: {
                if (contents != null) break block4;
                if (this.data == null) break block5;
                this.data = null;
                this.init();
                if (!fire) break block5;
                this.fireActionPerformed(ACTION_LIST_CHANGED, -1);
                break block5;
            }
            if (this.data == null || contents.length != this.data.size()) {
                this.data = new ArrayList<Object>(Arrays.asList(contents));
                this.init();
                if (fire) {
                    this.fireActionPerformed(ACTION_LIST_CHANGED, -1);
                }
            } else {
                for (int i = 0; i < contents.length; ++i) {
                    this.setValueAt(i, contents[i], fire);
                }
            }
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public void insertRow(int row) {
        this.insertRow(row, "");
    }

    public void insertRow(int row, Object value) {
        if (row < 0 || row > this.data.size()) {
            row = this.data.size();
        }
        this.data.add(row, value);
        if (this.data.size() == 1) {
            row = 0;
            Row r = this.getRow(row);
            r.elementEditor.setEnabled(true);
            r.removeButton.setEnabled(true);
            r.elementEditor.setValue(value);
        } else {
            this.addRow(row, value);
        }
        this.validate();
        this.repaint();
        this.fireActionPerformed(ACTION_ITEM_INSERTED, row);
    }

    public void removeRow(int index) {
        if (index < 0 || index >= this.getRowCount()) {
            throw new IllegalArgumentException("Row " + index + " out of bounds (" + this.getRowCount() + ")");
        }
        Row r = this.getRow(index);
        this.data.remove(index);
        if (this.data.size() == 0) {
            this.adjusting = true;
            r.elementEditor.setValue(null);
            this.adjusting = false;
            r.elementEditor.setEnabled(false);
            r.removeButton.setEnabled(false);
        } else {
            this.rows.remove(r);
            this.remove(r);
        }
        this.validate();
        this.repaint();
        this.fireActionPerformed(ACTION_ITEM_DELETED, index);
    }

    public Object[] getValues() {
        return this.data.toArray(new Object[this.data.size()]);
    }

    public void setValues(Object[] contents) {
        this.setValues(contents, true);
    }

    public void setValueAt(int index, Object value) {
        this.setValueAt(index, value, true);
    }

    private void setValueAt(int index, Object value, boolean fire) {
        if (index < 0 || index >= this.data.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range (" + this.data.size() + ")");
        }
        if (value == this.data.get(index) || value != null && value.equals(this.data.get(index))) {
            return;
        }
        this.data.set(index, value);
        if (!this.adjusting) {
            this.getRow((int)index).elementEditor.setValue(value);
        }
        if (fire) {
            this.fireActionPerformed(ACTION_ITEM_CHANGED, index);
        }
    }

    public String getValueAt(int index) {
        return (String)this.data.get(index);
    }

    protected void fireActionPerformed(String action, int index) {
        Iterator iter = this.listeners.iterator();
        ActionEvent e = new ActionEvent(this, index, action);
        while (iter.hasNext()) {
            ((ActionListener)iter.next()).actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    protected class Row
    extends JPanel {
        public ElementEditor elementEditor;
        public Component editor;
        public JButton addButton;
        public JButton removeButton;

        public Row(Object value) {
            BorderLayout layout = new BorderLayout();
            layout.setVgap(0);
            this.setLayout(layout);
            this.elementEditor = ArrayEditor.this.createEditor(value);
            this.editor = this.elementEditor.getEditorComponent();
            this.add(this.editor);
            this.editor.setName("editor");
            Box buttons = new Box(0);
            this.add((Component)buttons, "East");
            this.removeButton = new SizedButton("-");
            buttons.add(this.removeButton);
            this.removeButton.setName("remove");
            this.removeButton.setToolTipText(Strings.get("editor.array.remove"));
            this.addButton = new SizedButton("+");
            buttons.add(this.addButton);
            this.addButton.setName("add");
            this.addButton.setToolTipText(Strings.get("editor.array.insert"));
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ArrayEditor.this.insertRow(ArrayEditor.this.getRowCount() == 0 ? 0 : Row.this.getRowIndex() + 1);
                }
            });
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ArrayEditor.this.removeRow(Row.this.getRowIndex());
                }
            });
            this.elementEditor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index = Row.this.getRowIndex();
                    if (!ArrayEditor.this.adjusting && index != -1) {
                        ArrayEditor.this.adjusting = true;
                        ArrayEditor.this.setValueAt(index, Row.this.elementEditor.getValue(), true);
                        ArrayEditor.this.adjusting = false;
                    }
                }
            });
        }

        public Dimension getMaximumSize() {
            Dimension size = super.getMaximumSize();
            size.height = super.getPreferredSize().height;
            return size;
        }

        protected int getRowIndex() {
            Container parent = this.getParent();
            if (parent != null) {
                Component[] kids = parent.getComponents();
                for (int i = 0; i < kids.length; ++i) {
                    if (kids[i] != this) continue;
                    return i;
                }
            }
            return -1;
        }

        public String toString() {
            return super.toString() + "[" + this.getRowIndex() + ": " + this.elementEditor.getValue() + "]";
        }

        private class SizedButton
        extends JButton {
            public SizedButton(String label) {
                super(label);
            }

            public Insets getInsets() {
                int min;
                Insets insets = super.getInsets();
                insets.top = insets.bottom = (min = Math.min(insets.top, Math.min(insets.bottom, Math.min(insets.right, insets.left))));
                insets.left = insets.bottom;
                insets.right = insets.bottom;
                return insets;
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getPreferredSize() {
                Dimension size = Row.this.editor.getPreferredSize();
                size.width = size.height;
                return size;
            }
        }
    }

    protected class TextEditor
    extends TextField
    implements ElementEditor {
        public TextEditor(Object value) {
            super(value.toString(), 10);
        }

        public Object getValue() {
            return this.getText();
        }

        public void setValue(Object o) {
            this.setText(o == null ? "" : o.toString());
        }

        public Component getEditorComponent() {
            return this;
        }
    }

    protected static interface ElementEditor {
        public void setValue(Object var1);

        public Object getValue();

        public Component getEditorComponent();

        public void addActionListener(ActionListener var1);

        public void removeActionListener(ActionListener var1);

        public void setEnabled(boolean var1);
    }
}

