/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.tester.FileComparator;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;

public class ImageComparator
implements Comparator {
    private FileComparator comparator = new FileComparator();

    private static File convertToJPEGFile(Object obj) throws IOException {
        if (obj != null) {
            if (obj instanceof String) {
                obj = new File((String)obj);
            }
            if (obj instanceof BufferedImage) {
                File file = File.createTempFile("ImageComparator", ".jpg");
                Log.debug("Creating " + file);
                ImageComparator.writeJPEG(file, (BufferedImage)obj);
                file.deleteOnExit();
                return file;
            }
            if (obj instanceof File) {
                return (File)obj;
            }
        }
        return null;
    }

    public static void writeJPEG(File file, BufferedImage img) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        JPEGImageEncoder ie = JPEGCodec.createJPEGEncoder((OutputStream)os);
        JPEGEncodeParam param = ie.getDefaultJPEGEncodeParam(img);
        param.setQuality(1.0f, false);
        ie.setJPEGEncodeParam(param);
        ie.encode(img);
        os.close();
    }

    public int compare(Object obj1, Object obj2) {
        try {
            obj1 = ImageComparator.convertToJPEGFile(obj1);
        }
        catch (IOException io) {
            obj1 = null;
        }
        try {
            obj2 = ImageComparator.convertToJPEGFile(obj2);
        }
        catch (IOException io) {
            obj2 = null;
        }
        Log.debug("Comparing " + obj1 + " and " + obj2);
        return this.comparator.compare(obj1, obj2);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(this.getClass());
    }
}

