/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import abbot.tester.JTabbedPaneLocation;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

public class JTabbedPaneTester
extends JComponentTester {
    public String[] getTabs(Component comp) {
        JTabbedPane tp = (JTabbedPane)comp;
        int count = tp.getTabCount();
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            list.add(tp.getTitleAt(i));
        }
        return list.toArray(new String[count]);
    }

    public void actionSelectTab(Component comp, JTabbedPaneLocation loc) {
        try {
            Point pt = loc.getPoint(comp);
            this.click(comp, pt.x, pt.y);
        }
        catch (JTabbedPaneLocation.TabNotVisibleException e) {
            ((JTabbedPane)comp).setSelectedIndex(e.index);
        }
        this.waitForIdle();
    }

    public ComponentLocation parseLocation(String encoded) {
        return new JTabbedPaneLocation().parse(encoded);
    }

    public ComponentLocation getLocation(Component c, Point p) {
        JTabbedPane tabs = (JTabbedPane)c;
        TabbedPaneUI ui = tabs.getUI();
        int index = ui.tabForCoordinate(tabs, p.x, p.y);
        if (index != -1) {
            String name = tabs.getTitleAt(index);
            return new JTabbedPaneLocation(name);
        }
        return new JTabbedPaneLocation(p);
    }
}

