/*
 * Decompiled with CFR 0.152.
 */
package abbot.util;

import abbot.Log;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.util.Properties;
import javax.swing.UIManager;

public class SystemState {
    private static final int[] CODES = new int[]{20, 144, 145, 262};
    private Properties oldProps;
    private PrintStream oldOut;
    private PrintStream oldErr;
    private SecurityManager oldsm;
    private String oldLookAndFeel;
    private boolean[] lockingKeys = new boolean[CODES.length];
    private static Robot robot = null;

    public SystemState() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        for (int i = 0; i < CODES.length; ++i) {
            try {
                this.lockingKeys[i] = toolkit.getLockingKeyState(CODES[i]);
                try {
                    toolkit.setLockingKeyState(CODES[i], false);
                }
                catch (UnsupportedOperationException e) {
                    if (!this.lockingKeys[i] || robot == null) continue;
                    robot.keyPress(CODES[i]);
                    robot.keyRelease(CODES[i]);
                }
                continue;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.oldLookAndFeel = UIManager.getLookAndFeel().getClass().getName();
        this.oldOut = System.out;
        this.oldErr = System.err;
        System.setOut(new ProtectedStream(this.oldOut));
        System.setErr(new ProtectedStream(this.oldErr));
        this.oldProps = (Properties)System.getProperties().clone();
        this.oldsm = System.getSecurityManager();
    }

    public void restore() {
        System.setSecurityManager(this.oldsm);
        System.setProperties(this.oldProps);
        System.setOut(this.oldOut);
        System.setErr(this.oldErr);
        try {
            UIManager.setLookAndFeel(this.oldLookAndFeel);
        }
        catch (Exception e) {
            Log.warn("Could not restore LAF: " + e);
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        for (int i = 0; i < CODES.length; ++i) {
            try {
                boolean state = toolkit.getLockingKeyState(CODES[i]);
                if (state == this.lockingKeys[i]) continue;
                try {
                    toolkit.setLockingKeyState(CODES[i], this.lockingKeys[i]);
                }
                catch (UnsupportedOperationException e) {
                    if (robot == null) continue;
                    robot.keyPress(CODES[i]);
                    robot.keyRelease(CODES[i]);
                }
                continue;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    static {
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    private class ProtectedStream
    extends PrintStream {
        private boolean closed;

        public ProtectedStream(PrintStream original) {
            super(original);
            this.closed = false;
        }

        public void flush() {
            if (!this.closed) {
                super.flush();
            }
        }

        public void close() {
            this.closed = true;
        }

        public void write(int b) {
            if (!this.closed) {
                super.write(b);
            }
        }

        public void write(byte[] buf, int off, int len) {
            if (!this.closed) {
                super.write(buf, off, len);
            }
        }
    }
}

