<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
	<html>
		<head>
			<title>Gnalogie de la famille <xsl:value-of select="//pre/nom"/></title>
			<link rel="stylesheet" href="genealogie.css" type="text/css"/>
		</head>
		<body>
			<table width="100%">
				<tbody>
					<tr bgcolor="silver">
						<td width="33%"><b>Fille ou garon</b></td>
						<td width="33%"><b>Nom</b></td>
						<td width="33%"><b>Lieu de naissance</b></td>
					</tr>
					<xsl:for-each select="//enfant">
						<xsl:choose>
							<xsl:when test="@genre='garon'">
								<tr class="masculin">
									<td><xsl:apply-templates select="@genre"/></td>
									<td><xsl:apply-templates select="./prnom"/></td>
									<td><xsl:apply-templates select="./lieu_de_naissance"/></td>
								</tr>
							</xsl:when>
							<xsl:otherwise>
								<tr class="feminin">
									<td><xsl:apply-templates select="@genre"/></td>
									<td><xsl:apply-templates select="./prnom"/></td>
									<td><xsl:apply-templates select="./lieu_de_naissance"/></td>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</tbody>
			</table>
		</body>
	</html>
</xsl:template>
</xsl:stylesheet>