<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
  <html>
    <head>
      <title>Statistiques pour <xsl:value-of select="statistiques/nom"/></title>
<style>
.active {cursor:hand;}
</style>
<script>
<xsl:comment>
<![CDATA[
                  var xslStylesheet = null;
                  var xmlSource = null;
                  var triColonne = null;

                  function display(colonne)
                  {
                     triColonne.nodeValue = colonne;

                     classement.innerHTML =
                       xmlSource.documentElement.transformNode(xslStylesheet);
                  }

]]>
</xsl:comment>
</script>
         <script for="window" event="onload">
            <xsl:comment>
               <![CDATA[
                  xslStylesheet = document.XSLDocument;
                  xmlSource = document.XMLDocument;
                  triColonne = document.XSLDocument.selectSingleNode("//xsl:sort/@select");
                  display('classement');
               ]]>
            </xsl:comment>
         </script>
    </head>
    <body>
      <h2><xsl:value-of select="statistiques/nom"/></h2>
      <div id="classement"/>
    </body>
  </html>
</xsl:template>

<xsl:template match="statistiques">

<font size="2">Cliquez sur <b>Equipe</b> ou <b>Classement</b> pour trier les statistiques</font>.
      <table>
	<tbody>
	    <tr>
              <th class="active" onclick="display('nom')">Equipe</th>
              <th>Victoires</th>
              <th>Dfaites</th>
              <th class="active" onclick="display('classement')">Classement</th>
	    </tr>
           <hr/>
	   <xsl:for-each select="//quipe">
             <xsl:sort select="./classement"/>
            <tr>
             <td><xsl:apply-templates select="nom"/></td>
             <td align="center"><xsl:apply-templates select="rsultats/victoires"/></td>
             <td align="center"><xsl:apply-templates select="rsultats/dfaites"/></td>
             <td align="center"><xsl:apply-templates select="classement"/></td>
            </tr>
          </xsl:for-each>
	</tbody>
      </table>
</xsl:template>

</xsl:stylesheet>

