<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:saxon="http://icl.com/saxon"
                extension-element-prefixes="saxon">


<xsl:output method="html" indent="yes"/>

<!-- <xsl:template match="*"/> -->

<xsl:template match="/">
<saxon:output method="html" href="table.htm">
  <html>
    <head>
      <title>Rsultats des ligues classs par divisions</title>
    </head>
    <body>

<xsl:for-each select="statistiques/ligue">
<xsl:for-each select="division">
<xsl:variable name="nom_division">
<xsl:value-of select="@nom"/>
</xsl:variable>
<xsl:variable name="nom_ligue">
<xsl:value-of select="../@nom"/>
</xsl:variable>
<p>
<a href="{concat($nom_ligue,$nom_division,'.htm')}" target="statistiques"><xsl:value-of select="../@nom"/> League <xsl:value-of select="@nom"/></a>
</p>
</xsl:for-each>
</xsl:for-each>

</body>
</html>
</saxon:output>
<xsl:apply-templates />
</xsl:template>

<xsl:template match="//division">
<xsl:variable name="nom_division">
<xsl:value-of select="@nom"/>
</xsl:variable>
<xsl:variable name="nom_ligue">
<xsl:value-of select="../@nom"/>
</xsl:variable>
<saxon:output method="html" href="{concat($nom_ligue,$nom_division,'.htm')}">
<html>
<head>
<title>Rsultat de la <xsl:value-of select="../@nom"/> League <xsl:value-of select="@nom"/></title>
<style>
<![CDATA[
.Titre {display: block; font-size: x-large; font-weight: bold; font-family: sans-serif;}
.TitreTableau {display: block; font-size: large; font-weight: bold;}
.NomEquipe {display: block; font-size: medium; font-weight: bold;}
.DonneeEquipe {display: block; font-size: medium; text-align: right; padding-right: 20 px;}
]]>


</style>
</head>
<body>
<p class="Titre"><xsl:value-of select="../@nom"/> League <xsl:value-of select="@nom"/></p>
<table>
<tbody>
<th>
<tr>
<td class="TitreTableau">Equipe</td>
<td class="TitreTableau">Vitoires</td>
<td class="TitreTableau">Dfaites</td>
<td class="TitreTableau">Classement</td>
</tr>
</th>
<hr />
<xsl:for-each select="quipe">
<xsl:sort select="rsultats/victoires" order="descending"/>
<tr>
<td class="NomEquipe"><xsl:value-of select="nom"/></td>
<td class="DonneeEquipe"><xsl:value-of select="rsultats/victoires"/></td>
<td class="DonneeEquipe"><xsl:value-of select="rsultats/dfaites"/></td>
<td class="DonneeEquipe"><xsl:value-of select="position()"/></td>
</tr>
</xsl:for-each>
</tbody>
</table>
</body>
</html>

</saxon:output>
</xsl:template>


</xsl:stylesheet>

