/*
 * Created on 23 f�vr. 2003
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code Template
 */
package com.blueweb.bookmarks.ui;

import java.util.Properties;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

import com.blueweb.bookmarks.ui.actions.ExitAction;
import com.blueweb.bookmarks.ui.actions.PropertiesAction;

import com.blueweb.bookmarks.ui.model.Signet;
import com.blueweb.bookmarks.ui.model.Theme;

/**
 * <p>
 * Classe principale, affiche l'interface graphique
 * Ici, il s'agit d'un arbre.
 * Codee en utilisant certaines fonctionnalit�s avanc�es de JFace.
 * </p> 
 * @author jm
 */
public class SignetsUI extends ApplicationWindow{

	private Menu popupMenu;
	private Action exitAction;
	private Action propertiesAction;
	private Properties systemProps;
	
	/**
	 * constructeur
	 * @param aShell
	 */
	public SignetsUI(Shell aShell) {
		// TODO Auto-generated method stub
		super(aShell);
		exitAction=new ExitAction(this);
		propertiesAction = new PropertiesAction(this);
		addMenuBar();
		addToolBar(SWT.FLAT|SWT.WRAP);
		System.err.println("constructor invoked");
	} // constructeur()
	
	/**
	 * retourne les proprietes utilisees pour la communication avec 
	 * le serveur Web telles que:
	 * nom d'hote ou adresse IP
	 * numero de port
	 * @return Properties
	 */
	public Properties getProperties(){
		return systemProps;
	} // getProperties()
	
	public void setProperties(Properties someProps){
		systemProps = someProps;
	} // setProperties()
	/**
	 * <p>
	 * Cette methode creee le contenu de notre composant
	 * Ici il s'agit donc de retourner une instance de la classe
	 * Tree (heritant de Control la classe mere dans la hierarchie SWT
	 * de tous les widgets)
	 * </p>
	 * @return Control, instance de la classe Tree
	 * @see org.eclipse.jface.window.Window#createContents(Composite)
	 */
	protected Control createContents(Composite parent){
		// Ici l'on cree le menu popup commun a tous les elements de l'arbre
		popupMenu = new Menu(getShell(),SWT.DEFAULT);
				final MenuItem item = new MenuItem (popupMenu, SWT.PUSH);
						item.addListener (SWT.Selection, new Listener () {
								public void handleEvent (Event e) {
									System.out.println ("menu clicked = " + item.getText());
								}
							});
						item.setText ("Ajouter Theme");
						final MenuItem item2 = new MenuItem(popupMenu,SWT.PUSH);
						item2.addListener (SWT.Selection, new Listener () {
										public void handleEvent (Event e) {
											System.out.println ("menu clicked = " + item2.getText());
										}
									});
						item2.setText ("Ajouter Signet");
		// c'est un noeud fantome (non affiche)
		Theme root = new Theme();
		root.setParent(null);
		
		// premier niveau de noeud visible
		// ici on ajoute un Theme - Java
		Theme java = new Theme();
		// le nom du noeud
		java.setNom("Divers");
		root.addChild(java);
		
		// ici on cree un signet
		// avec une URL: celle du site principal de sun dedie
		// a Java
		Signet s1= new Signet();
		s1.setAdresseSignet("http://www.javasoft.com");
		s1.setNom("Sun site");
		// ne pas oublier d'ajouter ce noeud aupres du noeud pere (java)
		java.addChild(s1);
		
		// un autre theme (c++)
		Theme cpp = new Theme();
		cpp.setNom("Fun");
		root.addChild(cpp);
		Signet s3 = new Signet();
		
		// tiens un signet...
		s3.setAdresseSignet("www.tf1.fr");
		s3.setNom("Ping test:TF1");
		root.addChild(s3);
		System.err.println("Nb of children from root node = " + root.children().size());
		Signet s2=new Signet();
		s2.setAdresseSignet("http://gcc.gnu.org");
		s2.setNom("GCC - GNU");
		cpp.addChild(s2);
		System.err.println("created themes");
		
		// on instancie un TreeViewer en donnant une reference sur le composite
		// parent
		TreeViewer tree = new TreeViewer(parent);
		// ici on ajoute la classe en charge de la gestion du contenu du noeud
		tree.setContentProvider( new SignetsContentProvider());
		// ici une classe gerant les labels affiches dans l'arbre
		tree.setLabelProvider(new SignetLabelProvider());
		// ici le Sorter a pour role d'operer un classement
		tree.setSorter( new SignetSorter());
		
		// il est tres interessant de decommenter la ligne
		// en dessous et de recompiler puis relancer..
		//tree.addFilter(new SignetOnlyFilter());
		System.err.println("setted content provider");
		setStatus("arbre OK");
		tree.setInput(root);
		tree.getTree().setMenu(popupMenu);
		tree.getTree().addSelectionListener( new SelectionListener(){

			public void widgetSelected(SelectionEvent arg0) {
				// TODO Auto-generated method stub
				System.err.println("selection");
			}

			public void widgetDefaultSelected(SelectionEvent arg0) {
				// TODO Auto-generated method stub
				System.err.println("default selection");
			}
		});
		return tree.getTree();
	}
	
	protected MenuManager createMenuManager(){
		System.err.println("createMenumanager invoked");
		MenuManager main_manager = new MenuManager("");
		MenuManager file_menu = new MenuManager("&Fichiers");
		main_manager.add(file_menu);
		file_menu.add(exitAction);
		return main_manager;
	}
	
	protected ToolBarManager createToolBarManager(int style)
	  {

		ToolBarManager tool_bar_manager = new ToolBarManager(style);

		tool_bar_manager.add(exitAction);

		return tool_bar_manager;
	  }
	
	public static void main(String[] args) {
		System.err.println("launching UI");
		SignetsUI ui = new SignetsUI(null);
		ui.addStatusLine();
		ui.setBlockOnOpen(true);
		ui.open();
		Display.getCurrent().dispose();
	}
}
